/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import devplugin.Channel;
import java.util.ArrayList;
import tvbrowser.core.ChannelList;
import util.settings.Property;
import util.settings.PropertyManager;

public class ChannelArrayProperty
extends Property {
    private Channel[] mDefaultValue;
    private Channel[] mCachedValue;

    public ChannelArrayProperty(PropertyManager manager, String key, Channel[] defaultValue) {
        super(manager, key);
        this.mDefaultValue = defaultValue;
        this.mCachedValue = null;
    }

    public Channel[] getDefault() {
        return this.mDefaultValue;
    }

    public Channel[] getChannelArray() {
        if (this.mCachedValue == null) {
            String asString = this.getProperty();
            if (asString != null) {
                String[] splits = asString.split(",");
                ArrayList<Channel> channels = new ArrayList<Channel>();
                for (String split : splits) {
                    Channel ch;
                    int pos = split.indexOf(58);
                    if (pos <= 0) continue;
                    String dataServiceId = split.substring(0, pos);
                    String groupId = null;
                    String country = null;
                    String channelId = split.substring(pos + 1);
                    String channelName = "Dummy";
                    if (channelId.indexOf(58) != -1) {
                        String[] values = channelId.split(":");
                        groupId = values[0];
                        if (values.length > 2) {
                            country = values[1];
                            channelId = values[2];
                        } else {
                            channelId = values[1];
                        }
                        if (values.length > 3) {
                            channelName = values[3];
                        }
                    }
                    if ((ch = ChannelList.getChannel(dataServiceId, groupId, country, channelId, channelName)) == null) continue;
                    channels.add(ch);
                }
                this.mCachedValue = new Channel[channels.size()];
                this.mCachedValue = channels.toArray(this.mCachedValue);
            }
            if (this.mCachedValue == null) {
                this.mCachedValue = this.mDefaultValue;
            }
        }
        return this.mCachedValue;
    }

    public void setChannelArray(Channel[] value) {
        if (value == null) {
            throw new IllegalArgumentException("You can't set a null value");
        }
        boolean equalsDefault = false;
        if (this.mDefaultValue != null && value.length == this.mDefaultValue.length) {
            equalsDefault = true;
            for (int i = 0; i < value.length; ++i) {
                if (value[i] != null && value[i].equals(this.mDefaultValue[i])) continue;
                equalsDefault = false;
                break;
            }
        }
        if (equalsDefault) {
            this.setProperty(null);
        } else {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < value.length; ++i) {
                if (value[i] == null) continue;
                if (i != 0) {
                    buffer.append(',');
                }
                String dataServiceId = value[i].getDataServiceId();
                buffer.append(dataServiceId).append(':').append(value[i].getGroup().getId()).append(':').append(value[i].getBaseCountry()).append(':').append(value[i].getId()).append(":").append(value[i].getDefaultName());
            }
            this.setProperty(buffer.toString());
        }
        this.mCachedValue = value;
    }

    @Override
    protected void clearCache() {
        this.mCachedValue = null;
    }

    public void clearCacheExternal() {
        this.clearCache();
    }
}

