/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.SwingUtilities;

public final class WindowSetting {
    private Window mWindowCache;
    private int mXPos;
    private int mYPos;
    private int mWidth;
    private int mHeight;
    private Dimension mMinSize;

    public WindowSetting(ObjectInputStream in) throws IOException {
        in.readInt();
        this.mXPos = in.readInt();
        this.mYPos = in.readInt();
        this.mWidth = in.readInt();
        this.mHeight = in.readInt();
    }

    public WindowSetting(Dimension size) {
        this.mXPos = -1;
        this.mYPos = -1;
        if (size == null) {
            this.mWidth = -1;
            this.mHeight = -1;
        } else {
            this.mWidth = size.width;
            this.mHeight = size.height;
        }
    }

    public void saveSettings(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeInt(this.mXPos);
        out.writeInt(this.mYPos);
        out.writeInt(this.mWidth);
        out.writeInt(this.mHeight);
    }

    public void layout(Window window) {
        this.layout(window, null);
    }

    public void layout(final Window window, final Window parent) {
        final Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int width = this.mWidth;
        int height = this.mHeight;
        if (width < 20 || width > d.width) {
            window.pack();
            width = window.getWidth();
        }
        if (height < 20 || height > d.height) {
            window.pack();
            height = window.getHeight();
        }
        window.pack();
        this.mMinSize = window.getMinimumSize();
        this.mMinSize = new Dimension(Math.min(this.mMinSize.width, d.width), Math.min(this.mMinSize.height, d.height));
        width = Math.max(width, this.mMinSize.width);
        height = Math.max(height, this.mMinSize.height);
        width = Math.min(width, d.width);
        height = Math.min(height, d.height);
        window.setSize(width, height);
        if (this.mXPos < 0 || this.mYPos < 0 || this.mXPos > d.width || this.mYPos > d.height) {
            window.setLocationRelativeTo(null);
        } else {
            window.setLocation(this.mXPos, this.mYPos);
        }
        if (this.mWindowCache == null || !window.equals(this.mWindowCache)) {
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(final WindowEvent e) {
                    SwingUtilities.invokeLater(new Thread(){

                        @Override
                        public void run() {
                            try {
                                1.sleep(100L);
                            }
                            catch (InterruptedException e1) {
                                // empty catch block
                            }
                            if (parent == null) {
                                Point p = e.getComponent().getLocation();
                                if (WindowSetting.this.mXPos < 0 || WindowSetting.this.mYPos < 0 || WindowSetting.this.mXPos > d.width || WindowSetting.this.mYPos > d.height) {
                                    window.setLocationRelativeTo(null);
                                } else if ((p.x != WindowSetting.this.mXPos || WindowSetting.this.mYPos != p.y) && System.getenv("DESKTOP_SESSION") != null && System.getenv("DESKTOP_SESSION").toLowerCase().equals("ubuntu")) {
                                    window.setLocation(WindowSetting.this.mXPos - Math.abs(p.x - WindowSetting.this.mXPos), WindowSetting.this.mYPos - Math.abs(p.y - WindowSetting.this.mYPos));
                                }
                            }
                            window.addComponentListener(new ComponentListener(){

                                @Override
                                public void componentHidden(ComponentEvent e) {
                                    this.savePos(e);
                                }

                                @Override
                                public void componentMoved(ComponentEvent e) {
                                    this.savePos(e);
                                }

                                @Override
                                public void componentResized(ComponentEvent e) {
                                    if (WindowSetting.this.mMinSize != null) {
                                        int winWidth = window.getWidth();
                                        int winHeight = window.getHeight();
                                        boolean resize = false;
                                        if ((double)winWidth < WindowSetting.this.mMinSize.getWidth()) {
                                            winWidth = ((WindowSetting)WindowSetting.this).mMinSize.width;
                                            resize = true;
                                        }
                                        if ((double)winHeight < WindowSetting.this.mMinSize.getHeight()) {
                                            winHeight = ((WindowSetting)WindowSetting.this).mMinSize.height;
                                            resize = true;
                                        }
                                        if (resize) {
                                            window.setSize(winWidth, winHeight);
                                        }
                                    }
                                    this.saveSize(e);
                                }

                                @Override
                                public void componentShown(ComponentEvent e) {
                                    this.savePos(e);
                                }

                                private void savePos(ComponentEvent e) {
                                    WindowSetting.this.mXPos = e.getComponent().getX();
                                    WindowSetting.this.mYPos = e.getComponent().getY();
                                }

                                private void saveSize(ComponentEvent e) {
                                    WindowSetting.this.mWidth = e.getComponent().getWidth();
                                    WindowSetting.this.mHeight = e.getComponent().getHeight();
                                }
                            });
                        }
                    });
                }
            });
        }
        if (parent != null) {
            window.setLocationRelativeTo(parent);
        }
        this.mWindowCache = window;
    }

    public String toString() {
        return "x:" + this.mXPos + " y:" + this.mYPos + " " + this.mWidth + "x" + this.mHeight;
    }
}

