/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public class GridFlowLayout
implements LayoutManager {
    public static final int CENTER = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    private int mHGap;
    private int mVGap;
    private int mVAlign;
    private int mHAlign;

    public GridFlowLayout(int hgap, int vgap, int valign, int halign) {
        this.mHGap = hgap;
        this.mVGap = vgap;
        this.mVAlign = valign;
        this.mHAlign = halign;
    }

    public GridFlowLayout(int hgap, int vgap) {
        this(hgap, vgap, 0, 0);
    }

    public GridFlowLayout() {
        this(0, 0);
    }

    private Dimension getMaximumComponentSize(Container container) {
        int width = 0;
        int height = 0;
        int cnt = container.getComponentCount();
        for (int i = 0; i < cnt; ++i) {
            Component c = container.getComponent(i);
            Dimension dim = c.getPreferredSize();
            if (dim.getWidth() > (double)width) {
                width = (int)dim.getWidth();
            }
            if (!(dim.getHeight() > (double)height)) continue;
            height = (int)dim.getHeight();
        }
        return new Dimension(width, height);
    }

    @Override
    public void removeLayoutComponent(Component arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension compDimension = this.getMaximumComponentSize(container);
            int cnt = container.getComponentCount();
            int width = container.getWidth();
            if (width == 0) {
                width = 1;
            }
            int height = container.getHeight();
            int totalLength = (int)(compDimension.getWidth() + (double)this.mHGap) * cnt;
            int rows = totalLength / width + 1;
            int compsPerRow = (int)((double)width / (compDimension.getWidth() + (double)this.mHGap));
            if (compsPerRow == 0) {
                compsPerRow = 1;
            }
            int rowLength = (int)((double)compsPerRow * compDimension.getWidth() + (double)(this.mHGap * compsPerRow - 1));
            int rowHeight = (int)((double)rows * compDimension.getHeight() + (double)(this.mVGap * rows - 1));
            int hIndent = 0;
            if (this.mHAlign == 0) {
                hIndent = (width - rowLength) / 2;
            } else if (this.mHAlign == 2) {
                hIndent = width - rowLength;
            }
            int vIndent = 0;
            if (this.mVAlign == 0) {
                vIndent = (height - rowHeight) / 2;
            } else if (this.mVAlign == 2) {
                vIndent = height - rowHeight;
            }
            for (int i = 0; i < cnt; ++i) {
                Component c = container.getComponent(i);
                int x = i % compsPerRow * (compDimension.width + this.mHGap) + hIndent;
                int y = i / compsPerRow * (compDimension.height + this.mVGap) + vIndent;
                c.setLocation(x, y);
                c.setSize(compDimension);
            }
        }
    }

    @Override
    public void addLayoutComponent(String arg0, Component arg1) {
    }

    @Override
    public Dimension minimumLayoutSize(Container c) {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension preferredLayoutSize(Container c) {
        return this.minimumLayoutSize(c);
    }
}

