/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.Marker;
import devplugin.Plugin;
import devplugin.PluginAccess;
import devplugin.ProgramReceiveIf;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.extras.favoritesplugin.FavoritesPluginProxy;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;
import util.ui.customizableitems.SelectableItemList;

public class MarkerChooserDlg
extends JDialog
implements WindowClosingIf {
    private static final long serialVersionUID = 1L;
    private Marker[] mResultPluginArr;
    private Marker[] mPluginArr;
    private SelectableItemList mPluginItemList;
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(MarkerChooserDlg.class);

    public MarkerChooserDlg(Window parent, Marker[] pluginArr, String description) {
        super(parent);
        this.setModal(true);
        this.init(pluginArr, description);
    }

    @Deprecated
    public MarkerChooserDlg(Dialog parent, Marker[] pluginArr, String description) {
        this((Window)parent, pluginArr, description);
    }

    @Deprecated
    public MarkerChooserDlg(Frame parent, Marker[] pluginArr, String description) {
        this((Window)parent, pluginArr, description);
    }

    private void init(Marker[] channelArr, String description) {
        this.setTitle(mLocalizer.msg("title", "Choose Plugins"));
        UiUtilities.registerForClosing(this);
        if (channelArr == null) {
            this.mPluginArr = new Marker[0];
            this.mResultPluginArr = new Marker[0];
        } else {
            this.mPluginArr = channelArr;
            this.mResultPluginArr = channelArr;
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        FormLayout layout = new FormLayout("fill:pref:grow", "");
        contentPane.setLayout(layout);
        contentPane.setBorder(Borders.DLU4);
        CellConstraints cc = new CellConstraints();
        PluginAccess[] pluginAccess = Plugin.getPluginManager().getActivatedPlugins();
        ArrayList<ProgramReceiveIf> list = new ArrayList<ProgramReceiveIf>();
        list.add(FavoritesPluginProxy.getInstance());
        list.add(ReminderPluginProxy.getInstance());
        for (PluginAccess plugin : pluginAccess) {
            Icon[] markIcons = plugin.getMarkIcons(PluginManagerImpl.getInstance().getExampleProgram());
            if (markIcons == null || markIcons.length <= 0) continue;
            list.add(plugin);
        }
        Collections.sort(list, new Comparator<Marker>(){

            @Override
            public int compare(Marker arg0, Marker arg1) {
                return arg0.toString().compareTo(arg1.toString());
            }
        });
        this.mPluginItemList = new SelectableItemList(this.mResultPluginArr, list.toArray());
        int pos = 1;
        layout.appendRow(RowSpec.decode("fill:default:grow"));
        layout.appendRow(RowSpec.decode("3dlu"));
        contentPane.add((Component)this.mPluginItemList, cc.xy(1, pos));
        pos += 2;
        if (description != null) {
            JLabel lb = new JLabel(description);
            layout.appendRow(RowSpec.decode("pref"));
            layout.appendRow(RowSpec.decode("3dlu"));
            contentPane.add((Component)lb, cc.xy(1, pos));
            pos += 2;
        }
        JButton okBt = new JButton(Localizer.getLocalization("i18n_ok"));
        JButton cancelBt = new JButton(Localizer.getLocalization("i18n_cancel"));
        okBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object[] o = MarkerChooserDlg.this.mPluginItemList.getSelection();
                MarkerChooserDlg.access$102(MarkerChooserDlg.this, new Marker[o.length]);
                for (int i = 0; i < o.length; ++i) {
                    ((MarkerChooserDlg)MarkerChooserDlg.this).mResultPluginArr[i] = (Marker)o[i];
                }
                MarkerChooserDlg.this.setVisible(false);
            }
        });
        cancelBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MarkerChooserDlg.access$102(MarkerChooserDlg.this, null);
                MarkerChooserDlg.this.setVisible(false);
            }
        });
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addGlue();
        builder.addButton(okBt, cancelBt);
        layout.appendRow(RowSpec.decode("pref"));
        contentPane.add((Component)builder.getPanel(), cc.xy(1, pos));
        this.pack();
    }

    public Marker[] getMarker() {
        if (this.mResultPluginArr == null) {
            return this.mPluginArr;
        }
        return this.mResultPluginArr;
    }

    @Override
    public void close() {
        this.setVisible(false);
    }

    static /* synthetic */ Marker[] access$102(MarkerChooserDlg x0, Marker[] x1) {
        x0.mResultPluginArr = x1;
        return x1;
    }
}

