/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.Plugin;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tvbrowser.core.Settings;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;
import util.ui.customizableitems.SelectableItem;
import util.ui.customizableitems.SelectableItemList;

public class PluginChooserDlg
extends JDialog
implements WindowClosingIf {
    private ProgramReceiveIf[] mResultPluginArr;
    private ProgramReceiveIf[] mPluginArr;
    private Hashtable<ProgramReceiveIf, ArrayList<ProgramReceiveTarget>> mReceiveTargetTable;
    private SelectableItemList mPluginItemList;
    private ProgramReceiveTarget[] mCurrentTargets;
    private boolean mOkWasPressed;
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(PluginChooserDlg.class);

    public PluginChooserDlg(Window parent, ProgramReceiveIf[] pluginArr, String description, ProgramReceiveIf caller) {
        super(parent);
        this.setModal(true);
        this.init(pluginArr, description, caller, null, null, parent);
    }

    @Deprecated
    public PluginChooserDlg(Dialog parent, ProgramReceiveIf[] pluginArr, String description, ProgramReceiveIf caller) {
        this((Window)parent, pluginArr, description, caller);
    }

    public PluginChooserDlg(Window parent, ProgramReceiveTarget[] pluginArr, String description, ProgramReceiveIf caller) {
        this(parent, pluginArr, description, caller, null);
    }

    @Deprecated
    public PluginChooserDlg(Dialog parent, ProgramReceiveTarget[] pluginArr, String description, ProgramReceiveIf caller) {
        this((Window)parent, pluginArr, description, caller);
    }

    public PluginChooserDlg(Window parent, ProgramReceiveTarget[] pluginArr, String description, ProgramReceiveIf caller, ProgramReceiveTarget[] disabledTargets) {
        super(parent);
        this.setModal(true);
        Hashtable<ProgramReceiveIf, ArrayList<ProgramReceiveTarget>> table = this.createReceiveTable(pluginArr);
        this.init(table.keySet().toArray(new ProgramReceiveIf[table.keySet().size()]), description, caller, table, disabledTargets, parent);
    }

    @Deprecated
    public PluginChooserDlg(Dialog parent, ProgramReceiveTarget[] pluginArr, String description, ProgramReceiveIf caller, ProgramReceiveTarget[] disabledTargets) {
        this((Window)parent, pluginArr, description, caller, disabledTargets);
    }

    @Deprecated
    public PluginChooserDlg(Frame parent, ProgramReceiveIf[] pluginArr, String description, ProgramReceiveIf caller) {
        this((Window)parent, pluginArr, description, caller);
    }

    @Deprecated
    public PluginChooserDlg(Frame parent, ProgramReceiveTarget[] targets, String description, ProgramReceiveIf caller) {
        this((Window)parent, targets, description, caller);
    }

    @Deprecated
    public PluginChooserDlg(Frame parent, ProgramReceiveTarget[] targets, String description, ProgramReceiveIf caller, ProgramReceiveTarget[] disabledTargets) {
        this((Window)parent, targets, description, caller, disabledTargets);
    }

    private Hashtable<ProgramReceiveIf, ArrayList<ProgramReceiveTarget>> createReceiveTable(ProgramReceiveTarget[] targets) {
        Hashtable<ProgramReceiveIf, ArrayList<ProgramReceiveTarget>> table = new Hashtable<ProgramReceiveIf, ArrayList<ProgramReceiveTarget>>();
        if (targets != null) {
            for (ProgramReceiveTarget target : targets) {
                if (target == null || target.getReceifeIfForIdOfTarget() == null) continue;
                ArrayList<ProgramReceiveTarget> receiveTargetList = table.get(target.getReceifeIfForIdOfTarget());
                if (receiveTargetList != null) {
                    receiveTargetList.add(target);
                    continue;
                }
                receiveTargetList = new ArrayList();
                receiveTargetList.add(target);
                table.put(target.getReceifeIfForIdOfTarget(), receiveTargetList);
            }
        }
        return table;
    }

    private void init(ProgramReceiveIf[] pluginArr, String description, ProgramReceiveIf caller, Hashtable<ProgramReceiveIf, ArrayList<ProgramReceiveTarget>> targetTable, final ProgramReceiveTarget[] disabledReceiveTargets, Window parent) {
        this.mOkWasPressed = false;
        this.setTitle(mLocalizer.msg("title", "Choose Plugins"));
        UiUtilities.registerForClosing(this);
        if (pluginArr == null) {
            this.mPluginArr = new ProgramReceiveIf[0];
            this.mResultPluginArr = new ProgramReceiveIf[0];
            this.mReceiveTargetTable = new Hashtable();
        } else {
            this.mPluginArr = pluginArr;
            this.mResultPluginArr = pluginArr;
            this.mReceiveTargetTable = targetTable;
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        FormLayout layout = new FormLayout("fill:pref:grow", "");
        contentPane.setLayout(layout);
        contentPane.setBorder(Borders.DLU4);
        CellConstraints cc = new CellConstraints();
        Object[] tempProgramReceiveIf = Plugin.getPluginManager().getReceiveIfs(caller, null);
        ArrayList<ProgramReceiveIf> disabledList = new ArrayList<ProgramReceiveIf>(disabledReceiveTargets != null ? disabledReceiveTargets.length : 0);
        if (disabledReceiveTargets != null) {
            for (ProgramReceiveTarget target : disabledReceiveTargets) {
                disabledList.add(target.getReceifeIfForIdOfTarget());
            }
        }
        if (caller != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object tempIf : tempProgramReceiveIf) {
                if (tempIf.getId().compareTo(caller.getId()) == 0) continue;
                list.add(tempIf);
            }
            this.mPluginItemList = new SelectableItemList((Object[])this.mResultPluginArr, list.toArray(), disabledList.toArray());
        } else {
            this.mPluginItemList = new SelectableItemList((Object[])this.mResultPluginArr, tempProgramReceiveIf, disabledList.toArray());
        }
        this.mPluginItemList.setSelectionMode(0);
        int pos = 1;
        layout.appendRow(RowSpec.decode("fill:default:grow"));
        layout.appendRow(RowSpec.decode("3dlu"));
        if (targetTable != null) {
            JSplitPane splitPane = new JSplitPane();
            splitPane.setLeftComponent(this.mPluginItemList);
            final JPanel targetPanel = new JPanel();
            targetPanel.setLayout(new BorderLayout());
            this.mPluginItemList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    try {
                        if (!e.getValueIsAdjusting()) {
                            targetPanel.removeAll();
                            SelectableItem pluginItem = (SelectableItem)PluginChooserDlg.this.mPluginItemList.getSelectedValue();
                            ProgramReceiveIf plugin = (ProgramReceiveIf)pluginItem.getItem();
                            ProgramReceiveTarget[] pluginTargets = plugin.getProgramReceiveTargets();
                            PluginChooserDlg.access$102(PluginChooserDlg.this, Arrays.copyOf(pluginTargets, pluginTargets.length));
                            if (PluginChooserDlg.this.mCurrentTargets != null) {
                                Arrays.sort(PluginChooserDlg.this.mCurrentTargets);
                                ArrayList<ProgramReceiveTarget> targets = (ArrayList<ProgramReceiveTarget>)PluginChooserDlg.this.mReceiveTargetTable.get(plugin);
                                if (targets == null || !pluginItem.isSelected()) {
                                    targets = new ArrayList<ProgramReceiveTarget>();
                                }
                                if (pluginItem.isSelected() && targets.isEmpty()) {
                                    targets.add(PluginChooserDlg.this.mCurrentTargets[0]);
                                }
                                PluginChooserDlg.this.mReceiveTargetTable.put(plugin, targets);
                                final SelectableItemList targetList = new SelectableItemList(targets.toArray(), (Object[])PluginChooserDlg.this.mCurrentTargets, disabledReceiveTargets);
                                targetPanel.add((Component)targetList, "Center");
                                targetList.addListSelectionListener(new ListSelectionListener(){

                                    @Override
                                    public void valueChanged(ListSelectionEvent listEvent) {
                                        if (!listEvent.getValueIsAdjusting()) {
                                            SelectableItem currPluginItem = (SelectableItem)PluginChooserDlg.this.mPluginItemList.getSelectedValue();
                                            ProgramReceiveIf currPlugin = (ProgramReceiveIf)currPluginItem.getItem();
                                            Object[] sel = targetList.getSelection();
                                            ArrayList<ProgramReceiveTarget> selTargets = new ArrayList<ProgramReceiveTarget>(sel.length);
                                            for (Object obj : sel) {
                                                selTargets.add((ProgramReceiveTarget)obj);
                                            }
                                            if (currPluginItem.isSelected() != sel.length > 0) {
                                                currPluginItem.setSelected(sel.length > 0);
                                                PluginChooserDlg.this.mPluginItemList.updateUI();
                                            }
                                            PluginChooserDlg.this.mReceiveTargetTable.put(currPlugin, selTargets);
                                        }
                                    }
                                });
                            }
                            targetPanel.updateUI();
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            });
            splitPane.setRightComponent(targetPanel);
            contentPane.add((Component)splitPane, cc.xy(1, pos));
        } else {
            contentPane.add((Component)this.mPluginItemList, cc.xy(1, pos));
        }
        this.mPluginItemList.setSelectedIndex(0);
        pos += 2;
        if (description != null) {
            JLabel lb = new JLabel(description);
            layout.appendRow(RowSpec.decode("pref"));
            layout.appendRow(RowSpec.decode("3dlu"));
            contentPane.add((Component)lb, cc.xy(1, pos));
            pos += 2;
        }
        JButton okBt = new JButton(Localizer.getLocalization("i18n_ok"));
        JButton cancelBt = new JButton(Localizer.getLocalization("i18n_cancel"));
        okBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PluginChooserDlg.this.mOkWasPressed = true;
                Object[] o = PluginChooserDlg.this.mPluginItemList.getSelection();
                PluginChooserDlg.access$402(PluginChooserDlg.this, new ProgramReceiveIf[o.length]);
                for (int i = 0; i < o.length; ++i) {
                    ((PluginChooserDlg)PluginChooserDlg.this).mResultPluginArr[i] = (ProgramReceiveIf)o[i];
                }
                PluginChooserDlg.this.close();
            }
        });
        cancelBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PluginChooserDlg.this.mOkWasPressed = false;
                PluginChooserDlg.access$402(PluginChooserDlg.this, null);
                PluginChooserDlg.this.close();
            }
        });
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addGlue();
        builder.addButton(okBt, cancelBt);
        layout.appendRow(RowSpec.decode("pref"));
        contentPane.add((Component)builder.getPanel(), cc.xy(1, pos));
        Settings.layoutWindow("pluginChooserDlg", this, new Dimension(350, 300), parent);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PluginChooserDlg.this.close();
            }
        });
    }

    public ProgramReceiveIf[] getPlugins() {
        if (this.mResultPluginArr == null) {
            return new ProgramReceiveIf[0];
        }
        return (ProgramReceiveIf[])this.mResultPluginArr.clone();
    }

    public ProgramReceiveTarget[] getReceiveTargets() {
        if (this.mOkWasPressed) {
            ArrayList targetList = new ArrayList();
            Enumeration<ProgramReceiveIf> keyEnum = this.mReceiveTargetTable.keys();
            while (keyEnum.hasMoreElements()) {
                ProgramReceiveIf plugin = keyEnum.nextElement();
                for (ProgramReceiveIf selectedPlugin : this.mResultPluginArr) {
                    if (selectedPlugin != plugin) continue;
                    targetList.addAll(this.mReceiveTargetTable.get(plugin));
                }
            }
            return targetList.toArray(new ProgramReceiveTarget[targetList.size()]);
        }
        return null;
    }

    @Override
    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    static /* synthetic */ ProgramReceiveTarget[] access$102(PluginChooserDlg x0, ProgramReceiveTarget[] x1) {
        x0.mCurrentTargets = x1;
        return x1;
    }

    static /* synthetic */ ProgramReceiveIf[] access$402(PluginChooserDlg x0, ProgramReceiveIf[] x1) {
        x0.mResultPluginArr = x1;
        return x1;
    }
}

