/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import tvbrowser.core.Settings;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class SendToPluginDialog
extends JDialog
implements WindowClosingIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(SendToPluginDialog.class);
    private Program[] mPrograms;
    private JComboBox mPluginList;
    private JComboBox mTargetList;
    private ProgramReceiveIf mCaller;
    private ProgramReceiveTarget mCallerTarget;

    public SendToPluginDialog(ProgramReceiveIf caller, Window owner, Program[] prg) {
        this(caller, null, owner, prg);
    }

    @Deprecated
    public SendToPluginDialog(ProgramReceiveIf caller, Frame owner, Program[] prg) {
        this(caller, null, (Window)owner, prg);
    }

    @Deprecated
    public SendToPluginDialog(ProgramReceiveIf caller, Dialog owner, Program[] prg) {
        this(caller, null, (Window)owner, prg);
    }

    @Deprecated
    public SendToPluginDialog(ProgramReceiveIf caller, ProgramReceiveTarget callerTarget, Frame owner, Program[] prg) {
        this(caller, callerTarget, (Window)owner, prg);
    }

    public SendToPluginDialog(ProgramReceiveIf caller, ProgramReceiveTarget callerTarget, Window owner, Program[] prg) {
        super(owner);
        this.setModal(true);
        this.mPrograms = prg;
        this.mCaller = caller;
        this.mCallerTarget = callerTarget;
        this.createDialog(owner);
    }

    @Deprecated
    public SendToPluginDialog(ProgramReceiveIf caller, ProgramReceiveTarget callerTarget, Dialog owner, Program[] prg) {
        this(caller, callerTarget, (Window)owner, prg);
    }

    private void createDialog(Window parent) {
        this.setTitle(mLocalizer.msg("title", "Send to other Plugin"));
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu,0dlu:grow,5dlu", "pref,5dlu,pref,5dlu,pref,5dlu,pref,fill:10dlu:grow,pref"));
        pb.border(Borders.DIALOG);
        pb.addSeparator(mLocalizer.msg("sendTo", "Send {0} programs to", this.mPrograms.length), cc.xyw(1, 1, 3));
        ProgramReceiveIf[] installedPluginArr = Plugin.getPluginManager().getReceiveIfs(this.mCaller, this.mCallerTarget);
        Arrays.sort(installedPluginArr, new ObjectComparator());
        this.mPluginList = new JComboBox<ProgramReceiveIf>(installedPluginArr);
        pb.add((Component)this.mPluginList, cc.xy(2, 3));
        pb.addSeparator(mLocalizer.msg("target", "Target:"), cc.xyw(1, 5, 3));
        this.mTargetList = new JComboBox<ProgramReceiveTarget>(installedPluginArr[0].getProgramReceiveTargets());
        pb.add((Component)this.mTargetList, cc.xy(2, 7));
        final DefaultComboBoxModel model = (DefaultComboBoxModel)this.mTargetList.getModel();
        this.mTargetList.setEnabled(installedPluginArr[0].canReceiveProgramsWithTarget() && this.mTargetList.getItemCount() > 1);
        this.mPluginList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ProgramReceiveTarget[] targets = ((ProgramReceiveIf)e.getItem()).getProgramReceiveTargets();
                    model.removeAllElements();
                    if (((ProgramReceiveIf)e.getItem()).canReceiveProgramsWithTarget()) {
                        for (ProgramReceiveTarget target : targets) {
                            if (target.equals(SendToPluginDialog.this.mCallerTarget)) continue;
                            model.addElement(target);
                        }
                        SendToPluginDialog.this.mTargetList.setEnabled(targets.length > 1);
                    } else if (targets != null && targets.length > 0) {
                        model.addElement(targets[0]);
                        SendToPluginDialog.this.mTargetList.setEnabled(false);
                    }
                    SendToPluginDialog.this.mTargetList.repaint();
                }
            }
        });
        String lastUsedPlugin = Settings.propLastUsedReceivePlugin.getString();
        if (lastUsedPlugin != null) {
            for (ProgramReceiveIf programReceiveIf : installedPluginArr) {
                if (!programReceiveIf.getId().equals(lastUsedPlugin)) continue;
                this.mPluginList.setSelectedItem(programReceiveIf);
                String lastUsedTarget = Settings.propLastUsedReceiveTarget.getString();
                if (lastUsedTarget == null) continue;
                for (ProgramReceiveTarget target : programReceiveIf.getProgramReceiveTargets()) {
                    if (!target.getTargetId().equals(lastUsedTarget)) continue;
                    this.mTargetList.setSelectedItem(lastUsedTarget);
                }
            }
        }
        JButton sendButton = new JButton(mLocalizer.msg("send", "Send"));
        sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SendToPluginDialog.this.send();
                SendToPluginDialog.this.setVisible(false);
            }
        });
        sendButton.setEnabled(this.mPrograms.length > 0);
        JButton cancelButton = new JButton(Localizer.getLocalization("i18n_cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SendToPluginDialog.this.setVisible(false);
            }
        });
        ButtonBarBuilder buttonBuilder = new ButtonBarBuilder();
        buttonBuilder.addGlue();
        buttonBuilder.addButton(sendButton, cancelButton);
        pb.add((Component)buttonBuilder.getPanel(), cc.xyw(1, 9, 3));
        this.setLayout(new BorderLayout());
        this.add((Component)pb.getPanel(), "Center");
        Settings.layoutWindow("util.sendToDialog", this, new Dimension(Sizes.dialogUnitXAsPixel(220, this), Sizes.dialogUnitYAsPixel(125, this)), parent);
        UiUtilities.registerForClosing(this);
        this.getRootPane().setDefaultButton(sendButton);
    }

    protected void send() {
        int result = 0;
        ProgramReceiveIf plug = (ProgramReceiveIf)this.mPluginList.getSelectedItem();
        if (this.mPrograms.length > 5) {
            result = JOptionPane.showConfirmDialog(this, mLocalizer.msg("AskBeforeSend", "Are you really sure to send {0} programs\nto \"{1}\"?", this.mPrograms.length, plug.toString()), mLocalizer.msg("Attention", "Attention"), 0, 2);
        }
        if (result == 0) {
            ProgramReceiveTarget target = (ProgramReceiveTarget)this.mTargetList.getSelectedItem();
            plug.receivePrograms(this.mPrograms, target);
            Settings.propLastUsedReceivePlugin.setString(plug.getId());
            Settings.propLastUsedReceiveTarget.setString(target.getTargetId());
        }
    }

    @Override
    public void close() {
        this.setVisible(false);
    }

    private static class ObjectComparator
    implements Comparator<ProgramReceiveIf> {
        private ObjectComparator() {
        }

        @Override
        public int compare(ProgramReceiveIf o1, ProgramReceiveIf o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

