/*
 * Decompiled with CFR 0.152.
 */
package com._17od.upm.database;

import com._17od.upm.database.FlatPackObject;
import com._17od.upm.database.ProblemReadingDatabaseFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DatabaseHeader
extends FlatPackObject {
    private int majorVersion;
    private int minorVersion;
    private int patchVersion;

    public DatabaseHeader(InputStream is) throws IOException, ProblemReadingDatabaseFile {
        this.assemble(is);
    }

    public DatabaseHeader(int majorVersion, int minorVersion, int patchVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchVersion = patchVersion;
    }

    @Override
    public void flatPack(OutputStream os) throws IOException {
        os.write(this.flatPack(String.valueOf(this.majorVersion)));
        os.write(this.flatPack(String.valueOf(this.minorVersion)));
        os.write(this.flatPack(String.valueOf(this.patchVersion)));
    }

    private void assemble(InputStream is) throws IOException, ProblemReadingDatabaseFile {
        this.majorVersion = this.getInt(is);
        this.minorVersion = this.getInt(is);
        this.patchVersion = this.getInt(is);
    }

    public String getVersion() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.majorVersion);
        buf.append('.');
        buf.append(this.minorVersion);
        buf.append('.');
        buf.append(this.patchVersion);
        return buf.toString();
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getPatchVersion() {
        return this.patchVersion;
    }

    public void setPatchVersion(int patchVersion) {
        this.patchVersion = patchVersion;
    }
}

