/*
 * Decompiled with CFR 0.152.
 */
package com._17od.upm.gui;

import com._17od.upm.crypto.CryptoException;
import com._17od.upm.crypto.InvalidPasswordException;
import com._17od.upm.database.AccountInformation;
import com._17od.upm.database.AccountsCSVMarshaller;
import com._17od.upm.database.ExportException;
import com._17od.upm.database.ImportException;
import com._17od.upm.database.PasswordDatabase;
import com._17od.upm.database.PasswordDatabasePersistence;
import com._17od.upm.database.ProblemReadingDatabaseFile;
import com._17od.upm.gui.AboutDialog;
import com._17od.upm.gui.AccountDialog;
import com._17od.upm.gui.DatabasePropertiesDialog;
import com._17od.upm.gui.MainWindow;
import com._17od.upm.gui.OpenDatabaseFromURLDialog;
import com._17od.upm.gui.OptionsDialog;
import com._17od.upm.gui.PasswordDatabaseException;
import com._17od.upm.gui.SortedListModel;
import com._17od.upm.gui.UPMException;
import com._17od.upm.transport.Transport;
import com._17od.upm.transport.TransportException;
import com._17od.upm.util.FileChangedCallback;
import com._17od.upm.util.FileMonitor;
import com._17od.upm.util.Preferences;
import com._17od.upm.util.Translator;
import com._17od.upm.util.Util;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatabaseActions {
    private static Log LOG = LogFactory.getLog(DatabaseActions.class);
    private MainWindow mainWindow;
    private PasswordDatabase database;
    private ArrayList accountNames;
    private boolean localDatabaseDirty = true;
    private PasswordDatabasePersistence dbPers;
    private FileMonitor fileMonitor;
    private boolean databaseNeedsReload = false;
    private boolean lockIfInactive;
    private int msToWaitBeforeClosingDB;
    private boolean runSetDBDirtyThread = true;

    public DatabaseActions(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    public void newDatabase() throws IOException, CryptoException {
        int option;
        File newDatabaseFile = this.getSaveAsFile(Translator.translate("newPasswordDatabase"));
        if (newDatabaseFile == null) {
            return;
        }
        final JPasswordField masterPassword = new JPasswordField("");
        boolean passwordsMatch = false;
        do {
            JPasswordField confirmedMasterPassword = new JPasswordField("");
            JOptionPane pane = new JOptionPane(new Object[]{Translator.translate("enterMasterPassword"), masterPassword, Translator.translate("confirmation"), confirmedMasterPassword}, 3, 2);
            JDialog dialog = pane.createDialog(this.mainWindow, Translator.translate("masterPassword"));
            dialog.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    masterPassword.requestFocusInWindow();
                }
            });
            dialog.show();
            if (pane.getValue().equals(new Integer(0))) {
                if (!Arrays.equals(masterPassword.getPassword(), confirmedMasterPassword.getPassword())) {
                    JOptionPane.showMessageDialog(this.mainWindow, Translator.translate("passwordsDontMatch"));
                    continue;
                }
                passwordsMatch = true;
                continue;
            }
            return;
        } while (!passwordsMatch);
        if (newDatabaseFile.exists()) {
            newDatabaseFile.delete();
        }
        this.database = new PasswordDatabase(newDatabaseFile);
        this.dbPers = new PasswordDatabasePersistence(masterPassword.getPassword());
        this.saveDatabase();
        this.accountNames = new ArrayList();
        this.doOpenDatabaseActions();
        if ((Preferences.get("DBToLoadOnStartup") == null || Preferences.get("DBToLoadOnStartup").equals("")) && (option = JOptionPane.showConfirmDialog(this.mainWindow, Translator.translate("setNewLoadOnStartupDatabase"), Translator.translate("newPasswordDatabase"), 0)) == 0) {
            Preferences.set("DBToLoadOnStartup", newDatabaseFile.getAbsolutePath());
            Preferences.save();
        }
    }

    public void changeMasterPassword() throws IOException, ProblemReadingDatabaseFile, CryptoException, PasswordDatabaseException, TransportException {
        if (this.getLatestVersionOfDatabase()) {
            boolean passwordCorrect = false;
            boolean okClicked = true;
            do {
                char[] password;
                if ((password = this.askUserForPassword(Translator.translate("enterDatabasePassword"))) == null) {
                    okClicked = false;
                    continue;
                }
                try {
                    this.dbPers.load(this.database.getDatabaseFile(), password);
                    passwordCorrect = true;
                }
                catch (InvalidPasswordException e) {
                    JOptionPane.showMessageDialog(this.mainWindow, Translator.translate("incorrectPassword"));
                }
            } while (!passwordCorrect && okClicked);
            if (passwordCorrect) {
                Object buttonClicked;
                final JPasswordField masterPassword = new JPasswordField("");
                boolean passwordsMatch = false;
                do {
                    JPasswordField confirmedMasterPassword = new JPasswordField("");
                    JOptionPane pane = new JOptionPane(new Object[]{Translator.translate("enterNewMasterPassword"), masterPassword, Translator.translate("confirmation"), confirmedMasterPassword}, 3, 2);
                    JDialog dialog = pane.createDialog(this.mainWindow, Translator.translate("changeMasterPassword"));
                    dialog.addWindowFocusListener(new WindowAdapter(){

                        @Override
                        public void windowGainedFocus(WindowEvent e) {
                            masterPassword.requestFocusInWindow();
                        }
                    });
                    dialog.show();
                    buttonClicked = pane.getValue();
                    if (!buttonClicked.equals(new Integer(0))) continue;
                    if (!Arrays.equals(masterPassword.getPassword(), confirmedMasterPassword.getPassword())) {
                        JOptionPane.showMessageDialog(this.mainWindow, Translator.translate("passwordsDontMatch"));
                        continue;
                    }
                    passwordsMatch = true;
                } while (buttonClicked.equals(new Integer(0)) && !passwordsMatch);
                if (buttonClicked.equals(new Integer(0)) && passwordsMatch) {
                    this.dbPers.getEncryptionService().initCipher(masterPassword.getPassword());
                    this.saveDatabase();
                }
            }
        }
    }

    public void errorHandler(Exception e) {
        e.printStackTrace();
        String errorMessage = e.getMessage();
        if (errorMessage == null) {
            errorMessage = e.getClass().getName();
        }
        JOptionPane.showMessageDialog(this.mainWindow, errorMessage, Translator.translate("error"), 0);
    }

    private void doCloseDatabaseActions() {
        this.mainWindow.getAddAccountButton().setEnabled(false);
        this.mainWindow.getAddAccountMenuItem().setEnabled(false);
        this.mainWindow.getSearchField().setEnabled(false);
        this.mainWindow.getSearchField().setText("");
        this.mainWindow.getSearchIcon().setEnabled(false);
        this.mainWindow.getResetSearchButton().setEnabled(false);
        this.mainWindow.getChangeMasterPasswordMenuItem().setEnabled(false);
        this.mainWindow.getDatabasePropertiesMenuItem().setEnabled(false);
        this.mainWindow.getExportMenuItem().setEnabled(false);
        this.mainWindow.getImportMenuItem().setEnabled(false);
        this.mainWindow.setTitle(MainWindow.getApplicationName());
        this.mainWindow.getStatusBar().setText("");
        this.databaseNeedsReload = false;
        SortedListModel listview = (SortedListModel)this.mainWindow.getAccountsListview().getModel();
        listview.clear();
        this.mainWindow.getEditAccountButton().setEnabled(false);
        this.mainWindow.getCopyUsernameButton().setEnabled(false);
        this.mainWindow.getCopyPasswordButton().setEnabled(false);
        this.mainWindow.getLaunchURLButton().setEnabled(false);
        this.mainWindow.getDeleteAccountButton().setEnabled(false);
        this.mainWindow.getEditAccountMenuItem().setEnabled(false);
        this.mainWindow.getCopyUsernameMenuItem().setEnabled(false);
        this.mainWindow.getCopyPasswordMenuItem().setEnabled(false);
        this.mainWindow.getLaunchURLMenuItem().setEnabled(false);
        this.mainWindow.getDeleteAccountMenuItem().setEnabled(false);
        this.mainWindow.getViewAccountMenuItem().setEnabled(false);
    }

    private void doOpenDatabaseActions() {
        this.mainWindow.getAddAccountButton().setEnabled(true);
        this.mainWindow.getAddAccountMenuItem().setEnabled(true);
        this.mainWindow.getSearchField().setEnabled(true);
        this.mainWindow.getSearchField().setText("");
        this.mainWindow.getSearchIcon().setEnabled(true);
        this.mainWindow.getResetSearchButton().setEnabled(true);
        this.mainWindow.getChangeMasterPasswordMenuItem().setEnabled(true);
        this.mainWindow.getDatabasePropertiesMenuItem().setEnabled(true);
        this.mainWindow.getExportMenuItem().setEnabled(true);
        this.mainWindow.getImportMenuItem().setEnabled(true);
        this.mainWindow.setTitle(this.database.getDatabaseFile() + " - " + MainWindow.getApplicationName());
        this.setLocalDatabaseDirty(true);
        this.databaseNeedsReload = false;
        this.accountNames = this.getAccountNames();
        this.populateListview(this.accountNames);
        FileChangedCallback callback = new FileChangedCallback(){

            @Override
            public void fileChanged(File file) {
                DatabaseActions.this.databaseNeedsReload = true;
                DatabaseActions.this.mainWindow.setFileChangedPanelVisible(true);
            }
        };
        this.fileMonitor = new FileMonitor(this.database.getDatabaseFile(), callback);
        Thread thread = new Thread(this.fileMonitor);
        thread.start();
        this.configureAutoLock();
        this.mainWindow.getSearchField().requestFocusInWindow();
        this.mainWindow.getDatabaseFileChangedPanel().setVisible(false);
    }

    private void configureAutoLock() {
        this.lockIfInactive = Preferences.get("database.auto_lock", "false").equals("true");
        this.msToWaitBeforeClosingDB = Preferences.getInt("database.auto_lock_time", 5) * 60 * 1000;
        if (this.lockIfInactive) {
            LOG.debug((Object)"Enabling autoclose when focus lost");
            if (this.mainWindow.getWindowFocusListeners().length == 0) {
                this.mainWindow.addWindowFocusListener(new AutoLockDatabaseListener());
            }
        } else {
            LOG.debug((Object)"Disabling autoclose when focus lost");
            for (int i = 0; i < this.mainWindow.getWindowFocusListeners().length; ++i) {
                this.mainWindow.removeWindowFocusListener(this.mainWindow.getWindowFocusListeners()[i]);
            }
        }
    }

    public ArrayList getAccountNames() {
        ArrayList dbAccounts = this.database.getAccounts();
        ArrayList<String> accountNames = new ArrayList<String>();
        for (int i = 0; i < dbAccounts.size(); ++i) {
            AccountInformation ai = (AccountInformation)dbAccounts.get(i);
            String accountName = ai.getAccountName();
            accountNames.add(accountName);
        }
        return accountNames;
    }

    private char[] askUserForPassword(String message) {
        char[] password = null;
        final JPasswordField masterPassword = new JPasswordField("");
        JOptionPane pane = new JOptionPane(new Object[]{message, masterPassword}, 3, 2);
        JDialog dialog = pane.createDialog(this.mainWindow, Translator.translate("masterPassword"));
        dialog.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                masterPassword.requestFocusInWindow();
            }
        });
        dialog.show();
        if (pane.getValue() != null && pane.getValue().equals(new Integer(0))) {
            password = masterPassword.getPassword();
        }
        return password;
    }

    public void openDatabase(String databaseFilename) throws IOException, ProblemReadingDatabaseFile, CryptoException {
        this.openDatabase(databaseFilename, null);
    }

    public void openDatabase(String databaseFilename, char[] password) throws IOException, ProblemReadingDatabaseFile, CryptoException {
        boolean passwordCorrect = false;
        boolean okClicked = true;
        while (!passwordCorrect && okClicked) {
            if (password == null) {
                password = this.askUserForPassword(Translator.translate("enterDatabasePassword"));
                if (password == null) {
                    okClicked = false;
                }
            } else {
                okClicked = true;
            }
            if (!okClicked) continue;
            try {
                this.dbPers = new PasswordDatabasePersistence();
                this.database = this.dbPers.load(new File(databaseFilename), password);
                passwordCorrect = true;
            }
            catch (InvalidPasswordException e) {
                JOptionPane.showMessageDialog(this.mainWindow, Translator.translate("incorrectPassword"));
                password = null;
            }
        }
        if (passwordCorrect) {
            this.doOpenDatabaseActions();
        }
    }

    public void openDatabase() throws IOException, ProblemReadingDatabaseFile, CryptoException {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(Translator.translate("openDatabase"));
        int returnVal = fc.showOpenDialog(this.mainWindow);
        if (returnVal == 0) {
            File databaseFile = fc.getSelectedFile();
            if (databaseFile.exists()) {
                this.openDatabase(databaseFile.getAbsolutePath());
            } else {
                JOptionPane.showMessageDialog(this.mainWindow, Translator.translate("fileDoesntExistWithName", databaseFile.getAbsolutePath()), Translator.translate("fileDoesntExist"), 0);
            }
        }
        this.runSetDBDirtyThread = false;
    }

    public void deleteAccount() throws IOException, CryptoException, TransportException, ProblemReadingDatabaseFile, PasswordDatabaseException {
        if (this.getLatestVersionOfDatabase()) {
            SortedListModel listview = (SortedListModel)this.mainWindow.getAccountsListview().getModel();
            String selectedAccName = (String)this.mainWindow.getAccountsListview().getSelectedValue();
            int buttonSelected = JOptionPane.showConfirmDialog(this.mainWindow, Translator.translate("askConfirmDeleteAccount", selectedAccName), Translator.translate("confirmDeleteAccount"), 0);
            if (buttonSelected == 0) {
                listview.removeElement(selectedAccName);
                int i = this.accountNames.indexOf(selectedAccName);
                this.accountNames.remove(i);
                this.database.deleteAccount(selectedAccName);
                this.saveDatabase();
                this.filter();
            }
        }
    }

    public void addAccount() throws IOException, CryptoException, TransportException, ProblemReadingDatabaseFile, PasswordDatabaseException {
        if (this.getLatestVersionOfDatabase()) {
            AccountInformation accInfo = new AccountInformation();
            AccountDialog accDialog = new AccountDialog(accInfo, this.mainWindow, false, this.accountNames);
            accDialog.pack();
            accDialog.setLocationRelativeTo(this.mainWindow);
            accDialog.show();
            if (accDialog.okClicked()) {
                this.database.deleteAccount(accInfo.getAccountName());
                this.database.addAccount(accInfo);
                this.saveDatabase();
                this.accountNames.add(accInfo.getAccountName());
                this.filter();
            }
        }
    }

    public AccountInformation getSelectedAccount() {
        String selectedAccName = (String)this.mainWindow.getAccountsListview().getSelectedValue();
        return this.database.getAccount(selectedAccName);
    }

    private boolean getLatestVersionOfDatabase() throws TransportException, ProblemReadingDatabaseFile, IOException, CryptoException, PasswordDatabaseException {
        boolean latestVersionDownloaded = false;
        if (this.databaseHasRemoteInstance() && this.localDatabaseDirty) {
            int answer = JOptionPane.showConfirmDialog(this.mainWindow, Translator.translate("askSyncWithRemoteDB"), Translator.translate("syncDatabase"), 0);
            if (answer == 0) {
                latestVersionDownloaded = this.syncWithRemoteDatabase();
            }
        } else {
            latestVersionDownloaded = true;
        }
        return latestVersionDownloaded;
    }

    private boolean databaseHasRemoteInstance() {
        return !this.database.getDbOptions().getRemoteLocation().equals("");
    }

    public void viewAccount() {
        AccountInformation accInfo = this.getSelectedAccount();
        AccountDialog accDialog = new AccountDialog(accInfo, this.mainWindow, true, this.accountNames);
        accDialog.pack();
        accDialog.setLocationRelativeTo(this.mainWindow);
        accDialog.show();
    }

    public void editAccount(String accountName) throws TransportException, ProblemReadingDatabaseFile, IOException, CryptoException, PasswordDatabaseException, InvalidPasswordException, UPMException {
        if (this.getLatestVersionOfDatabase()) {
            AccountInformation accInfo = this.database.getAccount(accountName);
            if (accInfo == null) {
                throw new UPMException(Translator.translate("accountDoesntExist", accountName));
            }
            AccountDialog accDialog = new AccountDialog(accInfo, this.mainWindow, false, this.accountNames);
            accDialog.pack();
            accDialog.setLocationRelativeTo(this.mainWindow);
            accDialog.show();
            if (accDialog.okClicked() && accDialog.getAccountChanged()) {
                accInfo = accDialog.getAccount();
                this.database.deleteAccount(accountName);
                this.database.addAccount(accInfo);
                if (!accInfo.getAccountName().equals(accountName)) {
                    if (accountName.equals(this.database.getDbOptions().getAuthDBEntry())) {
                        this.database.getDbOptions().setAuthDBEntry(accInfo.getAccountName());
                    }
                    int i = this.accountNames.indexOf(accountName);
                    this.accountNames.remove(i);
                    this.accountNames.add(accInfo.getAccountName());
                    this.filter();
                }
                this.saveDatabase();
            }
        }
    }

    public void filter() {
        String filterStr = this.mainWindow.getSearchField().getText().toLowerCase();
        ArrayList<String> filteredAccountsList = new ArrayList<String>();
        for (int i = 0; i < this.accountNames.size(); ++i) {
            String accountName = (String)this.accountNames.get(i);
            if (!filterStr.equals("") && accountName.toLowerCase().indexOf(filterStr) == -1) continue;
            filteredAccountsList.add(accountName);
        }
        this.populateListview(filteredAccountsList);
        if (this.mainWindow.getAccountsListview().getModel().getSize() == 1) {
            this.mainWindow.getAccountsListview().setSelectedIndex(0);
        }
    }

    public void populateListview(ArrayList accountNames) {
        SortedListModel listview = (SortedListModel)this.mainWindow.getAccountsListview().getModel();
        listview.clear();
        this.mainWindow.getAccountsListview().clearSelection();
        for (int i = 0; i < accountNames.size(); ++i) {
            listview.addElement(accountNames.get(i));
        }
        this.setButtonState();
    }

    public void setButtonState() {
        if (this.mainWindow.getAccountsListview().getSelectedValue() == null) {
            this.mainWindow.getEditAccountButton().setEnabled(false);
            this.mainWindow.getCopyUsernameButton().setEnabled(false);
            this.mainWindow.getCopyPasswordButton().setEnabled(false);
            this.mainWindow.getLaunchURLButton().setEnabled(false);
            this.mainWindow.getDeleteAccountButton().setEnabled(false);
            this.mainWindow.getEditAccountMenuItem().setEnabled(false);
            this.mainWindow.getCopyUsernameMenuItem().setEnabled(false);
            this.mainWindow.getCopyPasswordMenuItem().setEnabled(false);
            this.mainWindow.getLaunchURLMenuItem().setEnabled(false);
            this.mainWindow.getDeleteAccountMenuItem().setEnabled(false);
            this.mainWindow.getViewAccountMenuItem().setEnabled(false);
        } else {
            this.mainWindow.getEditAccountButton().setEnabled(true);
            this.mainWindow.getCopyUsernameButton().setEnabled(true);
            this.mainWindow.getCopyPasswordButton().setEnabled(true);
            this.mainWindow.getLaunchURLButton().setEnabled(true);
            this.mainWindow.getDeleteAccountButton().setEnabled(true);
            this.mainWindow.getEditAccountMenuItem().setEnabled(true);
            this.mainWindow.getCopyUsernameMenuItem().setEnabled(true);
            this.mainWindow.getCopyPasswordMenuItem().setEnabled(true);
            this.mainWindow.getLaunchURLMenuItem().setEnabled(true);
            this.mainWindow.getDeleteAccountMenuItem().setEnabled(true);
            this.mainWindow.getViewAccountMenuItem().setEnabled(true);
        }
    }

    public void options() {
        OptionsDialog oppDialog = new OptionsDialog(this.mainWindow);
        oppDialog.pack();
        oppDialog.setLocationRelativeTo(this.mainWindow);
        oppDialog.show();
        this.configureAutoLock();
        if (oppDialog.hasLanguageChanged()) {
            this.mainWindow.initialiseControlsWithDefaultLanguage();
            if (this.database != null) {
                this.setStatusBarText();
            }
        }
    }

    public void showAbout() {
        AboutDialog aboutDialog = new AboutDialog(this.mainWindow);
        aboutDialog.pack();
        aboutDialog.setLocationRelativeTo(this.mainWindow);
        aboutDialog.show();
    }

    public void resetSearch() {
        this.mainWindow.getSearchField().setText("");
    }

    public void showDatabaseProperties() throws ProblemReadingDatabaseFile, IOException, CryptoException, PasswordDatabaseException {
        block4: {
            try {
                if (this.getLatestVersionOfDatabase()) {
                    DatabasePropertiesDialog dbPropsDialog = new DatabasePropertiesDialog((JFrame)this.mainWindow, this.getAccountNames(), this.database);
                    dbPropsDialog.pack();
                    dbPropsDialog.setLocationRelativeTo(this.mainWindow);
                    dbPropsDialog.show();
                    if (dbPropsDialog.getDatabaseNeedsSaving()) {
                        this.saveDatabase();
                    }
                }
            }
            catch (TransportException e) {
                int response = JOptionPane.showConfirmDialog(this.mainWindow, Translator.translate("problemRetrievingRemoteDB"), Translator.translate("detachDatabase"), 0);
                if (response != 0) break block4;
                this.database.getDbOptions().setRemoteLocation("");
                this.database.getDbOptions().setAuthDBEntry("");
                this.saveDatabase();
            }
        }
    }

    public void openDatabaseFromURL() throws TransportException, IOException, ProblemReadingDatabaseFile, CryptoException {
        OpenDatabaseFromURLDialog openDBDialog = new OpenDatabaseFromURLDialog(this.mainWindow);
        openDBDialog.pack();
        openDBDialog.setLocationRelativeTo(this.mainWindow);
        openDBDialog.show();
        if (openDBDialog.getOkClicked()) {
            String remoteLocation = openDBDialog.getUrlTextField().getText();
            String username = openDBDialog.getUsernameTextField().getText();
            String password = openDBDialog.getPasswordTextField().getText();
            File saveDatabaseTo = this.getSaveAsFile(Translator.translate("saveDatabaseAs"));
            if (saveDatabaseTo != null) {
                Transport transport = Transport.getTransportForURL(new URL(remoteLocation));
                File downloadedDatabaseFile = transport.getRemoteFile(remoteLocation, username, password);
                if (saveDatabaseTo.exists()) {
                    saveDatabaseTo.delete();
                }
                Util.copyFile(downloadedDatabaseFile, saveDatabaseTo);
                this.openDatabase(saveDatabaseTo.getAbsolutePath());
            }
        }
    }

    public void reloadDatabase() throws InvalidPasswordException, ProblemReadingDatabaseFile, IOException {
        PasswordDatabase reloadedDb = null;
        try {
            reloadedDb = this.dbPers.load(this.database.getDatabaseFile());
        }
        catch (InvalidPasswordException e) {
            boolean okClicked = false;
            do {
                char[] password;
                if ((password = this.askUserForPassword(Translator.translate("enterDatabasePassword"))) == null) {
                    okClicked = false;
                    continue;
                }
                okClicked = true;
                try {
                    reloadedDb = this.dbPers.load(this.database.getDatabaseFile(), password);
                }
                catch (InvalidPasswordException invalidPassword) {
                    JOptionPane.showMessageDialog(this.mainWindow, Translator.translate("incorrectPassword"));
                }
                catch (CryptoException e1) {
                    this.errorHandler(e);
                }
            } while (okClicked && reloadedDb == null);
        }
        if (reloadedDb != null) {
            this.database = reloadedDb;
            this.doOpenDatabaseActions();
        }
    }

    public void reloadDatabaseBefore(MainWindow.ChangeDatabaseAction editAction) throws InvalidPasswordException, ProblemReadingDatabaseFile, IOException {
        boolean proceedWithAction = false;
        if (this.databaseNeedsReload) {
            int answer = JOptionPane.showConfirmDialog(this.mainWindow, Translator.translate("askReloadDatabase"), Translator.translate("reloadDatabase"), 0);
            if (answer == 0) {
                proceedWithAction = this.reloadDatabaseFromDisk();
            }
        } else {
            proceedWithAction = true;
        }
        if (proceedWithAction) {
            editAction.doAction();
        }
    }

    public boolean reloadDatabaseFromDisk() throws InvalidPasswordException, ProblemReadingDatabaseFile, IOException {
        boolean reloadSuccessful = false;
        PasswordDatabase reloadedDb = null;
        try {
            reloadedDb = this.dbPers.load(this.database.getDatabaseFile());
        }
        catch (InvalidPasswordException e) {
            boolean okClicked = false;
            do {
                char[] password;
                if ((password = this.askUserForPassword(Translator.translate("enterDatabasePassword"))) == null) {
                    okClicked = false;
                    continue;
                }
                okClicked = true;
                try {
                    reloadedDb = this.dbPers.load(this.database.getDatabaseFile(), password);
                }
                catch (InvalidPasswordException invalidPassword) {
                    JOptionPane.showMessageDialog(this.mainWindow, Translator.translate("incorrectPassword"));
                }
                catch (CryptoException e1) {
                    this.errorHandler(e);
                }
            } while (okClicked && reloadedDb == null);
        }
        if (reloadedDb != null) {
            this.database = reloadedDb;
            this.doOpenDatabaseActions();
            reloadSuccessful = true;
        }
        return reloadSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncWithRemoteDatabase() throws TransportException, ProblemReadingDatabaseFile, IOException, CryptoException, PasswordDatabaseException {
        boolean syncSuccessful = false;
        try {
            this.fileMonitor.pause();
            this.mainWindow.getContentPane().setCursor(new Cursor(3));
            String remoteLocation = this.database.getDbOptions().getRemoteLocation();
            String authDBEntry = this.database.getDbOptions().getAuthDBEntry();
            String httpUsername = null;
            String httpPassword = null;
            if (!authDBEntry.equals("")) {
                httpUsername = this.database.getAccount(authDBEntry).getUserId();
                httpPassword = this.database.getAccount(authDBEntry).getPassword();
            }
            Transport transport = Transport.getTransportForURL(new URL(remoteLocation));
            File remoteDatabaseFile = transport.getRemoteFile(remoteLocation, this.database.getDatabaseFile().getName(), httpUsername, httpPassword);
            PasswordDatabase remoteDatabase = null;
            char[] password = null;
            boolean successfullyDecryptedDb = false;
            try {
                remoteDatabase = this.dbPers.load(remoteDatabaseFile);
                successfullyDecryptedDb = true;
            }
            catch (InvalidPasswordException e) {
                boolean okClicked = false;
                do {
                    if ((password = this.askUserForPassword(Translator.translate("enterPaswordForRemoteDB"))) == null) {
                        okClicked = false;
                        continue;
                    }
                    okClicked = true;
                    try {
                        remoteDatabase = this.dbPers.load(remoteDatabaseFile, password);
                        successfullyDecryptedDb = true;
                    }
                    catch (InvalidPasswordException invalidPassword) {
                        JOptionPane.showMessageDialog(this.mainWindow, Translator.translate("incorrectPassword"));
                    }
                } while (okClicked && !successfullyDecryptedDb);
            }
            if (successfullyDecryptedDb) {
                if (this.database.getRevision() > remoteDatabase.getRevision()) {
                    transport.delete(remoteLocation, this.database.getDatabaseFile().getName(), httpUsername, httpPassword);
                    transport.put(remoteLocation, this.database.getDatabaseFile(), httpUsername, httpPassword);
                    syncSuccessful = true;
                } else if (this.database.getRevision() < remoteDatabase.getRevision()) {
                    Util.copyFile(remoteDatabaseFile, this.database.getDatabaseFile());
                    this.database = new PasswordDatabase(remoteDatabase.getRevisionObj(), remoteDatabase.getDbOptions(), remoteDatabase.getAccountsHash(), this.database.getDatabaseFile());
                    this.doOpenDatabaseActions();
                    syncSuccessful = true;
                } else {
                    syncSuccessful = true;
                }
                if (syncSuccessful) {
                    this.setLocalDatabaseDirty(false);
                    final long dirtyThreadStartTime = System.currentTimeMillis();
                    this.runSetDBDirtyThread = true;
                    Thread setDBDirtyThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            while (DatabaseActions.this.runSetDBDirtyThread) {
                                long currentTime;
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                if ((currentTime = System.currentTimeMillis()) - dirtyThreadStartTime <= 300000L) continue;
                                LOG.info((Object)"SetDBDirtyThread setting database dirty");
                                DatabaseActions.this.setLocalDatabaseDirty(true);
                                DatabaseActions.this.runSetDBDirtyThread = false;
                            }
                        }
                    });
                    setDBDirtyThread.setName("SetDBDirty");
                    setDBDirtyThread.start();
                    LOG.info((Object)"Started SetDBDirtyThread thread");
                }
            }
        }
        finally {
            this.mainWindow.getContentPane().setCursor(new Cursor(0));
            this.fileMonitor.start();
        }
        return syncSuccessful;
    }

    public void exitApplication() {
        System.exit(0);
    }

    public void export() {
        File exportFile = this.getSaveAsFile(Translator.translate("exportFile"));
        if (exportFile == null) {
            return;
        }
        if (exportFile.exists()) {
            exportFile.delete();
        }
        AccountsCSVMarshaller marshaller = new AccountsCSVMarshaller();
        try {
            marshaller.marshal(this.database.getAccounts(), exportFile);
        }
        catch (ExportException e) {
            JOptionPane.showMessageDialog(this.mainWindow, e.getMessage(), Translator.translate("problemExporting"), 0);
        }
    }

    public void importAccounts() throws TransportException, ProblemReadingDatabaseFile, IOException, CryptoException, PasswordDatabaseException {
        if (this.getLatestVersionOfDatabase()) {
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle(Translator.translate("import"));
            int returnVal = fc.showOpenDialog(this.mainWindow);
            if (returnVal == 0) {
                File csvFile = fc.getSelectedFile();
                try {
                    int i;
                    AccountsCSVMarshaller marshaller = new AccountsCSVMarshaller();
                    ArrayList accountsInCSVFile = marshaller.unmarshal(csvFile);
                    ArrayList<AccountInformation> accountsToImport = new ArrayList<AccountInformation>();
                    boolean importCancelled = false;
                    for (i = 0; i < accountsInCSVFile.size(); ++i) {
                        AccountInformation importedAccount = (AccountInformation)accountsInCSVFile.get(i);
                        if (this.database.getAccount(importedAccount.getAccountName()) != null) {
                            Object[] options = new Object[]{"Overwrite Existing", "Keep Existing", "Cancel"};
                            int answer = JOptionPane.showOptionDialog(this.mainWindow, Translator.translate("importExistingQuestion", importedAccount.getAccountName()), Translator.translate("importExistingTitle"), 1, 3, null, options, options[1]);
                            if (answer == 1) continue;
                            if (answer == 2) {
                                importCancelled = true;
                                break;
                            }
                        }
                        accountsToImport.add(importedAccount);
                    }
                    if (!importCancelled && accountsToImport.size() > 0) {
                        for (i = 0; i < accountsToImport.size(); ++i) {
                            AccountInformation accountToImport = (AccountInformation)accountsToImport.get(i);
                            this.database.deleteAccount(accountToImport.getAccountName());
                            this.database.addAccount(accountToImport);
                        }
                        this.saveDatabase();
                        this.accountNames = this.getAccountNames();
                        this.filter();
                    }
                }
                catch (ImportException e) {
                    JOptionPane.showMessageDialog(this.mainWindow, e.getMessage(), Translator.translate("problemImporting"), 0);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this.mainWindow, e.getMessage(), Translator.translate("problemImporting"), 0);
                }
                catch (CryptoException e) {
                    JOptionPane.showMessageDialog(this.mainWindow, e.getMessage(), Translator.translate("problemImporting"), 0);
                }
            }
        }
    }

    private File getSaveAsFile(String title) {
        File selectedFile;
        boolean gotValidFile = false;
        do {
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle(title);
            int returnVal = fc.showSaveDialog(this.mainWindow);
            if (returnVal != 0) {
                return null;
            }
            selectedFile = fc.getSelectedFile();
            if (selectedFile.exists()) {
                Object[] options = new Object[]{"Yes", "No"};
                int i = JOptionPane.showOptionDialog(this.mainWindow, Translator.translate("fileAlreadyExistsWithFileName", selectedFile.getAbsolutePath()) + '\n' + Translator.translate("overwrite"), Translator.translate("fileAlreadyExists"), 0, 3, null, options, options[1]);
                if (i != 0) continue;
                gotValidFile = true;
                continue;
            }
            gotValidFile = true;
        } while (!gotValidFile);
        return selectedFile;
    }

    private void saveDatabase() throws IOException, CryptoException {
        this.dbPers.save(this.database);
        if (this.fileMonitor != null) {
            this.fileMonitor.start();
        }
        if (this.databaseHasRemoteInstance()) {
            this.setLocalDatabaseDirty(true);
        } else {
            this.setLocalDatabaseDirty(false);
        }
    }

    private void setLocalDatabaseDirty(boolean dirty) {
        this.localDatabaseDirty = dirty;
        if (this.databaseHasRemoteInstance()) {
            if (this.localDatabaseDirty) {
                this.mainWindow.getSyncWithRemoteDatabaseMenuItem().setEnabled(true);
                this.mainWindow.getSyncWithRemoteDatabaseButton().setEnabled(true);
            } else {
                this.mainWindow.getSyncWithRemoteDatabaseMenuItem().setEnabled(false);
                this.mainWindow.getSyncWithRemoteDatabaseButton().setEnabled(false);
            }
        } else {
            this.mainWindow.getSyncWithRemoteDatabaseMenuItem().setEnabled(false);
            this.mainWindow.getSyncWithRemoteDatabaseButton().setEnabled(false);
        }
        this.setStatusBarText();
    }

    private void setStatusBarText() {
        String status = null;
        Color color = null;
        if (this.databaseHasRemoteInstance()) {
            if (this.localDatabaseDirty) {
                status = Translator.translate("unsynchronised");
                color = Color.RED;
            } else {
                status = Translator.translate("synchronised");
                color = Color.BLACK;
            }
            status = Translator.translate("revision") + ' ' + String.valueOf(this.database.getRevision()) + " - " + status;
        } else {
            status = Translator.translate("localDatabase");
            color = Color.BLACK;
        }
        this.mainWindow.getStatusBar().setText(status);
        this.mainWindow.getStatusBar().setForeground(color);
    }

    private class AutoLockDatabaseListener
    implements WindowFocusListener {
        private String databaseClosedOnTimer;
        private Timer closeDBTimer;

        private AutoLockDatabaseListener() {
        }

        @Override
        public synchronized void windowGainedFocus(WindowEvent we) {
            if (this.closeDBTimer != null) {
                LOG.debug((Object)"Stopping closeDBTimer");
                this.closeDBTimer.removeActionListener(this.closeDBTimer.getActionListeners()[0]);
                this.closeDBTimer = null;
            }
            if (this.databaseClosedOnTimer != null) {
                try {
                    DatabaseActions.this.openDatabase(this.databaseClosedOnTimer);
                }
                catch (Exception e) {
                    DatabaseActions.this.errorHandler(e);
                }
                this.databaseClosedOnTimer = null;
            }
        }

        @Override
        public synchronized void windowLostFocus(WindowEvent e) {
            if (e.getOppositeWindow() != null && e.getOppositeWindow().getOwner() == DatabaseActions.this.mainWindow) {
                LOG.debug((Object)"Focus switched to another window within this app");
                return;
            }
            if (DatabaseActions.this.database != null && this.closeDBTimer == null) {
                this.closeDBTimer = new Timer(DatabaseActions.this.msToWaitBeforeClosingDB, null);
                this.closeDBTimer.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LOG.debug((Object)"Closing database due to inactivity");
                        AutoLockDatabaseListener.this.databaseClosedOnTimer = DatabaseActions.this.database.getDatabaseFile().getAbsolutePath();
                        DatabaseActions.this.doCloseDatabaseActions();
                        DatabaseActions.this.database = null;
                        AutoLockDatabaseListener.this.closeDBTimer = null;
                    }
                });
                this.closeDBTimer.setRepeats(false);
                this.closeDBTimer.start();
                LOG.debug((Object)("Started lost focus timer, " + DatabaseActions.this.msToWaitBeforeClosingDB));
            }
        }
    }
}

