/*
 * Decompiled with CFR 0.152.
 */
package com._17od.upm.gui;

import com._17od.upm.crypto.InvalidPasswordException;
import com._17od.upm.database.AccountInformation;
import com._17od.upm.database.ProblemReadingDatabaseFile;
import com._17od.upm.gui.DatabaseActions;
import com._17od.upm.gui.SortedListModel;
import com._17od.upm.platformspecific.PlatformSpecificCode;
import com._17od.upm.util.Preferences;
import com._17od.upm.util.Translator;
import com._17od.upm.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.crypto.IllegalBlockSizeException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.validator.routines.UrlValidator;

public class MainWindow
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String applicationName = "Universal Password Manager";
    public static final String NEW_DATABASE_TXT = "newDatabaseMenuItem";
    public static final String OPEN_DATABASE_TXT = "openDatabaseMenuItem";
    public static final String OPEN_DATABASE_FROM_URL_TXT = "openDatabaseFromURLMenuItem";
    public static final String SYNC_DATABASE_TXT = "syncWithRemoteDatabaseMenuItem";
    public static final String CHANGE_MASTER_PASSWORD_TXT = "changeMasterPasswordMenuItem";
    public static final String DATABASE_PROPERTIES_TXT = "databasePropertiesMenuItem";
    public static final String ADD_ACCOUNT_TXT = "addAccountMenuItem";
    public static final String EDIT_ACCOUNT_TXT = "editAccountMenuItem";
    public static final String DELETE_ACCOUNT_TXT = "deleteAccountMenuItem";
    public static final String VIEW_ACCOUNT_TXT = "viewAccountMenuItem";
    public static final String COPY_USERNAME_TXT = "copyUsernameMenuItem";
    public static final String COPY_PASSWORD_TXT = "copyPasswordMenuItem";
    public static final String LAUNCH_URL_TXT = "launchURLMenuItem";
    public static final String OPTIONS_TXT = "optionsMenuItem";
    public static final String ABOUT_TXT = "aboutMenuItem";
    public static final String RESET_SEARCH_TXT = "resetSearchMenuItem";
    public static final String EXIT_TXT = "exitMenuItem";
    public static final String EXPORT_TXT = "exportMenuItem";
    public static final String IMPORT_TXT = "importMenuItem";
    public static final String LOCK_TIMER_TXT = "lock";
    private JButton addAccountButton;
    private JButton editAccountButton;
    private JButton deleteAccountButton;
    private JButton copyUsernameButton;
    private JButton copyPasswordButton;
    private JButton launchURLButton;
    private JButton optionsButton;
    private JButton syncDatabaseButton;
    private JTextField searchField;
    private JButton resetSearchButton;
    private JLabel searchIcon;
    private JMenu databaseMenu;
    private JMenuItem newDatabaseMenuItem;
    private JMenuItem openDatabaseMenuItem;
    private JMenuItem openDatabaseFromURLMenuItem;
    private JMenuItem syncWithRemoteDatabaseMenuItem;
    private JMenuItem changeMasterPasswordMenuItem;
    private JMenuItem databasePropertiesMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu helpMenu;
    private JMenuItem aboutMenuItem;
    private JMenu accountMenu;
    private JMenuItem addAccountMenuItem;
    private JMenuItem editAccountMenuItem;
    private JMenuItem deleteAccountMenuItem;
    private JMenuItem viewAccountMenuItem;
    private JMenuItem copyUsernameMenuItem;
    private JMenuItem copyPasswordMenuItem;
    private JMenuItem launchURLMenuItem;
    private JMenuItem exportMenuItem;
    private JMenuItem importMenuItem;
    private JList accountsListview;
    private JLabel statusBar = new JLabel(" ");
    private JPanel databaseFileChangedPanel;
    public static MainWindow AppWindow;
    private DatabaseActions dbActions;

    public MainWindow(String title) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException, IllegalBlockSizeException, IOException, GeneralSecurityException, ProblemReadingDatabaseFile {
        super(title);
        this.setIconImage(Util.loadImage("upm.gif").getImage());
        this.setDefaultCloseOperation(3);
        PlatformSpecificCode.getInstance().initialiseApplication(this);
        this.dbActions = new DatabaseActions(this);
        this.addComponentsToPane();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainWindow.this.storeWindowBounds();
                try {
                    Preferences.save();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.pack();
        this.setLocationRelativeTo(null);
        boolean restore = Preferences.get("window.store_position", "false").equals("true");
        if (restore) {
            this.restoreWindowBounds();
        }
        Boolean appAlwaysonTop = new Boolean(Preferences.get("mainwindow.alwaysontop", "false"));
        this.setAlwaysOnTop(appAlwaysonTop);
        this.setVisible(true);
        try {
            String db = Preferences.get("DBToLoadOnStartup");
            if (db != null && !db.equals("")) {
                File dbFile = new File(db);
                if (!dbFile.exists()) {
                    this.dbActions.errorHandler(new Exception(Translator.translate("dbDoesNotExist", db)));
                } else {
                    this.dbActions.openDatabase(db);
                }
            }
        }
        catch (Exception e) {
            this.dbActions.errorHandler(e);
        }
        this.searchField.requestFocusInWindow();
    }

    public static void setAppAlwaysonTop(boolean val) {
        AppWindow.setAlwaysOnTop(val);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Preferences.load();
                    Translator.initialise();
                    Double jvmVersion = new Double(System.getProperty("java.specification.version"));
                    if (jvmVersion < 1.4) {
                        JOptionPane.showMessageDialog(null, Translator.translate("requireJava14"), Translator.translate("problem"), 0);
                        System.exit(1);
                    } else {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        AppWindow = new MainWindow(MainWindow.applicationName);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void addComponentsToPane() {
        if (!(this.getContentPane().getLayout() instanceof GridBagLayout)) {
            this.getContentPane().setLayout(new GridBagLayout());
        }
        this.setJMenuBar(this.createMenuBar());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        c.fill = 2;
        JToolBar toolbar = this.createToolBar();
        this.getContentPane().add((Component)toolbar, c);
        this.getContentPane().setBackground(toolbar.getBackground());
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        c.fill = 2;
        this.getContentPane().add((Component)new JSeparator(), c);
        this.searchIcon = new JLabel(Util.loadImage("search.gif"));
        this.searchIcon.setDisabledIcon(Util.loadImage("search_d.gif"));
        this.searchIcon.setEnabled(false);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 21;
        c.insets = new Insets(5, 1, 5, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        this.getContentPane().add((Component)this.searchIcon, c);
        this.searchField = new JTextField(15);
        this.searchField.setEnabled(false);
        this.searchField.setMinimumSize(this.searchField.getPreferredSize());
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                MainWindow.this.dbActions.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MainWindow.this.dbActions.filter();
            }
        });
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    MainWindow.this.dbActions.resetSearch();
                } else if (e.getKeyCode() == 10 && MainWindow.this.accountsListview.getModel().getSize() == 1) {
                    MainWindow.this.viewAccountMenuItem.doClick();
                }
            }
        });
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 21;
        c.insets = new Insets(5, 1, 5, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        this.getContentPane().add((Component)this.searchField, c);
        this.resetSearchButton = new JButton(Util.loadImage("stop.gif"));
        this.resetSearchButton.setDisabledIcon(Util.loadImage("stop_d.gif"));
        this.resetSearchButton.setEnabled(false);
        this.resetSearchButton.setToolTipText(Translator.translate(RESET_SEARCH_TXT));
        this.resetSearchButton.setActionCommand(RESET_SEARCH_TXT);
        this.resetSearchButton.addActionListener(this);
        this.resetSearchButton.setBorder(BorderFactory.createEmptyBorder());
        this.resetSearchButton.setFocusable(false);
        c.gridx = 2;
        c.gridy = 2;
        c.anchor = 21;
        c.insets = new Insets(5, 1, 5, 1);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        this.getContentPane().add((Component)this.resetSearchButton, c);
        this.accountsListview = new JList();
        this.accountsListview.setSelectionMode(0);
        this.accountsListview.setSelectedIndex(0);
        this.accountsListview.setVisibleRowCount(10);
        this.accountsListview.setModel(new SortedListModel());
        JScrollPane accountsScrollList = new JScrollPane(this.accountsListview, 20, 30);
        this.accountsListview.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (MainWindow.this.accountsListview.getModel().getSize() > 0 && MainWindow.this.accountsListview.getSelectedIndex() == -1) {
                    MainWindow.this.accountsListview.setSelectionInterval(0, 0);
                }
            }
        });
        this.accountsListview.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MainWindow.this.dbActions.setButtonState();
            }
        });
        this.accountsListview.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MainWindow.this.viewAccountMenuItem.doClick();
                }
            }
        });
        this.accountsListview.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MainWindow.this.viewAccountMenuItem.doClick();
                }
            }
        });
        this.accountsListview.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    try {
                        MainWindow.this.dbActions.reloadDatabaseBefore(new DeleteAccountAction());
                    }
                    catch (InvalidPasswordException e1) {
                        e1.printStackTrace();
                    }
                    catch (ProblemReadingDatabaseFile e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 10;
        c.insets = new Insets(0, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.fill = 1;
        this.getContentPane().add((Component)accountsScrollList, c);
        c.gridx = 0;
        c.gridy = 4;
        c.anchor = 10;
        c.insets = new Insets(0, 1, 0, 1);
        c.ipadx = 3;
        c.ipady = 3;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        c.fill = 1;
        this.databaseFileChangedPanel = new JPanel();
        this.databaseFileChangedPanel.setLayout(new BoxLayout(this.databaseFileChangedPanel, 0));
        this.databaseFileChangedPanel.setBackground(new Color(249, 172, 60));
        this.databaseFileChangedPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JLabel fileChangedLabel = new JLabel("Database file changed");
        fileChangedLabel.setAlignmentX(0.0f);
        this.databaseFileChangedPanel.add(fileChangedLabel);
        this.databaseFileChangedPanel.add(Box.createHorizontalGlue());
        JButton reloadButton = new JButton("Reload");
        reloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MainWindow.this.dbActions.reloadDatabaseFromDisk();
                }
                catch (Exception ex) {
                    MainWindow.this.dbActions.errorHandler(ex);
                }
            }
        });
        this.databaseFileChangedPanel.add(reloadButton);
        this.databaseFileChangedPanel.setVisible(false);
        this.getContentPane().add((Component)this.databaseFileChangedPanel, c);
        c.gridx = 0;
        c.gridy = 5;
        c.anchor = 10;
        c.insets = new Insets(0, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        c.fill = 2;
        this.getContentPane().add((Component)this.statusBar, c);
    }

    public void setFileChangedPanelVisible(boolean visible) {
        this.databaseFileChangedPanel.setVisible(visible);
    }

    private JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        this.addAccountButton = new JButton();
        this.addAccountButton.setToolTipText(Translator.translate(ADD_ACCOUNT_TXT));
        this.addAccountButton.setIcon(Util.loadImage("add_account.gif"));
        this.addAccountButton.setDisabledIcon(Util.loadImage("add_account_d.gif"));
        this.addAccountButton.addActionListener(this);
        this.addAccountButton.setEnabled(false);
        this.addAccountButton.setActionCommand(ADD_ACCOUNT_TXT);
        toolbar.add(this.addAccountButton);
        this.editAccountButton = new JButton();
        this.editAccountButton.setToolTipText(Translator.translate(EDIT_ACCOUNT_TXT));
        this.editAccountButton.setIcon(Util.loadImage("edit_account.gif"));
        this.editAccountButton.setDisabledIcon(Util.loadImage("edit_account_d.gif"));
        this.editAccountButton.addActionListener(this);
        this.editAccountButton.setEnabled(false);
        this.editAccountButton.setActionCommand(EDIT_ACCOUNT_TXT);
        toolbar.add(this.editAccountButton);
        this.deleteAccountButton = new JButton();
        this.deleteAccountButton.setToolTipText(Translator.translate(DELETE_ACCOUNT_TXT));
        this.deleteAccountButton.setIcon(Util.loadImage("delete_account.gif"));
        this.deleteAccountButton.setDisabledIcon(Util.loadImage("delete_account_d.gif"));
        this.deleteAccountButton.addActionListener(this);
        this.deleteAccountButton.setEnabled(false);
        this.deleteAccountButton.setActionCommand(DELETE_ACCOUNT_TXT);
        toolbar.add(this.deleteAccountButton);
        toolbar.addSeparator();
        this.copyUsernameButton = new JButton();
        this.copyUsernameButton.setToolTipText(Translator.translate(COPY_USERNAME_TXT));
        this.copyUsernameButton.setIcon(Util.loadImage("copy_username.gif"));
        this.copyUsernameButton.setDisabledIcon(Util.loadImage("copy_username_d.gif"));
        this.copyUsernameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.copyUsernameToClipboard();
            }
        });
        this.copyUsernameButton.setEnabled(false);
        toolbar.add(this.copyUsernameButton);
        this.copyPasswordButton = new JButton();
        this.copyPasswordButton.setToolTipText(Translator.translate(COPY_PASSWORD_TXT));
        this.copyPasswordButton.setIcon(Util.loadImage("copy_password.gif"));
        this.copyPasswordButton.setDisabledIcon(Util.loadImage("copy_password_d.gif"));
        this.copyPasswordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.copyPasswordToClipboard();
            }
        });
        this.copyPasswordButton.setEnabled(false);
        toolbar.add(this.copyPasswordButton);
        this.launchURLButton = new JButton();
        this.launchURLButton.setToolTipText(Translator.translate(LAUNCH_URL_TXT));
        this.launchURLButton.setIcon(Util.loadImage("launch_URL.gif"));
        this.launchURLButton.setDisabledIcon(Util.loadImage("launch_URL_d.gif"));
        this.launchURLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountInformation accInfo = MainWindow.this.dbActions.getSelectedAccount();
                String uRl = accInfo.getUrl();
                if (uRl == null || uRl.length() == 0) {
                    JOptionPane.showMessageDialog(MainWindow.this.launchURLButton.getParent(), Translator.translate("EmptyUrlJoptionpaneMsg"), Translator.translate("UrlErrorJoptionpaneTitle"), 2);
                } else if (!MainWindow.this.urlIsValid(uRl)) {
                    JOptionPane.showMessageDialog(MainWindow.this.launchURLButton.getParent(), Translator.translate("InvalidUrlJoptionpaneMsg"), Translator.translate("UrlErrorJoptionpaneTitle"), 2);
                } else {
                    MainWindow.this.LaunchSelectedURL(uRl);
                }
            }
        });
        this.launchURLButton.setEnabled(false);
        toolbar.add(this.launchURLButton);
        toolbar.addSeparator();
        this.optionsButton = new JButton();
        this.optionsButton.setToolTipText(Translator.translate(OPTIONS_TXT));
        this.optionsButton.setIcon(Util.loadImage("options.gif"));
        this.optionsButton.setDisabledIcon(Util.loadImage("options_d.gif"));
        this.optionsButton.addActionListener(this);
        this.optionsButton.setEnabled(true);
        this.optionsButton.setActionCommand(OPTIONS_TXT);
        toolbar.add(this.optionsButton);
        toolbar.addSeparator();
        this.syncDatabaseButton = new JButton();
        this.syncDatabaseButton.setToolTipText(Translator.translate(SYNC_DATABASE_TXT));
        this.syncDatabaseButton.setIcon(Util.loadImage("sync.png"));
        this.syncDatabaseButton.setDisabledIcon(Util.loadImage("sync_d.png"));
        this.syncDatabaseButton.addActionListener(this);
        this.syncDatabaseButton.setEnabled(false);
        this.syncDatabaseButton.setActionCommand(SYNC_DATABASE_TXT);
        toolbar.add(this.syncDatabaseButton);
        return toolbar;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.databaseMenu = new JMenu(Translator.translate("databaseMenu"));
        this.databaseMenu.setMnemonic(68);
        menuBar.add(this.databaseMenu);
        this.newDatabaseMenuItem = new JMenuItem(Translator.translate(NEW_DATABASE_TXT), 78);
        this.newDatabaseMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.databaseMenu.add(this.newDatabaseMenuItem);
        this.newDatabaseMenuItem.addActionListener(this);
        this.newDatabaseMenuItem.setActionCommand(NEW_DATABASE_TXT);
        this.openDatabaseMenuItem = new JMenuItem(Translator.translate(OPEN_DATABASE_TXT), 79);
        this.openDatabaseMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.databaseMenu.add(this.openDatabaseMenuItem);
        this.openDatabaseMenuItem.addActionListener(this);
        this.openDatabaseMenuItem.setActionCommand(OPEN_DATABASE_TXT);
        this.openDatabaseFromURLMenuItem = new JMenuItem(Translator.translate(OPEN_DATABASE_FROM_URL_TXT), 76);
        this.openDatabaseFromURLMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.databaseMenu.add(this.openDatabaseFromURLMenuItem);
        this.openDatabaseFromURLMenuItem.addActionListener(this);
        this.openDatabaseFromURLMenuItem.setActionCommand(OPEN_DATABASE_FROM_URL_TXT);
        this.databaseMenu.addSeparator();
        this.syncWithRemoteDatabaseMenuItem = new JMenuItem(Translator.translate(SYNC_DATABASE_TXT), 83);
        this.syncWithRemoteDatabaseMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.databaseMenu.add(this.syncWithRemoteDatabaseMenuItem);
        this.syncWithRemoteDatabaseMenuItem.addActionListener(this);
        this.syncWithRemoteDatabaseMenuItem.setEnabled(false);
        this.syncWithRemoteDatabaseMenuItem.setActionCommand(SYNC_DATABASE_TXT);
        this.changeMasterPasswordMenuItem = new JMenuItem(Translator.translate(CHANGE_MASTER_PASSWORD_TXT), 71);
        this.changeMasterPasswordMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.databaseMenu.add(this.changeMasterPasswordMenuItem);
        this.changeMasterPasswordMenuItem.addActionListener(this);
        this.changeMasterPasswordMenuItem.setEnabled(false);
        this.changeMasterPasswordMenuItem.setActionCommand(CHANGE_MASTER_PASSWORD_TXT);
        this.databasePropertiesMenuItem = new JMenuItem(Translator.translate(DATABASE_PROPERTIES_TXT), 73);
        this.databasePropertiesMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.databaseMenu.add(this.databasePropertiesMenuItem);
        this.databasePropertiesMenuItem.addActionListener(this);
        this.databasePropertiesMenuItem.setEnabled(false);
        this.databasePropertiesMenuItem.setActionCommand(DATABASE_PROPERTIES_TXT);
        this.databaseMenu.addSeparator();
        this.exportMenuItem = new JMenuItem(Translator.translate(EXPORT_TXT));
        this.databaseMenu.add(this.exportMenuItem);
        this.exportMenuItem.addActionListener(this);
        this.exportMenuItem.setEnabled(false);
        this.exportMenuItem.setActionCommand(EXPORT_TXT);
        this.importMenuItem = new JMenuItem(Translator.translate(IMPORT_TXT));
        this.databaseMenu.add(this.importMenuItem);
        this.importMenuItem.addActionListener(this);
        this.importMenuItem.setEnabled(false);
        this.importMenuItem.setActionCommand(IMPORT_TXT);
        this.accountMenu = new JMenu(Translator.translate("accountMenu"));
        this.accountMenu.setMnemonic(65);
        menuBar.add(this.accountMenu);
        this.addAccountMenuItem = new JMenuItem(Translator.translate(ADD_ACCOUNT_TXT), 65);
        this.addAccountMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.accountMenu.add(this.addAccountMenuItem);
        this.addAccountMenuItem.addActionListener(this);
        this.addAccountMenuItem.setEnabled(false);
        this.addAccountMenuItem.setActionCommand(ADD_ACCOUNT_TXT);
        this.editAccountMenuItem = new JMenuItem(Translator.translate(EDIT_ACCOUNT_TXT), 69);
        this.editAccountMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.accountMenu.add(this.editAccountMenuItem);
        this.editAccountMenuItem.addActionListener(this);
        this.editAccountMenuItem.setEnabled(false);
        this.editAccountMenuItem.setActionCommand(EDIT_ACCOUNT_TXT);
        this.deleteAccountMenuItem = new JMenuItem(Translator.translate(DELETE_ACCOUNT_TXT), 68);
        this.deleteAccountMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.accountMenu.add(this.deleteAccountMenuItem);
        this.deleteAccountMenuItem.addActionListener(this);
        this.deleteAccountMenuItem.setEnabled(false);
        this.deleteAccountMenuItem.setActionCommand(DELETE_ACCOUNT_TXT);
        this.viewAccountMenuItem = new JMenuItem(Translator.translate(VIEW_ACCOUNT_TXT), 86);
        this.viewAccountMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.accountMenu.add(this.viewAccountMenuItem);
        this.viewAccountMenuItem.addActionListener(this);
        this.viewAccountMenuItem.setEnabled(false);
        this.viewAccountMenuItem.setActionCommand(VIEW_ACCOUNT_TXT);
        this.copyUsernameMenuItem = new JMenuItem(Translator.translate(COPY_USERNAME_TXT), 85);
        this.copyUsernameMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.accountMenu.add(this.copyUsernameMenuItem);
        this.copyUsernameMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.copyUsernameToClipboard();
            }
        });
        this.copyUsernameMenuItem.setEnabled(false);
        this.copyUsernameMenuItem.setActionCommand(COPY_USERNAME_TXT);
        this.copyPasswordMenuItem = new JMenuItem(Translator.translate(COPY_PASSWORD_TXT), 80);
        this.copyPasswordMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.accountMenu.add(this.copyPasswordMenuItem);
        this.copyPasswordMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.copyPasswordToClipboard();
            }
        });
        this.copyPasswordMenuItem.setEnabled(false);
        this.copyPasswordMenuItem.setActionCommand(COPY_PASSWORD_TXT);
        this.launchURLMenuItem = new JMenuItem(Translator.translate(LAUNCH_URL_TXT), 66);
        this.launchURLMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.accountMenu.add(this.launchURLMenuItem);
        this.launchURLMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountInformation accInfo = MainWindow.this.dbActions.getSelectedAccount();
                String uRl = accInfo.getUrl();
                if (uRl == null || uRl.length() == 0) {
                    JOptionPane.showMessageDialog(MainWindow.this.accountMenu.getParent().getParent(), Translator.translate("EmptyUrlJoptionpaneMsg"), Translator.translate("UrlErrorJoptionpaneTitle"), 2);
                } else if (!MainWindow.this.urlIsValid(uRl)) {
                    JOptionPane.showMessageDialog(MainWindow.this.accountMenu.getParent().getParent(), Translator.translate("InvalidUrlJoptionpaneMsg"), Translator.translate("UrlErrorJoptionpaneTitle"), 2);
                } else {
                    MainWindow.this.LaunchSelectedURL(uRl);
                }
            }
        });
        this.launchURLMenuItem.setEnabled(false);
        this.launchURLMenuItem.setActionCommand(LAUNCH_URL_TXT);
        this.exitMenuItem = new JMenuItem(Translator.translate(EXIT_TXT), 88);
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.exitMenuItem.addActionListener(this);
        this.exitMenuItem.setActionCommand(EXIT_TXT);
        this.aboutMenuItem = new JMenuItem(Translator.translate(ABOUT_TXT), 65);
        this.aboutMenuItem.addActionListener(this);
        this.aboutMenuItem.setActionCommand(ABOUT_TXT);
        if (!PlatformSpecificCode.isMAC()) {
            this.databaseMenu.addSeparator();
            this.databaseMenu.add(this.exitMenuItem);
            this.helpMenu = new JMenu(Translator.translate("helpMenu"));
            this.helpMenu.setMnemonic(72);
            menuBar.add(this.helpMenu);
            this.helpMenu.add(this.aboutMenuItem);
        }
        return menuBar;
    }

    public JList getAccountsListview() {
        return this.accountsListview;
    }

    private void copyUsernameToClipboard() {
        AccountInformation accInfo = this.dbActions.getSelectedAccount();
        this.copyToClipboard(new String(accInfo.getUserId()));
    }

    private void copyPasswordToClipboard() {
        AccountInformation accInfo = this.dbActions.getSelectedAccount();
        this.copyToClipboard(new String(accInfo.getPassword()));
    }

    private void copyToClipboard(String s) {
        StringSelection stringSelection = new StringSelection(s);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    private boolean urlIsValid(String urL) {
        UrlValidator urlValidator = new UrlValidator();
        return urlValidator.isValid(urL);
    }

    private void LaunchSelectedURL(String url) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI(url));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        } else {
            Runtime runtime = Runtime.getRuntime();
            try {
                runtime.exec("xdg-open " + url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void storeWindowBounds() {
        Preferences.set("window.location.x", Integer.toString(this.getX()));
        Preferences.set("window.location.y", Integer.toString(this.getY()));
        Preferences.set("window.width", Integer.toString(this.getWidth()));
        Preferences.set("window.height", Integer.toString(this.getHeight()));
    }

    private void restoreWindowBounds() {
        int y;
        int x = Preferences.getInt("window.location.x", this.getX());
        if (this.getGraphicsConfigurationContaining(x, y = Preferences.getInt("window.location.y", this.getY())) == null) {
            x = this.getX();
            y = this.getY();
        }
        int width = Preferences.getInt("window.width", this.getWidth());
        int height = Preferences.getInt("window.height", this.getHeight());
        this.setBounds(x, y, width, height);
    }

    private GraphicsConfiguration getGraphicsConfigurationContaining(int x, int y) {
        int i;
        ArrayList<GraphicsConfiguration> configs = new ArrayList<GraphicsConfiguration>();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = env.getScreenDevices();
        for (i = 0; i < devices.length; ++i) {
            GraphicsConfiguration[] gconfigs = devices[i].getConfigurations();
            configs.addAll(Arrays.asList(gconfigs));
        }
        for (i = 0; i < configs.size(); ++i) {
            GraphicsConfiguration config = (GraphicsConfiguration)configs.get(i);
            Rectangle bounds = config.getBounds();
            if (!bounds.contains(x, y)) continue;
            return config;
        }
        return null;
    }

    private static ArrayList getConfigs() {
        ArrayList<GraphicsConfiguration> result = new ArrayList<GraphicsConfiguration>();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = env.getScreenDevices();
        for (int i = 0; i < devices.length; ++i) {
            GraphicsConfiguration[] configs = devices[i].getConfigurations();
            result.addAll(Arrays.asList(configs));
        }
        return result;
    }

    public JButton getCopyPasswordButton() {
        return this.copyPasswordButton;
    }

    public JButton getLaunchURLButton() {
        return this.launchURLButton;
    }

    public JButton getCopyUsernameButton() {
        return this.copyUsernameButton;
    }

    public JButton getEditAccountButton() {
        return this.editAccountButton;
    }

    public JButton getAddAccountButton() {
        return this.addAccountButton;
    }

    public JButton getOptionsButton() {
        return this.optionsButton;
    }

    public JButton getDeleteAccountButton() {
        return this.deleteAccountButton;
    }

    public JTextField getSearchField() {
        return this.searchField;
    }

    public JLabel getSearchIcon() {
        return this.searchIcon;
    }

    public JButton getResetSearchButton() {
        return this.resetSearchButton;
    }

    public JMenuItem getAboutMenuItem() {
        return this.aboutMenuItem;
    }

    public JMenuItem getExitMenuItem() {
        return this.exitMenuItem;
    }

    public JMenuItem getCopyPasswordMenuItem() {
        return this.copyPasswordMenuItem;
    }

    public JMenuItem getLaunchURLMenuItem() {
        return this.launchURLMenuItem;
    }

    public JMenuItem getCopyUsernameMenuItem() {
        return this.copyUsernameMenuItem;
    }

    public JMenuItem getDeleteAccountMenuItem() {
        return this.deleteAccountMenuItem;
    }

    public JMenuItem getViewAccountMenuItem() {
        return this.viewAccountMenuItem;
    }

    public JMenuItem getEditAccountMenuItem() {
        return this.editAccountMenuItem;
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public JMenuItem getAddAccountMenuItem() {
        return this.addAccountMenuItem;
    }

    public JMenuItem getChangeMasterPasswordMenuItem() {
        return this.changeMasterPasswordMenuItem;
    }

    public JMenuItem getDatabasePropertiesMenuItem() {
        return this.databasePropertiesMenuItem;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand() == NEW_DATABASE_TXT) {
                this.dbActions.newDatabase();
            } else if (event.getActionCommand() == OPEN_DATABASE_TXT) {
                this.dbActions.openDatabase();
            } else if (event.getActionCommand() == OPEN_DATABASE_FROM_URL_TXT) {
                this.dbActions.openDatabaseFromURL();
            } else if (event.getActionCommand() == SYNC_DATABASE_TXT) {
                this.dbActions.syncWithRemoteDatabase();
            } else if (event.getActionCommand() == ADD_ACCOUNT_TXT) {
                this.dbActions.reloadDatabaseBefore(new AddAccountAction());
            } else if (event.getActionCommand() == EDIT_ACCOUNT_TXT) {
                String selectedAccName = (String)this.accountsListview.getSelectedValue();
                this.dbActions.reloadDatabaseBefore(new EditAccountAction(selectedAccName));
            } else if (event.getActionCommand() == DELETE_ACCOUNT_TXT) {
                this.dbActions.reloadDatabaseBefore(new DeleteAccountAction());
            } else if (event.getActionCommand() == VIEW_ACCOUNT_TXT) {
                this.dbActions.viewAccount();
            } else if (event.getActionCommand() == OPTIONS_TXT) {
                this.dbActions.options();
            } else if (event.getActionCommand() == ABOUT_TXT) {
                this.dbActions.showAbout();
            } else if (event.getActionCommand() == RESET_SEARCH_TXT) {
                this.dbActions.resetSearch();
            } else if (event.getActionCommand() == CHANGE_MASTER_PASSWORD_TXT) {
                this.dbActions.reloadDatabaseBefore(new ChangeMasterPasswordAction());
            } else if (event.getActionCommand() == DATABASE_PROPERTIES_TXT) {
                this.dbActions.reloadDatabaseBefore(new ShowDatabasePropertiesAction());
            } else if (event.getActionCommand() == EXIT_TXT) {
                this.dbActions.exitApplication();
            } else if (event.getActionCommand() == EXPORT_TXT) {
                this.dbActions.export();
            } else if (event.getActionCommand() == IMPORT_TXT) {
                this.dbActions.reloadDatabaseBefore(new ImportAccountsAction());
            }
        }
        catch (Exception e) {
            this.dbActions.errorHandler(e);
        }
    }

    public JButton getSyncWithRemoteDatabaseButton() {
        return this.syncDatabaseButton;
    }

    public JMenuItem getSyncWithRemoteDatabaseMenuItem() {
        return this.syncWithRemoteDatabaseMenuItem;
    }

    public JMenuItem getExportMenuItem() {
        return this.exportMenuItem;
    }

    public JMenuItem getImportMenuItem() {
        return this.importMenuItem;
    }

    public JLabel getStatusBar() {
        return this.statusBar;
    }

    public JPanel getDatabaseFileChangedPanel() {
        return this.databaseFileChangedPanel;
    }

    public void initialiseControlsWithDefaultLanguage() {
        this.databaseMenu.setText(Translator.translate("databaseMenu"));
        this.newDatabaseMenuItem.setText(Translator.translate(NEW_DATABASE_TXT));
        this.openDatabaseMenuItem.setText(Translator.translate(OPEN_DATABASE_TXT));
        this.openDatabaseFromURLMenuItem.setText(Translator.translate(OPEN_DATABASE_FROM_URL_TXT));
        this.syncWithRemoteDatabaseMenuItem.setText(Translator.translate(SYNC_DATABASE_TXT));
        this.changeMasterPasswordMenuItem.setText(Translator.translate(CHANGE_MASTER_PASSWORD_TXT));
        this.databasePropertiesMenuItem.setText(Translator.translate(DATABASE_PROPERTIES_TXT));
        this.accountMenu.setText(Translator.translate("accountMenu"));
        this.addAccountMenuItem.setText(Translator.translate(ADD_ACCOUNT_TXT));
        this.editAccountMenuItem.setText(Translator.translate(EDIT_ACCOUNT_TXT));
        this.deleteAccountMenuItem.setText(Translator.translate(DELETE_ACCOUNT_TXT));
        this.viewAccountMenuItem.setText(Translator.translate(VIEW_ACCOUNT_TXT));
        this.copyUsernameMenuItem.setText(Translator.translate(COPY_USERNAME_TXT));
        this.copyPasswordMenuItem.setText(Translator.translate(COPY_PASSWORD_TXT));
        this.launchURLMenuItem.setText(Translator.translate(LAUNCH_URL_TXT));
        this.exitMenuItem.setText(Translator.translate(EXIT_TXT));
        this.aboutMenuItem.setText(Translator.translate(ABOUT_TXT));
        this.exportMenuItem.setText(Translator.translate(EXPORT_TXT));
        this.importMenuItem.setText(Translator.translate(IMPORT_TXT));
        if (!PlatformSpecificCode.isMAC()) {
            this.helpMenu.setText(Translator.translate("helpMenu"));
        }
        this.addAccountButton.setToolTipText(Translator.translate(ADD_ACCOUNT_TXT));
        this.editAccountButton.setToolTipText(Translator.translate(EDIT_ACCOUNT_TXT));
        this.deleteAccountButton.setToolTipText(Translator.translate(DELETE_ACCOUNT_TXT));
        this.copyUsernameButton.setToolTipText(Translator.translate(COPY_USERNAME_TXT));
        this.copyPasswordButton.setToolTipText(Translator.translate(COPY_PASSWORD_TXT));
        this.launchURLButton.setToolTipText(Translator.translate(LAUNCH_URL_TXT));
        this.optionsButton.setToolTipText(Translator.translate(OPTIONS_TXT));
        this.syncDatabaseButton.setToolTipText(Translator.translate(SYNC_DATABASE_TXT));
        this.resetSearchButton.setToolTipText(Translator.translate(RESET_SEARCH_TXT));
    }

    private class ImportAccountsAction
    implements ChangeDatabaseAction {
        private ImportAccountsAction() {
        }

        @Override
        public void doAction() {
            try {
                MainWindow.this.dbActions.importAccounts();
            }
            catch (Exception e) {
                MainWindow.this.dbActions.errorHandler(e);
            }
        }
    }

    private class ShowDatabasePropertiesAction
    implements ChangeDatabaseAction {
        private ShowDatabasePropertiesAction() {
        }

        @Override
        public void doAction() {
            try {
                MainWindow.this.dbActions.showDatabaseProperties();
            }
            catch (Exception e) {
                MainWindow.this.dbActions.errorHandler(e);
            }
        }
    }

    private class AddAccountAction
    implements ChangeDatabaseAction {
        private AddAccountAction() {
        }

        @Override
        public void doAction() {
            try {
                MainWindow.this.dbActions.addAccount();
            }
            catch (Exception e) {
                MainWindow.this.dbActions.errorHandler(e);
            }
        }
    }

    private class DeleteAccountAction
    implements ChangeDatabaseAction {
        private DeleteAccountAction() {
        }

        @Override
        public void doAction() {
            try {
                MainWindow.this.dbActions.deleteAccount();
            }
            catch (Exception e) {
                MainWindow.this.dbActions.errorHandler(e);
            }
        }
    }

    private class ChangeMasterPasswordAction
    implements ChangeDatabaseAction {
        private ChangeMasterPasswordAction() {
        }

        @Override
        public void doAction() {
            try {
                MainWindow.this.dbActions.changeMasterPassword();
            }
            catch (Exception e) {
                MainWindow.this.dbActions.errorHandler(e);
            }
        }
    }

    private class EditAccountAction
    implements ChangeDatabaseAction {
        private String accountToEdit;

        public EditAccountAction(String accountToEdit) {
            this.accountToEdit = accountToEdit;
        }

        @Override
        public void doAction() {
            try {
                MainWindow.this.dbActions.editAccount(this.accountToEdit);
            }
            catch (Exception e) {
                MainWindow.this.dbActions.errorHandler(e);
            }
        }
    }

    public static interface ChangeDatabaseAction {
        public void doAction();
    }
}

