/*
 * Decompiled with CFR 0.152.
 */
package com._17od.upm.transport;

import com._17od.upm.transport.EasySSLProtocolSocketFactory;
import com._17od.upm.transport.Transport;
import com._17od.upm.transport.TransportException;
import com._17od.upm.util.Preferences;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class HTTPTransport
extends Transport {
    private HttpClient client = new HttpClient();

    public HTTPTransport() {
        Boolean proxyEnabled;
        Boolean acceptSelfSignedCerts = new Boolean(Preferences.get("https.accept.selfsigned.certs"));
        if (acceptSelfSignedCerts.booleanValue()) {
            Protocol httpsProtocol = new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443);
            Protocol.registerProtocol("https", httpsProtocol);
        }
        if ((proxyEnabled = new Boolean(Preferences.get("http.proxy.enabled"))).booleanValue()) {
            String proxyHost = Preferences.get("http.proxy.host");
            String proxyPortStr = Preferences.get("http.proxy.port");
            String proxyUserName = Preferences.get("http.proxy.username");
            String proxyPassword = Preferences.get("http.proxy.password");
            String decodedPassword = new String(Base64.decodeBase64(proxyPassword.getBytes()));
            if (this.isNotEmpty(proxyHost)) {
                int proxyPort = 0;
                if (this.isNotEmpty(proxyPortStr)) {
                    proxyPort = Integer.parseInt(proxyPortStr);
                    this.client.getHostConfiguration().setProxy(proxyHost, proxyPort);
                    if (this.isNotEmpty(proxyUserName) && this.isNotEmpty(proxyPassword)) {
                        this.client.getState().setProxyCredentials(AuthScope.ANY, new UsernamePasswordCredentials(proxyUserName, decodedPassword));
                    }
                }
            }
        }
    }

    @Override
    public void put(String targetLocation, File file) throws TransportException {
        this.put(targetLocation, file, null, null);
    }

    @Override
    public void put(String targetLocation, File file, String username, String password) throws TransportException {
        targetLocation = this.addTrailingSlash(targetLocation) + "upload.php";
        PostMethod post = new PostMethod(targetLocation);
        try {
            int status;
            Part[] parts = new Part[]{new FilePart("userfile", file)};
            post.setRequestEntity(new MultipartRequestEntity(parts, post.getParams()));
            if (username != null) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(new String(username), new String(password));
                URL url = new URL(targetLocation);
                AuthScope authScope = new AuthScope(url.getHost(), url.getPort());
                this.client.getState().setCredentials(authScope, creds);
                this.client.getParams().setAuthenticationPreemptive(true);
            }
            if ((status = this.client.executeMethod(post)) == 200 && post.getResponseBodyAsString().equals("FILE_WASNT_MOVED")) {
                status = this.client.executeMethod(post);
            }
            if (status != 200) {
                throw new TransportException("There's been some kind of problem uploading a file to the HTTP server.\n\nThe HTTP error message is [" + HttpStatus.getStatusText(status) + "]");
            }
            if (!post.getResponseBodyAsString().equals("OK")) {
                throw new TransportException("There's been some kind of problem uploading a file to the HTTP server.\n\nThe error message is [" + post.getResponseBodyAsString() + "]");
            }
        }
        catch (FileNotFoundException e) {
            throw new TransportException(e);
        }
        catch (MalformedURLException e) {
            throw new TransportException(e);
        }
        catch (HttpException e) {
            throw new TransportException(e);
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
        finally {
            post.releaseConnection();
        }
    }

    @Override
    public byte[] get(String url, String fileName) throws TransportException {
        return this.get(url, fileName, null, null);
    }

    @Override
    public byte[] get(String url, String fileName, String username, String password) throws TransportException {
        url = this.addTrailingSlash(url);
        return this.get(url + fileName, username, password);
    }

    @Override
    public byte[] get(String url, String username, String password) throws TransportException {
        byte[] retVal = null;
        GetMethod method = new GetMethod(url);
        try {
            int statusCode;
            if (username != null) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(new String(username), new String(password));
                URL urlObj = new URL(url);
                AuthScope authScope = new AuthScope(urlObj.getHost(), urlObj.getPort());
                this.client.getState().setCredentials(authScope, creds);
                this.client.getParams().setAuthenticationPreemptive(true);
            }
            if ((statusCode = this.client.executeMethod(method)) != 200) {
                throw new TransportException("There's been some kind of problem getting the URL [" + url + "].\n\nThe HTTP error message is [" + HttpStatus.getStatusText(statusCode) + "]");
            }
            retVal = method.getResponseBody();
        }
        catch (MalformedURLException e) {
            throw new TransportException(e);
        }
        catch (HttpException e) {
            throw new TransportException(e);
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
        finally {
            method.releaseConnection();
        }
        return retVal;
    }

    @Override
    public File getRemoteFile(String remoteLocation, String fileName) throws TransportException {
        return this.getRemoteFile(remoteLocation, fileName, null, null);
    }

    @Override
    public File getRemoteFile(String remoteLocation) throws TransportException {
        return this.getRemoteFile(remoteLocation, null, null);
    }

    @Override
    public File getRemoteFile(String remoteLocation, String fileName, String httpUsername, String httpPassword) throws TransportException {
        remoteLocation = this.addTrailingSlash(remoteLocation);
        return this.getRemoteFile(remoteLocation + fileName, httpUsername, httpPassword);
    }

    @Override
    public File getRemoteFile(String remoteLocation, String httpUsername, String httpPassword) throws TransportException {
        try {
            byte[] remoteFile = this.get(remoteLocation, httpUsername, httpPassword);
            File downloadedFile = File.createTempFile("upm", null);
            FileOutputStream fos = new FileOutputStream(downloadedFile);
            fos.write(remoteFile);
            fos.close();
            return downloadedFile;
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    @Override
    public void delete(String targetLocation, String name, String username, String password) throws TransportException {
        targetLocation = this.addTrailingSlash(targetLocation) + "deletefile.php";
        PostMethod post = new PostMethod(targetLocation);
        post.addParameter("fileToDelete", name);
        try {
            int status;
            if (username != null) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(new String(username), new String(password));
                URL url = new URL(targetLocation);
                AuthScope authScope = new AuthScope(url.getHost(), url.getPort());
                this.client.getState().setCredentials(authScope, creds);
                this.client.getParams().setAuthenticationPreemptive(true);
            }
            if ((status = this.client.executeMethod(post)) != 200) {
                throw new TransportException("There's been some kind of problem deleting a file on the HTTP server.\n\nThe HTTP error message is [" + HttpStatus.getStatusText(status) + "]");
            }
            if (!post.getResponseBodyAsString().equals("OK")) {
                throw new TransportException("There's been some kind of problem deleting a file to the HTTP server.\n\nThe error message is [" + post.getResponseBodyAsString() + "]");
            }
        }
        catch (MalformedURLException e) {
            throw new TransportException(e);
        }
        catch (HttpException e) {
            throw new TransportException(e);
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
        finally {
            post.releaseConnection();
        }
    }

    @Override
    public void delete(String targetLocation, String name) throws TransportException {
        this.delete(targetLocation, name, null, null);
    }

    private String addTrailingSlash(String url) {
        if (url.charAt(url.length() - 1) != '/') {
            url = url + '/';
        }
        return url;
    }

    private boolean isNotEmpty(String stringToCheck) {
        boolean retVal = false;
        if (stringToCheck != null && !stringToCheck.trim().equals("")) {
            retVal = true;
        }
        return retVal;
    }
}

