/*
 * Decompiled with CFR 0.152.
 */
package com._17od.upm.util;

import com._17od.upm.platformspecific.PlatformSpecificCode;
import com._17od.upm.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Preferences {
    private static final Log log = LogFactory.getLog(Preferences.class);
    private static final String PREF_FILE = System.getProperty("user.home") + System.getProperty("file.separator") + "upm.properties";
    private static final String PREF_FILE_SYS_PROP = "upm.properties";
    private static Properties preferences;
    private static String propertiesFile;

    public static String get(String name, String defaultValue) {
        String retVal = preferences.getProperty(name, defaultValue);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Returning the property, name=" + name + ", value=" + retVal));
        }
        return retVal;
    }

    public static int getInt(String name, int defaultValue) {
        String cfgVal = preferences.getProperty(name);
        int retVal = defaultValue;
        if (cfgVal != null && Util.isNumeric(cfgVal)) {
            retVal = Integer.parseInt(cfgVal);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Returning the property, name=" + name + ", value=" + retVal));
        }
        return retVal;
    }

    public static String get(String name) {
        return Preferences.get(name, null);
    }

    public static void set(String name, String value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting the property, name=" + name + ", value=" + value));
        }
        preferences.setProperty(name, value);
    }

    public static void load() throws FileNotFoundException, IOException {
        block9: {
            if (!System.getProperties().containsKey(PREF_FILE_SYS_PROP)) {
                if (PlatformSpecificCode.isLinux()) {
                    String configBase = System.getenv("XDG_CONFIG_HOME");
                    if (null == configBase || configBase.trim().equals("")) {
                        configBase = System.getProperty("user.home") + System.getProperty("file.separator") + ".config";
                    }
                    System.setProperty(PREF_FILE_SYS_PROP, configBase + System.getProperty("file.separator") + PREF_FILE_SYS_PROP);
                } else if (PlatformSpecificCode.isMAC()) {
                    System.setProperty(PREF_FILE_SYS_PROP, System.getProperty("user.home") + System.getProperty("file.separator") + "Library" + System.getProperty("file.separator") + "Preferences" + System.getProperty("file.separator") + PREF_FILE_SYS_PROP);
                }
            }
            if ((propertiesFile = System.getProperty(PREF_FILE_SYS_PROP)) == null || propertiesFile.trim().equals("")) {
                propertiesFile = PREF_FILE;
            }
            File prefs = new File(propertiesFile);
            prefs.getParentFile().mkdirs();
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Loading the properties file [" + propertiesFile + "]"));
                }
                preferences = new Properties();
                preferences.load(new FileInputStream(propertiesFile));
            }
            catch (FileNotFoundException e) {
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)"Property file not found. Will be created the next time the properties are saved.");
            }
        }
    }

    public static void save() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Saving properties to the file [" + PREF_FILE + "]"));
        }
        preferences.store(new FileOutputStream(propertiesFile), "Universal Password Manager Preferences");
    }

    public class DatabaseOptions {
    }

    public class ApplicationOptions {
        public static final String DB_TO_LOAD_ON_STARTUP = "DBToLoadOnStartup";
        public static final String ACCOUNT_HIDE_PASSWORD = "account.hidePassword";
        public static final String ACCOUNT_PASSWORD_LENGTH = "account.passwordLenght";
        public static final String INCLUDE_ESCAPE_CHARACTERS = "account.inclescapechars";
        public static final String MAINWINDOW_ALWAYS_ON_TOP = "mainwindow.alwaysontop";
        public static final String DATABASE_AUTO_LOCK = "database.auto_lock";
        public static final String DATABASE_AUTO_LOCK_TIME = "database.auto_lock_time";
        public static final String REMEMBER_WINDOW_POSITION = "window.store_position";
        public static final String HTTP_PROXY_ENABLED = "http.proxy.enabled";
        public static final String HTTP_PROXY_HOST = "http.proxy.host";
        public static final String HTTP_PROXY_PORT = "http.proxy.port";
        public static final String HTTP_PROXY_USERNAME = "http.proxy.username";
        public static final String HTTP_PROXY_PASSWORD = "http.proxy.password";
        public static final String HTTPS_ACCEPT_SELFSIGNED_CERTS = "https.accept.selfsigned.certs";
        public static final String XLOC = "window.location.x";
        public static final String YLOC = "window.location.y";
        public static final String WWIDTH = "window.width";
        public static final String WHEIGHT = "window.height";
        public static final String LOCALE = "locale";
    }
}

