/*
 * Decompiled with CFR 0.152.
 */
package com.sfs._102.awt;

import com.sfs._102.awt.SplitHorizontalLayout;
import com.sfs._102.awt.SplitLayout;
import com.sfs._102.awt.SplitVerticalLayout;
import java.awt.Container;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;

public class SplitPanel
extends Panel {
    public static final boolean VERTICAL = false;
    public static final boolean HORIZONTAL = true;
    SplitLayout layout;
    boolean isDragged = false;
    boolean splitHorizontal;
    Frame frame;

    public SplitPanel(boolean bl, int n) {
        this.splitHorizontal = bl;
        this.layout = bl ? new SplitHorizontalLayout(this, n) : new SplitVerticalLayout(this, n);
        this.setLayout(this.layout);
    }

    public void setBorder(int n) {
        this.layout.setBorder(n);
        this.layout();
    }

    public int getBorder() {
        return this.layout.getBorder();
    }

    public boolean handleEvent(Event event) {
        if (event.id == 506 && this == event.target) {
            this.layout.setBorderLine(this.splitHorizontal ? event.y : event.x);
            this.layout();
            return true;
        }
        if (event.id == 504 && this == event.target) {
            this.isDragged = true;
            this.repaint();
            return true;
        }
        if (event.id == 505 && this == event.target) {
            this.isDragged = false;
            this.validate();
            this.repaint();
            return true;
        }
        return super.handleEvent(event);
    }

    public void paint(Graphics graphics) {
        this.layout.paintBorderLine(graphics);
        super.paint(graphics);
        if (this.frame == null) {
            Container container = this;
            while (!(container instanceof Frame)) {
                container = container.getParent();
            }
            this.frame = (Frame)container;
        }
    }
}

