/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Timer;

public class HBufferManager
implements ActionListener {
    Hashtable buffer = null;
    int bufferMaxSize = 0;
    Timer timer;
    RandomAccessFile dataFile = null;
    public static final int DATABASE_VERSION = 1;
    public int databaseVersion = 1;
    protected int firstFreePage = -1;
    public HDataNode rootNode = null;
    HDataPage templateFreePage;

    public HBufferManager(RandomAccessFile randomAccessFile, int n) {
        this.dataFile = randomAccessFile;
        this.setBufferMaxSize(n);
        this.buffer = new Hashtable(4 * this.bufferMaxSize / 3 + 1, 0.75f);
        this.timer = new Timer(2000, this);
        this.timer.setRepeats(false);
        this.readHeader();
        this.templateFreePage = new HDataPage(this.rootNode);
        this.templateFreePage.primaryPointer = -2;
        this.templateFreePage.parentPointer = -2;
        this.templateFreePage.prevBrother = -1;
        this.templateFreePage.nextBrother = -1;
        this.templateFreePage.used = (short)22;
        this.templateFreePage.startAt = 0;
        this.templateFreePage.amount = 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.flushAllPages();
    }

    public HDataPage createBlobPage(HDataNode hDataNode) throws IOException {
        HDataPage hDataPage = new HDataPage(this.rootNode);
        hDataPage.primaryPointer = hDataNode.blobPointer = this.getFreePagePointer();
        hDataPage.parentPointer = hDataNode.myPointer;
        hDataPage.prevBrother = -1;
        hDataPage.nextBrother = -1;
        hDataPage.used = (short)22;
        hDataPage.startAt = 0;
        hDataPage.amount = (short)-1;
        hDataPage.myPointer = hDataPage.primaryPointer;
        hDataPage.timestamp = System.currentTimeMillis();
        hDataPage.needUpdateOnDisk = true;
        this.putInBuffer(hDataPage.myPointer, hDataPage);
        this.getPage((int)hDataNode.myPointer).needUpdateOnDisk = true;
        return hDataPage;
    }

    public HDataPage createBrotherPage(HDataPage hDataPage) throws IOException {
        HDataPage hDataPage2 = new HDataPage(this.rootNode);
        hDataPage2.primaryPointer = hDataPage.primaryPointer;
        hDataPage2.parentPointer = hDataPage.parentPointer;
        hDataPage2.prevBrother = hDataPage.myPointer;
        hDataPage2.nextBrother = -1;
        hDataPage2.used = (short)22;
        if (hDataPage.amount == -1) {
            hDataPage2.startAt = 0;
            hDataPage2.amount = (short)-1;
        } else {
            hDataPage2.startAt = (short)(hDataPage.startAt + hDataPage.amount);
            hDataPage2.amount = 0;
        }
        hDataPage2.myPointer = this.getFreePagePointer();
        hDataPage2.timestamp = System.currentTimeMillis();
        hDataPage2.needUpdateOnDisk = true;
        hDataPage.setNextBrother(hDataPage2.myPointer);
        this.putInBuffer(hDataPage2.myPointer, hDataPage2);
        this.putInBuffer(hDataPage.myPointer, hDataPage);
        return hDataPage2;
    }

    public HDataPage createChildPage(HDataNode hDataNode) throws IOException {
        HDataPage hDataPage = new HDataPage(this.rootNode);
        hDataPage.primaryPointer = hDataNode.childPointer = this.getFreePagePointer();
        hDataPage.parentPointer = hDataNode.myPointer;
        hDataPage.prevBrother = -1;
        hDataPage.nextBrother = -1;
        hDataPage.used = (short)22;
        hDataPage.startAt = 0;
        hDataPage.amount = 0;
        hDataPage.myPointer = hDataPage.primaryPointer;
        hDataPage.timestamp = System.currentTimeMillis();
        hDataPage.needUpdateOnDisk = true;
        this.putInBuffer(hDataPage.myPointer, hDataPage);
        if (hDataNode != this.rootNode) {
            this.getPage((int)hDataNode.myPointer).needUpdateOnDisk = true;
        }
        return hDataPage;
    }

    public void flushAllPages() {
        HDataNode hDataNode = this.rootNode;
        synchronized (hDataNode) {
            long l = System.currentTimeMillis();
            try {
                this.writeHeader();
                boolean bl = false;
                Enumeration enumeration = this.buffer.elements();
                while (enumeration.hasMoreElements()) {
                    HDataPage hDataPage = (HDataPage)enumeration.nextElement();
                    if (!hDataPage.needUpdateOnDisk) continue;
                    hDataPage.writePage(this.dataFile);
                }
                ((BufferedRandomAccessFile)this.dataFile).flushBuffer();
            }
            catch (IOException iOException) {
                System.out.println("error: " + iOException);
            }
        }
    }

    protected int getFreePagePointer() throws IOException {
        HDataNode hDataNode = this.rootNode;
        synchronized (hDataNode) {
            int n = (int)((this.dataFile.length() - 1L) / 1024L + 1L);
            int n2 = -1;
            HDataPage hDataPage = new HDataPage(this.rootNode);
            while (this.buffer.get(new Integer(n)) != null) {
                ++n;
            }
            if (this.firstFreePage == -1) {
                n2 = Math.max(1, n);
            } else {
                int n3 = this.firstFreePage == -2 ? 1 : this.firstFreePage;
                while (n3 < n && n2 == -1) {
                    if (this.buffer.get(new Integer(n3)) == null && hDataPage.checkFreePage(this.dataFile, n3)) {
                        this.firstFreePage = n3;
                        n2 = n3;
                    }
                    ++n3;
                }
                if (n2 == -1) {
                    n2 = n;
                    this.firstFreePage = -1;
                }
            }
            int n4 = n2;
            Object var3_7 = null;
            return n4;
        }
    }

    public HDataPage getPage(int n) throws IOException {
        HDataPage hDataPage = (HDataPage)this.buffer.get(new Integer(n));
        if (hDataPage == null) {
            hDataPage = this.readPage(n);
        }
        return hDataPage;
    }

    protected Object putInBuffer(int n, Object object) throws IOException {
        HDataNode hDataNode = this.rootNode;
        synchronized (hDataNode) {
            if (this.buffer.size() >= this.bufferMaxSize) {
                long l = System.currentTimeMillis();
                Vector<HDataPage> vector = new Vector<HDataPage>(this.bufferMaxSize / 10 + 1);
                Enumeration enumeration = this.buffer.elements();
                while (enumeration.hasMoreElements()) {
                    HDataPage hDataPage = (HDataPage)enumeration.nextElement();
                    boolean bl = false;
                    int n2 = 0;
                    while (n2 < vector.size() && !bl) {
                        if (hDataPage.timestamp < ((HDataPage)vector.elementAt((int)n2)).timestamp) {
                            vector.insertElementAt(hDataPage, n2);
                            bl = true;
                        }
                        ++n2;
                    }
                    if (!bl && vector.size() < this.bufferMaxSize / 10) {
                        vector.addElement(hDataPage);
                    }
                    if (vector.size() <= this.bufferMaxSize / 10) continue;
                    vector.setSize(this.bufferMaxSize / 10);
                }
                int n3 = 0;
                while (n3 < vector.size()) {
                    HDataPage hDataPage = (HDataPage)vector.elementAt(n3);
                    if (hDataPage.needUpdateOnDisk) {
                        hDataPage.writePage(this.dataFile);
                    }
                    this.buffer.remove(new Integer(hDataPage.myPointer));
                    ++n3;
                }
            }
            Object object2 = this.buffer.put(new Integer(n), object);
            Object var5_14 = null;
            return object2;
        }
    }

    protected void readHeader() {
        HDataNode hDataNode = this.rootNode = new HDataNode();
        synchronized (hDataNode) {
            this.rootNode.fileName = "root";
            this.rootNode.type = (byte)99;
            this.rootNode.length = 0L;
            this.rootNode.myPointer = 0;
            this.rootNode.primaryPointer = 0;
            try {
                this.dataFile.seek(0L);
                this.databaseVersion = this.dataFile.readInt();
                this.rootNode.dateModified = this.dataFile.readLong();
                this.rootNode.childPointer = this.dataFile.readInt();
                this.firstFreePage = this.dataFile.readInt();
            }
            catch (IOException iOException) {
                this.rootNode.dateModified = System.currentTimeMillis();
                this.rootNode.childPointer = -1;
            }
        }
    }

    protected HDataPage readPage(int n) throws IOException {
        HDataNode hDataNode = this.rootNode;
        synchronized (hDataNode) {
            HDataPage hDataPage = new HDataPage(this.rootNode);
            hDataPage.readPage(this.dataFile, n);
            this.putInBuffer(n, hDataPage);
            HDataPage hDataPage2 = hDataPage;
            Object var4_5 = null;
            return hDataPage2;
        }
    }

    public void removePage(int n) throws IOException {
        HDataNode hDataNode = this.rootNode;
        synchronized (hDataNode) {
            this.buffer.remove(new Integer(n));
            this.templateFreePage.myPointer = n;
            if (this.firstFreePage == -1 || n < this.firstFreePage) {
                this.firstFreePage = n;
            }
            this.templateFreePage.writePage(this.dataFile);
        }
    }

    public void setBufferMaxSize(int n) {
        this.bufferMaxSize = n < 10240 ? 10 : n / 1024;
    }

    public void startLazyWriteTimer() {
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    public void trimFile() throws IOException {
        HDataNode hDataNode = this.rootNode;
        synchronized (hDataNode) {
            Object object;
            int n = (int)(this.dataFile.length() / 1024L - 1L);
            Enumeration enumeration = this.buffer.keys();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                if ((Integer)object < n) continue;
                Object var2_5 = null;
                return;
            }
            enumeration = null;
            object = new HDataPage(this.rootNode);
            ((HDataPage)object).readPage(this.dataFile, n--);
            while (n > 0 && ((HDataPage)object).primaryPointer == -2 && this.buffer.get(new Integer(n + 1)) == null) {
                ((HDataPage)object).readPage(this.dataFile, n--);
            }
            try {
                this.dataFile.setLength(1024 * (n + 2));
            }
            catch (NoSuchMethodError noSuchMethodError) {}
        }
    }

    public synchronized boolean writeHeader() throws IOException {
        HDataNode hDataNode = this.rootNode;
        synchronized (hDataNode) {
            this.dataFile.seek(0L);
            this.dataFile.writeInt(this.databaseVersion);
            this.dataFile.writeLong(this.rootNode.dateModified);
            this.dataFile.writeInt(this.rootNode.childPointer);
            this.dataFile.writeInt(this.firstFreePage);
        }
        return false;
    }
}

