/* (C) 1999-2000 Samuel Audet <guardia@cam.org>

Profitable use of this source code based on its execution or sale
excluding the cost of the media, shipping, manwork or supporting
hardware is not allowed unless granted by the author himself.  Any
modifications or inclusion of this code in other non-profitable programs
must contain this message and the original author's name. Programs based
on any of this source code must therefore contain the original or
modified source code files.  Use of this source code in a commercial
program will require permission from the author.  No more than 50% of
the original size of the source code from Disk Indexer can be used in a
non-commercial program, unless granted by the author.

*/

import java.util.*;
import java.io.*;
import javax.swing.tree.*;

public class DynamicTreeNode extends DefaultMutableTreeNode implements ShuttleSortCompare
{
   HDatabase database;
   boolean loaded = false, loading = false;
   Vector allRows = new Vector(10,0);

public void sortChildren()
{
   int count = getChildCount();
   allRows.removeAllElements();
   allRows.ensureCapacity(count);

   for(int i = 0; i < count; i++)
      allRows.addElement(getChildAt(i));

   removeAllChildren();

   sort();
}

public DynamicTreeNode(Object userObject, HDatabase database)
{
   super(userObject);
   this.database = database;
}

public int getChildCount()
{
   if(!loaded && !loading) load();
   return super.getChildCount();
}

public TreeNode getChildAt(int index)
{
   if(!loaded && !loading) load();
   return super.getChildAt(index);
}

public Enumeration children()
{
   if(!loaded && !loading) load();
   return super.children();
}

protected void sort()
{
    // build array with unsorted row numbers
   int rowCount = allRows.size();
   int[] indexes = new int[rowCount];

   for(int row = 0; row < rowCount; row++)
      indexes[row] = row;

   ShuttleSort.sort((int[])indexes.clone(), indexes, 0, indexes.length, this);

   for(int i = 0; i < indexes.length; i++)
      add((MutableTreeNode)allRows.elementAt(indexes[i]));

   allRows.removeAllElements();
}

protected void load()
{
   loading = true;
   HDataNode parent = (HDataNode) getUserObject();
   try
   {
      int count = database.childCount(parent);
      allRows.removeAllElements();

      for(int i = 0; i < count; i++)
      {
         HDataNode anode = database.read(parent,i);

         if(anode.type == anode.d || anode.type == anode.v || anode.type == anode.c || anode.type == anode.z)
            allRows.addElement(new DynamicTreeNode(anode,database));
      }

      sort();

      loaded = true;
   }
   catch(IOException e)
   {
  //  JOptionPane.showMessageDialog(this,"Database corrupted","Error",JOptionPane.ERROR_MESSAGE);
   }
   loading = false;
}

// implementation of ShuttleSortCompare

public int compare(int row1, int row2)
{
   HDataNode node1 = (HDataNode) ((DynamicTreeNode) allRows.elementAt(row1)).getUserObject();
   HDataNode node2 = (HDataNode) ((DynamicTreeNode) allRows.elementAt(row2)).getUserObject();
   int prio1 = 0, prio2 = 0;

   switch(node1.type)
   {
      case node1.c: prio1 = 1; break;
      case node1.v: prio1 = 2; break;
      case node1.d: prio1 = 3; break;
      case node1.z: prio1 = 4; break;
      case node1.f: prio1 = 5; break;
   }

   switch(node2.type)
   {
      case node2.c: prio2 = 1; break;
      case node2.v: prio2 = 2; break;
      case node2.d: prio2 = 3; break;
      case node2.z: prio2 = 4; break;
      case node2.f: prio2 = 5; break;
   }

   if(prio1 > prio2)
      return 1;
   else if(prio1 < prio2)
      return -1;
   else
   {
      int result = node1.toString().compareTo(node2.toString());

      if(result < 0)
        return -1;
      else if(result > 0)
        return 1;
      else
        return 0;
   }
}


protected void finalize() throws Throwable
{
   database = null;
   super.finalize();
}

public void add(MutableTreeNode newChild) throws IllegalArgumentException, IllegalStateException
{
   super.add(newChild);
   HDataNode newNode = ((HDataNode)((DynamicTreeNode)newChild).getUserObject());
   HDataNode curNode = ((HDataNode)getUserObject());
   newNode.primaryPointer = curNode.childPointer;
   newNode.parentPointer = curNode.myPointer;
}

public boolean equals(Object o)
{
   if(o == this)
      return true;

   if(o == null)
      return false;

   if(!(o instanceof DynamicTreeNode))
      return false;

/* probably not necessary if we always compare treepaths

   if(getParent() == null)
   {
      if(((DefaultMutableTreeNode)o).getParent() != null)
         return false;
   }
   else
      if(!getParent().equals(((DefaultMutableTreeNode)o).getParent()))
         return false;
*/

   if(!getUserObject().equals(((DefaultMutableTreeNode)o).getUserObject()))
      return false;

   return true;
}

}
