/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.plugins.DataBunker;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JDialog;
import net.sf.jmp3renamer.AbstractTranslatablePlugin;
import net.sf.jmp3renamer.GeneralPlugin;
import net.sf.jmp3renamer.gui.PluginConfigGUI;
import net.sf.jmp3renamer.plugins.DataBunker.gui.DataBunkerPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBunker
extends AbstractTranslatablePlugin
implements GeneralPlugin {
    private static final String VERSION = "0.5";
    private static final String AUTHOR = "Henrik Niehaus, hampelratte@users.sf.net";
    private static final String NAME = "DataBunker";
    private static final String DESCRIPTION = "DataBunker is able to store and load the data, which will be used for renaming. This is useful for users, who have dial-up modems and want to collect the data first and then rename the files. This way you can save online time / money.";
    private static Properties props = new Properties();
    private static JDialog dialog;
    private static transient Logger logger;
    private boolean propsLoaded = false;
    private DataBunkerPanel gui;
    private String file = System.getProperty("user.home") + System.getProperty("file.separator") + ".jmp3renamer" + System.getProperty("file.separator") + "DataBunker" + ".props";
    private File conffile = new File(this.file);
    static /* synthetic */ Class class$net$sf$jmp3renamer$plugins$DataBunker$DataBunker;

    public String getVersion() {
        return VERSION;
    }

    public String getAuthor() {
        return AUTHOR;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public void init() {
        this.loadConfig();
        this.loadLanguage();
        this.gui = new DataBunkerPanel();
    }

    private void loadConfig() {
        if (!this.propsLoaded) {
            try {
                File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jmp3renamer");
                if (!file.exists()) {
                    file.mkdir();
                }
                if (!this.conffile.exists()) {
                    this.conffile.createNewFile();
                }
                FileInputStream fileInputStream = new FileInputStream(this.file);
                props.load(fileInputStream);
                this.propsLoaded = true;
            }
            catch (Exception exception) {
                logger.error("Couldn't load settings", (Throwable)exception);
            }
        }
    }

    public int getType() {
        return 2;
    }

    public String getName() {
        return NAME;
    }

    public JComponent getGUI() {
        return this.gui;
    }

    public PluginConfigGUI getConfigGUI() {
        return null;
    }

    public Properties getConfig() {
        return props;
    }

    public static String getProperty(String string) {
        return props.getProperty(string);
    }

    public static void setProperty(String string, String string2) {
        props.setProperty(string, string2);
    }

    public void saveConfig() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            props.store(fileOutputStream, "DataBunker Properties");
            logger.info("{}: Saving properties: done", (Object)NAME);
        }
        catch (Exception exception) {
            logger.error("DataBunker: Saving properties: failed", (Throwable)exception);
        }
    }

    public String toString() {
        return this.getName();
    }

    public void setDialog(JDialog jDialog) {
        dialog = jDialog;
        dialog.setTitle(dialog.getTitle() + " " + VERSION);
        dialog.setModal(false);
    }

    public static JDialog getDialog() {
        return dialog;
    }

    public void coreStarted() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        logger = LoggerFactory.getLogger((Class)(class$net$sf$jmp3renamer$plugins$DataBunker$DataBunker == null ? (class$net$sf$jmp3renamer$plugins$DataBunker$DataBunker = DataBunker.class$("net.sf.jmp3renamer.plugins.DataBunker.DataBunker")) : class$net$sf$jmp3renamer$plugins$DataBunker$DataBunker));
    }
}

