/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.ape.util;

import entagged.audioformats.ape.util.ApeTagField;
import entagged.audioformats.generic.TagField;
import java.io.UnsupportedEncodingException;

public class ApeTagBinaryField
extends ApeTagField {
    private byte[] content;

    public ApeTagBinaryField(String string, byte[] byArray) {
        super(string, true);
        this.content = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            this.content[i] = byArray[i];
        }
    }

    public boolean isEmpty() {
        return this.content.length == 0;
    }

    public String toString() {
        return "Binary field";
    }

    public void copyContent(TagField tagField) {
        if (tagField instanceof ApeTagBinaryField) {
            this.content = ((ApeTagBinaryField)tagField).getContent();
        }
    }

    public byte[] getContent() {
        return this.content;
    }

    public byte[] getRawContent() throws UnsupportedEncodingException {
        byte[] byArray = this.getBytes(this.getId(), "ISO-8859-1");
        byte[] byArray2 = new byte[8 + byArray.length + 1 + this.content.length];
        byte[] byArray3 = new byte[]{2, 0, 0, 0};
        int n = 0;
        this.copy(this.getSize(this.content.length), byArray2, n);
        this.copy(byArray3, byArray2, n += 4);
        this.copy(byArray, byArray2, n += 4);
        byArray2[n += byArray.length] = 0;
        this.copy(this.content, byArray2, ++n);
        n += this.content.length;
        return byArray2;
    }
}

