/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.ape.util;

import entagged.audioformats.generic.Utils;

public class MonkeyHeader {
    byte[] b;

    public MonkeyHeader(byte[] byArray) {
        this.b = byArray;
    }

    public int getCompressionLevel() {
        return Utils.getNumber(this.b, 0, 1);
    }

    public int getFormatFlags() {
        return Utils.getNumber(this.b, 2, 3);
    }

    public long getBlocksPerFrame() {
        return Utils.getLongNumber(this.b, 4, 7);
    }

    public long getFinalFrameBlocks() {
        return Utils.getLongNumber(this.b, 8, 11);
    }

    public long getTotalFrames() {
        return Utils.getLongNumber(this.b, 12, 15);
    }

    public int getLength() {
        return (int)((double)this.getBlocksPerFrame() * ((double)this.getTotalFrames() - 1.0) + (double)this.getFinalFrameBlocks()) / this.getSamplingRate();
    }

    public float getPreciseLength() {
        return (float)((double)(this.getBlocksPerFrame() * (this.getTotalFrames() - 1L) + this.getFinalFrameBlocks()) / (double)this.getSamplingRate());
    }

    public int getBitsPerSample() {
        return Utils.getNumber(this.b, 16, 17);
    }

    public int getChannelNumber() {
        return Utils.getNumber(this.b, 18, 19);
    }

    public int getSamplingRate() {
        return Utils.getNumber(this.b, 20, 23);
    }
}

