/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.ape.util;

import entagged.audioformats.EncodingInfo;
import entagged.audioformats.ape.util.MonkeyDescriptor;
import entagged.audioformats.ape.util.MonkeyHeader;
import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.generic.Utils;
import entagged.audioformats.wav.util.WavFormatHeader;
import entagged.audioformats.wav.util.WavRIFFHeader;
import java.io.IOException;
import java.io.RandomAccessFile;

public class MonkeyInfoReader {
    public EncodingInfo read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        EncodingInfo encodingInfo = new EncodingInfo();
        if (randomAccessFile.length() == 0L) {
            System.err.println("Error: File empty");
            throw new CannotReadException("File is empty");
        }
        randomAccessFile.seek(0L);
        byte[] byArray = new byte[4];
        randomAccessFile.read(byArray);
        String string = new String(byArray);
        if (!string.equals("MAC ")) {
            throw new CannotReadException("'MAC ' Header not found");
        }
        byArray = new byte[4];
        randomAccessFile.read(byArray);
        int n = Utils.getNumber(byArray, 0, 3);
        if (n < 3970) {
            throw new CannotReadException("Monkey Audio version <= 3.97 is not supported");
        }
        byArray = new byte[44];
        randomAccessFile.read(byArray);
        MonkeyDescriptor monkeyDescriptor = new MonkeyDescriptor(byArray);
        byArray = new byte[24];
        randomAccessFile.read(byArray);
        MonkeyHeader monkeyHeader = new MonkeyHeader(byArray);
        randomAccessFile.seek(monkeyDescriptor.getRiffWavOffset());
        byArray = new byte[12];
        randomAccessFile.read(byArray);
        WavRIFFHeader wavRIFFHeader = new WavRIFFHeader(byArray);
        if (!wavRIFFHeader.isValid()) {
            throw new CannotReadException("No valid RIFF Header found");
        }
        byArray = new byte[24];
        randomAccessFile.read(byArray);
        WavFormatHeader wavFormatHeader = new WavFormatHeader(byArray);
        if (!wavFormatHeader.isValid()) {
            throw new CannotReadException("No valid WAV Header found");
        }
        encodingInfo.setPreciseLength(monkeyHeader.getPreciseLength());
        encodingInfo.setChannelNumber(wavFormatHeader.getChannelNumber());
        encodingInfo.setSamplingRate(wavFormatHeader.getSamplingRate());
        encodingInfo.setBitrate(this.computeBitrate(encodingInfo.getLength(), randomAccessFile.length()));
        encodingInfo.setEncodingType("Monkey Audio v" + (double)n / 1000.0 + ", compression level " + monkeyHeader.getCompressionLevel());
        encodingInfo.setExtraEncodingInfos("");
        return encodingInfo;
    }

    private int computeBitrate(int n, long l) {
        return (int)(l / 1000L * 8L / (long)n);
    }
}

