/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.data;

import entagged.audioformats.asf.data.Chunk;
import entagged.audioformats.asf.data.GUID;
import entagged.audioformats.asf.util.Utils;
import java.math.BigInteger;
import java.util.Date;

public class FileHeader
extends Chunk {
    private final BigInteger duration;
    private final Date fileCreationTime;
    private BigInteger fileSize;
    private final long flags;
    private final long maxPackageSize;
    private final long minPackageSize;
    private final BigInteger packageCount;
    private final BigInteger timeEndPos;
    private final BigInteger timeStartPos;
    private final long uncompressedFrameSize;

    public FileHeader(long l, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, long l2, long l3, long l4, long l5) {
        super(GUID.GUID_FILE, l, bigInteger);
        this.fileSize = bigInteger2;
        this.packageCount = bigInteger4;
        this.duration = bigInteger5;
        this.timeStartPos = bigInteger6;
        this.timeEndPos = bigInteger7;
        this.flags = l2;
        this.minPackageSize = l3;
        this.maxPackageSize = l4;
        this.uncompressedFrameSize = l5;
        this.fileCreationTime = Utils.getDateOf(bigInteger3).getTime();
    }

    public BigInteger getDuration() {
        return this.duration;
    }

    public int getDurationInSeconds() {
        return this.duration.divide(new BigInteger("10000000")).intValue();
    }

    public Date getFileCreationTime() {
        return this.fileCreationTime;
    }

    public BigInteger getFileSize() {
        return this.fileSize;
    }

    public long getFlags() {
        return this.flags;
    }

    public long getMaxPackageSize() {
        return this.maxPackageSize;
    }

    public long getMinPackageSize() {
        return this.minPackageSize;
    }

    public BigInteger getPackageCount() {
        return this.packageCount;
    }

    public float getPreciseDuration() {
        double d = this.getDuration().doubleValue() / 1.0E7;
        return (float)d;
    }

    public BigInteger getTimeEndPos() {
        return this.timeEndPos;
    }

    public BigInteger getTimeStartPos() {
        return this.timeStartPos;
    }

    public long getUncompressedFrameSize() {
        return this.uncompressedFrameSize;
    }

    public String prettyPrint() {
        StringBuffer stringBuffer = new StringBuffer(super.prettyPrint());
        stringBuffer.insert(0, "\nFileHeader\n");
        stringBuffer.append("   Filesize      = " + this.getFileSize().toString() + " Bytes \n");
        stringBuffer.append("   Media duration= " + this.getDuration().divide(new BigInteger("10000")).toString() + " ms \n");
        stringBuffer.append("   Created at    = " + this.getFileCreationTime() + "\n");
        return stringBuffer.toString();
    }
}

