/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.flac.util;

import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.flac.util.MetadataBlockHeader;
import entagged.audioformats.ogg.OggTag;
import entagged.audioformats.ogg.util.OggTagReader;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FlacTagReader {
    private OggTagReader oggTagReader = new OggTagReader();

    public OggTag read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        if (randomAccessFile.length() == 0L) {
            throw new CannotReadException("Error: File empty");
        }
        randomAccessFile.seek(0L);
        byte[] byArray = new byte[4];
        randomAccessFile.read(byArray);
        String string = new String(byArray);
        if (!string.equals("fLaC")) {
            throw new CannotReadException("fLaC Header not found, not a flac file");
        }
        OggTag oggTag = null;
        boolean bl = false;
        while (!bl) {
            byArray = new byte[4];
            randomAccessFile.read(byArray);
            MetadataBlockHeader metadataBlockHeader = new MetadataBlockHeader(byArray);
            switch (metadataBlockHeader.getBlockType()) {
                case 4: {
                    oggTag = this.handleVorbisComment(metadataBlockHeader, randomAccessFile);
                    metadataBlockHeader = null;
                    return oggTag;
                }
            }
            randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)metadataBlockHeader.getDataLength());
            bl = metadataBlockHeader.isLastBlock();
            metadataBlockHeader = null;
        }
        throw new CannotReadException("FLAC Tag could not be found or read..");
    }

    private OggTag handleVorbisComment(MetadataBlockHeader metadataBlockHeader, RandomAccessFile randomAccessFile) throws IOException, CannotReadException {
        long l = randomAccessFile.getFilePointer();
        OggTag oggTag = this.oggTagReader.read(randomAccessFile);
        long l2 = randomAccessFile.getFilePointer();
        if (l2 - l != (long)metadataBlockHeader.getDataLength()) {
            throw new CannotReadException("Tag length do not match with flac comment data length");
        }
        return oggTag;
    }
}

