/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.generic;

import entagged.audioformats.AudioFile;
import entagged.audioformats.EncodingInfo;
import entagged.audioformats.Tag;
import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.generic.GenericTag;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class AudioFileReader {
    protected abstract EncodingInfo getEncodingInfo(RandomAccessFile var1) throws CannotReadException, IOException;

    protected abstract Tag getTag(RandomAccessFile var1) throws CannotReadException, IOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AudioFile read(File file) throws CannotReadException {
        AudioFile audioFile;
        if (!file.canRead()) {
            throw new CannotReadException("Can't read file \"" + file.getAbsolutePath() + "\"");
        }
        if (file.length() <= 150L) {
            throw new CannotReadException("Less than 150 byte \"" + file.getAbsolutePath() + "\"");
        }
        RandomAccessFile randomAccessFile = null;
        try {
            try {
                Tag tag;
                randomAccessFile = new RandomAccessFile(file, "r");
                randomAccessFile.seek(0L);
                EncodingInfo encodingInfo = this.getEncodingInfo(randomAccessFile);
                try {
                    randomAccessFile.seek(0L);
                    tag = this.getTag(randomAccessFile);
                }
                catch (CannotReadException cannotReadException) {
                    System.err.println(cannotReadException.getMessage());
                    tag = new GenericTag();
                }
                audioFile = new AudioFile(file, encodingInfo, tag);
                Object var7_8 = null;
            }
            catch (Exception exception) {
                throw new CannotReadException("\"" + file + "\" :" + exception, exception);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (randomAccessFile == null) throw throwable;
                randomAccessFile.close();
                throw throwable;
            }
            catch (Exception exception2) {
                System.err.println("\"" + file + "\" :" + exception2);
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            System.err.println("\"" + file + "\" :" + exception);
            return audioFile;
        }
        if (randomAccessFile == null) return audioFile;
        randomAccessFile.close();
        return audioFile;
    }
}

