/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.generic;

import java.io.File;
import java.io.UnsupportedEncodingException;

public class Utils {
    public static void copy(byte[] byArray, byte[] byArray2, int n) {
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
    }

    public static byte[] getDefaultBytes(String string) {
        return string.getBytes();
    }

    public static String getExtension(File file) {
        String string = file.getName().toLowerCase();
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static long getLongNumber(byte[] byArray, int n, int n2) {
        long l = 0L;
        for (int i = 0; i < n2 - n + 1; ++i) {
            l += (long)((byArray[n + i] & 0xFF) << i * 8);
        }
        return l;
    }

    public static long getLongNumberBigEndian(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2 - n + 1; ++i) {
            n3 += (byArray[n2 - i] & 0xFF) << i * 8;
        }
        return n3;
    }

    public static int getNumber(byte[] byArray, int n, int n2) {
        return (int)Utils.getLongNumber(byArray, n, n2);
    }

    public static int getNumberBigEndian(byte[] byArray, int n, int n2) {
        return (int)Utils.getLongNumberBigEndian(byArray, n, n2);
    }

    public static byte[] getSizeBigEndian(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    public static String getString(byte[] byArray, int n, int n2) {
        return new String(byArray, n, n2);
    }

    public static String getString(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        return new String(byArray, n, n2, string);
    }

    public static byte[] getUTF8Bytes(String string) throws UnsupportedEncodingException {
        return string.getBytes("UTF-8");
    }
}

