/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3;

import entagged.audioformats.generic.AbstractTag;
import entagged.audioformats.generic.TagField;
import entagged.audioformats.mp3.util.id3frames.CommId3Frame;
import entagged.audioformats.mp3.util.id3frames.TextId3Frame;
import java.util.List;
import java.util.Locale;

public class Id3v2Tag
extends AbstractTag {
    public static String DEFAULT_ENCODING = "UTF-16";
    public static byte ID3V22 = 0;
    public static byte ID3V23 = 1;
    public static byte ID3V24 = (byte)2;
    private boolean hasV1 = false;
    private byte representedVersion = ID3V23;

    public Id3v2Tag() {
    }

    public Id3v2Tag(byte by) {
        this.representedVersion = by;
    }

    protected TagField createAlbumField(String string) {
        return new TextId3Frame("TALB", string);
    }

    protected TagField createArtistField(String string) {
        return new TextId3Frame("TPE1", string);
    }

    protected TagField createCommentField(String string) {
        return new CommId3Frame(string);
    }

    protected TagField createGenreField(String string) {
        return new TextId3Frame("TCON", string);
    }

    protected TagField createTitleField(String string) {
        return new TextId3Frame("TIT2", string);
    }

    protected TagField createTrackField(String string) {
        return new TextId3Frame("TRCK", string);
    }

    protected TagField createYearField(String string) {
        return new TextId3Frame("TDRC", string);
    }

    protected String getAlbumId() {
        return "TALB";
    }

    protected String getArtistId() {
        return "TPE1";
    }

    public List getComment() {
        List list = super.getComment();
        String string = Locale.getDefault().getISO3Language();
        CommId3Frame commId3Frame = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof CommId3Frame)) continue;
            commId3Frame = (CommId3Frame)list.get(i);
            if (!commId3Frame.getLangage().equals(string)) {
                commId3Frame = null;
                continue;
            }
            list.remove(i);
            break;
        }
        if (commId3Frame != null) {
            list.add(0, commId3Frame);
        }
        return list;
    }

    protected String getCommentId() {
        return "COMM";
    }

    protected String getGenreId() {
        return "TCON";
    }

    public byte getRepresentedVersion() {
        return this.representedVersion;
    }

    protected String getTitleId() {
        return "TIT2";
    }

    protected String getTrackId() {
        return "TRCK";
    }

    protected String getYearId() {
        return "TDRC";
    }

    public boolean hasId3v1() {
        return this.hasV1;
    }

    protected void hasId3v1(boolean bl) {
        this.hasV1 = bl;
    }

    protected boolean isAllowedEncoding(String string) {
        boolean bl;
        boolean bl2 = bl = string.equals("ISO-8859-1") || string.startsWith("UTF-16");
        if (!bl && this.representedVersion == ID3V24) {
            bl = string.equals("UTF-16BE") || string.equals("UTF-8");
        }
        return bl;
    }

    public String toString() {
        return "Id3v2 " + super.toString();
    }

    protected void setRepresentedVersion(byte by) {
        this.representedVersion = by;
    }
}

