/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3.util;

import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.mp3.Id3v1Tag;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Id3v1TagReader {
    public Id3v1Tag read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        Id3v1Tag id3v1Tag = new Id3v1Tag();
        randomAccessFile.seek(randomAccessFile.length() - 128L);
        byte[] byArray = new byte[3];
        randomAccessFile.read(byArray);
        randomAccessFile.seek(0L);
        String string = new String(byArray);
        if (!string.equals("TAG")) {
            throw new CannotReadException("There is no Id3v1 Tag in this file");
        }
        randomAccessFile.seek(randomAccessFile.length() - 128L + 3L);
        String string2 = this.read(randomAccessFile, 30);
        String string3 = this.read(randomAccessFile, 30);
        String string4 = this.read(randomAccessFile, 30);
        String string5 = this.read(randomAccessFile, 4);
        String string6 = this.read(randomAccessFile, 30);
        String string7 = "";
        randomAccessFile.seek(randomAccessFile.getFilePointer() - 2L);
        byArray = new byte[2];
        randomAccessFile.read(byArray);
        if (byArray[0] == 0) {
            Integer n = new Integer(byArray[1]);
            string7 = n.toString();
        }
        byte by = randomAccessFile.readByte();
        randomAccessFile.seek(0L);
        id3v1Tag.setTitle(string2);
        id3v1Tag.setArtist(string3);
        id3v1Tag.setAlbum(string4);
        id3v1Tag.setYear(string5);
        id3v1Tag.setComment(string6);
        id3v1Tag.setTrack(string7);
        id3v1Tag.setGenre(id3v1Tag.translateGenre(by));
        return id3v1Tag;
    }

    private String read(RandomAccessFile randomAccessFile, int n) throws IOException {
        byte[] byArray = new byte[n];
        randomAccessFile.read(byArray);
        String string = new String(byArray).trim();
        int n2 = string.indexOf("\u0000");
        if (n2 != -1) {
            return string.substring(0, n2 + 1);
        }
        return string;
    }
}

