/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3.util;

public class LameMPEGFrame {
    private int bitrate;
    private boolean containsLameMPEGFrame;
    private int fileSize;
    private boolean isValidLameMPEGFrame = false;
    private String lameVersion;
    private boolean containsLameFrame = false;

    public LameMPEGFrame(byte[] byArray) {
        String string = new String(byArray, 0, 4);
        if (string.equals("LAME")) {
            this.isValidLameMPEGFrame = true;
            int[] nArray = this.u(byArray);
            this.containsLameFrame = (nArray[9] & 0xFF) == 255;
            byte[] byArray2 = new byte[]{byArray[4], byArray[5], byArray[6], byArray[7], byArray[8]};
            this.lameVersion = new String(byArray2);
            this.containsLameMPEGFrame = this.containsLameMPEGFrame();
            if (this.containsLameMPEGFrame) {
                this.bitrate = nArray[20];
                this.fileSize = nArray[28] * 0xFFFFFF + nArray[29] * 65535 + nArray[30] * 255 + nArray[31];
            }
        } else {
            this.isValidLameMPEGFrame = false;
        }
    }

    private int[] u(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        return nArray;
    }

    public boolean isValid() {
        return this.isValidLameMPEGFrame;
    }

    public String toString() {
        String string;
        if (this.isValidLameMPEGFrame) {
            string = "\n----LameMPEGFrame--------------------\n";
            string = string + "Lame" + this.lameVersion;
            if (this.containsLameMPEGFrame) {
                string = string + "\tMin.Bitrate:" + this.bitrate + "\tLength:" + this.fileSize;
            }
            string = string + "\n--------------------------------\n";
        } else {
            string = "\n!!!No Valid Lame MPEG Frame!!!\n";
        }
        return string;
    }

    private boolean containsLameMPEGFrame() {
        return this.containsLameFrame;
    }
}

