/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3.util.id3frames;

import entagged.audioformats.generic.TagField;
import entagged.audioformats.mp3.util.id3frames.TextId3Frame;
import java.io.UnsupportedEncodingException;

public class ApicId3Frame
extends TextId3Frame {
    private byte[] data;
    private String mime;
    private byte pictureType;
    private boolean unsupportedState = false;

    public ApicId3Frame(byte[] byArray, byte by) throws UnsupportedEncodingException {
        super("APIC", byArray, by);
    }

    public ApicId3Frame(String string, String string2, byte by, byte[] byArray) {
        super("APIC", string);
        this.mime = string2;
        this.pictureType = by;
        this.data = byArray;
    }

    protected byte[] build() throws UnsupportedEncodingException {
        if (this.unsupportedState) {
            return this.data;
        }
        byte[] byArray = this.getBytes(this.content, this.getEncoding());
        byte[] byArray2 = this.getBytes(this.mime, "ISO-8859-1");
        byte[] byArray3 = new byte[8 + this.flags.length + 1 + byArray2.length + 1 + byArray.length + this.data.length];
        int n = 0;
        this.copy(this.getIdBytes(), byArray3, n);
        this.copy(this.getSize(byArray3.length - 10), byArray3, n += 4);
        this.copy(this.flags, byArray3, n += 4);
        byArray3[n += this.flags.length] = this.encoding;
        this.copy(byArray2, byArray3, ++n);
        byArray3[n += byArray2.length] = this.pictureType;
        this.copy(byArray, byArray3, ++n);
        this.copy(this.data, byArray3, n += byArray.length);
        n += this.data.length;
        return byArray3;
    }

    public void copyContent(TagField tagField) {
        super.copyContent(tagField);
        if (tagField instanceof ApicId3Frame) {
            if (!((ApicId3Frame)tagField).unsupportedState) {
                this.mime = ((ApicId3Frame)tagField).getMimeType();
                this.pictureType = ((ApicId3Frame)tagField).getPictureType();
                this.data = ((ApicId3Frame)tagField).getData();
            } else {
                this.data = ((ApicId3Frame)tagField).data;
                this.unsupportedState = true;
            }
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public String getMimeType() {
        return this.mime;
    }

    public byte getPictureType() {
        return this.pictureType;
    }

    public String getPictureTypeAsString() {
        switch (this.pictureType & 0xFF) {
            case 0: {
                return "Other";
            }
            case 1: {
                return "32x32 pixels file icon";
            }
            case 2: {
                return "Other file icon";
            }
            case 3: {
                return "Cover (front)";
            }
            case 4: {
                return "Cover (back)";
            }
            case 5: {
                return "Leaflet page";
            }
            case 6: {
                return "Media (e.g. lable side of CD)";
            }
            case 7: {
                return "Lead artist/lead performer/soloist";
            }
            case 8: {
                return "Artist/performer";
            }
            case 9: {
                return "Conductor";
            }
            case 10: {
                return "Band/Orchestra";
            }
            case 11: {
                return "Composer";
            }
            case 12: {
                return "Lyricist/text writer";
            }
            case 13: {
                return "Recording Location";
            }
            case 14: {
                return "During recording";
            }
            case 15: {
                return "During performance";
            }
            case 16: {
                return "Movie/video screen capture";
            }
            case 17: {
                return "A bright coloured fish";
            }
            case 18: {
                return "Illustration";
            }
            case 19: {
                return "Band/artist logotype";
            }
            case 20: {
                return "Publisher/Studio logotype";
            }
        }
        return "Unknown";
    }

    public boolean isBinary() {
        return true;
    }

    public boolean isEmpty() {
        return super.isEmpty() && this.data.length == 0 && this.mime.equals("");
    }

    protected void populate(byte[] byArray) throws UnsupportedEncodingException {
        this.data = new byte[0];
        this.encoding = byArray[this.flags.length];
        if (this.encoding < 0 || this.encoding > 3) {
            this.encoding = 0;
        }
        int n = this.indexOfFirstNull(byArray, this.flags.length + 1);
        this.mime = this.getString(byArray, this.flags.length + 1, n - this.flags.length - 1, "ISO-8859-1");
        if (this.mime == null) {
            return;
        }
        if (this.mime.trim().equals("-->")) {
            this.unsupportedState = true;
            this.data = byArray;
            return;
        }
        this.pictureType = byArray[n + 1];
        int n2 = this.indexOfFirstNull(byArray, n + 2);
        this.content = this.getString(byArray, n + 2, n2 - n - 2, this.getEncoding());
        if (this.encoding == 2 || this.encoding == 3) {
            ++n2;
        }
        if (byArray.length > ++n2) {
            this.data = new byte[byArray.length - n2];
            System.arraycopy(byArray, n2, this.data, 0, this.data.length);
        } else {
            System.err.println("ApicId3Frame-> No space for picture data left.");
        }
    }

    public String toString() {
        return "[" + this.mime + " (" + this.getPictureTypeAsString() + ")] " + super.toString();
    }
}

