/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3.util.id3frames;

import entagged.audioformats.generic.TagField;
import entagged.audioformats.mp3.util.id3frames.Id3Frame;
import java.io.UnsupportedEncodingException;

public class UfidId3Frame
extends Id3Frame {
    private String ownerId;
    private byte[] identifier;

    public UfidId3Frame(byte[] byArray, byte by) throws UnsupportedEncodingException {
        super(byArray, by);
    }

    protected void populate(byte[] byArray) {
        int n = this.indexOfFirstNull(byArray, this.flags.length);
        if (n != -1) {
            this.ownerId = new String(byArray, this.flags.length, n - this.flags.length);
        } else {
            this.ownerId = new String(byArray, this.flags.length, byArray.length - this.flags.length);
            this.identifier = new byte[0];
        }
        this.identifier = new byte[byArray.length - n - 1];
        for (int i = 0; i < this.identifier.length; ++i) {
            this.identifier[i] = byArray[n + 1 + i];
        }
    }

    protected byte[] build() {
        byte[] byArray = this.ownerId.getBytes();
        byte[] byArray2 = new byte[8 + this.flags.length + byArray.length + 1 + this.identifier.length];
        int n = 0;
        this.copy(this.getIdBytes(), byArray2, n);
        this.copy(this.getSize(byArray2.length - 10), byArray2, n += 4);
        this.copy(this.flags, byArray2, n += 4);
        this.copy(byArray, byArray2, n += this.flags.length);
        byArray2[n += byArray.length] = 0;
        this.copy(this.identifier, byArray2, ++n);
        return byArray2;
    }

    public boolean isBinary() {
        return true;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public byte[] getIdentifier() {
        return this.identifier;
    }

    public String getId() {
        return "UFID";
    }

    public boolean isCommon() {
        return false;
    }

    public void copyContent(TagField tagField) {
        if (tagField instanceof UfidId3Frame) {
            this.ownerId = ((UfidId3Frame)tagField).getOwnerId();
            this.identifier = ((UfidId3Frame)tagField).getIdentifier();
        }
    }

    public boolean isEmpty() {
        return this.ownerId.equals("") || this.identifier.length == 0;
    }

    public String toString() {
        return "UFID : " + this.getOwnerId();
    }
}

