/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.ogg.util;

import entagged.audioformats.EncodingInfo;
import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.ogg.util.OggPageHeader;
import entagged.audioformats.ogg.util.VorbisCodecHeader;
import java.io.IOException;
import java.io.RandomAccessFile;

public class OggInfoReader {
    public EncodingInfo read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        Object object;
        Object object2;
        int n;
        byte[] byArray;
        EncodingInfo encodingInfo = new EncodingInfo();
        long l = 0L;
        randomAccessFile.seek(0L);
        double d = -1.0;
        randomAccessFile.seek(randomAccessFile.length() - 2L);
        while (randomAccessFile.getFilePointer() >= 4L) {
            if (randomAccessFile.read() == 83) {
                randomAccessFile.seek(randomAccessFile.getFilePointer() - 4L);
                byArray = new byte[3];
                randomAccessFile.readFully(byArray);
                if (byArray[0] == 79 && byArray[1] == 103 && byArray[2] == 103) {
                    randomAccessFile.seek(randomAccessFile.getFilePointer() - 3L);
                    l = randomAccessFile.getFilePointer();
                    randomAccessFile.seek(randomAccessFile.getFilePointer() + 26L);
                    n = randomAccessFile.readByte() & 0xFF;
                    randomAccessFile.seek(l);
                    object2 = new byte[27 + n];
                    randomAccessFile.readFully((byte[])object2);
                    object = new OggPageHeader((byte[])object2);
                    randomAccessFile.seek(0L);
                    d = ((OggPageHeader)object).getAbsoluteGranulePosition();
                    break;
                }
            }
            randomAccessFile.seek(randomAccessFile.getFilePointer() - 2L);
        }
        if (d == -1.0) {
            throw new CannotReadException("Error: Could not find the Ogg Setup block");
        }
        byArray = new byte[4];
        l = randomAccessFile.getFilePointer();
        randomAccessFile.seek(26L);
        n = randomAccessFile.read() & 0xFF;
        randomAccessFile.seek(l);
        byArray = new byte[27 + n];
        randomAccessFile.read(byArray);
        object2 = new OggPageHeader(byArray);
        object = new byte[((OggPageHeader)object2).getPageLength()];
        randomAccessFile.read((byte[])object);
        VorbisCodecHeader vorbisCodecHeader = new VorbisCodecHeader((byte[])object);
        encodingInfo.setPreciseLength((float)(d / (double)vorbisCodecHeader.getSamplingRate()));
        encodingInfo.setChannelNumber(vorbisCodecHeader.getChannelNumber());
        encodingInfo.setSamplingRate(vorbisCodecHeader.getSamplingRate());
        encodingInfo.setEncodingType(vorbisCodecHeader.getEncodingType());
        encodingInfo.setExtraEncodingInfos("");
        if (vorbisCodecHeader.getNominalBitrate() != 0 && vorbisCodecHeader.getMaxBitrate() == vorbisCodecHeader.getNominalBitrate() && vorbisCodecHeader.getMinBitrate() == vorbisCodecHeader.getNominalBitrate()) {
            encodingInfo.setBitrate(vorbisCodecHeader.getNominalBitrate() / 1000);
            encodingInfo.setVbr(false);
        } else if (vorbisCodecHeader.getNominalBitrate() != 0 && vorbisCodecHeader.getMaxBitrate() == 0 && vorbisCodecHeader.getMinBitrate() == 0) {
            encodingInfo.setBitrate(vorbisCodecHeader.getNominalBitrate() / 1000);
            encodingInfo.setVbr(true);
        } else {
            encodingInfo.setBitrate(this.computeBitrate(encodingInfo.getLength(), randomAccessFile.length()));
            encodingInfo.setVbr(true);
        }
        return encodingInfo;
    }

    private int computeBitrate(int n, long l) {
        return (int)(l / 1000L * 8L / (long)n);
    }
}

