/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.ogg.util;

public class VorbisCodecHeader {
    private int audioChannels;
    private boolean isValid = false;
    private int vorbisVersion;
    private int audioSampleRate;
    private int bitrateMinimal;
    private int bitrateNominal;
    private int bitrateMaximal;

    public VorbisCodecHeader(byte[] byArray) {
        this.generateCodecHeader(byArray);
    }

    public int getChannelNumber() {
        return this.audioChannels;
    }

    public String getEncodingType() {
        return "Ogg Vorbis Version " + this.vorbisVersion;
    }

    public int getSamplingRate() {
        return this.audioSampleRate;
    }

    public int getNominalBitrate() {
        return this.bitrateNominal;
    }

    public int getMaxBitrate() {
        return this.bitrateMaximal;
    }

    public int getMinBitrate() {
        return this.bitrateMinimal;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void generateCodecHeader(byte[] byArray) {
        byte by = byArray[0];
        String string = new String(byArray, 1, 6);
        if (by == 1 && string.equals("vorbis")) {
            this.vorbisVersion = byArray[7] + (byArray[8] << 8) + (byArray[9] << 16) + (byArray[10] << 24);
            this.audioChannels = this.u(byArray[11]);
            this.audioSampleRate = this.u(byArray[12]) + (this.u(byArray[13]) << 8) + (this.u(byArray[14]) << 16) + (this.u(byArray[15]) << 24);
            this.bitrateMinimal = this.u(byArray[16]) + (this.u(byArray[17]) << 8) + (this.u(byArray[18]) << 16) + (this.u(byArray[19]) << 24);
            this.bitrateNominal = this.u(byArray[20]) + (this.u(byArray[21]) << 8) + (this.u(byArray[22]) << 16) + (this.u(byArray[23]) << 24);
            this.bitrateMaximal = this.u(byArray[24]) + (this.u(byArray[25]) << 8) + (this.u(byArray[26]) << 16) + (this.u(byArray[27]) << 24);
            byte by2 = byArray[29];
            if (by2 != 0) {
                this.isValid = true;
            }
        }
    }

    private int u(int n) {
        return n & 0xFF;
    }
}

