/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.ogg.util;

import entagged.audioformats.Tag;
import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.exceptions.CannotWriteException;
import entagged.audioformats.generic.Utils;
import entagged.audioformats.ogg.OggTag;
import entagged.audioformats.ogg.util.OggCRCFactory;
import entagged.audioformats.ogg.util.OggPageHeader;
import entagged.audioformats.ogg.util.VorbisTagCreator;
import entagged.audioformats.ogg.util.VorbisTagReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class VorbisTagWriter {
    private VorbisTagCreator tc = new VorbisTagCreator();
    private VorbisTagReader reader = new VorbisTagReader();

    public void delete(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws IOException, CannotWriteException {
        OggTag oggTag = null;
        try {
            oggTag = (OggTag)this.reader.read(randomAccessFile);
        }
        catch (CannotReadException cannotReadException) {
            this.write(new OggTag(), randomAccessFile, randomAccessFile2);
            return;
        }
        OggTag oggTag2 = new OggTag();
        oggTag2.setVendor(oggTag.getVendor());
        this.write(oggTag2, randomAccessFile, randomAccessFile2);
    }

    public void write(Tag tag, RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws CannotWriteException, IOException {
        int n;
        randomAccessFile.seek(26L);
        byte[] byArray = new byte[4];
        int n2 = randomAccessFile.readByte() & 0xFF;
        randomAccessFile.seek(0L);
        byArray = new byte[27 + n2];
        randomAccessFile.read(byArray);
        OggPageHeader oggPageHeader = new OggPageHeader(byArray);
        randomAccessFile.seek(0L);
        randomAccessFile2.getChannel().transferFrom(randomAccessFile.getChannel(), 0L, oggPageHeader.getPageLength() + 27 + n2);
        randomAccessFile2.skipBytes((int)((long)oggPageHeader.getPageLength() + randomAccessFile.getFilePointer()));
        long l = randomAccessFile.getFilePointer();
        randomAccessFile.seek(randomAccessFile.getFilePointer() + 26L);
        n2 = randomAccessFile.readByte() & 0xFF;
        randomAccessFile.seek(l);
        byArray = new byte[27 + n2];
        randomAccessFile.read(byArray);
        OggPageHeader oggPageHeader2 = new OggPageHeader(byArray);
        long l2 = randomAccessFile.getFilePointer();
        int n3 = 7;
        randomAccessFile.seek(randomAccessFile.getFilePointer() + 7L);
        byArray = new byte[4];
        randomAccessFile.read(byArray);
        int n4 = Utils.getNumber(byArray, 0, 3);
        n3 += 4 + n4;
        randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)n4);
        byArray = new byte[4];
        randomAccessFile.read(byArray);
        int n5 = Utils.getNumber(byArray, 0, 3);
        n3 += 4;
        for (n = 0; n < n5; ++n) {
            byArray = new byte[4];
            randomAccessFile.read(byArray);
            int n6 = Utils.getNumber(byArray, 0, 3);
            n3 += 4 + n6;
            randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)n6);
        }
        n = randomAccessFile.readByte();
        ++n3;
        if (n != 1) {
            throw new CannotWriteException("Unable to retreive old tag informations");
        }
        ByteBuffer byteBuffer = this.tc.convert(tag);
        int n7 = byteBuffer.capacity();
        int n8 = oggPageHeader2.getPageLength() - n3 + n7;
        byte[] byArray2 = this.createSegmentTable(n3, n7, oggPageHeader2);
        int n9 = 27 + byArray2.length;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n8 + n9);
        byArray = new String("OggS").getBytes();
        byteBuffer2.put(byArray);
        byteBuffer2.put((byte)0);
        byteBuffer2.put((byte)0);
        byteBuffer2.put(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
        int n10 = oggPageHeader2.getSerialNumber();
        byArray = new byte[4];
        byArray[3] = (byte)((n10 & 0xFF000000) >> 24);
        byArray[2] = (byte)((n10 & 0xFF0000) >> 16);
        byArray[1] = (byte)((n10 & 0xFF00) >> 8);
        byArray[0] = (byte)(n10 & 0xFF);
        byteBuffer2.put(byArray);
        int n11 = oggPageHeader2.getPageSequence();
        byArray = new byte[4];
        byArray[3] = (byte)((n11 & 0xFF000000) >> 24);
        byArray[2] = (byte)((n11 & 0xFF0000) >> 16);
        byArray[1] = (byte)((n11 & 0xFF00) >> 8);
        byArray[0] = (byte)(n11 & 0xFF);
        byteBuffer2.put(byArray);
        byteBuffer2.put(new byte[]{0, 0, 0, 0});
        int n12 = 22;
        if (byArray2.length > 255) {
            throw new CannotWriteException("In this special case we need to create a new page, since we still hadn't the time for that we won't write because it wouldn't create an ogg file.");
        }
        byteBuffer2.put((byte)byArray2.length);
        for (int i = 0; i < byArray2.length; ++i) {
            byteBuffer2.put(byArray2[i]);
        }
        byteBuffer2.put(byteBuffer);
        randomAccessFile.seek(l2);
        randomAccessFile.skipBytes(n3);
        randomAccessFile.getChannel().read(byteBuffer2);
        byte[] byArray3 = OggCRCFactory.computeCRC(byteBuffer2.array());
        for (int i = 0; i < byArray3.length; ++i) {
            byteBuffer2.put(n12 + i, byArray3[i]);
        }
        byteBuffer2.rewind();
        randomAccessFile2.getChannel().write(byteBuffer2);
        randomAccessFile2.getChannel().transferFrom(randomAccessFile.getChannel(), randomAccessFile2.getFilePointer(), randomAccessFile.length() - randomAccessFile.getFilePointer());
    }

    private byte[] createSegmentTable(int n, int n2, OggPageHeader oggPageHeader) {
        int n3 = oggPageHeader.getPageLength();
        byte[] byArray = this.createSegments(n3 - n, false);
        byte[] byArray2 = this.createSegments(n2, true);
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        return byArray3;
    }

    private byte[] createSegments(int n, boolean bl) {
        int n2;
        byte[] byArray = new byte[n / 255 + (n % 255 == 0 && !bl ? 0 : 1)];
        for (n2 = 0; n2 < byArray.length - 1; ++n2) {
            byArray[n2] = -1;
        }
        byArray[byArray.length - 1] = (byte)(n - n2 * 255);
        return byArray;
    }
}

