/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.wav.util;

import entagged.audioformats.EncodingInfo;
import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.wav.util.WavFormatHeader;
import entagged.audioformats.wav.util.WavRIFFHeader;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WavInfoReader {
    public EncodingInfo read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        WavFormatHeader wavFormatHeader;
        EncodingInfo encodingInfo = new EncodingInfo();
        if (randomAccessFile.length() < 12L) {
            throw new CannotReadException("This is not a WAV File (<12 bytes)");
        }
        byte[] byArray = new byte[12];
        randomAccessFile.read(byArray);
        WavRIFFHeader wavRIFFHeader = new WavRIFFHeader(byArray);
        if (wavRIFFHeader.isValid()) {
            byArray = new byte[24];
            randomAccessFile.read(byArray);
            wavFormatHeader = new WavFormatHeader(byArray);
            if (!wavFormatHeader.isValid()) {
                throw new CannotReadException("Wav Format Header not valid");
            }
        } else {
            throw new CannotReadException("Wav RIFF Header not valid");
        }
        encodingInfo.setPreciseLength(((float)randomAccessFile.length() - 36.0f) / (float)wavFormatHeader.getBytesPerSecond());
        encodingInfo.setChannelNumber(wavFormatHeader.getChannelNumber());
        encodingInfo.setSamplingRate(wavFormatHeader.getSamplingRate());
        encodingInfo.setEncodingType("WAV-RIFF " + wavFormatHeader.getBitrate() + " bits");
        encodingInfo.setExtraEncodingInfos("");
        encodingInfo.setBitrate(wavFormatHeader.getBytesPerSecond() * 8 / 1000);
        encodingInfo.setVbr(false);
        return encodingInfo;
    }
}

