/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.jmp3renamer.DataSet;
import net.sf.jmp3renamer.FileManager;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.MagicCookieBaker;
import net.sf.jmp3renamer.Main;
import net.sf.jmp3renamer.util.MyFile;
import net.sf.jmp3renamer.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataManager
extends Observable {
    private static int id = 0;
    private static transient Logger logger = LoggerFactory.getLogger(class$net$sf$jmp3renamer$DataManager == null ? (class$net$sf$jmp3renamer$DataManager = DataManager.class$("net.sf.jmp3renamer.DataManager")) : class$net$sf$jmp3renamer$DataManager);
    private Vector datasets = new Vector();
    private static DataManager instance;
    public static final int CAPITALIZED = 0;
    public static final int UPPERCASE = 1;
    public static final int LOWERCASE = 2;
    static /* synthetic */ Class class$net$sf$jmp3renamer$DataManager;

    private DataManager() {
    }

    public static synchronized DataManager getInstance() {
        if (instance == null) {
            instance = new DataManager();
        }
        return instance;
    }

    public void addObserver(Observer o) {
        logger.debug("Adding observer " + o.getClass());
        super.addObserver(o);
        logger.debug("# observers: " + this.countObservers());
    }

    public void notifyObservers() {
        this.setChanged();
        logger.debug("Datasets changed");
        super.notifyObservers(this.datasets);
        this.clearChanged();
    }

    public Vector getDatasets() {
        return this.datasets;
    }

    public void setDatasets(Vector datasets) {
        Iterator iter = datasets.iterator();
        while (iter.hasNext()) {
            DataSet row = (DataSet)iter.next();
            if (row.isPartOfCompilation()) {
                row.setRegex(Main.getProperty("filenameCompilation"));
                continue;
            }
            row.setRegex(Main.getProperty("filename"));
        }
        this.datasets = datasets;
        this.notifyObservers();
    }

    public void trySort() {
        Vector files = FileManager.getInstance().getFiles();
        for (int i = 0; i < files.size(); ++i) {
            ArrayList<Container> list = new ArrayList<Container>();
            String filename = ((MyFile)files.elementAt(i)).getName();
            filename = filename.toLowerCase();
            filename = filename.substring(0, filename.lastIndexOf("."));
            for (int j = 0; j < this.datasets.size(); ++j) {
                String dataset = MagicCookieBaker.evaluateDataSet((DataSet)this.datasets.elementAt(j));
                int percent = StringUtils.percentageOfCommonWords(filename, dataset);
                list.add(new Container(percent, j));
            }
            Collections.sort(list);
            Container c = (Container)list.get(list.size() - 1);
            int index = c.getIndex();
            if (index == i || i >= this.datasets.size()) continue;
            this.moveRow(index, i);
        }
    }

    public void moveRow(int row, int to) {
        DataSet temp = (DataSet)this.datasets.elementAt(to);
        this.datasets.setElementAt(this.datasets.elementAt(row), to);
        if (row > to) {
            for (int i = row - 1; i > to; --i) {
                this.datasets.setElementAt(this.datasets.elementAt(i), i + 1);
            }
            this.datasets.setElementAt(temp, to + 1);
        } else if (row < to) {
            for (int i = row + 1; i < to; ++i) {
                this.datasets.setElementAt(this.datasets.elementAt(i), i - 1);
            }
            this.datasets.setElementAt(temp, to - 1);
        }
        this.notifyObservers();
    }

    public static int getNextID() {
        return id++;
    }

    public void removeRow(int row) {
        this.datasets.removeElementAt(row);
        this.notifyObservers();
    }

    public void addRow(DataSet row) {
        this.datasets.add(row);
        if (row.isPartOfCompilation()) {
            row.setRegex(Main.getProperty("filenameCompilation"));
        } else {
            row.setRegex(Main.getProperty("filename"));
        }
        this.notifyObservers();
    }

    public void setLeadingZeros(int count) {
        Main.setProperty("LEADING_0S", Integer.toString(count));
        Iterator iter = this.datasets.iterator();
        while (iter.hasNext()) {
            DataSet current = (DataSet)iter.next();
            String track = current.getTrack();
            if (track.indexOf("/") > 0) {
                String[] numbers = track.split("/");
                track = this.addLeadingZeros(numbers[0], count);
                track = track + "/";
                track = track + this.addLeadingZeros(numbers[1], count);
                current.setTrack(track);
                continue;
            }
            try {
                track = this.addLeadingZeros(track, count);
                current.setTrack(track);
            }
            catch (Exception e) {
                logger.warn(I18N.translate("warn.add_leading_zeros", new String[]{current.toString()}), e);
            }
        }
    }

    private String addLeadingZeros(String track, int count) {
        track = Integer.toString(Integer.parseInt(track));
        while (track.length() < count + 1) {
            track = "0" + track;
        }
        return track;
    }

    public void replaceBy(String r, String b) {
        if (!r.equals(I18N.translate("replace")) && !b.equals(I18N.translate("by"))) {
            Iterator iter = this.datasets.iterator();
            while (iter.hasNext()) {
                DataSet current = (DataSet)iter.next();
                current.setTitle(MagicCookieBaker.replace(current.getTitle(), r, b));
                current.setAlbum(MagicCookieBaker.replace(current.getAlbum(), r, b));
                current.setArtist(MagicCookieBaker.replace(current.getArtist(), r, b));
                current.setComposer(MagicCookieBaker.replace(current.getComposer(), r, b));
                current.setGenre(MagicCookieBaker.replace(current.getGenre(), r, b));
                current.setComment(MagicCookieBaker.replace(current.getComment(), r, b));
                current.setTrack(MagicCookieBaker.replace(current.getTrack(), r, b));
                current.setCopyright(MagicCookieBaker.replace(current.getCopyright(), r, b));
                current.setEncodedBy(MagicCookieBaker.replace(current.getEncodedBy(), r, b));
                current.setOrigArtist(MagicCookieBaker.replace(current.getOrigArtist(), r, b));
            }
        }
    }

    public void setWordCase(int wordCase) {
        Iterator iter = this.datasets.iterator();
        while (iter.hasNext()) {
            DataSet current = (DataSet)iter.next();
            if (wordCase == 1) {
                current.setTitle(current.getTitle().toUpperCase());
                current.setAlbum(current.getAlbum().toUpperCase());
                current.setArtist(current.getArtist().toUpperCase());
                current.setComposer(current.getComposer().toUpperCase());
                current.setGenre(current.getGenre().toUpperCase());
                current.setCopyright(current.getCopyright().toUpperCase());
                current.setEncodedBy(current.getEncodedBy().toUpperCase());
                current.setOrigArtist(current.getOrigArtist().toUpperCase());
                continue;
            }
            if (wordCase == 2) {
                current.setTitle(current.getTitle().toLowerCase());
                current.setAlbum(current.getAlbum().toLowerCase());
                current.setArtist(current.getArtist().toLowerCase());
                current.setComposer(current.getComposer().toLowerCase());
                current.setGenre(current.getGenre().toLowerCase());
                current.setCopyright(current.getCopyright().toLowerCase());
                current.setEncodedBy(current.getEncodedBy().toLowerCase());
                current.setOrigArtist(current.getOrigArtist().toLowerCase());
                continue;
            }
            if (wordCase != 0) continue;
            current.setTitle(this.capitalize(current.getTitle().toLowerCase()));
            current.setAlbum(this.capitalize(current.getAlbum().toLowerCase()));
            current.setArtist(this.capitalize(current.getArtist().toLowerCase()));
            current.setComposer(this.capitalize(current.getComposer().toLowerCase()));
            current.setGenre(this.capitalize(current.getGenre().toLowerCase()));
            current.setCopyright(this.capitalize(current.getCopyright().toLowerCase()));
            current.setEncodedBy(this.capitalize(current.getEncodedBy().toLowerCase()));
            current.setOrigArtist(this.capitalize(current.getOrigArtist().toLowerCase()));
        }
    }

    private String capitalize(String string) {
        if (string.length() > 0) {
            StringTokenizer st = new StringTokenizer(string, " _-.", true);
            StringBuffer sb = new StringBuffer();
            while (st.hasMoreTokens()) {
                char second;
                StringBuffer temp = new StringBuffer(st.nextToken());
                char first = temp.charAt(0);
                if (first >= 'a' && first <= 'z') {
                    first = (char)(first - 32);
                    temp.setCharAt(0, first);
                } else if (temp.length() > 1 && (second = temp.charAt(1)) >= 'a' && second <= 'z') {
                    second = (char)(second - 32);
                    temp.setCharAt(1, second);
                }
                sb.append(temp.toString());
            }
            string = sb.toString();
        }
        return string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Container
    implements Comparable {
        private int percent;
        private int index;

        Container(int _percent, int _index) {
            this.percent = _percent;
            this.index = _index;
        }

        public int compareTo(Object o) {
            if (o instanceof Container) {
                Container c = (Container)o;
                if (c.getPercent() == this.percent) {
                    return 0;
                }
                if (this.percent < c.getPercent()) {
                    return -1;
                }
                return 1;
            }
            return -1;
        }

        public int getPercent() {
            return this.percent;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return this.percent + "% " + this.index;
        }
    }
}

