/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import net.sf.jmp3renamer.DataManager;
import net.sf.jmp3renamer.DataSet;
import net.sf.jmp3renamer.FilePlugin;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.ImageLoader;
import net.sf.jmp3renamer.MagicCookieBaker;
import net.sf.jmp3renamer.Main;
import net.sf.jmp3renamer.RowObserver;
import net.sf.jmp3renamer.util.Ant;
import net.sf.jmp3renamer.util.ExtendedFileFilter;
import net.sf.jmp3renamer.util.FileChooser;
import net.sf.jmp3renamer.util.MyFile;
import org.apache.tools.ant.BuildException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManager
extends Observable
implements Runnable {
    private static transient Logger logger = LoggerFactory.getLogger(class$net$sf$jmp3renamer$FileManager == null ? (class$net$sf$jmp3renamer$FileManager = FileManager.class$("net.sf.jmp3renamer.FileManager")) : class$net$sf$jmp3renamer$FileManager);
    private ArrayList rowObservers = new ArrayList();
    private Vector fileFilter = new Vector();
    private Vector files = new Vector();
    private Set additionalFiles;
    private Hashtable suffixToPlugin = new Hashtable();
    private static FileManager instance;
    private SupportedFilesFilter supportedFiles = new SupportedFilesFilter();
    static /* synthetic */ Class class$net$sf$jmp3renamer$FileManager;

    private FileManager() {
        this.additionalFiles = Collections.synchronizedSet(new HashSet());
    }

    public static synchronized FileManager getInstance() {
        if (instance == null) {
            instance = new FileManager();
        }
        return instance;
    }

    public void addFilePlugin(FilePlugin plugin) {
        ExtendedFileFilter filter = plugin.getFileFilter();
        this.fileFilter.addElement(filter);
        this.suffixToPlugin.put(filter.getSuffix(), plugin);
        this.supportedFiles.addSuffix(filter.getSuffix());
    }

    public void removeFilePlugin(FilePlugin plugin) {
        ExtendedFileFilter filter = plugin.getFileFilter();
        this.fileFilter.remove(filter);
        this.suffixToPlugin.remove(filter.getSuffix());
        this.supportedFiles.removeSuffix(filter.getSuffix());
    }

    public void addObserver(Observer o) {
        logger.debug("Adding observer {}", o.getClass());
        super.addObserver(o);
        logger.debug("# observers: {}", (Object)Integer.toString(this.countObservers()));
    }

    public void notifyObservers() {
        this.setChanged();
        super.notifyObservers(this.files);
        this.clearChanged();
    }

    public void openDir() {
        File dir = null;
        boolean recursive = false;
        try {
            FileChooser chooser = new FileChooser();
            dir = chooser.getSelectedFile();
            recursive = chooser.recursive();
        }
        catch (Exception e) {
            logger.error(I18N.translate("error.open_dir"), e);
        }
        if (dir != null) {
            this.openDir(dir, recursive);
            Main.setProperty("last", dir.getAbsolutePath());
        }
    }

    public void openDir(File file, boolean recursive) {
        if (file.isDirectory()) {
            this.files.removeAllElements();
            this.additionalFiles.clear();
            this.notifyRowObservers(null, 0, -10);
            Vector _files = this.findFiles(file, recursive, this.supportedFiles);
            Iterator it = _files.iterator();
            while (it.hasNext()) {
                this.files.addElement(new MyFile((File)it.next()));
            }
            this.notifyObservers();
            it = this.files.iterator();
            int i = 0;
            while (it.hasNext()) {
                this.notifyRowObservers(it.next(), i++, 1);
            }
        } else {
            logger.error("Given file is not a directory");
        }
    }

    private Vector findFiles(File dir, boolean recursive, FileFilter filter) {
        int i;
        Vector<File> files = new Vector<File>();
        if (dir.canRead()) {
            File[] _files = dir.listFiles(filter);
            for (i = 0; i < _files.length; ++i) {
                files.add(_files[i]);
            }
        }
        if (recursive) {
            File[] dirs = dir.listFiles();
            for (i = 0; i < dirs.length; ++i) {
                if (!dirs[i].isDirectory()) continue;
                files.addAll(this.findFiles(dirs[i], recursive, filter));
            }
        }
        return files;
    }

    public void resetStates() {
        Iterator it = this.files.iterator();
        ImageIcon icon = ImageLoader.getInstance().loadImage("images/untouched.gif");
        while (it.hasNext()) {
            MyFile file = (MyFile)it.next();
            file.setIcon(icon);
        }
    }

    public DataSet getMetaData(MyFile file) {
        FilePlugin plugin = (FilePlugin)this.suffixToPlugin.get(file.getSuffix());
        return plugin.getMetaData(file);
    }

    public void run() {
        this.startProcess();
    }

    private void startProcess() {
        Vector datasets = DataManager.getInstance().getDatasets();
        if (this.files.size() <= 0) {
            logger.error(I18N.translate("no_files"));
            return;
        }
        if (DataManager.getInstance().getDatasets().size() <= 0) {
            logger.error(I18N.translate("no_data"));
            return;
        }
        int count = 0;
        count = datasets.size() >= this.files.size() ? this.files.size() : datasets.size();
        this.moveAdditionalFiles();
        File oldDir = null;
        for (int i = 0; i < count; ++i) {
            DataSet dataset = (DataSet)datasets.elementAt(i);
            MyFile oldFile = (MyFile)this.files.elementAt(i);
            File newFile = this.getNewFile(dataset, oldFile);
            oldDir = oldFile.getParentFile();
            oldFile.setRenaming();
            this.notifyObservers();
            this.notifyRowObservers(oldFile, i, 0);
            try {
                Ant.moveFile(oldFile, newFile);
            }
            catch (BuildException e) {
                oldFile.setFailed();
                this.notifyObservers();
                this.notifyRowObservers(oldFile, i, 0);
                logger.warn(I18N.translate("error.rename_file", new Object[]{oldFile, newFile}), e);
                continue;
            }
            MyFile file = new MyFile(newFile);
            this.files.setElementAt(file, i);
            file.setOK();
            FilePlugin plugin = (FilePlugin)this.suffixToPlugin.get(file.getSuffix());
            try {
                plugin.setMetaData(file, dataset);
            }
            catch (Exception e) {
                logger.warn("Couldn't save metadata to file", e);
                file.setMetaFailed();
            }
            this.notifyObservers();
            this.notifyRowObservers(file, i, 0);
        }
        while (oldDir != null && oldDir.listFiles().length == 0) {
            logger.info(I18N.translate("info.delete_dir"), oldDir);
            oldDir.delete();
            oldDir = oldDir.getParentFile();
        }
    }

    private File getNewFile(DataSet dataset, MyFile oldFile) {
        String path_string = dataset.isPartOfCompilation() ? Main.getProperty("directoryCompilation") : Main.getProperty("directory");
        File dir = oldFile.getParentFile();
        if (!path_string.equals("")) {
            dir = new File(MagicCookieBaker.evaluatePath(path_string, dataset));
        }
        String newname = MagicCookieBaker.evaluateDataSet(dataset);
        newname = newname.replace('/', '-');
        newname = newname.replace('\\', '-');
        newname = newname.replace(':', '-');
        newname = newname.replace('*', '-');
        newname = newname.replace('?', '-');
        newname = newname.replace('\"', '-');
        newname = newname.replace('<', '-');
        newname = newname.replace('>', '-');
        newname = newname.replace('|', '-');
        newname = newname + "." + oldFile.getSuffix();
        File newFile = new File(dir, newname);
        return newFile;
    }

    private void moveAdditionalFiles() {
        Vector datasets = DataManager.getInstance().getDatasets();
        DataSet dataset = (DataSet)datasets.elementAt(0);
        MyFile oldFile = (MyFile)this.files.elementAt(0);
        File file = this.getNewFile(dataset, oldFile);
        File destinationDirectory = file.getParentFile();
        boolean success = true;
        Iterator iter = this.additionalFiles.iterator();
        while (iter.hasNext()) {
            File additionalFile = (File)iter.next();
            File newFile = new File(destinationDirectory, additionalFile.getName());
            try {
                Ant.moveFile(additionalFile, newFile);
                if (!additionalFile.equals(newFile)) {
                    additionalFile.delete();
                }
                iter.remove();
            }
            catch (BuildException e) {
                logger.warn("Couldn't move additional file", e);
                success = false;
            }
        }
        if (!success) {
            logger.error(I18N.translate("error.move_add_files"));
        }
    }

    public Vector getFiles() {
        return this.files;
    }

    public void addRowObserver(RowObserver o) {
        this.rowObservers.add(o);
    }

    public void removeRowObserver(RowObserver o) {
        this.rowObservers.remove(o);
    }

    public void notifyRowObservers(Object o, int row, int action) {
        Iterator it = this.rowObservers.iterator();
        while (it.hasNext()) {
            RowObserver ro = (RowObserver)it.next();
            ro.update(o, row, action);
        }
    }

    public void removeRow(int row) {
        this.files.removeElementAt(row);
        this.notifyObservers();
        this.notifyRowObservers(null, row, -1);
    }

    public void addFile(File file) {
        logger.info(I18N.translate("info.add_file"), (Object)file.getAbsolutePath());
        if (file.exists()) {
            if (file.isDirectory()) {
                logger.info(I18N.translate("info.skip_dir"), (Object)file.getAbsolutePath());
                return;
            }
            MyFile myFile = new MyFile(file);
            Enumeration enumeration = this.fileFilter.elements();
            while (enumeration.hasMoreElements()) {
                ExtendedFileFilter filter = (ExtendedFileFilter)enumeration.nextElement();
                if (!filter.accept(myFile)) continue;
                if (!this.files.contains(myFile)) {
                    this.files.addElement(myFile);
                    this.notifyObservers();
                    this.notifyRowObservers(myFile, this.files.size() - 1, 1);
                    continue;
                }
                logger.warn(I18N.translate("warn.file_aready_selected"), (Object)file.getAbsolutePath());
                return;
            }
            logger.info(I18N.translate("info.no_plugin_for_type"));
            return;
        }
        logger.error(I18N.translate("error.file_not_found"), new FileNotFoundException(file.getAbsolutePath()));
    }

    public Set getAdditionalFiles() {
        return this.additionalFiles;
    }

    public void addAdditionalFile(File additionalFile) {
        this.additionalFiles.add(additionalFile);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class SupportedFilesFilter
    implements FileFilter {
        private Vector suffices = new Vector();

        public boolean accept(File f) {
            MyFile file;
            return !f.isDirectory() && this.suffices.contains((file = new MyFile(f)).getSuffix());
        }

        public void addSuffix(String suffix) {
            this.suffices.add(suffix);
        }

        public void removeSuffix(String suffix) {
            this.suffices.remove(suffix);
        }
    }
}

