/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jmp3renamer.DataSet;
import net.sf.jmp3renamer.MagicCookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MagicCookieBaker {
    private static transient Logger logger = LoggerFactory.getLogger(class$net$sf$jmp3renamer$MagicCookieBaker == null ? (class$net$sf$jmp3renamer$MagicCookieBaker = MagicCookieBaker.class$("net.sf.jmp3renamer.MagicCookieBaker")) : class$net$sf$jmp3renamer$MagicCookieBaker);
    public static final String COOKIE_ARTIST = "%artist";
    public static final String COOKIE_ARTIST_FC = "%char_of_artist";
    public static final String COOKIE_TRACK = "%track";
    public static final String COOKIE_TITLE = "%title";
    public static final String COOKIE_ALBUM = "%album";
    public static final String COOKIE_YEAR = "%year";
    public static final String COOKIE_GENRE = "%genre";
    public static final String COOKIE_COMPOSER = "%composer";
    public static final String COOKIE_ORIG_ARTIST = "%orig_artist";
    public static final String COOKIE_COPYRIGHT = "%copyright";
    public static final String COOKIE_ENCODED_BY = "%encoded_by";
    public static final String COOKIE_DISC_NO = "%discno";
    public static String[] cookies = new String[]{"%album", "%artist", "%char_of_artist", "%composer", "%copyright", "%encoded_by", "%genre", "%orig_artist", "%title", "%track", "%year", "%discno"};
    private static String cookieText = "<html>%artist = Artist<br>%char_of_artist = First character of %artist<br>%track = Track<br>%title = Title<br>%album = Album<br>%year = Year<br>%genre = Genre<br>%composer = Composer<br>%orig_artist = Orig. Artist<br>%copyright = Copyright<br>%encoded_by = Encoded by<br>%discno = Disc number</html>";
    static /* synthetic */ Class class$net$sf$jmp3renamer$MagicCookieBaker;

    public static String[] getCookies() {
        return cookies;
    }

    public static String evaluateDataSet(DataSet dataset) {
        String regex = dataset.getRegex();
        regex = MagicCookieBaker.replace(regex, COOKIE_ENCODED_BY, dataset.getEncodedBy());
        regex = MagicCookieBaker.replace(regex, COOKIE_ARTIST, dataset.getArtist());
        String artist = dataset.getArtist();
        String replacement = "";
        if (artist.length() > 0) {
            replacement = Character.toString(artist.charAt(0)).toLowerCase();
        }
        regex = MagicCookieBaker.replace(regex, COOKIE_ARTIST_FC, replacement);
        regex = MagicCookieBaker.replace(regex, COOKIE_TRACK, dataset.getTrack());
        regex = MagicCookieBaker.replace(regex, COOKIE_TITLE, dataset.getTitle());
        regex = MagicCookieBaker.replace(regex, COOKIE_ALBUM, dataset.getAlbum());
        regex = MagicCookieBaker.replace(regex, COOKIE_YEAR, dataset.getYear());
        regex = MagicCookieBaker.replace(regex, COOKIE_GENRE, dataset.getGenre());
        regex = MagicCookieBaker.replace(regex, COOKIE_COMPOSER, dataset.getComposer());
        regex = MagicCookieBaker.replace(regex, COOKIE_ORIG_ARTIST, dataset.getOrigArtist());
        regex = MagicCookieBaker.replace(regex, COOKIE_COPYRIGHT, dataset.getCopyright());
        regex = MagicCookieBaker.replace(regex, COOKIE_DISC_NO, dataset.getPartOfSet());
        return regex;
    }

    public static String createPreview(String regex) {
        DataSet dataset = new DataSet();
        dataset.setTitle("Title");
        dataset.setArtist("Artist");
        dataset.setAlbum("Album");
        dataset.setComment("Comment");
        dataset.setComposer("Composer");
        dataset.setCopyright("Copyright");
        dataset.setEncodedBy("Encoder");
        dataset.setGenre("Genre");
        dataset.setOrigArtist("Orig. Artist");
        dataset.setTrack("01");
        dataset.setUrl("http://sf.net/projects/jmp3renamer");
        dataset.setYear("2004");
        dataset.setPartOfSet("1");
        dataset.setRegex(regex);
        return MagicCookieBaker.evaluateDataSet(dataset);
    }

    public static DataSet evaluateCookie(String userRegex, String oldname) {
        int i;
        if (userRegex.length() < 3) {
            return null;
        }
        String[] cookieNames = new String[]{COOKIE_ENCODED_BY, COOKIE_ARTIST, COOKIE_ARTIST_FC, COOKIE_TRACK, COOKIE_TITLE, COOKIE_ALBUM, COOKIE_YEAR, COOKIE_GENRE, COOKIE_COMPOSER, COOKIE_ORIG_ARTIST, COOKIE_COPYRIGHT, COOKIE_DISC_NO};
        String replacement = "(\\.+)";
        ArrayList<MagicCookie> cookies = new ArrayList<MagicCookie>();
        for (i = 0; i < cookieNames.length; ++i) {
            String cookie = cookieNames[i];
            int index = userRegex.indexOf(cookie);
            while (index >= 0) {
                cookies.add(new MagicCookie(cookie, index));
                ++index;
                index = userRegex.indexOf(cookie, index);
            }
        }
        Collections.sort(cookies);
        userRegex = MagicCookieBaker.escapeSpecialChars(userRegex);
        for (i = 0; i < cookieNames.length; ++i) {
            userRegex = userRegex.replaceAll(cookieNames[i], replacement);
        }
        Pattern p = Pattern.compile(userRegex);
        Matcher m = p.matcher(oldname);
        if (m.matches()) {
            for (int i2 = 1; i2 <= m.groupCount(); ++i2) {
                MagicCookie mc = (MagicCookie)cookies.get(i2 - 1);
                mc.setValue(m.group(i2));
            }
        }
        DataSet dataset = new DataSet();
        Iterator iter = cookies.iterator();
        while (iter.hasNext()) {
            MagicCookie mc = (MagicCookie)iter.next();
            if (mc.getCookie().equals(COOKIE_ARTIST)) {
                dataset.setArtist(mc.getValue());
                continue;
            }
            if (mc.getCookie().equals(COOKIE_ARTIST_FC)) {
                dataset.setArtist(mc.getValue());
                continue;
            }
            if (mc.getCookie().equals(COOKIE_TRACK)) {
                dataset.setTrack(mc.getValue());
                continue;
            }
            if (mc.getCookie().equals(COOKIE_TITLE)) {
                dataset.setTitle(mc.getValue());
                continue;
            }
            if (mc.getCookie().equals(COOKIE_ALBUM)) {
                dataset.setAlbum(mc.getValue());
                continue;
            }
            if (mc.getCookie().equals(COOKIE_GENRE)) {
                dataset.setGenre(mc.getValue());
                continue;
            }
            if (mc.getCookie().equals(COOKIE_YEAR)) {
                dataset.setYear(mc.getValue());
                continue;
            }
            if (mc.getCookie().equals(COOKIE_ORIG_ARTIST)) {
                dataset.setOrigArtist(mc.getValue());
                continue;
            }
            if (mc.getCookie().equals(COOKIE_COPYRIGHT)) {
                dataset.setCopyright(mc.getValue());
                continue;
            }
            if (mc.getCookie().equals(COOKIE_COMPOSER)) {
                dataset.setComposer(mc.getValue());
                continue;
            }
            if (mc.getCookie().equals(COOKIE_ENCODED_BY)) {
                dataset.setEncodedBy(mc.getValue());
                continue;
            }
            if (!mc.getCookie().equals(COOKIE_DISC_NO)) continue;
            dataset.setPartOfSet(mc.getValue());
        }
        return dataset;
    }

    private static String escapeSpecialChars(String value) {
        char[] toEscape = new char[]{'$', '^', '(', ')', '[', ']', '{', '}', '.'};
        StringBuffer sb = new StringBuffer(value);
        for (int j = 0; j < toEscape.length; ++j) {
            for (int i = 0; i < sb.length(); ++i) {
                if (sb.charAt(i) != toEscape[j]) continue;
                sb.insert(i, '\\');
                ++i;
            }
        }
        value = sb.toString();
        return value;
    }

    public static String evaluatePath(String path, DataSet dataset) {
        String regex = path;
        regex = MagicCookieBaker.replace(regex, COOKIE_ENCODED_BY, dataset.getEncodedBy());
        regex = MagicCookieBaker.replace(regex, COOKIE_ARTIST, dataset.getArtist());
        String artist = dataset.getArtist();
        String replacement = "";
        if (artist.length() > 0) {
            replacement = Character.toString(artist.charAt(0)).toLowerCase();
        }
        regex = MagicCookieBaker.replace(regex, COOKIE_ARTIST_FC, replacement);
        regex = MagicCookieBaker.replace(regex, COOKIE_TRACK, dataset.getTrack());
        regex = MagicCookieBaker.replace(regex, COOKIE_TITLE, dataset.getTitle());
        regex = MagicCookieBaker.replace(regex, COOKIE_ALBUM, dataset.getAlbum());
        regex = MagicCookieBaker.replace(regex, COOKIE_YEAR, dataset.getYear());
        regex = MagicCookieBaker.replace(regex, COOKIE_GENRE, dataset.getGenre());
        regex = MagicCookieBaker.replace(regex, COOKIE_COMPOSER, dataset.getComposer());
        regex = MagicCookieBaker.replace(regex, COOKIE_ORIG_ARTIST, dataset.getOrigArtist());
        regex = MagicCookieBaker.replace(regex, COOKIE_COPYRIGHT, dataset.getCopyright());
        regex = MagicCookieBaker.replace(regex, COOKIE_DISC_NO, dataset.getPartOfSet());
        return regex;
    }

    public static String replace(String string, String regex, String rep) {
        try {
            char c;
            int i;
            StringBuffer sb = new StringBuffer(regex);
            for (i = 0; i < sb.length(); ++i) {
                c = sb.charAt(i);
                if (!MagicCookieBaker.isToEscape(c)) continue;
                sb.insert(i, '\\');
                ++i;
            }
            regex = sb.toString();
            sb = new StringBuffer(rep);
            for (i = 0; i < sb.length(); ++i) {
                c = sb.charAt(i);
                if (!MagicCookieBaker.isToEscape(c)) continue;
                sb.insert(i, '\\');
                ++i;
            }
            rep = sb.toString();
            return string.replaceAll(regex, rep);
        }
        catch (Exception e) {
            logger.warn("Error while replacing " + regex + " with " + rep, e);
            return string;
        }
    }

    private static boolean isToEscape(char c) {
        char[] toEscape = new char[]{'{', '}', '[', ']', '(', ')', '\\', '*', '+', '?', '^', '$', '.', '|'};
        for (int i = 0; i < toEscape.length; ++i) {
            if (toEscape[i] != c) continue;
            return true;
        }
        return false;
    }

    public static String getCookieText() {
        return cookieText;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

