/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.gui;

import java.awt.Component;
import java.awt.Image;
import javax.swing.ImageIcon;

public class AnimatedIcon
extends ImageIcon {
    private static Animator animator = new Animator();
    private static Image[] frames;
    private static int current;
    private static int delay;
    private static Component host;
    private static Image icon;
    private static AnimatedIcon instance;
    private static boolean running;

    private AnimatedIcon(Image icon, Image[] frames, int rate, Component host) {
        super(icon);
        AnimatedIcon.icon = icon;
        AnimatedIcon.frames = frames;
        delay = 1000 / rate;
        AnimatedIcon.host = host;
    }

    public static AnimatedIcon getInstance(Image img, Image[] frames, int rate, Component host) {
        if (instance == null) {
            instance = new AnimatedIcon(img, frames, rate, host);
            animator.start();
        }
        return instance;
    }

    public static void setHost(Component host) {
        AnimatedIcon.host = host;
    }

    public static void startAnimation() {
        animator.start();
    }

    public static void stopAnimation() {
        animator.stopThread();
        current = 0;
        instance.setImage(icon);
        host.repaint();
    }

    public boolean isRunning() {
        return running;
    }

    static {
        running = false;
    }

    static class Animator
    extends Thread {
        Animator() {
        }

        public void stopThread() {
            running = false;
        }

        public void run() {
            running = true;
            while (running) {
                try {
                    Animator.sleep(delay);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                current = (current + 1) % frames.length;
                instance.setImage(frames[current]);
                host.repaint();
            }
        }
    }
}

