/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import net.sf.jmp3renamer.DataPlugin;
import net.sf.jmp3renamer.DataSet;
import net.sf.jmp3renamer.FileManager;
import net.sf.jmp3renamer.GeneralPlugin;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.ImageLoader;
import net.sf.jmp3renamer.Main;
import net.sf.jmp3renamer.gui.AboutDialog;
import net.sf.jmp3renamer.gui.DataPanel;
import net.sf.jmp3renamer.gui.DebugConsole;
import net.sf.jmp3renamer.gui.HelpDialog;
import net.sf.jmp3renamer.gui.PluginManager;
import net.sf.jmp3renamer.gui.SplitPanel;
import net.sf.jmp3renamer.gui.StatusBar;
import net.sf.jmp3renamer.gui.settings.SettingsDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainGUI
extends JFrame
implements ActionListener {
    private static transient Logger logger = LoggerFactory.getLogger(class$net$sf$jmp3renamer$gui$MainGUI == null ? (class$net$sf$jmp3renamer$gui$MainGUI = MainGUI.class$("net.sf.jmp3renamer.gui.MainGUI")) : class$net$sf$jmp3renamer$gui$MainGUI);
    private final Main main;
    private SplitPanel splitpanel;
    private DataPanel datapanel;
    private DebugConsole debugConsole = new DebugConsole();
    private JMenu pluginMenu;
    private JPanel mainPanel = new JPanel();
    private JToolBar toolbar = new JToolBar();
    private JButton rename = new JButton();
    private JButton showDataButton;
    private Hashtable generalPlugins = new Hashtable();
    private StatusBar statusBar = new StatusBar();
    static /* synthetic */ Class class$net$sf$jmp3renamer$gui$MainGUI;

    public MainGUI(Main m) {
        this.main = m;
        this.initGUI();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                MainGUI.this.main.exit();
            }
        });
    }

    private void initGUI() {
        ToolTipManager.sharedInstance().setInitialDelay(200);
        this.mainPanel.setLayout(new GridBagLayout());
        this.splitpanel = new SplitPanel(this);
        this.splitpanel.setBorder(BorderFactory.createEmptyBorder());
        this.mainPanel.add((Component)this.splitpanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.datapanel = new DataPanel(this.main);
        this.mainPanel.add((Component)this.datapanel, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 13, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.toolbar, "First");
        this.getContentPane().add((Component)this.statusBar, "Last");
        this.rename.setText(I18N.translate("rename"));
        this.rename.setActionCommand("rename");
        this.rename.addActionListener(this);
        this.rename.setIcon(ImageLoader.getInstance().loadImage("images/run.png"));
        this.rename.setVerticalTextPosition(3);
        this.rename.setHorizontalTextPosition(0);
        this.rename.setMargin(new Insets(5, 10, 5, 10));
        this.toolbar.add(this.rename);
        this.showDataButton = new JButton(I18N.translate("edit_data"));
        this.showDataButton.addActionListener(this);
        this.showDataButton.setIcon(ImageLoader.getInstance().loadImage("images/editclear.png"));
        this.showDataButton.setVerticalTextPosition(3);
        this.showDataButton.setHorizontalTextPosition(0);
        this.showDataButton.setMargin(new Insets(5, 10, 5, 10));
        this.toolbar.add(this.showDataButton);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu1 = new JMenu(I18N.translate("file"));
        JMenuItem item11 = new JMenuItem(I18N.translate("rename"));
        item11.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        JMenuItem item12 = new JMenuItem(I18N.translate("select_dir"));
        item12.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        JMenuItem item13 = new JMenuItem(I18N.translate("exit"));
        item13.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        JMenu menu2 = new JMenu(I18N.translate("options"));
        JMenuItem item21 = new JMenuItem(I18N.translate("edit"));
        item21.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        JMenuItem item22 = new JMenuItem(I18N.translate("save"));
        this.pluginMenu = new JMenu(I18N.translate("plugins"));
        JMenuItem item41 = new JMenuItem(I18N.translate("pluginmanager"));
        JMenu menu3 = new JMenu(I18N.translate("help"));
        JMenuItem item31 = new JMenuItem(I18N.translate("help"));
        item31.setAccelerator(KeyStroke.getKeyStroke("F1"));
        JMenuItem item32 = new JMenuItem(I18N.translate("about"));
        JMenuItem item33 = new JMenuItem(I18N.translate("debug"));
        item11.setActionCommand("rename");
        item11.addActionListener(this);
        item12.setActionCommand("select_dir");
        item12.addActionListener(this);
        item13.setActionCommand("exit");
        item13.addActionListener(this);
        item21.setActionCommand("editOptions");
        item21.addActionListener(this);
        item22.setActionCommand("saveOptions");
        item22.addActionListener(this);
        item31.setActionCommand("help");
        item31.addActionListener(this);
        item32.setActionCommand("about");
        item32.addActionListener(this);
        item33.setActionCommand("debug");
        item33.addActionListener(this);
        item41.setActionCommand("plugins");
        item41.addActionListener(this);
        menu1.add(item11);
        menu1.add(item12);
        menu1.add(item13);
        menu2.add(item21);
        menu2.add(item22);
        menu3.add(item31);
        menu3.add(item32);
        menu3.add(item33);
        this.pluginMenu.add(item41);
        this.pluginMenu.addSeparator();
        menuBar.add(menu1);
        menuBar.add(menu2);
        menuBar.add(this.pluginMenu);
        menuBar.add(menu3);
        this.setJMenuBar(menuBar);
        this.setTitle("JMP3Renamer 2.2.1");
        try {
            this.setSize((int)Double.parseDouble(Main.getProperty("width")), (int)Double.parseDouble(Main.getProperty("height")));
            this.setLocation((int)Double.parseDouble(Main.getProperty("x")), (int)Double.parseDouble(Main.getProperty("y")));
            this.setExtendedState((int)Double.parseDouble(Main.getProperty("extendedState")));
        }
        catch (Exception e) {
            logger.error(I18N.translate("error.set_bounds"), e);
            logger.info(I18N.translate("info.using_default_bounds"));
            this.setSize(800, 600);
            this.setLocation(0, 0);
            this.setExtendedState(0);
        }
        ArrayList images = new ArrayList();
        this.setIconImage(ImageLoader.getInstance().loadImage("images/icon/jmp3renamer128.png").getImage());
        this.setDefaultCloseOperation(3);
    }

    public void paint(Graphics g) {
        this.splitpanel.setDividerLocation(this.splitpanel.getWidth() / 2);
        super.paint(g);
    }

    protected void showDataset(DataSet dataset) {
        this.datapanel.showDataset(dataset);
    }

    public void setStatus(String status) {
        this.statusBar.setStatus(status);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("rename")) {
            FileManager.getInstance().resetStates();
            Thread thread = new Thread(FileManager.getInstance());
            thread.start();
        } else if (e.getActionCommand().equals("select_dir")) {
            FileManager.getInstance().openDir();
        } else if (e.getActionCommand().equals("editOptions")) {
            new SettingsDialog(this.main);
        } else if (e.getActionCommand().equals("saveOptions")) {
            this.main.saveConfig();
        } else if (e.getActionCommand().equals("help")) {
            new HelpDialog(this);
        } else if (e.getActionCommand().equals("about")) {
            new AboutDialog(this);
        } else if (e.getActionCommand().equals("exit")) {
            this.main.exit();
        } else if (e.getActionCommand().equals("plugins")) {
            this.setCursor(new Cursor(3));
            final PluginManager pm = new PluginManager(this);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    new Thread(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            2.access$100(this.this$1).getList();
                        }
                    }.start();
                }

                static /* synthetic */ PluginManager access$100(2 x0) {
                    return x0.pm;
                }
            });
        } else if (e.getActionCommand().equals("debug")) {
            this.debugConsole.setVisible(true);
        } else if (e.getSource() == this.showDataButton) {
            this.datapanel.showDataset(null);
        } else {
            JDialog dialog = (JDialog)this.generalPlugins.get(e.getActionCommand());
            dialog.setVisible(true);
        }
    }

    public void addPlugin(DataPlugin plugin) {
        this.datapanel.addPlugin(plugin);
        JButton button = new JButton(plugin.getName());
        button.setIcon(plugin.getIcon());
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setToolTipText(this.descriptionToTooltip(plugin.getDescription()));
        button.setMargin(new Insets(5, 10, 5, 10));
        button.setActionCommand(plugin.getName());
        button.addActionListener(this.datapanel);
        this.toolbar.add(button);
    }

    public void addPlugin(GeneralPlugin plugin) {
        JMenuItem item = new JMenuItem(plugin.getName());
        item.setActionCommand(plugin.getName());
        item.addActionListener(this);
        this.pluginMenu.add(item);
        JDialog dialog = new JDialog((Frame)this, true);
        dialog.getContentPane().add(plugin.getGUI());
        plugin.setDialog(dialog);
        dialog.setTitle(plugin.getName());
        dialog.setSize(plugin.getGUI().getSize());
        dialog.setLocation((int)((double)((this.getWidth() - dialog.getWidth()) / 2) + this.getLocation().getX()), (int)((double)((this.getHeight() - dialog.getHeight()) / 2) + this.getLocation().getY()));
        this.generalPlugins.put(plugin.getName(), dialog);
    }

    public void removePlugin(DataPlugin plugin) {
        this.datapanel.removePlugin(plugin);
        for (int i = 0; i < this.toolbar.getComponentCount(); ++i) {
            JButton button = (JButton)this.toolbar.getComponent(i);
            if (!button.getActionCommand().equals(plugin.getName())) continue;
            this.toolbar.remove(button);
            this.toolbar.revalidate();
            this.toolbar.repaint();
        }
    }

    public void removePlugin(GeneralPlugin plugin) {
        for (int i = 2; i < this.pluginMenu.getItemCount(); ++i) {
            JMenuItem item = this.pluginMenu.getItem(i);
            if (!item.getText().equals(plugin.getName())) continue;
            this.pluginMenu.remove(item);
        }
        this.generalPlugins.remove(plugin.getName());
    }

    private String descriptionToTooltip(String desc) {
        int MAXSIGNS = 40;
        String result = "<html>";
        while (desc.length() > 40) {
            int pos = 40;
            char character = desc.charAt(pos);
            while (character != ' ') {
                character = desc.charAt(--pos);
            }
            result = result + desc.substring(0, pos) + "<br>";
            desc = desc.substring(pos, desc.length());
        }
        result = result + desc + "</html>";
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

