/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.gui.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.Main;
import net.sf.jmp3renamer.util.LookAndFeelFacade;

public class LookAndFeelPanel
extends JPanel
implements ItemListener {
    private JComboBox lafCombo = new JComboBox();
    private String[] themes = new String[]{"BrownSugar", "DarkStar", "DesertBlue", "DesertBluer", "DesertGreen", "DesertRed", "DesertYellow", "ExperienceBlue", "ExperienceGreen", "InvertedColorTheme", "Silver", "SkyBlue", "SkyBluer", "SkyBluerTahoma", "SkyGreen", "SkyKrupp", "SkyPink", "SkyRed", "SkyYellow"};
    private JComboBox themeCombo = new JComboBox<String>(this.themes);
    boolean hasChanged = false;

    public LookAndFeelPanel() {
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.lafCombo, gbc);
        gbc.gridy = 1;
        this.add((Component)this.themeCombo, gbc);
        this.setBorder(BorderFactory.createTitledBorder("Look And Feel"));
        String laf = Main.getProperty("laf");
        String theme = Main.getProperty("theme");
        this.themeCombo.setSelectedItem(theme);
        this.addAvailableLAFs();
        for (int i = 0; i < this.lafCombo.getItemCount(); ++i) {
            Object item = this.lafCombo.getItemAt(i);
            LookAndFeelFacade facade = (LookAndFeelFacade)item;
            if (!facade.getClassName().equals(laf)) continue;
            this.lafCombo.setSelectedItem(item);
            if (facade.getName().startsWith("Plastic")) continue;
            this.themeCombo.setEnabled(false);
        }
        this.lafCombo.addItemListener(this);
        this.themeCombo.addItemListener(this);
    }

    private void addAvailableLAFs() {
        UIManager.LookAndFeelInfo info = new UIManager.LookAndFeelInfo("Plastic", "com.jgoodies.plaf.plastic.PlasticLookAndFeel");
        this.lafCombo.addItem(new LookAndFeelFacade(info));
        info = new UIManager.LookAndFeelInfo("Plastic 3D", "com.jgoodies.plaf.plastic.Plastic3DLookAndFeel");
        this.lafCombo.addItem(new LookAndFeelFacade(info));
        info = new UIManager.LookAndFeelInfo("Plastic XP", "com.jgoodies.plaf.plastic.PlasticXPLookAndFeel");
        this.lafCombo.addItem(new LookAndFeelFacade(info));
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lafs.length; ++i) {
            LookAndFeelFacade facade = new LookAndFeelFacade(lafs[i]);
            this.lafCombo.addItem(facade);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        String laf = this.lafCombo.getSelectedItem().toString();
        if (laf.indexOf("Plastic") != -1) {
            this.themeCombo.setEnabled(true);
        } else {
            this.themeCombo.setEnabled(false);
        }
        this.hasChanged = true;
    }

    public void applyConfig() {
        if (this.hasChanged) {
            Object item = this.lafCombo.getSelectedItem();
            if (item instanceof LookAndFeelFacade) {
                LookAndFeelFacade facade = (LookAndFeelFacade)item;
                Main.setProperty("laf", facade.getClassName());
                if (facade.getName().startsWith("Plastic")) {
                    String theme = (String)this.themeCombo.getSelectedItem();
                    Main.setProperty("theme", theme);
                }
            }
            Main.setLookAndFeel();
            SwingUtilities.updateComponentTreeUI(Main.getGUI());
            JOptionPane.showMessageDialog(null, I18N.translate("pleaseRestart"));
        }
    }
}

