/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.gui.settings;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.Main;
import net.sf.jmp3renamer.Plugin;
import net.sf.jmp3renamer.PluginLoader;
import net.sf.jmp3renamer.gui.MainGUI;
import net.sf.jmp3renamer.gui.settings.FilenamePanel;
import net.sf.jmp3renamer.gui.settings.LoggingPanel;
import net.sf.jmp3renamer.gui.settings.LookAndFeelPanel;
import net.sf.jmp3renamer.gui.settings.ProxyPanel;
import net.sf.jmp3renamer.util.MyLocale;
import net.sf.jmp3renamer.util.MyLocaleComparator;

public class SettingsDialog
extends JDialog
implements TreeSelectionListener,
ActionListener {
    private JSplitPane splitpane = new JSplitPane();
    private DefaultMutableTreeNode root = null;
    private DefaultMutableTreeNode pluginNode = null;
    private JTree naviTree;
    private JPanel mainPanel = new JPanel();
    private CardLayout cards = new CardLayout();
    private MainGUI parent;
    private Main main;
    private DefaultMutableTreeNode filenameNode = null;
    private FilenamePanel filenamePanel = new FilenamePanel();
    private JPanel pluginPanel = new JPanel();
    private JTextField tHostname = new JTextField();
    private JLabel lHostname = new JLabel();
    private DefaultMutableTreeNode languageNode = null;
    private JPanel langpanel = new JPanel();
    private JComboBox langCombo = new JComboBox();
    private JButton bOk = new JButton(I18N.translate("ok"));
    private JButton bCancel = new JButton(I18N.translate("cancel"));
    private JPanel controlPanel = new JPanel();
    private DefaultMutableTreeNode loggingNode = null;
    private LoggingPanel loggingPanel = new LoggingPanel();
    private DefaultMutableTreeNode generalNode = null;
    private JPanel generalPanel = new JPanel();
    private JCheckBox cbSaveSettings = new JCheckBox(I18N.translate("save_settings"));
    private DefaultMutableTreeNode lafNode = null;
    private LookAndFeelPanel lafPanel = new LookAndFeelPanel();
    private DefaultMutableTreeNode proxyNode = null;
    private ProxyPanel proxyPanel = new ProxyPanel();

    public SettingsDialog(Main main) {
        super((Frame)Main.getGUI(), true);
        this.main = main;
        this.parent = Main.getGUI();
        this.initGUI();
    }

    private void initGUI() {
        this.mainPanel.setLayout(this.cards);
        this.root = new DefaultMutableTreeNode(I18N.translate("options"));
        this.generalNode = new DefaultMutableTreeNode(I18N.translate("general"));
        this.root.add(this.generalNode);
        this.lafNode = new DefaultMutableTreeNode(I18N.translate("lookAndFeel"));
        this.root.add(this.lafNode);
        this.filenameNode = new DefaultMutableTreeNode(I18N.translate("filename"));
        this.root.add(this.filenameNode);
        this.languageNode = new DefaultMutableTreeNode(I18N.translate("language"));
        this.root.add(this.languageNode);
        this.pluginNode = new DefaultMutableTreeNode(I18N.translate("plugins"));
        this.root.add(this.pluginNode);
        this.loggingNode = new DefaultMutableTreeNode(I18N.translate("logging"));
        this.root.add(this.loggingNode);
        this.proxyNode = new DefaultMutableTreeNode(I18N.translate("proxy"));
        this.root.add(this.proxyNode);
        this.naviTree = new JTree(this.root);
        this.naviTree.treeDidChange();
        this.naviTree.setShowsRootHandles(true);
        this.naviTree.setRootVisible(false);
        this.naviTree.getSelectionModel().addTreeSelectionListener(this);
        this.pluginPanel.setBorder(BorderFactory.createTitledBorder(I18N.translate("plugins")));
        this.pluginPanel.setLayout(new FlowLayout(0, 5, 5));
        this.lHostname.setText(I18N.translate("pluginmanager_url"));
        this.tHostname.setText(Main.getProperty("pluginmanager.url"));
        this.pluginPanel.add(this.lHostname);
        this.pluginPanel.add(this.tHostname);
        this.mainPanel.add((Component)this.pluginPanel, "PLUGINS");
        Vector plugins = PluginLoader.getInstance().getPlugins();
        Enumeration enumeration = plugins.elements();
        while (enumeration.hasMoreElements()) {
            Plugin plugin = (Plugin)enumeration.nextElement();
            if (plugin.getConfigGUI() == null) continue;
            this.pluginNode.add(new DefaultMutableTreeNode(plugin));
            plugin.getConfigGUI().loadProperties();
            this.mainPanel.add((Component)((JComponent)((Object)plugin.getConfigGUI())), plugin.getName());
        }
        this.splitpane.setLeftComponent(new JScrollPane(this.naviTree));
        this.splitpane.setRightComponent(this.mainPanel);
        this.splitpane.setDividerSize(5);
        this.splitpane.setDividerLocation(200);
        this.generalPanel.setLayout(null);
        this.generalPanel.setBorder(BorderFactory.createTitledBorder(I18N.translate("general")));
        this.cbSaveSettings.setBounds(10, 20, 300, 25);
        this.cbSaveSettings.setSelected(new Boolean(Main.getProperty("save_on_exit")));
        this.generalPanel.add(this.cbSaveSettings);
        this.mainPanel.add((Component)this.generalPanel, "GENERAL");
        this.mainPanel.add((Component)this.lafPanel, "LAF");
        this.mainPanel.add((Component)this.proxyPanel, "PROXY");
        this.mainPanel.add((Component)this.filenamePanel, "FILENAME");
        this.langpanel.setBorder(BorderFactory.createTitledBorder(I18N.translate("language")));
        this.langpanel.setLayout(null);
        this.langpanel.add(this.langCombo);
        this.langCombo.setBounds(15, 30, 150, 25);
        this.mainPanel.add((Component)this.langpanel, "LANGUAGE");
        ArrayList supportedLanguages = Main.getSupportedLanguages();
        Iterator it = supportedLanguages.iterator();
        MyLocale selected = null;
        ArrayList<MyLocale> locales = new ArrayList<MyLocale>();
        while (it.hasNext()) {
            String loc = (String)it.next();
            MyLocale current = new MyLocale(new Locale(loc));
            if (loc.equals(Main.getProperty("lang"))) {
                selected = current;
            }
            locales.add(current);
        }
        Collections.sort(locales, new MyLocaleComparator());
        Iterator iter = locales.iterator();
        while (iter.hasNext()) {
            MyLocale element = (MyLocale)iter.next();
            this.langCombo.addItem(element);
        }
        if (selected != null) {
            this.langCombo.setSelectedItem(selected);
        }
        this.mainPanel.add((Component)this.loggingPanel, "LOGGING");
        this.bOk.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.controlPanel.add(this.bOk);
        this.controlPanel.add(this.bCancel);
        this.cards.show(this.mainPanel, "GENERAL");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.splitpane, "Center");
        this.getContentPane().add((Component)this.controlPanel, "South");
        this.setSize(800, 600);
        int par_x = (int)this.parent.getLocation().getX();
        int par_y = (int)this.parent.getLocation().getY();
        int par_width = this.parent.getWidth();
        int par_height = this.parent.getHeight();
        int width = this.getWidth();
        int height = this.getHeight();
        int x = (par_width - width) / 2 + par_x;
        int y = (par_height - height) / 2 + par_y;
        this.setLocation(new Point(x, y));
        this.setTitle("JMP3Renamer " + I18N.translate("options"));
        this.setVisible(true);
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode source = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)source.getParent();
        if (parent == this.pluginNode) {
            this.cards.show(this.mainPanel, source.getUserObject().toString());
        } else if (source == this.languageNode) {
            this.cards.show(this.mainPanel, "LANGUAGE");
        } else if (source == this.filenameNode) {
            this.cards.show(this.mainPanel, "FILENAME");
        } else if (source == this.loggingNode) {
            this.cards.show(this.mainPanel, "LOGGING");
        } else if (source == this.generalNode) {
            this.cards.show(this.mainPanel, "GENERAL");
        } else if (source == this.pluginNode) {
            this.cards.show(this.mainPanel, "PLUGINS");
        } else if (source == this.proxyNode) {
            this.cards.show(this.mainPanel, "PROXY");
        } else if (source == this.lafNode) {
            this.cards.show(this.mainPanel, "LAF");
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bOk) {
            this.applyConfig();
            this.dispose();
        } else if (e.getSource() == this.bCancel) {
            this.dispose();
        }
    }

    private void applyConfig() {
        Main.setProperty("save_on_exit", Boolean.toString(this.cbSaveSettings.isSelected()));
        Main.setProperty("pluginmanager.url", this.tHostname.getText());
        this.filenamePanel.applyConfig();
        this.loggingPanel.applyConfig();
        this.main.initLogger();
        String loc = ((MyLocale)this.langCombo.getSelectedItem()).getLocale().toString();
        if (!loc.equals(Main.getProperty("lang"))) {
            JOptionPane.showMessageDialog(this, I18N.translate("restart"), I18N.translate("info"), 1);
        }
        Main.setProperty("lang", loc);
        Vector plugins = PluginLoader.getInstance().getPlugins();
        Enumeration enumeration = plugins.elements();
        while (enumeration.hasMoreElements()) {
            Plugin plugin = (Plugin)enumeration.nextElement();
            if (plugin.getConfigGUI() == null) continue;
            plugin.getConfigGUI().applyProperties();
        }
        this.proxyPanel.applyConfig();
        this.lafPanel.applyConfig();
    }
}

