/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.plugins.FileTag.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.sf.jmp3renamer.DataManager;
import net.sf.jmp3renamer.DataSet;
import net.sf.jmp3renamer.FileManager;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.Main;
import net.sf.jmp3renamer.RowObserver;
import net.sf.jmp3renamer.plugins.FileTag.FileTag;
import net.sf.jmp3renamer.util.MyFile;

public class FileTagPanel
extends JPanel
implements ActionListener,
Runnable,
RowObserver {
    private JButton extractDataButton;
    private JProgressBar progress = new JProgressBar(0, 100);

    public FileTagPanel() {
        this.initGUI();
        FileManager.getInstance().addRowObserver((RowObserver)this);
    }

    private void initGUI() {
        this.extractDataButton = new JButton(I18N.translate((String)"extract_tags"));
        this.extractDataButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.progress, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.extractDataButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.progress.setVisible(false);
        this.progress.setStringPainted(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.extractDataButton) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void run() {
        this.progress.setValue(0);
        this.extractDataButton.setVisible(false);
        this.progress.setVisible(true);
        Main.getGUI().setCursor(new Cursor(3));
        Vector<DataSet> vector = new Vector<DataSet>();
        Vector vector2 = FileManager.getInstance().getFiles();
        int n = vector2.size();
        for (int i = 0; i < vector2.size(); ++i) {
            MyFile myFile = (MyFile)vector2.elementAt(i);
            DataSet dataSet = FileManager.getInstance().getMetaData(myFile);
            if (dataSet != null) {
                dataSet.setRegex(Main.getProperty((String)"filename"));
                vector.add(dataSet);
            }
            int n2 = (int)((float)(i + 1) / (float)n * 100.0f);
            this.progress.setValue(n2);
        }
        DataManager.getInstance().setDatasets(vector);
        Main.getGUI().setCursor(new Cursor(0));
        this.extractDataButton.setVisible(true);
        this.progress.setVisible(false);
    }

    public void update(Object object, int n, int n2) {
        if (FileTag.getProperty("analyzeNewFiles").equals("true")) {
            if (n2 == -10) {
                DataManager.getInstance().setDatasets(new Vector());
            } else if (n2 == 1) {
                Main.getGUI().setCursor(new Cursor(3));
                MyFile myFile = (MyFile)object;
                DataSet dataSet = FileManager.getInstance().getMetaData(myFile);
                if (dataSet != null) {
                    dataSet.setRegex(Main.getProperty((String)"filename"));
                    DataManager.getInstance().addRow(dataSet);
                }
                Main.getGUI().setCursor(new Cursor(0));
            }
        }
    }
}

