/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.plugins.Mp3.gui;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.gui.PluginConfigGUI;
import net.sf.jmp3renamer.plugins.Mp3.Mp3;

public class Mp3ConfigGui
extends JPanel
implements PluginConfigGUI,
ActionListener {
    private JCheckBox cbRename = new JCheckBox();
    private JCheckBox readV1 = new JCheckBox();
    private JCheckBox readV2 = new JCheckBox();
    private JRadioButton rbVersion1 = new JRadioButton();
    private JRadioButton rbVersion2 = new JRadioButton();
    private JRadioButton rbBoth = new JRadioButton();
    private ButtonGroup buttonGroup1 = new ButtonGroup();

    public Mp3ConfigGui(Mp3 mp3) {
        this.initGUI();
    }

    private void initGUI() {
        this.cbRename.setText(I18N.translate((String)"rename_tags"));
        this.cbRename.setBounds(new Rectangle(15, 25, 275, 25));
        this.cbRename.addActionListener(this);
        this.rbVersion1.setEnabled(false);
        this.rbVersion1.setText(I18N.translate((String)"only_v1"));
        this.rbVersion1.setSelected(true);
        this.rbVersion1.setBounds(new Rectangle(35, 50, 210, 25));
        this.rbVersion2.setEnabled(false);
        this.rbVersion2.setText(I18N.translate((String)"only_v2"));
        this.rbVersion2.setBounds(new Rectangle(35, 75, 230, 25));
        this.rbBoth.setEnabled(false);
        this.rbBoth.setText(I18N.translate((String)"both"));
        this.rbBoth.setBounds(new Rectangle(35, 100, 130, 25));
        this.buttonGroup1.add(this.rbVersion1);
        this.buttonGroup1.add(this.rbVersion2);
        this.buttonGroup1.add(this.rbBoth);
        this.readV1.setText(I18N.translate((String)"readv1"));
        this.readV1.setBounds(new Rectangle(15, 150, 275, 25));
        this.readV1.addActionListener(this);
        this.readV2.setText(I18N.translate((String)"readv2"));
        this.readV2.setBounds(new Rectangle(15, 175, 275, 25));
        this.readV2.addActionListener(this);
        this.setBorder(BorderFactory.createTitledBorder(I18N.translate((String)"id3tags")));
        this.setLayout(null);
        this.add(this.cbRename);
        this.add(this.rbVersion1);
        this.add(this.rbVersion2);
        this.add(this.rbBoth);
        this.add(this.readV1);
        this.add(this.readV2);
    }

    public void loadProperties() {
        int i = Integer.parseInt(Mp3.getProperty("tagtype"));
        if (i > 0) {
            this.cbRename.setSelected(true);
            this.rbVersion1.setEnabled(true);
            this.rbVersion2.setEnabled(true);
            this.rbBoth.setEnabled(true);
            if (i == 1) {
                this.rbVersion1.setSelected(true);
            }
            if (i == 2) {
                this.rbVersion2.setSelected(true);
            }
            if (i == 3) {
                this.rbBoth.setSelected(true);
            }
        }
        this.readV1.setSelected(new Boolean(Mp3.getProperty("readV1")));
        this.readV2.setSelected(new Boolean(Mp3.getProperty("readV2")));
    }

    public void applyProperties() {
        if (this.cbRename.isSelected()) {
            if (this.rbVersion1.isSelected()) {
                Mp3.setProperty("tagtype", "1");
            }
            if (this.rbVersion2.isSelected()) {
                Mp3.setProperty("tagtype", "2");
            }
            if (this.rbBoth.isSelected()) {
                Mp3.setProperty("tagtype", "3");
            }
        } else {
            Mp3.setProperty("tagtype", "0");
        }
        Mp3.setProperty("readV1", Boolean.toString(this.readV1.isSelected()));
        Mp3.setProperty("readV2", Boolean.toString(this.readV2.isSelected()));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cbRename) {
            if (this.cbRename.isSelected()) {
                this.rbVersion1.setEnabled(true);
                this.rbVersion2.setEnabled(true);
                this.rbBoth.setEnabled(true);
            } else {
                this.rbVersion1.setEnabled(false);
                this.rbVersion2.setEnabled(false);
                this.rbBoth.setEnabled(false);
            }
        }
    }
}

