/*
 * Decompiled with CFR 0.152.
 */
package com.wet.wired.jsr.recorder;

import com.wet.wired.jsr.recorder.FrameCompressor;
import com.wet.wired.jsr.recorder.ScreenRecorderListener;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Queue;

public abstract class ScreenRecorder
implements Runnable {
    private Rectangle recordArea;
    private int frameSize;
    private int[] rawData;
    private OutputStream oStream;
    private boolean recording = false;
    private boolean running = false;
    private long startTime;
    private long frameTime;
    private boolean reset;
    private ScreenRecorderListener listener;
    private StreamPacker streamPacker;

    public ScreenRecorder(OutputStream oStream, ScreenRecorderListener listener) {
        this.listener = listener;
        this.oStream = oStream;
    }

    public void triggerRecordingStop() {
        this.recording = false;
    }

    @Override
    public synchronized void run() {
        this.startTime = System.currentTimeMillis();
        this.recording = true;
        this.running = true;
        long lastFrameTime = 0L;
        long time = 0L;
        this.frameSize = this.recordArea.width * this.recordArea.height;
        this.streamPacker = new StreamPacker(this.oStream, this.frameSize);
        while (this.recording) {
            time = System.currentTimeMillis();
            while (time - lastFrameTime < 190L) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                time = System.currentTimeMillis();
            }
            lastFrameTime = time;
            try {
                this.recordFrame();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    this.oStream.close();
                    break;
                }
                catch (Exception e2) {
                    // empty catch block
                    break;
                }
            }
        }
        this.running = false;
        this.recording = false;
        this.listener.recordingStopped();
    }

    public abstract Rectangle initialiseScreenCapture();

    public abstract BufferedImage captureScreen(Rectangle var1);

    public void recordFrame() throws IOException {
        BufferedImage bImage = this.captureScreen(this.recordArea);
        this.frameTime = System.currentTimeMillis() - this.startTime;
        this.rawData = new int[this.frameSize];
        bImage.getRGB(0, 0, this.recordArea.width, this.recordArea.height, this.rawData, 0, this.recordArea.width);
        this.streamPacker.packToStream(new DataPack(this.rawData, this.frameTime));
        this.listener.frameRecorded(false);
    }

    public void startRecording() {
        this.recordArea = this.initialiseScreenCapture();
        if (this.recordArea == null) {
            return;
        }
        try {
            this.oStream.write((this.recordArea.width & 0xFF00) >>> 8);
            this.oStream.write(this.recordArea.width & 0xFF);
            this.oStream.write((this.recordArea.height & 0xFF00) >>> 8);
            this.oStream.write(this.recordArea.height & 0xFF);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new Thread((Runnable)this, "Screen Recorder").start();
    }

    public void stopRecording() {
        this.triggerRecordingStop();
        for (int count = 0; this.running && count < 10; ++count) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            this.oStream.flush();
            this.oStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isRecording() {
        return this.recording;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    private class StreamPacker
    implements Runnable {
        Queue<DataPack> queue = new LinkedList<DataPack>();
        private FrameCompressor compressor;

        public StreamPacker(OutputStream oStream, int frameSize) {
            this.compressor = new FrameCompressor(oStream, frameSize);
            new Thread((Runnable)this, "Stream Packer").start();
        }

        public void packToStream(DataPack pack) {
            while (this.queue.size() > 2) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            this.queue.add(pack);
        }

        @Override
        public void run() {
            while (ScreenRecorder.this.recording) {
                while (!this.queue.isEmpty()) {
                    DataPack pack = this.queue.poll();
                    try {
                        this.compressor.pack(pack.newData, pack.frameTime, ScreenRecorder.this.reset);
                        if (!ScreenRecorder.this.reset) continue;
                        ScreenRecorder.this.reset = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            ScreenRecorder.this.oStream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                }
                while (this.queue.isEmpty()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private class DataPack {
        public long frameTime;
        public int[] newData;

        public DataPack(int[] newData, long frameTime) {
            this.newData = newData;
            this.frameTime = frameTime;
        }
    }
}

