/*
 * Decompiled with CFR 0.152.
 */
package com.wet.wired.jsr.player;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class FrameDecompressor {
    private static final int ALPHA = -16777216;
    public FramePacket frame;

    public FrameDecompressor(InputStream iStream, int frameSize) {
        this.frame = new FramePacket(iStream, frameSize);
    }

    public FramePacket unpack() throws IOException {
        int i;
        this.frame.nextFrame();
        int time = i = this.frame.iStream.read();
        time <<= 8;
        i = this.frame.iStream.read();
        time += i;
        time <<= 8;
        i = this.frame.iStream.read();
        time += i;
        time <<= 8;
        i = this.frame.iStream.read();
        this.frame.frameTimeStamp = (time += i);
        byte type = (byte)this.frame.iStream.read();
        if (type <= 0) {
            this.frame.result = type;
            return this.frame;
        }
        ByteArrayOutputStream bO = new ByteArrayOutputStream();
        try {
            int zSize = i = this.frame.iStream.read();
            zSize <<= 8;
            i = this.frame.iStream.read();
            zSize += i;
            zSize <<= 8;
            i = this.frame.iStream.read();
            zSize += i;
            zSize <<= 8;
            i = this.frame.iStream.read();
            byte[] zData = new byte[zSize += i];
            int readCursor = 0;
            int sizeRead = 0;
            while (sizeRead > -1 && (readCursor += sizeRead) < zSize) {
                sizeRead = this.frame.iStream.read(zData, readCursor, zSize - readCursor);
            }
            ByteArrayInputStream bI = new ByteArrayInputStream(zData);
            GZIPInputStream zI = new GZIPInputStream(bI);
            byte[] buffer = new byte[1000];
            sizeRead = zI.read(buffer);
            while (sizeRead > -1) {
                bO.write(buffer, 0, sizeRead);
                bO.flush();
                sizeRead = zI.read(buffer);
            }
            bO.flush();
            bO.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.frame.result = 0;
            return this.frame;
        }
        FramePacket.access$502(this.frame, bO.toByteArray());
        this.runLengthDecode();
        return this.frame;
    }

    private void runLengthDecode() {
        FramePacket.access$602(this.frame, new int[this.frame.frameSize]);
        int inCursor = 0;
        int outCursor = 0;
        int blockSize = 0;
        int rgb = -16777216;
        block0: while (inCursor < this.frame.packed.length && outCursor < this.frame.frameSize) {
            if (this.frame.packed[inCursor] == -1) {
                int count = this.frame.packed[++inCursor] & 0xFF;
                ++inCursor;
                int size = count * 126;
                if (size > this.frame.newData.length) {
                    size = this.frame.newData.length;
                }
                for (int loop = 0; loop < 126 * count; ++loop) {
                    ((FramePacket)this.frame).newData[outCursor] = this.frame.previousData[outCursor];
                    if (++outCursor == this.frame.newData.length) continue block0;
                }
                continue;
            }
            if (this.frame.packed[inCursor] < 0) {
                blockSize = this.frame.packed[inCursor] & 0x7F;
                ++inCursor;
                for (int loop = 0; loop < blockSize; ++loop) {
                    rgb = (this.frame.packed[inCursor] & 0xFF) << 16 | (this.frame.packed[inCursor + 1] & 0xFF) << 8 | this.frame.packed[inCursor + 2] & 0xFF | 0xFF000000;
                    if (rgb == -16777216) {
                        rgb = this.frame.previousData[outCursor];
                    }
                    inCursor += 3;
                    ((FramePacket)this.frame).newData[outCursor] = rgb;
                    if (++outCursor == this.frame.newData.length) continue block0;
                }
                continue;
            }
            blockSize = this.frame.packed[inCursor];
            rgb = (this.frame.packed[++inCursor] & 0xFF) << 16 | (this.frame.packed[inCursor + 1] & 0xFF) << 8 | this.frame.packed[inCursor + 2] & 0xFF | 0xFF000000;
            boolean transparent = false;
            if (rgb == -16777216) {
                transparent = true;
            }
            inCursor += 3;
            for (int loop = 0; loop < blockSize; ++loop) {
                ((FramePacket)this.frame).newData[outCursor] = transparent ? this.frame.previousData[outCursor] : rgb;
                if (++outCursor == this.frame.newData.length) continue block0;
            }
        }
        this.frame.result = outCursor;
    }

    public class FramePacket {
        private InputStream iStream;
        private int[] previousData;
        private int result;
        private long frameTimeStamp;
        private byte[] packed;
        private int frameSize;
        private int[] newData;

        private FramePacket(InputStream iStream, int expectedSize) {
            this.frameSize = expectedSize;
            this.iStream = iStream;
            this.previousData = new int[this.frameSize];
        }

        private void nextFrame() {
            if (this.newData != null) {
                this.previousData = this.newData;
            }
        }

        public int[] getData() {
            return this.newData;
        }

        public int getResult() {
            return this.result;
        }

        public long getTimeStamp() {
            return this.frameTimeStamp;
        }

        static /* synthetic */ byte[] access$502(FramePacket x0, byte[] x1) {
            x0.packed = x1;
            return x1;
        }

        static /* synthetic */ int[] access$602(FramePacket x0, int[] x1) {
            x0.newData = x1;
            return x1;
        }
    }
}

