/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class BandSplitDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_QUALITY = 3;
    private static final int PR_NUMBANDS = 4;
    private static final int PR_GAIN = 0;
    private static final int PR_FREQ1 = 1;
    private static final int PR_FREQ2 = 2;
    private static final int PR_FREQ3 = 3;
    private static final int PR_FREQ4 = 4;
    private static final int PR_FREQ5 = 5;
    private static final int PR_FREQ6 = 6;
    private static final int PR_FREQ7 = 7;
    private static final int PR_FREQ8 = 8;
    private static final int PR_ROLLOFF = 9;
    private static final int PR_NORMEACH = 0;
    private static final int QUAL_GOOD = 2;
    private static final String[] QUAL_NAMES = new String[]{"Low", "Medium", "Good", "Very good"};
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_QUALITY = "Quality";
    private static final String PRN_NUMBANDS = "NumBands";
    private static final String PRN_FREQ1 = "Freq1";
    private static final String PRN_FREQ2 = "Freq2";
    private static final String PRN_FREQ3 = "Freq3";
    private static final String PRN_FREQ4 = "Freq4";
    private static final String PRN_FREQ5 = "Freq5";
    private static final String PRN_FREQ6 = "Freq6";
    private static final String PRN_FREQ7 = "Freq7";
    private static final String PRN_FREQ8 = "Freq8";
    private static final String PRN_ROLLOFF = "RollOff";
    private static final String PRN_NORMEACH = "NormEach";
    private static final String[] prText = new String[]{"", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 2, 2};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "Quality", "NumBands"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null, null, null, null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "Freq1", "Freq2", "Freq3", "Freq4", "Freq5", "Freq6", "Freq7", "Freq8", "RollOff"};
    private static final boolean[] prBool = new boolean[]{false};
    private static final String[] prBoolName = new String[]{"NormEach"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_QUALITY = 259;
    private static final int GG_NUMBANDS = 260;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_GAIN = 512;
    private static final int GG_FREQ1 = 513;
    private static final int GG_ROLLOFF = 521;
    private static final int GG_NORMEACH = 0;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;

    public BandSplitDlg() {
        super("Band Splitting");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        int n;
        if (static_pr == null) {
            static_pr = new PropertyArray();
            BandSplitDlg.static_pr.text = prText;
            BandSplitDlg.static_pr.textName = prTextName;
            BandSplitDlg.static_pr.intg = prIntg;
            BandSplitDlg.static_pr.intgName = prIntgName;
            BandSplitDlg.static_pr.para = prPara;
            BandSplitDlg.static_pr.para[1] = new Param(200.0, 3);
            BandSplitDlg.static_pr.para[2] = new Param(800.0, 3);
            BandSplitDlg.static_pr.para[3] = new Param(1600.0, 3);
            BandSplitDlg.static_pr.para[4] = new Param(3200.0, 3);
            BandSplitDlg.static_pr.para[5] = new Param(4800.0, 3);
            BandSplitDlg.static_pr.para[6] = new Param(6400.0, 3);
            BandSplitDlg.static_pr.para[7] = new Param(8000.0, 3);
            BandSplitDlg.static_pr.para[8] = new Param(9600.0, 3);
            BandSplitDlg.static_pr.para[9] = new Param(100.0, 19);
            BandSplitDlg.static_pr.paraName = prParaName;
            BandSplitDlg.static_pr.bool = prBool;
            BandSplitDlg.static_pr.boolName = prBoolName;
            this.fillDefaultAudioDescr(BandSplitDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(BandSplitDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = BandSplitDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case 260: {
                        ((BandSplitDlg)BandSplitDlg.this).pr.intg[n - 256] = ((JComboBox)itemEvent.getSource()).getSelectedIndex();
                        BandSplitDlg.this.reflectPropertyChanges();
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(49, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0Splt$E");
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.3;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        this.gui.addChoice((JComboBox)componentArray[1], 258, itemListener);
        JCheckBox jCheckBox = new JCheckBox("Norm. each file");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridwidth = 0;
        this.gui.addCheckbox(jCheckBox, 0, itemListener);
        this.gui.addLabel(new GroupLabel("Band Adjust", 1, 0));
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (n = 2; n <= 9; ++n) {
            jComboBox.addItem(String.valueOf(n));
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("# of Bands", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox, 260, itemListener);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        for (n = 0; n < QUAL_NAMES.length; ++n) {
            jComboBox2.addItem(QUAL_NAMES[n]);
        }
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel(PRN_QUALITY, 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox2, 259, itemListener);
        for (n = 0; n < 8; ++n) {
            ParamField paramField = new ParamField(Constants.spaces[15]);
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.gridwidth = 1;
            this.gui.addLabel(new JLabel("CrossOver " + (n + 1), 4));
            gridBagConstraints.weightx = 0.4;
            gridBagConstraints.gridwidth = (n & 1) == 0 ? 1 : 0;
            this.gui.addParamField(paramField, 513 + n, null);
        }
        ParamField paramField = new ParamField(Constants.spaces[17]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel(PRN_ROLLOFF, 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 521, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        int n;
        int n2;
        AudioFile[] audioFileArray;
        int n3;
        File[][] fileArray;
        FloatFile[][] floatFileArray;
        AudioFile audioFile;
        block44: {
            float[] fArray;
            float[][][] fArray2;
            float[] fArray3;
            float[] fArray4;
            float[][] fArray5;
            AudioFileDescr audioFileDescr;
            audioFile = null;
            floatFileArray = null;
            fileArray = null;
            Param param = new Param(1.0, 1);
            float f = 1.0f;
            n3 = this.pr.intg[4] + 2;
            audioFileArray = new AudioFile[n3];
            AudioFileDescr[] audioFileDescrArray = new AudioFileDescr[n3];
            float[] fArray6 = new float[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                audioFileArray[n2] = null;
                audioFileDescrArray[n2] = null;
                fArray6[n2] = 0.0f;
            }
            try {
                float f2;
                int n4;
                int n5;
                int n6;
                double d;
                double d2;
                audioFile = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr = audioFile.getDescr();
                int n7 = audioFileDescr.channels;
                int n8 = (int)audioFileDescr.length;
                if (n8 * n7 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block44;
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                int n9 = this.pr.text[1].lastIndexOf(46);
                if (n9 < 0) {
                    n9 = this.pr.text[1].length();
                }
                for (n2 = 0; this.threadRunning && n2 < n3; ++n2) {
                    audioFileDescrArray[n2] = new AudioFileDescr(audioFileDescr);
                    pathField.fillStream(audioFileDescrArray[n2]);
                    audioFileDescrArray[n2].file = new File(this.pr.text[1].substring(0, n9) + (n2 + 1) + this.pr.text[1].substring(n9));
                    audioFileArray[n2] = AudioFile.openAsWrite((AudioFileDescr)audioFileDescrArray[n2]);
                }
                if (!this.threadRunning) break block44;
                float[] fArray7 = new float[n3 + 1];
                fArray7[0] = 0.0f;
                fArray7[n3] = (float)(audioFileDescr.rate / 2.0);
                for (n2 = 1; n2 < n3; ++n2) {
                    fArray7[n2] = (float)this.pr.para[1 + (n2 - 1)].value;
                }
                float[] fArray8 = new float[n3 + 1];
                fArray8[0] = 0.0f;
                double d3 = this.pr.para[9].value / 100.0;
                for (n2 = 1; n2 < n3; ++n2) {
                    d2 = Math.sqrt(fArray7[n2 - 1] * fArray7[n2]) - (double)fArray7[n2 - 1];
                    d = Math.sqrt(fArray7[n2] * fArray7[n2 + 1]) - (double)fArray7[n2];
                    fArray8[n2] = Math.max(0.0f, (float)(Math.min(d2, d) * d3));
                }
                fArray8[n3] = 0.0f;
                int n10 = 3 * (1 << this.pr.intg[3]);
                int n11 = Math.max(1, (int)((double)n10 * audioFileDescr.rate / (double)fArray7[1] + 0.5));
                double d4 = Math.PI * 2 / audioFileDescr.rate;
                double d5 = 0.4052847345693511;
                int n12 = n11 + n11;
                float[] fArray9 = Filter.createFullWindow(n12, 1);
                n9 = n12 + n12 - 1;
                for (n6 = 2; n6 < n9; n6 <<= 1) {
                }
                int n13 = n6 - n12 + 1;
                int n14 = n6 - n13;
                fArray5 = new float[n3][n6 + 2];
                fArray4 = new float[n6 + 2];
                fArray3 = new float[n6 + 2];
                float[][] fArray10 = new float[n7][n13];
                fArray2 = new float[n7][n3][n14];
                for (n2 = 0; n2 < n3; ++n2) {
                    fArray = fArray5[n2];
                    double d6 = d4 * (double)fArray7[n2 + 1];
                    double d7 = d4 * (double)fArray8[n2 + 1];
                    for (n9 = 1; n9 < n11; ++n9) {
                        d2 = Math.sin(d6 * (double)n9) / (double)n9;
                        d = d5 * d7 * (double)n9 * d7 * (double)n9;
                        fArray[n11 + n9] = (float)(d2 *= Math.cos(d7 * (double)n9) / (1.0 - d));
                        fArray[n11 - n9] = (float)d2;
                    }
                    fArray[n11] = (float)d6;
                    d6 = d4 * (double)fArray7[n2];
                    d7 = d4 * (double)fArray8[n2];
                    for (n9 = 1; n9 < n11; ++n9) {
                        d2 = Math.sin(d6 * (double)n9) / (double)n9;
                        d = d5 * d7 * (double)n9 * d7 * (double)n9;
                        int n15 = n11 + n9;
                        fArray[n15] = fArray[n15] - (float)(d2 *= Math.cos(d7 * (double)n9) / (1.0 - d));
                        int n16 = n11 - n9;
                        fArray[n16] = fArray[n16] - (float)d2;
                    }
                    int n17 = n11;
                    fArray[n17] = fArray[n17] - (float)d6;
                    for (n9 = n12; n9 < n6; ++n9) {
                        fArray[n9] = 0.0f;
                    }
                    Util.mult(fArray9, 0, fArray, 0, n12);
                    Fourier.realTransform(fArray, n6, 1);
                }
                long l = 0L;
                long l2 = (long)n8 * (long)(1 + n3 * n7);
                fileArray = new File[n3][n7];
                floatFileArray = new FloatFile[n3][n7];
                for (n2 = 0; n2 < n3; ++n2) {
                    for (n = 0; n < n7; ++n) {
                        fileArray[n2][n] = null;
                        floatFileArray[n2][n] = null;
                    }
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    for (n = 0; n < n7; ++n) {
                        fileArray[n2][n] = IOUtil.createTempFile();
                        floatFileArray[n2][n] = new FloatFile(fileArray[n2][n], 1);
                    }
                }
                l2 += (long)n8 * (long)n3;
                if (!this.threadRunning) break block44;
                if (this.pr.intg[2] == 1) {
                    f = (float)(Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value / Math.PI);
                }
                int n18 = 0;
                int n19 = n11;
                for (int i = 0; this.threadRunning && i < n8; i += Math.max(0, n5 - n19)) {
                    int n20;
                    int n21;
                    int n22 = Math.min(n13, n8 - n18);
                    for (n20 = 0; this.threadRunning && n20 < n22; n20 += n21) {
                        n21 = Math.min(8192, n22 - n20);
                        audioFile.readFrames(fArray10, n20, n21);
                        n18 += n21;
                        this.setProgression((float)(l += (long)n21) / (float)l2);
                    }
                    if (this.threadRunning) {
                        n5 = Math.min(n13, n8 - i);
                        for (n = 0; this.threadRunning && n < n7; ++n) {
                            System.arraycopy(fArray10[n], 0, fArray4, 0, n22);
                            for (n2 = n22; n2 < n6; ++n2) {
                                fArray4[n2] = 0.0f;
                            }
                            Fourier.realTransform(fArray4, n6, 1);
                            for (n4 = 0; this.threadRunning && n4 < n3; ++n4) {
                                Fourier.complexMult(fArray4, 0, fArray5[n4], 0, fArray3, 0, fArray4.length);
                                Fourier.realTransform(fArray3, n6, -1);
                                Util.add(fArray2[n][n4], 0, fArray3, 0, n14);
                                System.arraycopy(fArray3, n22, fArray2[n][n4], 0, n14);
                                for (n20 = n19; this.threadRunning && n20 < n5; n20 += n21) {
                                    n21 = Math.min(8192, n5 - n20);
                                    floatFileArray[n4][n].writeFloats(fArray3, n20, n21);
                                    n9 = n20 + n21;
                                    for (n2 = n20; n2 < n9; ++n2) {
                                        f2 = Math.abs(fArray3[n2]);
                                        if (!(f2 > fArray6[n4])) continue;
                                        fArray6[n4] = f2;
                                    }
                                    this.setProgression((float)(l += (long)n21) / (float)l2);
                                }
                            }
                        }
                        if (n19 <= 0) continue;
                        n19 = Math.max(0, n19 - n5);
                        continue;
                    }
                    break block44;
                }
                if (this.threadRunning) {
                    if (this.pr.intg[2] == 0 && !this.pr.bool[0]) {
                        f2 = 0.0f;
                        for (n2 = 0; n2 < n3; ++n2) {
                            f2 = Math.max(f2, fArray6[n2]);
                        }
                        f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value;
                    }
                    for (n4 = 0; this.threadRunning && n4 < n3; ++n4) {
                        if (this.pr.intg[2] == 0 && this.pr.bool[0]) {
                            f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)fArray6[n4]), (int)1), null).value;
                        }
                        int n23 = n4;
                        fArray6[n23] = fArray6[n23] * f;
                        f2 = this.getProgression() + (1.0f - this.getProgression()) / (float)(n3 - n4);
                        this.normalizeAudioFile(floatFileArray[n4], audioFileArray[n4], fArray10, f, f2);
                        for (n = 0; n < n7; ++n) {
                            floatFileArray[n4][n].cleanUp();
                            floatFileArray[n4][n] = null;
                            fileArray[n4][n].delete();
                            fileArray[n4][n] = null;
                        }
                    }
                    if (this.threadRunning) {
                        for (n2 = 0; n2 < n3; ++n2) {
                            audioFileArray[n2].close();
                            audioFileArray[n2] = null;
                            audioFileDescrArray[n2] = null;
                        }
                        audioFile.close();
                        audioFile = null;
                        audioFileDescr = null;
                        fArray4 = null;
                        fArray3 = null;
                        fArray5 = null;
                        fArray2 = null;
                        f2 = 0.0f;
                        for (n2 = 0; n2 < n3; ++n2) {
                            f2 = Math.max(f2, fArray6[n2]);
                        }
                        this.handleClipping(f2);
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr = null;
                audioFileDescrArray = null;
                fArray4 = null;
                fArray3 = null;
                fArray2 = null;
                fArray5 = null;
                fArray = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile != null) {
            audioFile.cleanUp();
            audioFile = null;
        }
        if (audioFileArray != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (audioFileArray[n2] == null) continue;
                audioFileArray[n2].cleanUp();
                audioFileArray[n2] = null;
            }
        }
        if (floatFileArray != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < floatFileArray[n2].length; ++n) {
                    if (floatFileArray[n2][n] != null) {
                        floatFileArray[n2][n].cleanUp();
                        floatFileArray[n2][n] = null;
                    }
                    if (fileArray[n2][n] == null) continue;
                    fileArray[n2][n].delete();
                    fileArray[n2][n] = null;
                }
            }
        }
    }

    @Override
    protected void reflectPropertyChanges() {
        super.reflectPropertyChanges();
        int n = this.pr.intg[4];
        for (int i = 0; i < 8; ++i) {
            Component component = this.gui.getItemObj(513 + i);
            if (component == null) continue;
            component.setEnabled(i <= n);
        }
    }
}

