/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.Application;
import de.sciss.fscape.util.PrefsUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public abstract class BasicDialog
extends JDialog {
    protected final Preferences classPrefs;

    protected BasicDialog(Component component, String string, boolean bl) {
        this(component, string, bl, "");
    }

    protected BasicDialog(Component component, String string, boolean bl, String string2) {
        super(BasicDialog.determineFrame(component), string, bl);
        String string3 = this.getClass().getName();
        this.classPrefs = Application.userPrefs.node(string3.substring(string3.lastIndexOf(46) + 1) + string2);
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                BasicDialog.this.classPrefs.put("size", PrefsUtil.dimensionToString(BasicDialog.this.getSize()));
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                BasicDialog.this.classPrefs.put("location", PrefsUtil.pointToString(BasicDialog.this.getLocation()));
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                BasicDialog.this.classPrefs.putBoolean("visible", true);
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                BasicDialog.this.classPrefs.putBoolean("visible", false);
            }
        };
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                BasicDialog.this.classPrefs.putBoolean("visible", true);
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BasicDialog.this.classPrefs.putBoolean("visible", false);
            }
        };
        this.addComponentListener(componentAdapter);
        this.addWindowListener(windowAdapter);
    }

    private static Frame determineFrame(Component component) {
        return (Frame)SwingUtilities.getAncestorOfClass(Frame.class, component);
    }

    protected void initDialog() {
        this.restoreFromPrefs();
    }

    private void restoreFromPrefs() {
        String string = this.classPrefs.get("size", null);
        String string2 = this.classPrefs.get("location", null);
        Rectangle rectangle = this.getBounds();
        Dimension dimension = PrefsUtil.stringToDimension(string);
        if (dimension == null || this.alwaysPackSize()) {
            this.pack();
            dimension = this.getSize();
        }
        rectangle.setSize(dimension);
        Point point = PrefsUtil.stringToPoint(string2);
        if (point != null) {
            rectangle.setLocation(point);
        }
        this.setBounds(rectangle);
        this.invalidate();
        this.validate();
    }

    protected boolean alwaysPackSize() {
        return false;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.updateFont(this.getContentPane(), font);
    }

    protected void updateFont(Container container, Font font) {
        Component[] componentArray = container.getComponents();
        container.setFont(font);
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof Container) {
                this.updateFont((Container)componentArray[i], font);
                continue;
            }
            componentArray[i].setFont(font);
        }
    }
}

