/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Param;
import de.sciss.gui.PathEvent;
import de.sciss.gui.PathListener;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ChannelMgrDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_INPUTLIST = 2;
    private static final int PR_OUTPUTLIST = 3;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_CHANMODE = 3;
    private static final int PR_NAMEMODE = 4;
    private static final int PR_GAIN = 0;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_CHANMODE = "ChanMode";
    private static final String PRN_NAMEMODE = "NameMode";
    private static final String PRN_INPUTLIST = "InputList";
    private static final String PRN_OUTPUTLIST = "OutputList";
    private static final String[] CHAN_NAMES = new String[]{"Split channels", "Merge channels"};
    private static final int CHAN_SPLIT = 0;
    private static final int CHAN_MERGE = 1;
    private static final String[] NAME_NAMES = new String[]{"Spatial (L,C,R)", "Numbers (1,2,3)", "Letters (A,B,C)"};
    private static final int NAME_SPATIAL = 0;
    private static final int NAME_NUMBERS = 1;
    private static final int NAME_LETTERS = 2;
    private static final String[][] SPATIAL_NAMES = new String[][]{new String[0], {"Mono"}, {"L", "R"}, {"L", "C", "R"}, {"L", "R", "Rs", "Ls"}, {"L", "C", "R", "Rs", "Ls"}, {"L", "C", "R", "Rs", "Ls", "LFE"}, {"L", "Lc", "C", "Rc", "R", "Rs", "Ls"}, {"L", "Lc", "C", "Rc", "R", "Rs", "Ls", "LFE"}};
    private static final String[] prText = new String[]{"", "", "", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile", "InputList", "OutputList"};
    private static final int[] prIntg = new int[]{0, 0, 1, 1, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "ChanMode", "NameMode"};
    private static final Param[] prPara = new Param[]{null};
    private static final String[] prParaName = new String[]{"Gain"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_CHANMODE = 259;
    private static final int GG_NAMEMODE = 260;
    private static final int GG_GAIN = 512;
    private static final int GG_INPUTLIST = 2048;
    private static final int GG_CMDINDEL = 2049;
    private static final int GG_CMDINDELALL = 2050;
    private static final int GG_CMDINUP = 2051;
    private static final int GG_CMDINDOWN = 2052;
    private static final int GG_OUTPUTLIST = 2058;
    private static final int GG_CMDOUTAUTO = 2059;
    private static final int GG_CMDOUTAUTOALL = 2060;
    private static final int GG_CMDOUTUP = 2061;
    private static final int GG_CMDOUTDOWN = 2062;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private static final String ERR_OUTNUM = "Please update # of output files";
    private String outPath = "";
    private String outFileName = "";
    private String outFileExt = "";
    protected JList ggInputList;
    protected JList ggOutputList;
    protected DefaultListModel ggInputListModel;
    protected DefaultListModel ggOutputListModel;

    public ChannelMgrDlg() {
        super("Channel Manager");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        int n;
        if (static_pr == null) {
            static_pr = new PropertyArray();
            ChannelMgrDlg.static_pr.text = prText;
            ChannelMgrDlg.static_pr.textName = prTextName;
            ChannelMgrDlg.static_pr.intg = prIntg;
            ChannelMgrDlg.static_pr.intgName = prIntgName;
            ChannelMgrDlg.static_pr.para = prPara;
            ChannelMgrDlg.static_pr.para[0] = new Param(0.0, 785);
            ChannelMgrDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(ChannelMgrDlg.static_pr.intg, 0, 1);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = ChannelMgrDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case 259: 
                    case 260: {
                        ((ChannelMgrDlg)ChannelMgrDlg.this).pr.intg[n - 256] = ((JComboBox)itemEvent.getSource()).getSelectedIndex();
                        ChannelMgrDlg.this.recalcOutChanNum();
                        ChannelMgrDlg.this.outListToPathField();
                    }
                }
            }
        };
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                if (listSelectionEvent.getSource() == ChannelMgrDlg.this.ggInputList) {
                    int n2 = ChannelMgrDlg.this.ggInputList.getSelectedIndex();
                    if (n2 != -1) {
                        ChannelMgrDlg.this.inListToPathField();
                    }
                } else if (listSelectionEvent.getSource() == ChannelMgrDlg.this.ggOutputList && (n = ChannelMgrDlg.this.ggOutputList.getSelectedIndex()) != -1) {
                    ChannelMgrDlg.this.outListToPathField();
                }
            }
        };
        PathListener pathListener = new PathListener(){

            public void pathChanged(PathEvent pathEvent) {
                int n = ChannelMgrDlg.this.gui.getItemID((EventObject)pathEvent);
                switch (n) {
                    case 1024: {
                        ((ChannelMgrDlg)ChannelMgrDlg.this).pr.text[n - 1024] = ((PathField)pathEvent.getSource()).getPath().getPath();
                        ChannelMgrDlg.this.setInput(((ChannelMgrDlg)ChannelMgrDlg.this).pr.text[n - 1024]);
                        ChannelMgrDlg.this.recalcOutChanNum();
                        break;
                    }
                    case 1025: {
                        ((ChannelMgrDlg)ChannelMgrDlg.this).pr.text[n - 1024] = ((PathField)pathEvent.getSource()).getPath().getPath();
                        ChannelMgrDlg.this.setOutput(((ChannelMgrDlg)ChannelMgrDlg.this).pr.text[n - 1024]);
                    }
                }
            }
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ChannelMgrDlg.this.gui.getItemID(actionEvent);
                switch (n) {
                    case 2051: 
                    case 2052: {
                        int n2 = ChannelMgrDlg.this.ggInputList.getSelectedIndex();
                        if (n2 < (n == 2051 ? 1 : 0) || n == 2052 && n2 >= ChannelMgrDlg.this.ggInputListModel.size() - 1) break;
                        Object e = ChannelMgrDlg.this.ggInputListModel.remove(n2);
                        ChannelMgrDlg.this.ggInputListModel.insertElementAt(e, n2 += n == 2051 ? -1 : 1);
                        ChannelMgrDlg.this.ggInputList.setSelectedIndex(n2);
                        ChannelMgrDlg.this.ggInputList.ensureIndexIsVisible(n2);
                        break;
                    }
                    case 2049: {
                        int[] nArray = ChannelMgrDlg.this.ggInputList.getSelectedIndices();
                        if (nArray.length == 0) break;
                        for (int i = nArray.length - 1; i >= 0; --i) {
                            ChannelMgrDlg.this.ggInputListModel.removeElementAt(nArray[i]);
                        }
                        ChannelMgrDlg.this.inListToPathField();
                        ChannelMgrDlg.this.recalcOutChanNum();
                        break;
                    }
                    case 2050: {
                        ChannelMgrDlg.this.ggInputListModel.removeAllElements();
                        ChannelMgrDlg.this.inListToPathField();
                        ChannelMgrDlg.this.recalcOutChanNum();
                        ChannelMgrDlg.this.outListToPathField();
                        break;
                    }
                    case 2061: 
                    case 2062: {
                        int n3 = ChannelMgrDlg.this.ggOutputList.getSelectedIndex();
                        if (n3 < (n == 2061 ? 1 : 0) || n == 2062 && n3 >= ChannelMgrDlg.this.ggOutputListModel.size() - 1) break;
                        Object e = ChannelMgrDlg.this.ggOutputListModel.remove(n3);
                        ChannelMgrDlg.this.ggOutputListModel.insertElementAt(e, n3 += n == 2061 ? -1 : 1);
                        ChannelMgrDlg.this.ggOutputList.setSelectedIndex(n3);
                        ChannelMgrDlg.this.ggOutputList.ensureIndexIsVisible(n3);
                        break;
                    }
                    case 2059: {
                        int n4 = ChannelMgrDlg.this.ggOutputList.getSelectedIndex();
                        if (n4 == -1) break;
                        ((OutputEntry)((ListEntry)((ListEntry)ChannelMgrDlg.this.ggOutputListModel.elementAt((int)n4))).peer).auto = true;
                        ChannelMgrDlg.this.recalcOutChanNum();
                        ChannelMgrDlg.this.outListToPathField();
                        break;
                    }
                    case 2060: {
                        for (int i = 0; i < ChannelMgrDlg.this.ggOutputListModel.size(); ++i) {
                            ((OutputEntry)((ListEntry)((ListEntry)ChannelMgrDlg.this.ggOutputListModel.elementAt((int)i))).peer).auto = true;
                        }
                        ChannelMgrDlg.this.recalcOutChanNum();
                        ChannelMgrDlg.this.outListToPathField();
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Input(s)", 1, 0));
        PathField pathField = new PathField(16, "Select an input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Add file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, pathListener);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.ggInputListModel = new DefaultListModel();
        this.ggInputList = new JList(this.ggInputListModel);
        this.ggInputList.addListSelectionListener(listSelectionListener);
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane(this.ggInputList);
        this.gui.addGadget(jScrollPane, 2048);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.025;
        gridBagConstraints.weighty = 0.0;
        JButton jButton = new JButton("Remove");
        gridBagConstraints.gridwidth = -1;
        this.gui.addButton(jButton, 2049, actionListener);
        jButton = new JButton("Remove all");
        gridBagConstraints.gridwidth = 0;
        this.gui.addButton(jButton, 2050, actionListener);
        jButton = new JButton("Move up");
        gridBagConstraints.gridwidth = -1;
        this.gui.addButton(jButton, 2051, actionListener);
        jButton = new JButton("Move down");
        gridBagConstraints.gridwidth = 0;
        this.gui.addButton(jButton, 2052, actionListener);
        this.gui.addLabel(new JLabel());
        this.gui.addLabel(new JLabel());
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("", 1, 0));
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (n = 0; n < CHAN_NAMES.length; ++n) {
            jComboBox.addItem(CHAN_NAMES[n]);
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Operation mode", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addChoice(jComboBox, 259, itemListener);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Output(s)", 1, 0));
        PathField pathField2 = new PathField(49, "Select an output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0-$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Filename", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, pathListener);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, itemListener);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.ggOutputListModel = new DefaultListModel();
        this.ggOutputList = new JList(this.ggOutputListModel);
        this.ggOutputList.addListSelectionListener(listSelectionListener);
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane2 = new JScrollPane(this.ggOutputList);
        this.gui.addGadget(jScrollPane2, 2058);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.025;
        gridBagConstraints.weighty = 0.0;
        jButton = new JButton("Auto");
        gridBagConstraints.gridwidth = -1;
        this.gui.addButton(jButton, 2059, actionListener);
        jButton = new JButton("Auto all");
        gridBagConstraints.gridwidth = 0;
        this.gui.addButton(jButton, 2060, actionListener);
        jButton = new JButton("Move up");
        gridBagConstraints.gridwidth = -1;
        this.gui.addButton(jButton, 2061, actionListener);
        jButton = new JButton("Move down");
        gridBagConstraints.gridwidth = 0;
        this.gui.addButton(jButton, 2062, actionListener);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        for (n = 0; n < NAME_NAMES.length; ++n) {
            jComboBox2.addItem(NAME_NAMES[n]);
        }
        gridBagConstraints.gridwidth = -1;
        this.gui.addLabel(new JLabel("Auto scheme", 4));
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox2, 260, itemListener);
        this.gui.addLabel(new JLabel());
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        int n;
        String string = this.pr.text[1];
        super.fillGUI();
        super.fillGUI(this.gui);
        this.ggInputListModel.removeAllElements();
        Properties properties = Presets.valueToProperties(this.getPropertyArray().text[2]);
        int n2 = properties.size();
        for (n = 0; n < n2; ++n) {
            InputEntry inputEntry = InputEntry.valueOf(properties.getProperty(String.valueOf(n)));
            this.ggInputListModel.addElement(new ListEntry(inputEntry));
        }
        this.ggOutputListModel.removeAllElements();
        properties = Presets.valueToProperties(this.getPropertyArray().text[3]);
        n2 = properties.size();
        for (n = 0; n < n2; ++n) {
            OutputEntry outputEntry = OutputEntry.valueOf(properties.getProperty(String.valueOf(n)));
            this.ggOutputListModel.addElement(new ListEntry(outputEntry));
        }
        this.pr.text[1] = string;
        this.gui.stringToPathField(this.pr.text[1], 1025);
        this.calcOutNameComponents(this.pr.text[1]);
    }

    @Override
    public void fillPropertyArray() {
        int n;
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
        int n2 = this.ggInputListModel.size();
        Properties properties = new Properties();
        for (n = 0; n < n2; ++n) {
            properties.put(String.valueOf(n), ((ListEntry)this.ggInputListModel.elementAt(n)).peer.toString());
        }
        this.getPropertyArray().text[2] = Presets.propertiesToValue(properties);
        n2 = this.ggOutputListModel.size();
        properties = new Properties();
        for (n = 0; n < n2; ++n) {
            properties.put(String.valueOf(n), ((ListEntry)this.ggOutputListModel.elementAt(n)).peer.toString());
        }
        this.getPropertyArray().text[3] = Presets.propertiesToValue(properties);
    }

    @Override
    protected void process() {
        AudioFile[] audioFileArray;
        AudioFile[] audioFileArray2;
        block31: {
            float[] fArray;
            float[] fArray2;
            float[][] fArray3;
            float[][] fArray4;
            audioFileArray2 = null;
            AudioFileDescr[] audioFileDescrArray = null;
            audioFileArray = null;
            AudioFileDescr[] audioFileDescrArray2 = null;
            float f = 1.0f;
            Param param = new Param(1.0, 1);
            float f2 = 0.0f;
            String string = this.pr.text[0].substring(0, this.pr.text[0].lastIndexOf(File.separatorChar) + 1);
            try {
                float f3;
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6 = this.ggInputListModel.size();
                audioFileArray2 = new AudioFile[n6];
                audioFileDescrArray = new AudioFileDescr[n6];
                for (n5 = 0; n5 < n6; ++n5) {
                    audioFileArray2[n5] = null;
                    audioFileDescrArray[n5] = null;
                }
                int n7 = 0;
                int n8 = 0;
                int n9 = Integer.MAX_VALUE;
                for (n5 = 0; n5 < n6 && this.threadRunning; ++n5) {
                    audioFileArray2[n5] = AudioFile.openAsRead((File)new File(string + ((ListEntry)this.ggInputListModel.elementAt(n5)).peer.getName()));
                    audioFileDescrArray[n5] = audioFileArray2[n5].getDescr();
                    n8 = Math.max(n8, audioFileDescrArray[n5].channels);
                    n7 += audioFileDescrArray[n5].channels;
                    n9 = (int)Math.min((long)n9, audioFileDescrArray[n5].length);
                }
                if (!this.threadRunning) break block31;
                if (n9 < 1 || n7 < 1) {
                    throw new EOFException("File is empty");
                }
                int n10 = this.pr.intg[3] == 0 ? n7 : 1;
                int n11 = n7 / n10;
                if (n10 > this.ggOutputListModel.size()) {
                    throw new IOException(ERR_OUTNUM);
                }
                audioFileArray = new AudioFile[n10];
                audioFileDescrArray2 = new AudioFileDescr[n10];
                fArray4 = new float[n11][8192];
                fArray3 = new float[n8][8192];
                for (n5 = 0; n5 < n10; ++n5) {
                    audioFileArray[n5] = null;
                    audioFileDescrArray2[n5] = null;
                }
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                this.calcOutNameComponents(this.pr.text[1]);
                for (n5 = 0; n5 < n10 && this.threadRunning; ++n5) {
                    audioFileDescrArray2[n5] = new AudioFileDescr(audioFileDescrArray[0]);
                    pathField.fillStream(audioFileDescrArray2[n5]);
                    audioFileDescrArray2[n5].channels = n11;
                    audioFileDescrArray2[n5].file = new File(this.outPath + this.outFileName + (this.pr.intg[3] == 0 ? "-" + ((ListEntry)this.ggOutputListModel.elementAt(n5)).peer.getName() : "") + this.outFileExt);
                    audioFileArray[n5] = AudioFile.openAsWrite((AudioFileDescr)audioFileDescrArray2[n5]);
                }
                if (!this.threadRunning) break block31;
                long l = (long)n7 * (long)n9 * 2L;
                long l2 = 0L;
                if (this.pr.intg[2] == 0) {
                    l += (long)n7 * (long)n9;
                    for (n5 = 0; n5 < n6 && this.threadRunning; ++n5) {
                        n4 = 0;
                        while (n4 < n9 && this.threadRunning) {
                            n3 = Math.min(n9 - n4, 8192);
                            audioFileArray2[n5].readFrames(fArray3, 0, n3);
                            n4 += n3;
                            this.setProgression((float)(l2 += (long)(n3 * audioFileDescrArray[n5].channels)) / (float)l);
                            for (n2 = 0; n2 < audioFileDescrArray[n5].channels; ++n2) {
                                fArray2 = fArray3[n2];
                                for (n = 0; n < n3; ++n) {
                                    f3 = Math.abs(fArray2[n]);
                                    if (!(f3 > f2)) continue;
                                    f2 = f3;
                                }
                            }
                        }
                        audioFileArray2[n5].seekFrame(0L);
                    }
                    if (!this.threadRunning) break block31;
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value;
                } else {
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                }
                for (n5 = 0; n5 < n9 && this.threadRunning; n5 += n3) {
                    n3 = Math.min(n9 - n5, 8192);
                    n2 = 0;
                    n = 0;
                    for (n4 = 0; n4 < n6 && this.threadRunning; ++n4) {
                        int n12;
                        int n13;
                        audioFileArray2[n4].readFrames(fArray3, 0, n3);
                        this.setProgression((float)(l2 += (long)(n3 * audioFileDescrArray[n4].channels)) / (float)l);
                        for (n13 = 0; n13 < audioFileDescrArray[n4].channels; ++n13) {
                            if (f == 1.0f) {
                                System.arraycopy(fArray3[n13], 0, fArray4[n], 0, n3);
                            } else {
                                fArray2 = fArray3[n13];
                                fArray = fArray4[n];
                                for (n12 = 0; n12 < n3; ++n12) {
                                    fArray[n12] = fArray2[n12] * f;
                                }
                            }
                            if (++n != n11) continue;
                            audioFileArray[n2].writeFrames(fArray4, 0, n3);
                            this.setProgression((float)(l2 += (long)(n3 * n11)) / (float)l);
                            n = 0;
                            ++n2;
                        }
                        if (this.pr.intg[2] != 1) continue;
                        for (n13 = 0; n13 < audioFileDescrArray[n4].channels; ++n13) {
                            fArray2 = fArray3[n13];
                            for (n12 = 0; n12 < n3; ++n12) {
                                f3 = Math.abs(fArray2[n12]);
                                if (!(f3 > f2)) continue;
                                f2 = f3;
                            }
                        }
                    }
                }
                if (this.threadRunning) {
                    for (n5 = 0; n5 < n6; ++n5) {
                        audioFileArray2[n5].close();
                        audioFileArray2[n5] = null;
                        audioFileDescrArray[n5] = null;
                    }
                    for (n5 = 0; n5 < n10; ++n5) {
                        audioFileArray[n5].close();
                        audioFileArray[n5] = null;
                        audioFileDescrArray2[n5] = null;
                    }
                    this.handleClipping(f2 *= f);
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescrArray = null;
                audioFileDescrArray2 = null;
                fArray3 = null;
                fArray4 = null;
                fArray2 = null;
                fArray = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFileArray != null) {
            for (int i = 0; i < audioFileArray.length; ++i) {
                if (audioFileArray[i] == null) continue;
                audioFileArray[i].cleanUp();
            }
        }
        if (audioFileArray2 != null) {
            for (int i = 0; i < audioFileArray2.length; ++i) {
                if (audioFileArray2[i] == null) continue;
                audioFileArray2[i].cleanUp();
            }
        }
    }

    protected void setInput(String string) {
        AudioFile audioFile = null;
        AudioFileDescr audioFileDescr = null;
        try {
            audioFile = AudioFile.openAsRead((File)new File(string));
            audioFileDescr = audioFile.getDescr();
            audioFile.close();
            InputEntry inputEntry = new InputEntry();
            inputEntry.name = string.substring(string.lastIndexOf(File.separatorChar) + 1);
            inputEntry.chan = audioFileDescr.channels;
            if (this.ggInputList == null) {
                this.obscure();
                return;
            }
            int n = this.ggInputList.getSelectedIndex();
            if (n >= 0) {
                this.ggInputList.clearSelection();
            }
            n = this.ggInputListModel.size();
            this.ggInputListModel.add(n, new ListEntry(inputEntry));
            this.ggInputList.setSelectedIndex(n);
            this.ggInputList.ensureIndexIsVisible(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String calcOutNameComponents(String string) {
        int n = string.lastIndexOf(File.separatorChar) + 1;
        int n2 = string.lastIndexOf(46);
        int n3 = string.lastIndexOf(45);
        this.outPath = string.substring(0, n);
        if (n2 <= n3 || n2 <= n) {
            n2 = string.length();
        }
        if (n3 < n) {
            n3 = n2;
        }
        this.outFileName = string.substring(n, n3);
        this.outFileExt = string.substring(n2);
        String string2 = string.substring(Math.min(n2, n3 + 1), n2);
        return string2;
    }

    protected void setOutput(String string) {
        String string2 = this.calcOutNameComponents(string);
        int n = this.ggOutputList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        OutputEntry outputEntry = (OutputEntry)((ListEntry)this.ggOutputListModel.elementAt(n)).peer;
        if (string2.equals(outputEntry.name) || this.pr.intg[3] == 1) {
            return;
        }
        outputEntry.name = string2;
        outputEntry.auto = false;
        this.ggOutputListModel.setElementAt(new ListEntry(outputEntry), n);
        this.ggOutputList.ensureIndexIsVisible(n);
        this.ggOutputList.setSelectedIndex(n);
    }

    protected void obscure() {
        if (this.isVisible()) {
            JOptionPane.showMessageDialog(this.getComponent(), "Oscure! Gadget missing...");
        }
    }

    protected void inListToPathField() {
        int n = this.ggInputList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        InputEntry inputEntry = (InputEntry)((ListEntry)this.ggInputListModel.elementAt(n)).peer;
        PathField pathField = (PathField)this.gui.getItemObj(1024);
        if (pathField == null) {
            this.obscure();
            return;
        }
        String string = pathField.getPath().getPath();
        pathField.setPath(new File(string.substring(0, string.lastIndexOf(File.separatorChar) + 1) + inputEntry.name));
    }

    protected void outListToPathField() {
        OutputEntry outputEntry;
        PathField pathField = (PathField)this.gui.getItemObj(1025);
        int n = this.ggOutputList.getSelectedIndex();
        OutputEntry outputEntry2 = outputEntry = n != -1 ? (OutputEntry)((ListEntry)this.ggOutputListModel.elementAt(n)).peer : null;
        if (pathField == null) {
            this.obscure();
            return;
        }
        pathField.setPath(new File(this.outPath + this.outFileName + (this.pr.intg[3] == 0 ? "-" + (outputEntry == null ? "" : outputEntry.name) : "") + this.outFileExt));
    }

    protected void recalcOutChanNum() {
        OutputEntry outputEntry;
        int n;
        int n2 = 0;
        for (n = 0; n < this.ggInputListModel.size(); ++n) {
            n2 += ((InputEntry)((ListEntry)((ListEntry)this.ggInputListModel.elementAt((int)n))).peer).chan;
        }
        if (this.pr.intg[3] == 1) {
            n2 = Math.min(1, n2);
        }
        int n3 = n2;
        int n4 = this.ggOutputList.getSelectedIndex();
        if (n4 >= 0) {
            this.ggOutputList.clearSelection();
        }
        if (n3 < this.ggOutputListModel.size()) {
            for (n = this.ggOutputListModel.size() - 1; n >= n3; --n) {
                this.ggOutputListModel.removeElementAt(n);
            }
        }
        for (n = 0; n < this.ggOutputListModel.size(); ++n) {
            outputEntry = (OutputEntry)((ListEntry)this.ggOutputListModel.elementAt(n)).peer;
            if (!outputEntry.auto) continue;
            outputEntry.name = this.createAutoExt(n, n3);
            this.ggOutputListModel.setElementAt(new ListEntry(outputEntry), n);
        }
        while (n3 > this.ggOutputListModel.size()) {
            outputEntry = new OutputEntry();
            outputEntry.auto = true;
            outputEntry.name = this.createAutoExt(this.ggOutputListModel.size(), n3);
            this.ggOutputListModel.addElement(new ListEntry(outputEntry));
        }
        if (n4 >= 0 && n4 < n3) {
            this.ggOutputList.setSelectedIndex(n4);
            this.ggOutputList.ensureIndexIsVisible(n4);
        }
    }

    protected String createAutoExt(int n, int n2) {
        int n3 = this.pr.intg[4];
        String string = "";
        if (n3 == 0 && n2 > 8 || n3 == 2 && n2 > 26) {
            n3 = 1;
        }
        switch (n3) {
            case 0: {
                string = SPATIAL_NAMES[n2][n];
                break;
            }
            case 1: {
                string = String.valueOf(n + 1);
                break;
            }
            case 2: {
                string = String.valueOf((char)(n + 65));
                break;
            }
        }
        return string;
    }

    static class OutputEntry
    implements Entry {
        String name;
        boolean auto;
        private static final String PR_NAME = "nam";
        private static final String PR_AUTO = "aut";

        OutputEntry() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            Properties properties = new Properties();
            properties.put(PR_NAME, this.name);
            properties.put(PR_AUTO, String.valueOf(this.auto));
            return Presets.propertiesToValue(properties);
        }

        public static OutputEntry valueOf(String string) {
            Properties properties = Presets.valueToProperties(string);
            OutputEntry outputEntry = new OutputEntry();
            outputEntry.name = properties.getProperty(PR_NAME);
            try {
                outputEntry.auto = Boolean.valueOf(properties.getProperty(PR_AUTO));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return outputEntry;
        }
    }

    static class InputEntry
    implements Entry {
        String name;
        int chan;
        private static final String PR_NAME = "nam";
        private static final String PR_CHAN = "cha";

        InputEntry() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            Properties properties = new Properties();
            properties.put(PR_NAME, this.name);
            properties.put(PR_CHAN, String.valueOf(this.chan));
            return Presets.propertiesToValue(properties);
        }

        public static InputEntry valueOf(String string) {
            Properties properties = Presets.valueToProperties(string);
            InputEntry inputEntry = new InputEntry();
            inputEntry.name = properties.getProperty(PR_NAME);
            try {
                inputEntry.chan = Integer.parseInt(properties.getProperty(PR_CHAN));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return inputEntry;
        }
    }

    static class ListEntry {
        private final Entry peer;

        public ListEntry(Entry entry) {
            this.peer = entry;
        }

        public String toString() {
            return this.peer.getName();
        }
    }

    static interface Entry {
        public String getName();
    }
}

