/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.gui.SpectSlider;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ChebychevDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_SPECTSLIDER1 = 2;
    private static final int PR_SPECTSLIDER2 = 3;
    private static final int PR_SPECTSLIDER3 = 4;
    private static final int PR_SPECTSLIDER4 = 5;
    private static final int PR_SPECTSLIDER5 = 6;
    private static final int PR_SPECTSLIDER6 = 7;
    private static final int PR_SPECTSLIDER7 = 8;
    private static final int PR_SPECTSLIDER8 = 9;
    private static final int PR_SPECTSLIDER9 = 10;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_FILTERLEN = 3;
    private static final int PR_GAIN = 0;
    private static final int PR_LOFREQ = 1;
    private static final int PR_MIDFREQ = 2;
    private static final int PR_HIFREQ = 3;
    private static final int PR_MIDTIME = 4;
    private static final int PR_DRYMIX = 5;
    private static final int PR_WETMIX = 6;
    private static final int PR_ROLLOFF = 7;
    private static final int PR_BANDSPEROCT = 8;
    private static final int FLT_LONG = 2;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_SPECTSLIDER1 = "Shape1";
    private static final String PRN_SPECTSLIDER2 = "Shape2";
    private static final String PRN_SPECTSLIDER3 = "Shape3";
    private static final String PRN_SPECTSLIDER4 = "Shape4";
    private static final String PRN_SPECTSLIDER5 = "Shape5";
    private static final String PRN_SPECTSLIDER6 = "Shape6";
    private static final String PRN_SPECTSLIDER7 = "Shape7";
    private static final String PRN_SPECTSLIDER8 = "Shape8";
    private static final String PRN_SPECTSLIDER9 = "Shape9";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_FILTERLEN = "FilterLen";
    private static final String PRN_LOFREQ = "LoFreq";
    private static final String PRN_MIDFREQ = "MidFreq";
    private static final String PRN_HIFREQ = "HiFreq";
    private static final String PRN_MIDTIME = "MidTime";
    private static final String PRN_DRYMIX = "DryMix";
    private static final String PRN_WETMIX = "WetMix";
    private static final String PRN_ROLLOFF = "RollOff";
    private static final String PRN_BANDSPEROCT = "BandsPerOct";
    private static final String PRN_DROPENV = "DropEnv";
    private static final int SLIDER_NUM = 9;
    private static final int MAX_HARMON = 8;
    private static final String[] prText = new String[11];
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile", "Shape1", "Shape2", "Shape3", "Shape4", "Shape5", "Shape6", "Shape7", "Shape8", "Shape9"};
    private static final int[] prIntg = new int[]{0, 0, 0, 2};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "FilterLen"};
    private static final Param[] prPara = new Param[9];
    private static final String[] prParaName = new String[]{"Gain", "LoFreq", "MidFreq", "HiFreq", "MidTime", "DryMix", "WetMix", "RollOff", "BandsPerOct"};
    private static final boolean[] prBool = new boolean[]{false};
    private static final String[] prBoolName = new String[]{"DropEnv"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_FILTERLEN = 259;
    private static final int GG_GAIN = 512;
    private static final int GG_LOFREQ = 513;
    private static final int GG_MIDFREQ = 514;
    private static final int GG_HIFREQ = 515;
    private static final int GG_MIDTIME = 516;
    private static final int GG_BANDSPEROCT = 520;
    private static final int GG_PANEL = 2048;
    private static final int GG_SPECTSLIDER1 = 2050;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    protected JButton ggToTime;
    protected JButton ggToFreq;

    public ChebychevDlg() {
        super("Chebyshev Waveshaping");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            ChebychevDlg.static_pr.text = prText;
            ChebychevDlg.static_pr.textName = prTextName;
            ChebychevDlg.static_pr.text[0] = "";
            ChebychevDlg.static_pr.text[1] = "";
            for (int i = 0; i < 9; ++i) {
                ChebychevDlg.static_pr.text[2 + i] = "1.0,0,0,0,0,0,0,0";
            }
            ChebychevDlg.static_pr.intg = prIntg;
            ChebychevDlg.static_pr.intgName = prIntgName;
            ChebychevDlg.static_pr.bool = prBool;
            ChebychevDlg.static_pr.boolName = prBoolName;
            ChebychevDlg.static_pr.para = prPara;
            ChebychevDlg.static_pr.para[1] = new Param(400.0, 3);
            ChebychevDlg.static_pr.para[2] = new Param(2000.0, 3);
            ChebychevDlg.static_pr.para[3] = new Param(9000.0, 3);
            ChebychevDlg.static_pr.para[5] = new Param(100.0, 17);
            ChebychevDlg.static_pr.para[6] = new Param(25.0, 17);
            ChebychevDlg.static_pr.para[7] = new Param(12.0, 547);
            ChebychevDlg.static_pr.para[8] = new Param(36.0, 0);
            ChebychevDlg.static_pr.para[4] = new Param(50.0, 18);
            ChebychevDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(ChebychevDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(ChebychevDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                block5: {
                    int n;
                    float[] fArray;
                    int n2;
                    block4: {
                        SpectSlider spectSlider = null;
                        for (n2 = 0; n2 < 9 && !(spectSlider = (SpectSlider)ChebychevDlg.this.gui.getItemObj(2050 + n2)).hasFocus(); ++n2) {
                        }
                        if (n2 == 9) {
                            return;
                        }
                        fArray = spectSlider.getBands();
                        int n3 = n2 % 3;
                        n = n2 / 3;
                        if (actionEvent.getSource() != ChebychevDlg.this.ggToTime) break block4;
                        for (int i = n3; i < 9; i += 3) {
                            if (i == n2) continue;
                            ((SpectSlider)ChebychevDlg.this.gui.getItemObj(2050 + i)).setBands(fArray);
                        }
                        break block5;
                    }
                    if (actionEvent.getSource() != ChebychevDlg.this.ggToFreq) break block5;
                    for (int i = n * 3; i < (n + 1) * 3; ++i) {
                        if (i == n2) continue;
                        ((SpectSlider)ChebychevDlg.this.gui.getItemObj(2050 + i)).setBands(fArray);
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(49, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0Chby$E");
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, null);
        this.gui.addLabel(new GroupLabel("Shape Settings", 1, 0));
        ParamField paramField = new ParamField(Constants.spaces[15]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Low Freq", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 513, null);
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[15], Constants.spaces[18], Constants.spaces[19]};
        ParamField paramField2 = new ParamField(paramSpaceArray);
        paramField2.setReference(paramField);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Mid Freq", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField2, 514, null);
        ParamField paramField3 = new ParamField(paramSpaceArray);
        paramField3.setReference(paramField);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("High Freq", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField3, 515, null);
        JPanel jPanel = new JPanel(new GridLayout(3, 3, 4, 4));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        Box box = Box.createVerticalBox();
        for (int i = 0; i < 9; ++i) {
            SpectSlider spectSlider = new SpectSlider(8, 32, 59);
            jPanel.add(spectSlider);
            this.gui.registerGadget(spectSlider, 2050 + i);
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)jPanel, "Center");
        this.ggToTime = new JButton("\u2192all times");
        this.ggToTime.setFocusable(false);
        this.ggToTime.addActionListener(actionListener);
        this.ggToFreq = new JButton("\u2192all freq");
        this.ggToFreq.setFocusable(false);
        this.ggToFreq.addActionListener(actionListener);
        box.add(this.ggToTime);
        box.add(this.ggToFreq);
        jPanel2.add((Component)box, "East");
        this.gui.addGadget(jPanel2, 2048);
        ParamSpace[] paramSpaceArray2 = new ParamSpace[]{Constants.spaces[8], Constants.spaces[9], Constants.spaces[10]};
        ParamField paramField4 = new ParamField(paramSpaceArray2);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Mid Time", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField4, 516, null);
        ParamField paramField5 = new ParamField(new ParamSpace(1.0, 256.0, 1.0, 0));
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Bands per Oct.", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField5, 520, null);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Short");
        jComboBox.addItem("Medium");
        jComboBox.addItem("Long");
        jComboBox.addItem("Very long");
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Filter length", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox, 259, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
        for (int i = 0; i < 9; ++i) {
            SpectSlider spectSlider = (SpectSlider)this.gui.getItemObj(2050 + i);
            if (spectSlider == null) continue;
            spectSlider.setBands(SpectSlider.valueOf(this.pr.text[2 + i]));
        }
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
        for (int i = 0; i < 9; ++i) {
            SpectSlider spectSlider = (SpectSlider)this.gui.getItemObj(2050 + i);
            if (spectSlider == null) continue;
            this.pr.text[2 + i] = spectSlider.toString();
        }
    }

    @Override
    protected void process() {
        AudioFile audioFile;
        AudioFile audioFile2;
        block71: {
            audioFile2 = null;
            audioFile = null;
            AudioFile audioFile3 = null;
            Param param = new Param(1.0, 1);
            float f = 1.0f;
            float f2 = 0.0f;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            try {
                float[] fArray;
                float[] fArray2;
                float f3;
                float f4;
                int n4;
                int n5;
                float f5;
                ChebyTracker chebyTracker;
                int n6;
                float[] fArray3;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                AudioFileDescr audioFileDescr = audioFile2.getDescr();
                int n13 = audioFileDescr.channels;
                int n14 = (int)audioFileDescr.length;
                if (n14 * n13 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block71;
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                AudioFileDescr audioFileDescr2 = new AudioFileDescr(audioFileDescr);
                pathField.fillStream(audioFileDescr2);
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr2);
                if (!this.threadRunning) break block71;
                double d = Param.transform((Param)this.pr.para[1], (int)3, null, null).value;
                double d2 = Param.transform((Param)this.pr.para[2], (int)3, (Param)this.pr.para[1], null).value;
                double d3 = Math.min(audioFileDescr.rate * 0.2475, Param.transform((Param)this.pr.para[3], (int)3, (Param)this.pr.para[1], null).value);
                double d4 = Math.pow(2.0, 1.0 / this.pr.para[8].value);
                float f6 = (float)(audioFileDescr.rate * 0.49);
                int n15 = (int)(Math.log(d3 / d) / Math.log(d4));
                float[] fArray4 = new float[n15 + 1];
                float[] fArray5 = new float[n15 + 1];
                int[] nArray = new int[n15];
                double d5 = d;
                double d6 = d5 * d4;
                int n16 = (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)Param.transform((Param)this.pr.para[4], (int)2, (Param)new Param((double)AudioFileDescr.samplesToMillis((AudioFileDescr)audioFileDescr, (long)((long)n14)), (int)2), null).value) + 0.5);
                n16 = Math.max(1, Math.min(n16, n14 - 1));
                for (n12 = 0; n12 <= n15; ++n12) {
                    fArray4[n12] = (float)d5;
                    fArray5[n12] = (float)(Math.sqrt(d6 * d5) - d5);
                    d5 = d6;
                    d6 = d5 * d4;
                }
                d3 = fArray4[n15];
                int n17 = 6;
                int n18 = Math.max(1, (int)((double)n17 * audioFileDescr.rate / d + 0.5));
                double d7 = Math.PI * 2 / audioFileDescr.rate;
                double d8 = 0.4052847345693511;
                int n19 = n18 + n18;
                int n20 = n19 + n19 - 1;
                for (n11 = 2; n11 < n20; n11 <<= 1) {
                }
                int n21 = n11 - n19 + 1;
                int n22 = n11 - n21;
                int n23 = Math.max(1, (int)((double)n17 * audioFileDescr.rate / d3 + 0.5));
                float[] fArray6 = Filter.createFullWindow(n23 << 1, 1);
                double d9 = d7 * (audioFileDescr.rate / 2.0);
                float[] fArray7 = new float[n11 + 2];
                Util.clear(fArray7);
                fArray7[n18] = (float)d9;
                d9 = d7 * d3 * 0.8;
                double d10 = d7 * d3 * 0.04;
                double d11 = d10 * d10;
                for (n20 = 1; n20 < n23; ++n20) {
                    d5 = Math.sin(d9 * (double)n20) / (double)n20;
                    d6 = d8 * d11 * (double)n20 * (double)n20;
                    int n24 = n18 + n20;
                    fArray7[n24] = fArray7[n24] - (float)(d5 *= Math.cos(d10 * (double)n20) / (1.0 - d6));
                    int n25 = n18 - n20;
                    fArray7[n25] = fArray7[n25] - (float)d5;
                }
                int n26 = n18;
                fArray7[n26] = fArray7[n26] - (float)d9;
                Util.mult(fArray6, 0, fArray7, n18 - n23, fArray6.length);
                Fourier.realTransform(fArray7, n11, 1);
                Util.mult(fArray7, 0, fArray7.length, 0.31830987f);
                fArray6 = Filter.createFullWindow(n19, 1);
                d9 = d7 * (audioFileDescr.rate / 2.0);
                float[] fArray8 = new float[n11 + 2];
                Util.clear(fArray8);
                fArray8[n18] = (float)(Math.PI - d9);
                d9 = d7 * d * 1.2;
                d10 = d7 * d * 0.04;
                d11 = d10 * d10;
                for (n20 = 1; n20 < n18; ++n20) {
                    d5 = Math.sin(d9 * (double)n20) / (double)n20;
                    d6 = d8 * d11 * (double)n20 * (double)n20;
                    fArray8[n18 + n20] = (float)(d5 *= Math.cos(d10 * (double)n20) / (1.0 - d6));
                    fArray8[n18 - n20] = (float)d5;
                }
                int n27 = n18;
                fArray8[n27] = fArray8[n27] + (float)d9;
                Util.mult(fArray6, 0, fArray8, 0, n19);
                Fourier.realTransform(fArray8, n11, 1);
                Util.mult(fArray8, 0, fArray8.length, 0.31830987f);
                int n28 = 3 << this.pr.intg[3];
                int n29 = Math.max(1, (int)((double)n28 * audioFileDescr.rate / (double)fArray4[0] + 0.5));
                int n30 = Math.max(1, (int)((double)n28 * audioFileDescr.rate / (double)fArray4[n15 - 1] + 0.5));
                n12 = n30 + n30;
                n20 = n12 + n12 - 1;
                for (n10 = 2; n10 < n20; n10 <<= 1) {
                }
                n12 = n29 + n29;
                n20 = n12 + n12 - 1;
                for (n9 = 2; n9 < n20; n9 <<= 1) {
                }
                int n31 = 1;
                n12 = n10;
                while (n12 < n9) {
                    n12 <<= 1;
                    ++n31;
                }
                int[] nArray2 = new int[n31];
                int[] nArray3 = new int[n31];
                int[] nArray4 = new int[n31];
                Object object = new float[n15][];
                float[] fArray9 = new float[n9 + 2];
                float[][][] fArray10 = new float[n13][n15][];
                int n32 = -1;
                int n33 = -1;
                nArray2[0] = n32;
                nArray3[0] = 0;
                n12 = n9 - (n29 << 1) + 1;
                nArray4[0] = (n21 + n12 - 1) / n12;
                int n34 = n29;
                float[] fArray11 = Filter.createFullWindow(n34 << 1, 1);
                ChebyTracker[][] chebyTrackerArray = new ChebyTracker[n13][n15];
                float[] fArray12 = SpectSlider.valueOf(this.pr.text[2]);
                float[] fArray13 = SpectSlider.valueOf(this.pr.text[3]);
                float[] fArray14 = SpectSlider.valueOf(this.pr.text[4]);
                float[] fArray15 = SpectSlider.valueOf(this.pr.text[5]);
                float[] fArray16 = SpectSlider.valueOf(this.pr.text[6]);
                float[] fArray17 = SpectSlider.valueOf(this.pr.text[7]);
                float[] fArray18 = SpectSlider.valueOf(this.pr.text[8]);
                float[] fArray19 = SpectSlider.valueOf(this.pr.text[9]);
                float[] fArray20 = SpectSlider.valueOf(this.pr.text[10]);
                for (n8 = 0; n8 < n15; ++n8) {
                    n7 = n34;
                    float[] fArray21 = fArray11;
                    nArray[n8] = n7;
                    n34 = Math.max(1, (int)((double)n28 * audioFileDescr.rate / (double)fArray4[n8 + 1] + 0.5));
                    fArray11 = Filter.createFullWindow(n34 << 1, 1);
                    n20 = (n7 + n7 << 1) - 1;
                    for (n23 = 2; n23 < n20; n23 <<= 1) {
                    }
                    fArray3 = new float[n23 + 2];
                    object[n8] = fArray3;
                    if (n23 != n32) {
                        n32 = n23;
                        nArray2[++n33] = n32;
                        n20 = n32 - (n7 << 1) + 1;
                        nArray4[n33] = (n21 + n20 - 1) / n20;
                    }
                    int n35 = n33;
                    nArray3[n35] = nArray3[n35] + 1;
                    n = n32 - (n7 << 1) + 1;
                    n3 = n32 - n;
                    for (n6 = 0; n6 < n13; ++n6) {
                        fArray10[n6][n8] = new float[n3];
                    }
                    if (n8 < n15 - 1) {
                        d9 = d7 * (double)fArray4[n8 + 1];
                        d10 = d7 * (double)fArray5[n8 + 1];
                        d11 = d10 * d10;
                        for (n20 = 1; n20 < n34; ++n20) {
                            d5 = Math.sin(d9 * (double)n20) / (double)n20;
                            d6 = d8 * d11 * (double)n20 * (double)n20;
                            fArray3[n7 + n20] = (float)(d5 *= Math.cos(d10 * (double)n20) / (1.0 - d6)) * fArray11[n34 + n20];
                            fArray3[n7 - n20] = (float)d5 * fArray11[n34 - n20];
                        }
                        fArray3[n7] = (float)d9 * fArray11[n34];
                    } else {
                        Util.clear(fArray3);
                        fArray3[n7] = (float)Math.PI * fArray11[n34];
                    }
                    if (n8 > 0) {
                        d9 = d7 * (double)fArray4[n8];
                        d10 = d7 * (double)fArray5[n8];
                        d11 = d10 * d10;
                        for (n20 = 1; n20 < n7; ++n20) {
                            d5 = Math.sin(d9 * (double)n20) / (double)n20;
                            d6 = d8 * d11 * (double)n20 * (double)n20;
                            int n36 = n7 + n20;
                            fArray3[n36] = fArray3[n36] - (float)(d5 *= Math.cos(d10 * (double)n20) / (1.0 - d6)) * fArray21[n7 + n20];
                            int n37 = n7 - n20;
                            fArray3[n37] = fArray3[n37] - (float)d5 * fArray21[n7 - n20];
                        }
                        int n38 = n7;
                        fArray3[n38] = fArray3[n38] - (float)d9 * fArray21[n7];
                        for (n20 = n7 << 1; n20 < n32; ++n20) {
                            fArray3[n20] = 0.0f;
                        }
                    }
                    Fourier.realTransform(fArray3, n32, 1);
                    Util.mult(fArray3, 0, fArray3.length, 0.31830987f);
                    chebyTracker = new ChebyTracker();
                    f5 = (float)audioFileDescr.rate / fArray4[n8];
                    n5 = Math.max(64, (int)(f5 * 1.5f + 0.5f));
                    chebyTracker.peakBufLen = n4 = n5 << 1;
                    chebyTracker.peakScope = n5;
                    chebyTracker.peakBuf = new float[n4];
                    Util.clear(chebyTracker.peakBuf);
                    chebyTracker.peakBufStart = 0;
                    chebyTracker.peakBufOff = n5 - 1;
                    chebyTracker.peakValid = 0;
                    chebyTracker.harmonWeight1 = new float[8];
                    chebyTracker.harmonWeight2 = new float[8];
                    chebyTracker.harmonWeight3 = new float[8];
                    for (n12 = 0; n12 < 8; ++n12) {
                        if (fArray4[n8 + 1] < f6) {
                            float f7;
                            if ((double)fArray4[n8 + 1] < d2) {
                                f4 = (float)(((double)fArray4[n8 + 1] - d) / (d2 - d));
                                f5 = fArray12[n12];
                                f3 = fArray13[n12];
                                f7 = f5 = f5 * (1.0f - f4) + f3 * f4;
                                chebyTracker.harmonWeight1[n12] = f5 * f5 * f5;
                                f5 = fArray15[n12];
                                f3 = fArray16[n12];
                                f5 = f5 * (1.0f - f4) + f3 * f4;
                                f7 = Math.max(f7, f5);
                                chebyTracker.harmonWeight2[n12] = f5 * f5 * f5;
                                f5 = fArray18[n12];
                                f3 = fArray19[n12];
                                f5 = f5 * (1.0f - f4) + f3 * f4;
                                f7 = Math.max(f7, f5);
                                chebyTracker.harmonWeight3[n12] = f5 * f5 * f5;
                            } else {
                                f4 = (float)((d3 - (double)fArray4[n8 + 1]) / (d3 - d2));
                                f5 = fArray13[n12];
                                f3 = fArray14[n12];
                                f7 = f5 = f5 * f4 + f3 * (1.0f - f4);
                                chebyTracker.harmonWeight1[n12] = f5 * f5 * f5;
                                f5 = fArray16[n12];
                                f3 = fArray17[n12];
                                f5 = f5 * f4 + f3 * (1.0f - f4);
                                f7 = Math.max(f7, f5);
                                chebyTracker.harmonWeight2[n12] = f5 * f5 * f5;
                                f5 = fArray19[n12];
                                f3 = fArray20[n12];
                                f5 = f5 * f4 + f3 * (1.0f - f4);
                                f7 = Math.max(f7, f5);
                                chebyTracker.harmonWeight3[n12] = f5 * f5 * f5;
                            }
                            if (!(f7 > 0.0f)) continue;
                            chebyTracker.harmonNum = n12 + 1;
                            continue;
                        }
                        chebyTracker.harmonWeight1[n12] = 0.0f;
                        chebyTracker.harmonWeight2[n12] = 0.0f;
                        chebyTracker.harmonWeight3[n12] = 0.0f;
                    }
                    chebyTrackerArray[0][n8] = chebyTracker;
                    for (n6 = 1; n6 < n13; ++n6) {
                        chebyTrackerArray[n6][n8] = (ChebyTracker)chebyTracker.clone();
                    }
                }
                n31 = n33 + 1;
                float[][] fArray22 = new float[n13][n29 + n21];
                float[] fArray23 = new float[n11 + 2];
                float[] fArray24 = new float[n11 + 2];
                float[] fArray25 = new float[n11 + 2];
                float[][] fArray26 = new float[n13][n22];
                float[][] fArray27 = new float[n13][n22];
                float[][] fArray28 = new float[n13][n21 + n18];
                float[][] fArray29 = new float[nArray4[n31 - 1]][n9 + 2];
                Util.clear(fArray28);
                long l = 0L;
                long l2 = (long)n14 * (long)(2 + n13 + n13);
                int n39 = 0;
                float f8 = chebyTrackerArray[0][0].harmonWeight1[0];
                if (this.pr.intg[2] == 0) {
                    audioFile3 = this.createTempFile(audioFileDescr);
                    l2 += (long)n14;
                } else {
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                }
                if (!this.threadRunning) break block71;
                int n40 = 0;
                int n41 = 0;
                int n42 = n18 + n29;
                fArray14 = new float[8];
                while (this.threadRunning && n41 < n14) {
                    int n43;
                    int n44;
                    int n45 = Math.min(n21, n14 - n40);
                    int n46 = Math.min(n21, n14 - n41);
                    for (n43 = 0; this.threadRunning && n43 < n45; n43 += n44) {
                        n44 = Math.min(8192, n45 - n43);
                        audioFile2.readFrames(fArray28, n43 + n18, n44);
                        n40 += n44;
                        this.setProgression((float)(l += (long)n44) / (float)l2);
                    }
                    if (!this.threadRunning) break block71;
                    boolean bl = n40 <= n16;
                    f4 = bl ? (float)n40 / (float)n16 : (float)(n40 - n16) / (float)(n14 - n16);
                    for (n6 = 0; this.threadRunning && n6 < n13; ++n6) {
                        fArray3 = fArray22[n6];
                        fArray2 = fArray28[n6];
                        System.arraycopy(fArray2, n18, fArray23, 0, n45);
                        for (n12 = n45; n12 < n11; ++n12) {
                            fArray23[n12] = 0.0f;
                        }
                        Fourier.realTransform(fArray23, n11, 1);
                        Fourier.complexMult(fArray8, 0, fArray23, 0, fArray24, 0, fArray8.length);
                        Fourier.realTransform(fArray24, n11, -1);
                        Util.add(fArray26[n6], 0, fArray24, 0, n22);
                        System.arraycopy(fArray24, n21, fArray26[n6], 0, n22);
                        Fourier.complexMult(fArray7, 0, fArray23, 0, fArray25, 0, fArray7.length);
                        Fourier.realTransform(fArray25, n11, -1);
                        Util.add(fArray27[n6], 0, fArray25, 0, n22);
                        System.arraycopy(fArray25, n21, fArray27[n6], 0, n22);
                        Util.sub(fArray24, 0, fArray2, 0, n21);
                        Util.sub(fArray25, 0, fArray2, 0, n21);
                        System.arraycopy(fArray24, 0, fArray3, n29, n21);
                        Util.add(fArray25, 0, fArray3, n29, n21);
                        Util.mult(fArray3, n29, n21, f8);
                        n33 = -1;
                        int n47 = 0;
                        for (n8 = 0; this.threadRunning && n8 < n15; ++n8) {
                            n7 = nArray[n8];
                            if (n47 == 0) {
                                n47 = nArray3[++n33];
                                n32 = nArray2[n33];
                                n = n32 - (n7 << 1) + 1;
                                n2 = nArray4[n33];
                                n43 = 0;
                                for (n12 = 0; n12 < n2; ++n12) {
                                    n44 = Math.min(n, n21 - n43);
                                    fArray = fArray29[n12];
                                    System.arraycopy(fArray2, n43, fArray, 0, n44);
                                    for (n20 = n44; n20 < n32; ++n20) {
                                        fArray[n20] = 0.0f;
                                    }
                                    Fourier.realTransform(fArray, n32, 1);
                                    n43 += n44;
                                }
                            }
                            --n47;
                            n3 = (n7 << 1) - 1;
                            int n48 = n29 - n7;
                            chebyTracker = chebyTrackerArray[n6][n8];
                            float[] fArray30 = chebyTracker.peakBuf;
                            n4 = chebyTracker.peakBufLen;
                            int n49 = chebyTracker.peakBufStart;
                            int n50 = chebyTracker.peakBufOff;
                            int n51 = chebyTracker.peakValid;
                            float f9 = chebyTracker.peakValue;
                            n5 = chebyTracker.peakScope;
                            boolean bl2 = n49 < n50;
                            int n52 = chebyTracker.harmonNum;
                            if (bl) {
                                fArray12 = chebyTracker.harmonWeight1;
                                fArray13 = chebyTracker.harmonWeight2;
                            } else {
                                fArray12 = chebyTracker.harmonWeight2;
                                fArray13 = chebyTracker.harmonWeight3;
                            }
                            for (n12 = 0; n12 < 8; ++n12) {
                                fArray14[n12] = fArray12[n12] * (1.0f - f4) + fArray13[n12] * f4;
                            }
                            n43 = 0;
                            for (n12 = 0; n12 < n2; ++n12) {
                                Fourier.complexMult(object[n8], 0, fArray29[n12], 0, fArray9, 0, object[n8].length);
                                Fourier.realTransform(fArray9, n32, -1);
                                n44 = Math.min(n, n21 - n43);
                                Util.add(fArray10[n6][n8], 0, fArray9, 0, n3);
                                System.arraycopy(fArray9, n44, fArray10[n6][n8], 0, n3);
                                for (n20 = 0; n20 < n44; ++n20) {
                                    f5 = fArray9[n20];
                                    fArray30[n50] = f3 = Math.abs(f5);
                                    if (n51 > 0) {
                                        if (f3 >= f9) {
                                            f9 = f3;
                                            n51 = n5;
                                        }
                                        --n51;
                                    } else {
                                        f9 = -1.0f;
                                        if (bl2) {
                                            for (n23 = n49; n23 <= n50; ++n23) {
                                                if (!(fArray30[n23] >= f9)) continue;
                                                f9 = fArray30[n23];
                                                n39 = n23;
                                            }
                                            n51 = n39 - n49;
                                        } else {
                                            for (n23 = n49; n23 < n4; ++n23) {
                                                if (!(fArray30[n23] >= f9)) continue;
                                                f9 = fArray30[n23];
                                                n39 = n23;
                                            }
                                            for (n23 = 0; n23 <= n50; ++n23) {
                                                if (!(fArray30[n23] >= f9)) continue;
                                                f9 = fArray30[n23];
                                                n39 = n23;
                                            }
                                            n51 = n39 - n49;
                                            if (n51 < 0) {
                                                n51 += n4;
                                            }
                                        }
                                    }
                                    ++n49;
                                    if (++n50 == n4) {
                                        n50 = 0;
                                        bl2 = false;
                                    } else if (n49 == n4) {
                                        n49 = 0;
                                        bl2 = true;
                                    }
                                    if (f9 > 1.0E-5f) {
                                        float f10 = 1.0f;
                                        float f11 = f5 / f9;
                                        f3 = 2.0f * f11;
                                        float f12 = f11 * fArray14[0];
                                        for (n23 = 1; n23 < n52; ++n23) {
                                            float f13 = f10;
                                            f10 = f11;
                                            f11 = f3 * f10 - f13;
                                            f12 += f11 * fArray14[n23];
                                        }
                                        if (f9 > 1.0E-4f) {
                                            fArray9[n20] = f12 * f9;
                                            continue;
                                        }
                                        f3 = f9 / 1.0E-4f;
                                        fArray9[n20] = f12 * f3 * f9 + f5 * fArray14[0] * (1.0f - f3);
                                        continue;
                                    }
                                    int n53 = n20;
                                    fArray9[n53] = fArray9[n53] * fArray14[0];
                                }
                                Util.add(fArray9, 0, fArray3, n43 + n48, n44);
                                n43 += n44;
                            }
                            chebyTracker.peakBufStart = n49;
                            chebyTracker.peakBufOff = n50;
                            chebyTracker.peakValid = n51;
                            chebyTracker.peakValue = f9;
                        }
                        if (this.threadRunning) {
                            System.arraycopy(fArray2, n21, fArray2, 0, n18);
                            this.setProgression((float)(l += (long)(n46 + n46)) / (float)l2);
                            continue;
                        }
                        break block71;
                    }
                    if (this.threadRunning) {
                        for (n43 = n42; this.threadRunning && n43 < n46; n43 += n44) {
                            n44 = Math.min(8192, n46 - n43);
                            if (audioFile3 != null) {
                                audioFile3.writeFrames(fArray22, n43, n44);
                            } else {
                                for (n6 = 0; n6 < n13; ++n6) {
                                    Util.mult(fArray22[n6], n43, n44, f);
                                }
                                audioFile.writeFrames(fArray22, n43, n44);
                            }
                            this.setProgression((float)(l += (long)n44) / (float)l2);
                        }
                        for (n6 = 0; n6 < n13; ++n6) {
                            fArray3 = fArray22[n6];
                            for (n43 = n42; n43 < n46; ++n43) {
                                f5 = Math.abs(fArray3[n43]);
                                if (!(f5 > f2)) continue;
                                f2 = f5;
                            }
                            System.arraycopy(fArray3, n21, fArray3, 0, n29);
                        }
                        if (n42 > 0) {
                            n41 += Math.max(0, n46 - n42);
                            n42 = Math.max(0, n42 - n46);
                            continue;
                        }
                        n41 += n46;
                        continue;
                    }
                    break block71;
                }
                if (this.threadRunning) {
                    if (this.pr.intg[2] == 0) {
                        f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value;
                        f5 = 1.0f;
                        this.normalizeAudioFile(audioFile3, audioFile, fArray22, f, f5);
                        f2 *= f;
                        this.deleteTempFile(audioFile3);
                    }
                    if (this.threadRunning) {
                        audioFile.close();
                        audioFile = null;
                        audioFileDescr2 = null;
                        audioFile2.close();
                        audioFile2 = null;
                        audioFileDescr = null;
                        object = null;
                        fArray26 = null;
                        fArray27 = null;
                        fArray29 = null;
                        fArray10 = null;
                        fArray3 = null;
                        fArray2 = null;
                        fArray = null;
                        fArray28 = null;
                        fArray22 = null;
                        chebyTrackerArray = null;
                        this.handleClipping(f2);
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Object var34_11 = null;
                Object var35_16 = null;
                Object var37_47 = null;
                Object var38_43 = null;
                Object var39_98 = null;
                Object var40_96 = null;
                Object var41_94 = null;
                Object var42_60 = null;
                float[][] fArray = null;
                float[][] fArray31 = null;
                float[][] fArray32 = null;
                float[][] fArray33 = null;
                float[][][] fArray34 = null;
                Object var48_85 = null;
                Object var49_120 = null;
                Object var50_122 = null;
                float[][] fArray35 = null;
                float[][] fArray36 = null;
                ChebyTracker[][] chebyTrackerArray = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
            audioFile2 = null;
        }
        if (audioFile != null) {
            audioFile.cleanUp();
            audioFile = null;
        }
    }

    private static class ChebyTracker {
        float[] peakBuf;
        int peakBufLen;
        int peakBufStart;
        int peakBufOff;
        int peakValid;
        float peakValue;
        int peakScope;
        int harmonNum;
        float[] harmonWeight1;
        float[] harmonWeight2;
        float[] harmonWeight3;

        protected ChebyTracker() {
        }

        protected ChebyTracker(ChebyTracker chebyTracker) {
            this.peakBuf = (float[])chebyTracker.peakBuf.clone();
            this.peakBufLen = chebyTracker.peakBufLen;
            this.peakBufStart = chebyTracker.peakBufStart;
            this.peakBufOff = chebyTracker.peakBufOff;
            this.peakValid = chebyTracker.peakValid;
            this.peakValue = chebyTracker.peakValue;
            this.peakScope = chebyTracker.peakScope;
            this.harmonNum = chebyTracker.harmonNum;
            this.harmonWeight1 = (float[])chebyTracker.harmonWeight1.clone();
            this.harmonWeight2 = (float[])chebyTracker.harmonWeight2.clone();
            this.harmonWeight3 = (float[])chebyTracker.harmonWeight3.clone();
        }

        public Object clone() {
            return new ChebyTracker(this);
        }
    }
}

