/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class CircuitPanel
extends JPanel {
    public static final String ACTION_BOXSELECTED = "act";
    public static final String ACTION_BOXDESELECTED = "des";
    public static final String ACTION_BOXCREATED = "new";
    public static final String ACTION_BOXDELETED = "rem";
    public static final int TYPE_GROUND = 0;
    public static final int TYPE_SERIAL = 1;
    public static final int TYPE_PARALLEL = 2;
    public static final int TYPE_BOX = 3;
    protected Box currentBox = null;
    protected CircuitPanel ground;
    protected final Box protoType;
    protected final List<Object> boxes = new ArrayList<Object>();
    protected final Map<Object, JComponent> mapBoxToView;
    protected int typ;
    private Button actionComponent;
    private static final int DIR_WEST = 1;
    private static final int DIR_EAST = 2;
    private static final int DIR_NORTH = 16;
    private static final int DIR_SOUTH = 32;
    private static final Color colrConLight = new Color(0, 0, 0, 127);
    private static final Color colrConDark = new Color(255, 255, 255, 127);
    private GridBagLayout lay;
    private GridBagConstraints con;
    protected final CircuitPanel enc_cp = this;
    private final boolean isDark = UIManager.getBoolean("dark-skin");

    public CircuitPanel(Box box) {
        this.typ = 0;
        this.ground = this;
        this.actionComponent = new Button();
        this.protoType = box;
        this.mapBoxToView = new HashMap<Object, JComponent>();
        this.init();
        this.setCircuit("");
    }

    protected CircuitPanel(CircuitPanel circuitPanel, String string) {
        this.typ = string.charAt(0) - 48;
        this.ground = circuitPanel;
        this.protoType = circuitPanel.protoType;
        this.mapBoxToView = null;
        this.init();
        this.setCircuit(string);
    }

    public void repaintBox(Box box) {
        Component component = this.ground.mapBoxToView.get(box);
        if (component != null) {
            component.repaint();
        }
    }

    protected void insertBox(Object object, int n) {
        JComponent jComponent;
        if (object instanceof Box) {
            jComponent = new JToggleButton(new BoxAction((Box)object));
        } else if (object instanceof CircuitPanel) {
            jComponent = (CircuitPanel)object;
        } else {
            assert (false) : object.getClass().getName();
            jComponent = null;
        }
        this.con.gridx = 1;
        this.con.gridy = 1;
        switch (this.typ) {
            case 1: {
                this.con.gridx += n;
                break;
            }
            case 2: {
                this.con.gridy += n;
            }
        }
        this.lay.setConstraints(jComponent, this.con);
        this.add((Component)jComponent, n);
        this.boxes.add(n, object);
        this.ground.mapBoxToView.put(object, jComponent);
        int n2 = this.boxes.size();
        for (int i = ++n; i < n2; ++i) {
            Component component;
            switch (this.typ) {
                case 1: {
                    ++this.con.gridx;
                    break;
                }
                case 2: {
                    ++this.con.gridy;
                }
            }
            Object object2 = this.boxes.get(i);
            if (object2 instanceof Box) {
                component = this.ground.mapBoxToView.get(object2);
            } else if (object2 instanceof CircuitPanel) {
                component = (CircuitPanel)object2;
            } else {
                assert (false) : object2.getClass().getName();
                component = null;
            }
            this.lay.setConstraints(component, this.con);
        }
        if (this.isVisible()) {
            this.invalidate();
            this.ground.validate();
        }
        this.notifyListeners(ACTION_BOXCREATED);
    }

    protected void removeBox(int n) {
        Component component;
        Object object = this.boxes.remove(n);
        if (object instanceof Box) {
            component = this.ground.mapBoxToView.remove(object);
            if (component != null) {
                this.remove(component);
            }
        } else if (object instanceof CircuitPanel) {
            ((CircuitPanel)object).clear();
            this.remove((CircuitPanel)object);
        } else assert (false) : object.getClass().getName();
        this.con.gridx = 1;
        this.con.gridy = 1;
        switch (this.typ) {
            case 1: {
                this.con.gridx += n;
                break;
            }
            case 2: {
                this.con.gridy += n;
            }
        }
        int n2 = this.boxes.size();
        block8: for (int i = n; i < n2; ++i) {
            Object object2 = this.boxes.get(i);
            if (object2 instanceof Box) {
                component = this.ground.mapBoxToView.get(object2);
            } else if (object2 instanceof CircuitPanel) {
                component = (CircuitPanel)object2;
            } else {
                assert (false) : object2.getClass().getName();
                component = null;
            }
            this.lay.setConstraints(component, this.con);
            switch (this.typ) {
                case 1: {
                    ++this.con.gridx;
                    continue block8;
                }
                case 2: {
                    ++this.con.gridy;
                }
            }
        }
        if (this.isVisible()) {
            this.invalidate();
            this.ground.validate();
        }
        this.notifyListeners(ACTION_BOXDELETED);
    }

    private void clear() {
        while (!this.boxes.isEmpty()) {
            Object object = this.boxes.remove(0);
            if (object instanceof Box) {
                Component component = this.ground.mapBoxToView.remove(object);
                if (component == null) continue;
                this.remove(component);
                continue;
            }
            if (object instanceof CircuitPanel) {
                ((CircuitPanel)object).clear();
                this.remove((CircuitPanel)object);
                continue;
            }
            assert (false) : object.getClass().getName();
        }
    }

    private void init() {
        Border border;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!CircuitPanel.this.enc_cp.isEnabled()) {
                    return;
                }
                if (mouseEvent.getSource() == CircuitPanel.this.enc_cp && mouseEvent.getClickCount() == 2 && !mouseEvent.isAltDown()) {
                    Box box = CircuitPanel.this.ground.protoType.duplicate();
                    int n = CircuitPanel.this.boxes.size();
                    if (n == 0) {
                        CircuitPanel.this.insertBox(box, 0);
                    } else {
                        block0 : switch (CircuitPanel.this.typ) {
                            case 0: {
                                Component component;
                                Object object = CircuitPanel.this.boxes.get(0);
                                if (object instanceof Box) {
                                    component = CircuitPanel.this.ground.mapBoxToView.get(object);
                                } else if (object instanceof CircuitPanel) {
                                    component = (CircuitPanel)object;
                                } else {
                                    assert (false) : object.getClass().getName();
                                    component = null;
                                }
                                int n2 = CircuitPanel.this.calcDirection(component, mouseEvent.getX(), mouseEvent.getY());
                                if (n2 != 1 && n2 != 2 && n2 != 16 && n2 != 32) break;
                                boolean bl = n2 == 1 || n2 == 16;
                                CircuitPanel circuitPanel = new CircuitPanel(CircuitPanel.this.ground, (n2 == 1 || n2 == 2 ? 1 : 2) + CircuitPanel.this.encodeBox(bl ? box : CircuitPanel.this.boxes.get(0)) + CircuitPanel.this.encodeBox(bl ? CircuitPanel.this.boxes.get(0) : box));
                                CircuitPanel.this.removeBox(0);
                                CircuitPanel.this.insertBox(circuitPanel, 0);
                                break;
                            }
                            case 1: {
                                block15: for (int i = 0; i < n; ++i) {
                                    Component component;
                                    Object object = CircuitPanel.this.boxes.get(i);
                                    if (object instanceof Box) {
                                        component = CircuitPanel.this.ground.mapBoxToView.get(object);
                                    } else if (object instanceof CircuitPanel) {
                                        component = (CircuitPanel)object;
                                    } else {
                                        assert (false) : object.getClass().getName();
                                        component = null;
                                    }
                                    int n3 = CircuitPanel.this.calcDirection(component, mouseEvent.getX(), mouseEvent.getY());
                                    switch (n3) {
                                        case 16: 
                                        case 32: {
                                            boolean bl = n3 == 16;
                                            CircuitPanel circuitPanel = new CircuitPanel(CircuitPanel.this.ground, 2 + CircuitPanel.this.encodeBox(bl ? box : CircuitPanel.this.boxes.get(i)) + CircuitPanel.this.encodeBox(bl ? CircuitPanel.this.boxes.get(i) : box));
                                            CircuitPanel.this.removeBox(i);
                                            CircuitPanel.this.insertBox(circuitPanel, i);
                                            break block0;
                                        }
                                        case 1: {
                                            CircuitPanel.this.insertBox(box, i);
                                            break block0;
                                        }
                                        case 2: {
                                            if (i != n - 1) continue block15;
                                            CircuitPanel.this.insertBox(box, n);
                                            break block0;
                                        }
                                    }
                                }
                                break;
                            }
                            case 2: {
                                block16: for (int i = 0; i < n; ++i) {
                                    Component component;
                                    Object object = CircuitPanel.this.boxes.get(i);
                                    if (object instanceof Box) {
                                        component = CircuitPanel.this.ground.mapBoxToView.get(object);
                                    } else if (object instanceof CircuitPanel) {
                                        component = (CircuitPanel)object;
                                    } else {
                                        assert (false) : object.getClass().getName();
                                        component = null;
                                    }
                                    int n4 = CircuitPanel.this.calcDirection(component, mouseEvent.getX(), mouseEvent.getY());
                                    switch (n4) {
                                        case 1: 
                                        case 2: {
                                            boolean bl = n4 == 1;
                                            CircuitPanel circuitPanel = new CircuitPanel(CircuitPanel.this.ground, 1 + CircuitPanel.this.encodeBox(bl ? box : CircuitPanel.this.boxes.get(i)) + CircuitPanel.this.encodeBox(bl ? CircuitPanel.this.boxes.get(i) : box));
                                            CircuitPanel.this.removeBox(i);
                                            CircuitPanel.this.insertBox(circuitPanel, i);
                                            break block0;
                                        }
                                        case 16: {
                                            CircuitPanel.this.insertBox(box, i);
                                            break block0;
                                        }
                                        case 32: {
                                            if (i != n - 1) continue block16;
                                            CircuitPanel.this.insertBox(box, n);
                                            break block0;
                                        }
                                    }
                                }
                                break;
                            }
                        }
                    }
                    AbstractButton abstractButton = (AbstractButton)CircuitPanel.this.ground.mapBoxToView.get(box);
                    if (abstractButton != null) {
                        abstractButton.doClick();
                    }
                }
            }
        });
        Icon icon = this.ground.protoType.getIcon();
        this.setMinimumSize(new Dimension(icon.getIconWidth() + 8, icon.getIconHeight() + 8));
        if (this.ground == this) {
            border = BorderFactory.createEmptyBorder(2, 4, 2, 4);
        } else {
            Color color = this.isDark ? Color.darkGray : Color.lightGray;
            border = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(color, 2), BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }
        this.setBorder(border);
        this.lay = new GridBagLayout();
        this.con = new GridBagConstraints();
        this.con.gridx = 1;
        this.con.gridy = 1;
        this.con.gridwidth = 1;
        this.con.gridheight = 1;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.fill = 0;
        this.con.anchor = 10;
        this.con.insets = new Insets(3, 3, 3, 3);
        this.setLayout(this.lay);
    }

    public void setCircuit(String string) {
        this.clear();
        int n = 1;
        int n2 = this.parseNumBoxes(string, n);
        block4: for (int i = 0; i < n2; ++i) {
            int n3 = string.charAt(n++) - 48;
            String string2 = this.parseSettings(string, n);
            n += string2.length() + 2;
            Object object = null;
            switch (n3) {
                case 1: 
                case 2: {
                    object = new CircuitPanel(this.ground, string2);
                    break;
                }
                case 3: {
                    object = this.ground.protoType.fromString(string2);
                    break;
                }
                default: {
                    break block4;
                }
            }
            if (object == null) continue;
            this.insertBox(object, i);
        }
    }

    public String getCircuit() {
        return this.toString();
    }

    public Iterator getElements() {
        return this.boxes.iterator();
    }

    public int getType() {
        return this.typ;
    }

    public void addActionListener(ActionListener actionListener) {
        this.ground.actionComponent.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.ground.actionComponent.removeActionListener(actionListener);
    }

    public Box getActiveBox() {
        return this.ground.currentBox;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        int n = dimension.height >> 1;
        graphics.setColor(this.isDark ? colrConDark : colrConLight);
        if (this.typ != 1) {
            graphics.fillRect(2, n - 2, 2, 5);
            graphics.fillRect(dimension.width - 4, n - 2, 2, 5);
        }
        if (this.typ == 2) {
            Component[] componentArray = this.getComponents();
            int n2 = 0;
            int n3 = dimension.height;
            for (int i = 0; i < componentArray.length; ++i) {
                Rectangle rectangle = componentArray[i].getBounds();
                int n4 = rectangle.y + (rectangle.height >> 1);
                graphics.drawLine(4, n4, dimension.width - 5, n4);
                if (n4 < n3) {
                    n3 = n4;
                }
                if (n4 <= n2) continue;
                n2 = n4;
            }
            graphics.drawLine(3, n3, 3, n - 3);
            graphics.drawLine(3, n + 3, 3, n2);
            graphics.drawLine(dimension.width - 4, n3, dimension.width - 4, n - 3);
            graphics.drawLine(dimension.width - 4, n + 3, dimension.width - 4, n2);
        } else {
            graphics.drawLine(4, n, dimension.width - 5, n);
        }
    }

    protected void notifyListeners(String string) {
        ActionEvent actionEvent = new ActionEvent(this.ground, 1001, string);
        this.ground.actionComponent.dispatchEvent(actionEvent);
    }

    protected int calcDirection(Component component, int n, int n2) {
        Rectangle rectangle = component.getBounds();
        int n3 = 0;
        if (n < rectangle.x) {
            n3 = 1;
        } else if (n >= rectangle.x + rectangle.width) {
            n3 = 2;
        }
        if (n2 < rectangle.y) {
            n3 += 16;
        } else if (n2 >= rectangle.y + rectangle.height) {
            n3 += 32;
        }
        return n3;
    }

    private int parseNumBoxes(String string, int n) {
        int n2 = n;
        int n3 = 0;
        while (n2 < string.length()) {
            char c;
            if ((c = string.charAt(n2++)) != '{') continue;
            ++n3;
            int n4 = 1;
            while (n4 > 0 && n2 < string.length()) {
                if ((c = string.charAt(n2++)) == '{') {
                    ++n4;
                    continue;
                }
                if (c != '}') continue;
                --n4;
            }
            if (n4 == 0) continue;
            return 0;
        }
        return n3;
    }

    private String parseSettings(String string, int n) {
        int n2 = n;
        while (n2 < string.length()) {
            char c;
            if ((c = string.charAt(n2++)) != '{') continue;
            int n3 = n2;
            int n4 = 1;
            while (n4 > 0 && n2 < string.length()) {
                if ((c = string.charAt(n2++)) == '{') {
                    ++n4;
                    continue;
                }
                if (c != '}') continue;
                --n4;
            }
            if (n4 != 0) {
                return "";
            }
            int n5 = n2 - 1;
            return string.substring(n3, n5);
        }
        return "";
    }

    protected String encodeBox(Object object) {
        if (object instanceof Box) {
            return String.valueOf(3) + '{' + object.toString() + '}';
        }
        if (object instanceof CircuitPanel) {
            return String.valueOf(((CircuitPanel)object).typ) + '{' + object.toString() + '}';
        }
        assert (false) : object.getClass().getName();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.typ);
        List<Object> list = this.boxes;
        synchronized (list) {
            for (int i = 0; i < this.boxes.size(); ++i) {
                stringBuffer.append(this.encodeBox(this.boxes.get(i)));
            }
        }
        return stringBuffer.toString();
    }

    private class BoxAction
    extends AbstractAction {
        private Box box;

        protected BoxAction(Box box) {
            this.putValue("SmallIcon", box.getIcon());
            this.box = box;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if ((actionEvent.getModifiers() & 8) != 0) {
                int n;
                if (CircuitPanel.this.ground.currentBox != null) {
                    AbstractButton abstractButton2 = (AbstractButton)CircuitPanel.this.ground.mapBoxToView.get(CircuitPanel.this.ground.currentBox);
                    if (abstractButton2 != null) {
                        abstractButton2.setSelected(false);
                    }
                    CircuitPanel.this.ground.currentBox = null;
                    CircuitPanel.this.notifyListeners(CircuitPanel.ACTION_BOXDESELECTED);
                }
                if ((n = CircuitPanel.this.boxes.indexOf(this.box)) < 0) return;
                CircuitPanel.this.removeBox(n);
                if (CircuitPanel.this.enc_cp != CircuitPanel.this.ground && CircuitPanel.this.boxes.size() < 2) {
                    Object object = null;
                    if (CircuitPanel.this.boxes.size() == 1) {
                        object = CircuitPanel.this.boxes.get(0);
                        CircuitPanel.this.removeBox(0);
                    }
                    CircuitPanel circuitPanel = (CircuitPanel)CircuitPanel.this.enc_cp.getParent();
                    int n2 = circuitPanel.boxes.indexOf(CircuitPanel.this.enc_cp);
                    circuitPanel.removeBox(n2);
                    if (object == null) return;
                    circuitPanel.insertBox(object, n2);
                    return;
                }
                if (!CircuitPanel.this.boxes.isEmpty()) return;
                return;
            } else {
                if (abstractButton.isSelected()) {
                    AbstractButton abstractButton3;
                    if (CircuitPanel.this.ground.currentBox != null && (abstractButton3 = (AbstractButton)CircuitPanel.this.ground.mapBoxToView.get(CircuitPanel.this.ground.currentBox)) != null && abstractButton3 != abstractButton) {
                        abstractButton3.setSelected(false);
                    }
                    CircuitPanel.this.ground.currentBox = this.box;
                    CircuitPanel.this.notifyListeners(CircuitPanel.ACTION_BOXSELECTED);
                    return;
                }
                if (CircuitPanel.this.ground.currentBox == this.box) {
                    CircuitPanel.this.ground.currentBox = null;
                }
                CircuitPanel.this.notifyListeners(CircuitPanel.ACTION_BOXDESELECTED);
            }
        }
    }

    public static interface Box {
        public Icon getIcon();

        public Box duplicate();

        public String toString();

        public Box fromString(String var1);
    }
}

