/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamEvent;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.ParamListener;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.gui.PathEvent;
import de.sciss.gui.PathListener;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ComplexConvDlg
extends ModulePanel {
    private static final int PR_REINPUTFILE = 0;
    private static final int PR_IMINPUTFILE = 1;
    private static final int PR_REIMPFILE = 2;
    private static final int PR_IMIMPFILE = 3;
    private static final int PR_REOUTPUTFILE = 4;
    private static final int PR_IMOUTPUTFILE = 5;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_GAIN = 0;
    private static final int PR_MEMORY = 1;
    private static final int PR_HASIMINPUT = 0;
    private static final int PR_HASIMIMPULSE = 1;
    private static final int PR_HASIMOUTPUT = 2;
    private static final int PR_CEPSTRAL1 = 3;
    private static final int PR_CEPSTRAL2 = 4;
    private static final String PRN_REINPUTFILE = "ReInFile";
    private static final String PRN_IMINPUTFILE = "ImInFile";
    private static final String PRN_REIMPFILE = "ReImpFile";
    private static final String PRN_IMIMPFILE = "ImImpFile";
    private static final String PRN_REOUTPUTFILE = "ReOutFile";
    private static final String PRN_IMOUTPUTFILE = "ImOutFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_HASIMINPUT = "HasImInput";
    private static final String PRN_HASIMIMPULSE = "HasImImp";
    private static final String PRN_HASIMOUTPUT = "HasImOutput";
    private static final String PRN_CEPSTRAL1 = "Cepstral1";
    private static final String PRN_CEPSTRAL2 = "Cepstral2";
    private static final String PRN_MEMORY = "Memory";
    private static final String[] prText = new String[]{"", "", "", "", "", ""};
    private static final String[] prTextName = new String[]{"ReInFile", "ImInFile", "ReImpFile", "ImImpFile", "ReOutFile", "ImOutFile"};
    private static final int[] prIntg = new int[]{0, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType"};
    private static final Param[] prPara = new Param[]{null, null};
    private static final String[] prParaName = new String[]{"Gain", "Memory"};
    private static final boolean[] prBool = new boolean[]{false, false, false, false, false};
    private static final String[] prBoolName = new String[]{"HasImInput", "HasImImp", "HasImOutput", "Cepstral1", "Cepstral2"};
    private static final int GG_REINPUTFILE = 1024;
    private static final int GG_IMINPUTFILE = 1025;
    private static final int GG_REIMPFILE = 1026;
    private static final int GG_IMIMPFILE = 1027;
    private static final int GG_REOUTPUTFILE = 1028;
    private static final int GG_IMOUTPUTFILE = 1029;
    private static final int GG_GAIN = 512;
    private static final int GG_MEMORY = 513;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_HASIMINPUT = 0;
    private static final int GG_HASIMIMPULSE = 1;
    private static final int GG_HASIMOUTPUT = 2;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private JTextField ggInfo;
    protected ParamField ggMemory;
    protected final long[] guiInLength = new long[4];
    protected final int[] inChanNum = new int[4];

    public ComplexConvDlg() {
        super("Complex Convolution");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        PathField[] pathFieldArray;
        int n;
        if (static_pr == null) {
            static_pr = new PropertyArray();
            ComplexConvDlg.static_pr.text = prText;
            ComplexConvDlg.static_pr.textName = prTextName;
            ComplexConvDlg.static_pr.intg = prIntg;
            ComplexConvDlg.static_pr.intgName = prIntgName;
            ComplexConvDlg.static_pr.para = prPara;
            ComplexConvDlg.static_pr.para[1] = new Param(32.0, 0);
            ComplexConvDlg.static_pr.paraName = prParaName;
            ComplexConvDlg.static_pr.bool = prBool;
            ComplexConvDlg.static_pr.boolName = prBoolName;
            this.fillDefaultAudioDescr(ComplexConvDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(ComplexConvDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = ComplexConvDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case 0: 
                    case 1: {
                        ((ComplexConvDlg)ComplexConvDlg.this).pr.bool[n - 0] = ((JCheckBox)itemEvent.getSource()).isSelected();
                        ComplexConvDlg.this.reflectPropertyChanges();
                        ComplexConvDlg.this.recalcSteps();
                        break;
                    }
                    case 2: {
                        ((ComplexConvDlg)ComplexConvDlg.this).pr.bool[n - 0] = ((JCheckBox)itemEvent.getSource()).isSelected();
                        ComplexConvDlg.this.reflectPropertyChanges();
                    }
                }
            }
        };
        PathListener pathListener = new PathListener(){

            public void pathChanged(PathEvent pathEvent) {
                int n = ComplexConvDlg.this.gui.getItemID((EventObject)pathEvent);
                switch (n) {
                    case 1024: {
                        int n2 = 0;
                        break;
                    }
                    case 1025: {
                        int n2 = 1;
                        break;
                    }
                    case 1026: {
                        int n2 = 2;
                        break;
                    }
                    case 1027: {
                        int n2 = 3;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                try {
                    AudioFile audioFile = AudioFile.openAsRead((File)pathEvent.getPath());
                    AudioFileDescr audioFileDescr = audioFile.getDescr();
                    audioFile.close();
                    ComplexConvDlg.this.guiInLength[n2] = audioFileDescr.length;
                    ComplexConvDlg.this.inChanNum[n2] = audioFileDescr.channels;
                }
                catch (IOException iOException) {
                    ComplexConvDlg.this.guiInLength[n2] = 0L;
                    ComplexConvDlg.this.inChanNum[n2] = 0;
                }
                ComplexConvDlg.this.recalcSteps();
            }
        };
        ParamListener paramListener = new ParamListener(){

            @Override
            public void paramChanged(ParamEvent paramEvent) {
                if (paramEvent.getSource() == ComplexConvDlg.this.ggMemory) {
                    ((ComplexConvDlg)ComplexConvDlg.this).pr.para[1] = paramEvent.getParam();
                    ComplexConvDlg.this.recalcSteps();
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField[] pathFieldArray2 = new PathField[2];
        for (n = 0; n < 2; ++n) {
            PathField pathField = new PathField(16, "Select real part of input");
            pathField.handleTypes(GenericFile.TYPES_SOUND);
            pathFieldArray2[n] = pathField;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.1;
            this.gui.addLabel(new JLabel("Input " + (n + 1) + " [Real]", 4));
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 0.9;
            this.gui.addPathField(pathField, 1024 + (n << 1), pathListener);
            PathField pathField2 = new PathField(16, "Select imaginary part of input");
            pathField2.handleTypes(GenericFile.TYPES_SOUND);
            pathFieldArray = new PathField[]{pathField};
            pathField2.deriveFrom(pathFieldArray, "$D0$F0i$X0");
            JCheckBox jCheckBox = new JCheckBox("Input " + (n + 1) + " [Imaginary]");
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.1;
            int n2 = gridBagConstraints.anchor;
            gridBagConstraints.anchor = 13;
            this.gui.addCheckbox(jCheckBox, 0 + (n << 1), itemListener);
            gridBagConstraints.anchor = n2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 0.9;
            this.gui.addPathField(pathField2, 1025 + (n << 1), pathListener);
        }
        PathField pathField = new PathField(49, "Select output for real part");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output [Real]", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1028, pathListener);
        this.gui.registerGadget(pathField.getTypeGadget(), 256);
        this.gui.registerGadget(pathField.getResGadget(), 257);
        PathField pathField3 = new PathField(1, "Select output for imaginary part");
        JCheckBox jCheckBox = new JCheckBox("Output [Imaginary]");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        n = gridBagConstraints.anchor;
        gridBagConstraints.anchor = 13;
        this.gui.addCheckbox(jCheckBox, 2, itemListener);
        gridBagConstraints.anchor = n;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1029, pathListener);
        pathFieldArray = new PathField[]{pathField};
        pathField.deriveFrom(pathFieldArray2, "$D0$B0Con$B1$E");
        pathField3.deriveFrom(pathFieldArray, "$D0$F0i$X0");
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, paramListener);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, itemListener);
        this.ggMemory = new ParamField(new ParamSpace(1.0, 2047.0, 1.0, 0));
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Mem.alloc. [MB]", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(this.ggMemory, 513, paramListener);
        this.ggInfo = new JTextField(32);
        this.ggInfo.setEditable(false);
        this.ggInfo.setBackground(null);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("\u2192", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addGadget(this.ggInfo, 2048);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
        int n = 0;
        int n2 = 0;
        while (n < 3) {
            try {
                AudioFile audioFile = AudioFile.openAsRead((File)new File(this.pr.text[n]));
                AudioFileDescr audioFileDescr = audioFile.getDescr();
                audioFile.close();
                this.guiInLength[n2] = audioFileDescr.length;
                this.inChanNum[n2] = audioFileDescr.channels;
            }
            catch (IOException iOException) {
                this.guiInLength[n2] = 0L;
                this.inChanNum[n2] = 0;
            }
            ++n;
            ++n2;
        }
        this.recalcSteps();
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        block103: {
            float[] fArray;
            float[][] fArray2;
            float[][] fArray3;
            float f = (float)Math.PI;
            AudioFile[] audioFileArray = new AudioFile[2];
            AudioFile[] audioFileArray2 = new AudioFile[2];
            AudioFile audioFile = null;
            AudioFile audioFile2 = null;
            AudioFileDescr[] audioFileDescrArray = new AudioFileDescr[2];
            AudioFileDescr[] audioFileDescrArray2 = new AudioFileDescr[2];
            AudioFileDescr audioFileDescr = null;
            AudioFileDescr audioFileDescr2 = null;
            AudioFile[] audioFileArray3 = new AudioFile[4];
            long[] lArray = new long[2];
            float f2 = 0.0f;
            try {
                float f3;
                int n;
                float[] fArray4;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                boolean bl = this.pr.text[0].equals(this.pr.text[2]) && this.pr.bool[0] == this.pr.bool[1] && (!this.pr.bool[0] || this.pr.text[1].equals(this.pr.text[3])) && this.pr.bool[3] == this.pr.bool[4];
                int n7 = 0;
                int n8 = 0;
                while (n7 < (bl ? 1 : 2)) {
                    audioFileArray[n7] = AudioFile.openAsRead((File)new File(this.pr.text[0 + n8]));
                    audioFileDescrArray[n7] = audioFileArray[n7].getDescr();
                    this.inChanNum[n7] = audioFileDescrArray[n7].channels;
                    lArray[n7] = audioFileDescrArray[n7].length;
                    if (this.pr.bool[0 + n7]) {
                        audioFileArray2[n7] = AudioFile.openAsRead((File)new File(this.pr.text[1 + n8]));
                        audioFileDescrArray2[n7] = audioFileArray2[n7].getDescr();
                        if (audioFileDescrArray2[n7].channels != this.inChanNum[n7]) {
                            throw new IOException("Real and imaginary file must\nhave same # of channels");
                        }
                        lArray[n7] = Math.min(lArray[n7], audioFileDescrArray2[n7].length);
                    }
                    if (lArray[n7] * (long)this.inChanNum[n7] < 1L) {
                        throw new EOFException("File is empty");
                    }
                    ++n7;
                    n8 += 2;
                }
                if (!this.threadRunning) break block103;
                if (bl) {
                    this.inChanNum[1] = this.inChanNum[0];
                    lArray[1] = lArray[0];
                    audioFileDescrArray[1] = audioFileDescrArray[0];
                    audioFileDescrArray2[1] = audioFileDescrArray2[0];
                }
                int n9 = Math.max(this.inChanNum[0], this.inChanNum[1]);
                Descriptor descriptor = this.initDescriptor(lArray, n9);
                PathField pathField = (PathField)this.gui.getItemObj(1028);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr = new AudioFileDescr(audioFileDescrArray[0]);
                pathField.fillStream(audioFileDescr);
                audioFileDescr.channels = n9;
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr);
                if (this.pr.bool[2]) {
                    audioFileDescr2 = new AudioFileDescr(audioFileDescrArray[0]);
                    pathField.fillStream(audioFileDescr2);
                    audioFileDescr2.channels = n9;
                    audioFileDescr2.file = new File(this.pr.text[5]);
                    audioFile2 = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr2);
                }
                if (!this.threadRunning) break block103;
                int n10 = descriptor.inputLen[0] + descriptor.inputLen[1] - 1;
                long l = lArray[0] + lArray[1] - 1L;
                int n11 = descriptor.complex ? descriptor.fftSize << 1 : descriptor.fftSize;
                fArray3 = new float[n9][n11 + 2];
                fArray2 = new float[n9][8192];
                long l2 = 0L;
                long l3 = this.pr.bool[2] ? l << 1 : l;
                for (n7 = 0; n7 < (bl ? 1 : 2); ++n7) {
                    l3 += lArray[n7] + (long)n11 * (long)descriptor.steps[n7] * 2L;
                }
                long l4 = 0L;
                for (n6 = 0; n6 < descriptor.steps[0]; ++n6) {
                    for (n5 = 0; n5 < descriptor.steps[1]; ++n5) {
                        l3 += (long)(3 * n11);
                        long l5 = (long)n6 * (long)descriptor.inputLen[0] + (long)n5 * (long)descriptor.inputLen[1];
                        l3 += Math.min(l4 - l5, (long)n10);
                        n4 = (int)Math.min((long)n10, l - l5);
                        l3 += (long)n4;
                        l4 = Math.max(l4, l5 + (long)n4);
                    }
                }
                for (n6 = 0; n6 < 2; ++n6) {
                    audioFileArray3[n6] = this.createTempFile(audioFileDescrArray[n6]);
                }
                for (n6 = 2; n6 < (descriptor.complex ? 4 : 3); ++n6) {
                    audioFileArray3[n6] = this.createTempFile(n9, audioFileDescrArray[0].rate);
                }
                for (n6 = 0; this.threadRunning && n6 < (bl ? 1 : 2); ++n6) {
                    boolean bl2;
                    audioFileArray[n6].seekFrame(0L);
                    boolean bl3 = bl2 = this.pr.bool[0 + n6] || this.pr.bool[3 + n6];
                    if (audioFileArray2[n6] != null) {
                        audioFileArray2[n6].seekFrame(0L);
                    }
                    long l6 = 0L;
                    while (this.threadRunning && l6 < lArray[n6]) {
                        int n12;
                        n4 = (int)Math.min((long)descriptor.inputLen[n6], lArray[n6] - l6);
                        for (n2 = 0; this.threadRunning && n2 < n4; n2 += n3) {
                            n3 = Math.min(8192, n4 - n2);
                            audioFileArray[n6].readFrames(fArray2, 0, n3);
                            if (bl2) {
                                for (n5 = 0; n5 < this.inChanNum[n6]; ++n5) {
                                    fArray = fArray2[n5];
                                    fArray4 = fArray3[n5];
                                    n12 = n2 << 1;
                                    n = 0;
                                    while (n < n3) {
                                        fArray4[n12] = fArray[n];
                                        ++n;
                                        n12 += 2;
                                    }
                                    if (audioFileArray2[n6] == null) continue;
                                    audioFileArray2[n6].readFrames(fArray2, 0, n3);
                                    n12 = (n2 << 1) + 1;
                                    n = 0;
                                    while (n < n3) {
                                        fArray4[n12] = fArray[n];
                                        ++n;
                                        n12 += 2;
                                    }
                                }
                            } else {
                                for (n5 = 0; n5 < this.inChanNum[n6]; ++n5) {
                                    System.arraycopy(fArray2[n5], 0, fArray3[n5], n2, n3);
                                }
                            }
                            l6 += (long)n3;
                            this.setProgression((float)(l2 += (long)n3) / (float)l3);
                        }
                        if (!this.threadRunning) break block103;
                        for (n5 = 0; n5 < this.inChanNum[n6]; ++n5) {
                            fArray4 = fArray3[n5];
                            if (bl2) {
                                n12 = n4 << 1;
                                while (n12 < n11) {
                                    fArray4[n12++] = 0.0f;
                                }
                            } else {
                                n12 = n4;
                                while (n12 < descriptor.fftSize) {
                                    fArray4[n12++] = 0.0f;
                                }
                            }
                            if (bl2) {
                                if (this.pr.bool[3 + n6]) {
                                    if (this.pr.bool[0 + n6]) {
                                        Fourier.rect2Polar(fArray4, 0, fArray4, 0, n11);
                                        for (n12 = 0; n12 < n11; n12 += 2) {
                                            f3 = fArray4[n12];
                                            fArray4[n12] = f3 > 1.2664166E-14f ? (float)Math.log(f3) : -32.0f;
                                        }
                                    } else {
                                        n12 = 0;
                                        while (n12 < n11) {
                                            f3 = fArray4[n12];
                                            if (f3 > 1.2664166E-14f) {
                                                fArray4[n12++] = (float)Math.log(f3);
                                                fArray4[n12++] = 0.0f;
                                                continue;
                                            }
                                            if (f3 < -1.2664166E-14f) {
                                                fArray4[n12++] = (float)Math.log(-f3);
                                                fArray4[n12++] = f;
                                                continue;
                                            }
                                            fArray4[n12++] = -32.0f;
                                            fArray4[n12++] = 0.0f;
                                        }
                                    }
                                }
                                Fourier.complexTransform(fArray4, descriptor.fftSize, 1);
                                continue;
                            }
                            Fourier.realTransform(fArray4, descriptor.fftSize, 1);
                            if (!descriptor.complex) continue;
                            n12 = descriptor.fftSize;
                            n = descriptor.fftSize;
                            while (n12 > 0) {
                                fArray4[n] = fArray4[n12];
                                fArray4[n + 1] = -fArray4[n12 + 1];
                                n12 -= 2;
                                n += 2;
                            }
                        }
                        n4 = n11;
                        this.setProgression((float)(l2 += (long)n4) / (float)l3);
                        if (this.threadRunning) {
                            for (n2 = 0; this.threadRunning && n2 < n4; n2 += n3) {
                                n3 = Math.min(8192, n4 - n2);
                                audioFileArray3[n6].writeFrames(fArray3, n2, n3);
                                this.setProgression((float)(l2 += (long)n3) / (float)l3);
                            }
                            if (this.threadRunning) continue;
                        }
                        break block103;
                    }
                    audioFileArray[n6].close();
                    audioFileArray[n6] = null;
                    if (audioFileArray2[n6] == null) continue;
                    audioFileArray2[n6].close();
                    audioFileArray2[n6] = null;
                }
                long l7 = 0L;
                for (n6 = 0; this.threadRunning && n6 < descriptor.steps[0]; ++n6) {
                    for (n5 = 0; this.threadRunning && n5 < descriptor.steps[1]; ++n5) {
                        int n13;
                        int n14;
                        AudioFile audioFile3 = audioFileArray3[0];
                        audioFile3.seekFrame((long)n6 * (long)n11);
                        n4 = n11;
                        for (n2 = 0; this.threadRunning && n2 < n4; n2 += n3) {
                            n3 = Math.min(8192, n4 - n2);
                            audioFile3.readFrames(fArray3, n2, n3);
                            this.setProgression((float)(l2 += (long)n3) / (float)l3);
                        }
                        if (!this.threadRunning) break block103;
                        audioFile3 = audioFileArray3[bl ? 0 : 1];
                        audioFile3.seekFrame((long)n5 * (long)n11);
                        for (n2 = 0; this.threadRunning && n2 < n4; n2 += n3) {
                            n3 = Math.min(8192, n4 - n2);
                            audioFile3.readFrames(fArray2, 0, n3);
                            for (int i = n9 - 1; i >= 0; --i) {
                                Fourier.complexMult(fArray2[i % this.inChanNum[1]], 0, fArray3[i % this.inChanNum[0]], n2, fArray3[i], n2, n3);
                            }
                            this.setProgression((float)(l2 += (long)n3) / (float)l3);
                        }
                        if (!this.threadRunning) break block103;
                        for (int i = 0; i < n9; ++i) {
                            fArray4 = fArray3[i];
                            if (descriptor.complex) {
                                Fourier.complexTransform(fArray4, descriptor.fftSize, -1);
                                for (n = 0; n < 2; ++n) {
                                    if (!this.pr.bool[3 + n]) continue;
                                    for (n14 = 0; n14 < n11; n14 += 2) {
                                        fArray4[n14] = (float)Math.exp(fArray4[n14]);
                                    }
                                    Fourier.polar2Rect(fArray4, 0, fArray4, 0, n11);
                                }
                                continue;
                            }
                            Fourier.realTransform(fArray4, descriptor.fftSize, -1);
                        }
                        n4 = n11;
                        this.setProgression((float)(l2 += (long)n4) / (float)l3);
                        if (!this.threadRunning) break block103;
                        long l8 = (long)n6 * (long)descriptor.inputLen[0] + (long)n5 * (long)descriptor.inputLen[1];
                        audioFileArray3[2].seekFrame(l8);
                        if (descriptor.complex) {
                            audioFileArray3[3].seekFrame(l8);
                        }
                        n4 = (int)Math.min(l7 - l8, (long)n10);
                        for (n2 = 0; this.threadRunning && n2 < n4; n2 += n3) {
                            n3 = Math.min(8192, n4 - n2);
                            audioFileArray3[2].readFrames(fArray2, 0, n3);
                            if (descriptor.complex) {
                                int n15;
                                for (n14 = 0; n14 < n9; ++n14) {
                                    fArray = fArray2[n14];
                                    fArray4 = fArray3[n14];
                                    n15 = 0;
                                    n13 = n2 << 1;
                                    while (n15 < n3) {
                                        int n16 = n13;
                                        fArray4[n16] = fArray4[n16] + fArray[n15];
                                        ++n15;
                                        n13 += 2;
                                    }
                                }
                                audioFileArray3[3].readFrames(fArray2, 0, n3);
                                for (n14 = 0; n14 < n9; ++n14) {
                                    fArray = fArray2[n14];
                                    fArray4 = fArray3[n14];
                                    n15 = 0;
                                    n13 = (n2 << 1) + 1;
                                    while (n15 < n3) {
                                        int n17 = n13;
                                        fArray4[n17] = fArray4[n17] + fArray[n15];
                                        ++n15;
                                        n13 += 2;
                                    }
                                }
                            } else {
                                for (n14 = 0; n14 < n9; ++n14) {
                                    Util.add(fArray2[n14], 0, fArray3[n14], n2, n3);
                                }
                            }
                            this.setProgression((float)(l2 += (long)n3) / (float)l3);
                        }
                        if (!this.threadRunning) break block103;
                        audioFileArray3[2].seekFrame(l8);
                        if (descriptor.complex) {
                            audioFileArray3[3].seekFrame(l8);
                        }
                        n4 = (int)Math.min((long)n10, l - l8);
                        long l9 = l8 + (long)n4;
                        if (n5 < descriptor.steps[1] - 1) {
                            l9 = Math.min(l9, l8 + (long)descriptor.inputLen[1]);
                        }
                        if (n6 < descriptor.steps[0] - 1) {
                            l9 = Math.min(l9, (long)(n6 + 1) * (long)descriptor.inputLen[0]);
                        }
                        int n18 = (int)(l9 - l8);
                        n2 = 0;
                        while (this.threadRunning && n2 < n4) {
                            int n19;
                            int n20;
                            n3 = Math.min(8192, n4 - n2);
                            if (descriptor.complex) {
                                for (n13 = 0; n13 < n9; ++n13) {
                                    fArray = fArray2[n13];
                                    fArray4 = fArray3[n13];
                                    n20 = 0;
                                    n19 = (n2 << 1) + 1;
                                    while (n20 < n3) {
                                        fArray[n20] = fArray4[n19];
                                        ++n20;
                                        n19 += 2;
                                    }
                                }
                                audioFileArray3[3].writeFrames(fArray2, 0, n3);
                                if (this.pr.bool[2]) {
                                    for (n13 = 0; n13 < n9; ++n13) {
                                        fArray = fArray2[n13];
                                        n20 = Math.min(n3, n18);
                                        while (n20 > 0) {
                                            if (!((f3 = Math.abs(fArray[--n20])) > f2)) continue;
                                            f2 = f3;
                                        }
                                    }
                                }
                                for (n13 = 0; n13 < n9; ++n13) {
                                    fArray = fArray2[n13];
                                    fArray4 = fArray3[n13];
                                    n20 = 0;
                                    n19 = n2 << 1;
                                    while (n20 < n3) {
                                        fArray[n20] = fArray4[n19];
                                        ++n20;
                                        n19 += 2;
                                    }
                                }
                                audioFileArray3[2].writeFrames(fArray2, 0, n3);
                                for (n13 = 0; n13 < n9; ++n13) {
                                    fArray = fArray2[n13];
                                    n20 = Math.min(n3, n18);
                                    while (n20 > 0) {
                                        if (!((f3 = Math.abs(fArray[--n20])) > f2)) continue;
                                        f2 = f3;
                                    }
                                }
                            } else {
                                audioFileArray3[2].writeFrames(fArray3, n2, n3);
                                for (n13 = 0; n13 < n9; ++n13) {
                                    fArray4 = fArray3[n13];
                                    n20 = n2;
                                    n19 = Math.min(n3, n18) + n2;
                                    while (n20 < n19) {
                                        int n21 = n20++;
                                        f3 = Math.abs(fArray4[n21]);
                                        if (!(f3 > f2)) continue;
                                        f2 = f3;
                                    }
                                }
                            }
                            n2 += n3;
                            n18 -= n3;
                            this.setProgression((float)(l2 += (long)n3) / (float)l3);
                        }
                        if (this.threadRunning) {
                            l7 = Math.max(l7, l8 + (long)n4);
                            continue;
                        }
                        break block103;
                    }
                }
                for (n6 = 0; n6 < 2; ++n6) {
                    if (audioFileArray3[n6] == null) continue;
                    this.deleteTempFile(audioFileArray3[n6]);
                }
                if (this.threadRunning) {
                    Param param = this.pr.intg[2] == 0 ? new Param(1.0 / (double)f2, 1) : new Param(1.0, 1);
                    float f4 = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                    f3 = audioFile2 != null ? (1.0f + this.getProgression()) / 2.0f : 1.0f;
                    this.normalizeAudioFile(audioFileArray3[2], audioFile, fArray2, f4, f3);
                    if (audioFile2 != null) {
                        this.normalizeAudioFile(audioFileArray3[3], audioFile2, fArray2, f4, 1.0f);
                    }
                    f2 *= f4;
                    for (n6 = 2; n6 < 4; ++n6) {
                        if (audioFileArray3[n6] == null) continue;
                        this.deleteTempFile(audioFileArray3[n6]);
                    }
                    if (this.threadRunning) {
                        audioFile.close();
                        audioFile = null;
                        if (audioFile2 != null) {
                            audioFile2.close();
                            audioFile2 = null;
                        }
                        this.handleClipping(f2);
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                fArray = null;
                fArray3 = null;
                fArray2 = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
            finally {
                for (int i = 0; i < 2; ++i) {
                    if (audioFileArray[i] != null) {
                        audioFileArray[i].cleanUp();
                    }
                    if (audioFileArray2[i] == null) continue;
                    audioFileArray2[i].cleanUp();
                }
                if (audioFile != null) {
                    audioFile.cleanUp();
                }
                if (audioFile2 != null) {
                    audioFile2.cleanUp();
                }
            }
        }
    }

    protected void recalcSteps() {
        int n = Math.max(this.inChanNum[0], this.inChanNum[2]);
        long[] lArray = new long[]{this.pr.bool[0] ? Math.min(this.guiInLength[0], this.guiInLength[1]) : this.guiInLength[0], this.pr.bool[1] ? Math.min(this.guiInLength[2], this.guiInLength[3]) : this.guiInLength[2]};
        if (n > 0 && lArray[0] > 0L && lArray[1] > 0L) {
            Descriptor descriptor = this.initDescriptor(lArray, n);
            this.ggInfo.setText("process divided into " + descriptor.totalSteps + " steps.");
        } else {
            this.ggInfo.setText(null);
        }
    }

    private Descriptor initDescriptor(long[] lArray, int n) {
        Descriptor descriptor = new Descriptor();
        boolean bl = this.pr.text[0].equals(this.pr.text[2]) && this.pr.bool[0] == this.pr.bool[1] && (!this.pr.bool[0] || this.pr.text[1].equals(this.pr.text[3])) && this.pr.bool[3] == this.pr.bool[4];
        descriptor.complex = this.pr.bool[0] || this.pr.bool[1] || this.pr.bool[2] || this.pr.bool[3] || this.pr.bool[4];
        int n2 = (int)Math.min(0x3FFFFFFFL, ((long)this.pr.para[1].value * 1024L * 1024L >> (descriptor.complex ? 5 : 4)) * 3L / (long)n);
        descriptor.fftSize = 32;
        while (descriptor.fftSize <= n2) {
            descriptor.fftSize <<= 1;
        }
        if (!bl) {
            long l = lArray[0];
            long l2 = (lArray[0] * lArray[1] + 1L) * (long)descriptor.fftSize * (long)descriptor.fftSize;
            long l3 = Long.MAX_VALUE;
            int n3 = 0;
            long l4 = 0L;
            do {
                descriptor.fftSize >>= 1;
                int n4 = (int)Math.min(lArray[0], (long)(descriptor.fftSize + 1) - Math.min(32L, lArray[1]));
                long l5 = lArray[0] * lArray[1] + 1L;
                l = lArray[0];
                for (int i = (int)Math.min(32L, lArray[0]); i < n4; i += 512) {
                    descriptor.inputLen[0] = i;
                    descriptor.inputLen[1] = (int)Math.min(lArray[1], (long)(descriptor.fftSize + 1 - i));
                    descriptor.steps[0] = (int)((lArray[0] + (long)descriptor.inputLen[0] - 1L) / (long)descriptor.inputLen[0]);
                    descriptor.steps[1] = (int)((lArray[1] + (long)descriptor.inputLen[1] - 1L) / (long)descriptor.inputLen[1]);
                    descriptor.totalSteps = (long)descriptor.steps[0] * (long)descriptor.steps[1] + (long)descriptor.steps[0] + (long)descriptor.steps[1];
                    if (descriptor.totalSteps >= l5) continue;
                    l = i;
                    l5 = descriptor.totalSteps;
                }
                l2 = (long)((double)(l5 * (long)descriptor.fftSize) * Math.log(descriptor.fftSize));
                if (l2 >= l3) continue;
                l3 = l2;
                n3 = descriptor.fftSize;
                l4 = l;
            } while (descriptor.fftSize > 32);
            descriptor.fftSize = n3;
            descriptor.inputLen[0] = (int)l4;
            descriptor.inputLen[1] = (int)Math.min(lArray[1], (long)(descriptor.fftSize + 1 - descriptor.inputLen[0]));
        } else {
            long l = lArray[0] << 2;
            while ((long)descriptor.fftSize >= l) {
                descriptor.fftSize >>= 1;
            }
            descriptor.inputLen[0] = (int)Math.min(lArray[0], (long)(descriptor.fftSize >> 1));
            descriptor.inputLen[1] = descriptor.inputLen[0];
        }
        descriptor.steps[0] = (int)((lArray[0] + (long)descriptor.inputLen[0] - 1L) / (long)descriptor.inputLen[0]);
        descriptor.steps[1] = (int)((lArray[1] + (long)descriptor.inputLen[1] - 1L) / (long)descriptor.inputLen[1]);
        descriptor.totalSteps = (long)descriptor.steps[0] * (long)descriptor.steps[1];
        return descriptor;
    }

    @Override
    protected void reflectPropertyChanges() {
        super.reflectPropertyChanges();
        Component component = this.gui.getItemObj(1025);
        if (component != null) {
            component.setEnabled(this.pr.bool[0]);
        }
        if ((component = this.gui.getItemObj(1027)) != null) {
            component.setEnabled(this.pr.bool[1]);
        }
        boolean bl = this.pr.bool[0] || this.pr.bool[1];
        component = this.gui.getItemObj(2);
        if (component != null) {
            component.setEnabled(bl);
        }
        if ((component = this.gui.getItemObj(1029)) != null) {
            component.setEnabled(bl && this.pr.bool[2]);
        }
    }

    protected static class Descriptor {
        int fftSize;
        long totalSteps;
        boolean complex;
        int[] inputLen = new int[2];
        int[] steps = new int[2];

        protected Descriptor() {
        }
    }
}

