/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.BasicDialog;
import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.gui.ToolIcon;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.prop.PropertyArray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class EditOpDlg
extends BasicDialog {
    public static final int GG_PRESETS = 1;
    public static final int GG_ADDPRESET = 2;
    public static final int GG_DELPRESET = 3;
    public static final int GG_SPECTROGRAM = 4;
    public static final int GG_NORMALIZE = 5;
    public static final int GG_OPPREFS = 6;
    public static final int GG_OK = 7;
    public static final int GG_CANCEL = 8;
    private Operator op;
    private PropertyGUI opGUI;
    private boolean choice = false;
    private final EditOpDlg enc_this = this;

    public EditOpDlg(Component component, Operator operator) {
        super(component, "Edit Operator: " + operator.getIcon().getName(), true, operator.getClass().getName().substring(operator.getClass().getName().lastIndexOf(46) + 1));
        this.op = operator;
        GUISupport gUISupport = new GUISupport();
        GridBagConstraints gridBagConstraints = gUISupport.getGridBagConstraints();
        GridBagLayout gridBagLayout = gUISupport.getGridBagLayout();
        EditOpDlgListener editOpDlgListener = new EditOpDlgListener(this, gUISupport);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 2, 2));
        ToolIcon toolIcon = new ToolIcon(0, null);
        gUISupport.registerGadget(toolIcon, 2);
        toolIcon.addMouseListener(editOpDlgListener);
        ToolIcon toolIcon2 = new ToolIcon(1, null);
        gUISupport.registerGadget(toolIcon2, 3);
        toolIcon2.addMouseListener(editOpDlgListener);
        JComboBox<String> jComboBox = new JComboBox<String>();
        Iterator iterator = operator.getPresets().presetNames().iterator();
        while (iterator.hasNext()) {
            jComboBox.addItem((String)iterator.next());
        }
        jComboBox.setSelectedItem("(default)");
        toolIcon2.setEnabled(false);
        gUISupport.registerGadget(jComboBox, 1);
        jComboBox.addItemListener(editOpDlgListener);
        JCheckBox jCheckBox = new JCheckBox("Spectrogram");
        gUISupport.registerGadget(jCheckBox, 4);
        jCheckBox.addItemListener(editOpDlgListener);
        Properties properties = operator.getPropertyArray().superPr.toProperties(true);
        String string = properties.getProperty("Spectrogram");
        if (string != null) {
            jCheckBox.setSelected(Boolean.valueOf(string));
        }
        if (operator.getSlots(32).isEmpty()) {
            jCheckBox.setVisible(false);
        }
        jPanel.add(new JLabel("Preset"));
        jPanel.add(toolIcon);
        jPanel.add(toolIcon2);
        jPanel.add(jComboBox);
        jPanel.add(jCheckBox);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        gUISupport.add(jPanel);
        gridBagConstraints.fill = 1;
        this.opGUI = operator.createGUI(0);
        if (this.opGUI != null) {
            this.opGUI.fillGUI(operator.getPropertyArray());
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gUISupport.addGadget(this.opGUI, 6);
        gridBagConstraints.fill = 2;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(2, 2));
        JButton jButton = new JButton(" Cancel ");
        gUISupport.registerGadget(jButton, 8);
        jButton.addActionListener(editOpDlgListener);
        JButton jButton2 = new JButton("   OK   ");
        gUISupport.registerGadget(jButton2, 7);
        jButton2.addActionListener(editOpDlgListener);
        jPanel2.add((Component)jButton, "West");
        jPanel2.add((Component)jButton2, "East");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        gUISupport.add(jPanel2);
        this.getContentPane().add(gUISupport);
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                EditOpDlg.this.closeMe();
            }
        });
        super.initDialog();
    }

    protected void closeMe() {
        this.setVisible(false);
        try {
            this.op.getPrefs().store();
            this.op.getPresets().store();
        }
        catch (IOException iOException) {
            System.err.println("error storing presets : " + iOException.getLocalizedMessage());
        }
        this.dispose();
    }

    public boolean getChoice() {
        return this.choice;
    }

    public Operator getOperator() {
        return this.op;
    }

    public PropertyGUI getOpGUI() {
        return this.opGUI;
    }

    public void setChoice(boolean bl) {
        this.choice = bl;
    }

    private class EditOpDlgListener
    implements ActionListener,
    AdjustmentListener,
    ItemListener,
    MouseListener {
        private EditOpDlg dlg;
        private GUISupport gui;

        public EditOpDlgListener(EditOpDlg editOpDlg2, GUISupport gUISupport) {
            this.dlg = editOpDlg2;
            this.gui = gUISupport;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.gui.getItemID(actionEvent);
            switch (n) {
                case 7: {
                    this.dlg.setChoice(true);
                    this.dlg.getOpGUI().fillPropertyArray(EditOpDlg.this.op.getPropertyArray());
                    Component component = this.gui.getItemObj(4);
                    if (component != null) {
                        Properties properties = new Properties();
                        properties.put("Spectrogram", String.valueOf(((JCheckBox)component).isSelected()));
                        ((EditOpDlg)EditOpDlg.this).op.getPropertyArray().superPr.fromProperties(true, properties);
                    }
                }
                case 8: {
                    this.dlg.closeMe();
                    break;
                }
            }
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = this.gui.getItemID(itemEvent);
            switch (n) {
                case 1: {
                    String string;
                    Component component = this.gui.getItemObj(1);
                    if (component == null || (string = ((JComboBox)component).getSelectedItem().toString()) == null) break;
                    PropertyArray propertyArray = (PropertyArray)EditOpDlg.this.op.getPropertyArray().clone();
                    Properties properties = EditOpDlg.this.op.getPresets().getPreset(string);
                    propertyArray.fromProperties(false, properties);
                    this.dlg.getOpGUI().fillGUI(propertyArray);
                    component = this.gui.getItemObj(3);
                    if (component == null) break;
                    component.setEnabled(!string.equals("(default)"));
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = this.gui.getItemID(mouseEvent);
            switch (n) {
                case 2: {
                    int n2;
                    String string;
                    Component component = this.gui.getItemObj(1);
                    if (component == null || (string = JOptionPane.showInputDialog(this, (Object)"Enter preset name")) == null || string.length() <= 0) break;
                    if (string.equals("(default)")) {
                        JOptionPane.showMessageDialog(EditOpDlg.this.enc_this, "Cannot overwrite defaults!");
                        break;
                    }
                    boolean bl = false;
                    for (n2 = ((JComboBox)component).getItemCount() - 1; n2 >= 0 && !bl; --n2) {
                        bl = ((JComboBox)component).getItemAt(n2).equals(string);
                    }
                    if (bl && (n2 = JOptionPane.showConfirmDialog(EditOpDlg.this.enc_this, "Overwrite existing preset\n\"" + string + "\"", "Confirm", 0)) != 0) break;
                    PropertyArray propertyArray = (PropertyArray)EditOpDlg.this.op.getPropertyArray().clone();
                    this.dlg.getOpGUI().fillPropertyArray(propertyArray);
                    Properties properties = propertyArray.toProperties(false);
                    if (properties.isEmpty() || EditOpDlg.this.op.getPresets().setPreset(string, properties) == null) break;
                    if (!bl) {
                        ((JComboBox)component).addItem(string);
                    }
                    ((JComboBox)component).setSelectedItem(string);
                    component = this.gui.getItemObj(3);
                    if (component == null) break;
                    component.setEnabled(true);
                    break;
                }
                case 3: {
                    String string;
                    Component component = this.gui.getItemObj(1);
                    if (component == null || (string = ((JComboBox)component).getSelectedItem().toString()) == null) break;
                    if (string.equals("(default)")) {
                        JOptionPane.showMessageDialog(EditOpDlg.this.enc_this, "Cannot delete defaults!");
                        break;
                    }
                    if (EditOpDlg.this.op.getPresets().removePreset(string) == null) break;
                    ((JComboBox)component).removeItem(string);
                    if (((JComboBox)component).getItemCount() != 0 && !((JComboBox)component).getSelectedItem().equals("(default)") || (component = this.gui.getItemObj(3)) == null) break;
                    component.setEnabled(false);
                    break;
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

