/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import de.sciss.io.Marker;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class FourierDlg
extends ModulePanel {
    private static final int PR_REINPUTFILE = 0;
    private static final int PR_IMINPUTFILE = 1;
    private static final int PR_REOUTPUTFILE = 2;
    private static final int PR_IMOUTPUTFILE = 3;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_DIRECTION = 2;
    private static final int PR_GAINTYPE = 3;
    private static final int PR_FORMAT = 4;
    private static final int PR_LENGTH = 5;
    private static final int PR_GAIN = 0;
    private static final int PR_MEMORY = 1;
    private static final int PR_HASIMINPUT = 0;
    private static final int PR_HASIMOUTPUT = 1;
    private static final int DIR_FORWARD = 0;
    private static final int DIR_BACKWARD = 1;
    private static final int FORMAT_NORMAL = 0;
    private static final int FORMAT_POLAR = 1;
    private static final int LENGTH_EXPAND = 0;
    private static final int LENGTH_TRUNC = 1;
    private static final String PRN_REINPUTFILE = "ReInFile";
    private static final String PRN_IMINPUTFILE = "ImInFile";
    private static final String PRN_REOUTPUTFILE = "ReOutFile";
    private static final String PRN_IMOUTPUTFILE = "ImOutFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_DIRECTION = "Dir";
    private static final String PRN_FORMAT = "Format";
    private static final String PRN_LENGTH = "Length";
    private static final String PRN_MEMORY = "Memory";
    private static final String PRN_HASIMINPUT = "HasImInput";
    private static final String PRN_HASIMOUTPUT = "HasImOutput";
    private static final String[] prText = new String[]{"", "", "", ""};
    private static final String[] prTextName = new String[]{"ReInFile", "ImInFile", "ReOutFile", "ImOutFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 0, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "Dir", "GainType", "Format", "Length"};
    private static final Param[] prPara = new Param[]{null, null};
    private static final String[] prParaName = new String[]{"Gain", "Memory"};
    private static final boolean[] prBool = new boolean[]{false, true};
    private static final String[] prBoolName = new String[]{"HasImInput", "HasImOutput"};
    private static final int GG_REINPUTFILE = 1024;
    private static final int GG_IMINPUTFILE = 1025;
    private static final int GG_REOUTPUTFILE = 1026;
    private static final int GG_IMOUTPUTFILE = 1027;
    private static final int GG_GAIN = 512;
    private static final int GG_MEMORY = 513;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 259;
    private static final int GG_FORMAT = 260;
    private static final int GG_LENGTH = 261;
    private static final int GG_DIRECTION = 258;
    private static final int GG_HASIMINPUT = 0;
    private static final int GG_HASIMOUTPUT = 1;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private static final String MARK_PIHALF = "PiHalf";

    public FourierDlg() {
        super("Fourier Translation");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            FourierDlg.static_pr.text = prText;
            FourierDlg.static_pr.textName = prTextName;
            FourierDlg.static_pr.intg = prIntg;
            FourierDlg.static_pr.intgName = prIntgName;
            FourierDlg.static_pr.para = prPara;
            FourierDlg.static_pr.para[1] = new Param(16.0, 0);
            FourierDlg.static_pr.paraName = prParaName;
            FourierDlg.static_pr.bool = prBool;
            FourierDlg.static_pr.boolName = prBoolName;
            this.fillDefaultAudioDescr(FourierDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(FourierDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = FourierDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case 0: 
                    case 1: {
                        ((FourierDlg)FourierDlg.this).pr.bool[n - 0] = ((JCheckBox)itemEvent.getSource()).isSelected();
                        FourierDlg.this.reflectPropertyChanges();
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select real part of input");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input [Real]", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(16, "Select imaginary part of input");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        JCheckBox jCheckBox = new JCheckBox("Input [Imaginary]");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        int n = gridBagConstraints.anchor;
        gridBagConstraints.anchor = 13;
        this.gui.addCheckbox(jCheckBox, 0, itemListener);
        gridBagConstraints.anchor = n;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        PathField pathField3 = new PathField(49, "Select output for real part");
        pathField3.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output [Real]", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1026, null);
        this.gui.registerGadget(pathField3.getTypeGadget(), 256);
        this.gui.registerGadget(pathField3.getResGadget(), 257);
        PathField pathField4 = new PathField(1, "Select output for imaginary part");
        JCheckBox jCheckBox2 = new JCheckBox("Output [Imaginary]");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.anchor = 13;
        this.gui.addCheckbox(jCheckBox2, 1, itemListener);
        gridBagConstraints.anchor = n;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField4, 1027, null);
        PathField[] pathFieldArray = new PathField[]{pathField};
        PathField[] pathFieldArray2 = new PathField[]{pathField3};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0i$X0");
        pathField3.deriveFrom(pathFieldArray, "$D0$F0FT$E");
        pathField4.deriveFrom(pathFieldArray2, "$D0$F0i$X0");
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 259, itemListener);
        this.gui.addLabel(new GroupLabel("Translation", 1, 0));
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Forward");
        jComboBox.addItem("Backward (Inverse)");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Direction", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox, 258, itemListener);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        jComboBox2.addItem("Normal (rect)");
        jComboBox2.addItem("Polar");
        jComboBox2.addItem("Cepstral (log.)");
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Spectral format", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox2, 260, itemListener);
        JComboBox<String> jComboBox3 = new JComboBox<String>();
        jComboBox3.addItem("Expand to 2^n");
        jComboBox3.addItem("Truncate to 2^n");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("FFT Length", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox3, 261, itemListener);
        ParamField paramField = new ParamField(new ParamSpace(1.0, 2047.0, 1.0, 0));
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Mem.alloc. [MB]", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField, 513, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    public void process() {
        int n;
        float[] fArray;
        float[][] fArray2;
        float[][] fArray3;
        File[][] fileArray;
        FloatFile[][] floatFileArray;
        AudioFile audioFile;
        AudioFile audioFile2;
        AudioFile audioFile3;
        AudioFile audioFile4;
        block88: {
            audioFile4 = null;
            audioFile3 = null;
            audioFile2 = null;
            audioFile = null;
            AudioFileDescr audioFileDescr = null;
            AudioFileDescr audioFileDescr2 = null;
            AudioFileDescr audioFileDescr3 = null;
            AudioFileDescr audioFileDescr4 = null;
            floatFileArray = null;
            fileArray = null;
            fArray3 = null;
            fArray2 = null;
            fArray = null;
            float[][] fArray4 = null;
            long l = 0L;
            Param param = new Param(1.0, 1);
            float f = 0.0f;
            int n2 = 0;
            try {
                float f2;
                float f3;
                double d;
                double d2;
                int n3;
                float[] fArray5;
                float[] fArray6;
                int n4;
                int n5;
                int n6;
                PathField pathField;
                long l2;
                audioFile4 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr = audioFile4.getDescr();
                int n7 = audioFileDescr.channels;
                long l3 = (int)audioFileDescr.length;
                if (this.pr.bool[0]) {
                    audioFile3 = AudioFile.openAsRead((File)new File(this.pr.text[1]));
                    audioFileDescr2 = audioFile3.getDescr();
                    if (audioFileDescr2.channels != n7) {
                        throw new IOException("Real and imaginary file must\nhave same # of channels");
                    }
                    l3 = (int)Math.min(l3, audioFileDescr2.length);
                }
                if ((l2 = l3 * (long)n7) < 1L) {
                    throw new EOFException("File is empty");
                }
                long l4 = -1L;
                if (l4 < 0L) {
                    l = 2L;
                    n2 = 1;
                    while (l < l3) {
                        l <<= 1;
                        ++n2;
                    }
                    if (this.pr.intg[5] == 1 && l > l3) {
                        --n2;
                        l3 = l >>= 1;
                        l2 = l3 * (long)n7;
                    }
                }
                long l5 = l >> 1;
                if (this.pr.intg[2] == 0) {
                    ArrayList<Marker> arrayList = (ArrayList<Marker>)audioFileDescr.getProperty((Object)"markers");
                    if (arrayList == null) {
                        arrayList = new ArrayList<Marker>(1);
                    }
                    arrayList.add(new Marker(l5, MARK_PIHALF));
                    audioFileDescr.setProperty("markers", arrayList);
                }
                if ((pathField = (PathField)this.gui.getItemObj(1026)) == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr3 = new AudioFileDescr(audioFileDescr);
                pathField.fillStream(audioFileDescr3);
                audioFile2 = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr3);
                if (this.pr.bool[1]) {
                    audioFileDescr4 = new AudioFileDescr(audioFileDescr);
                    pathField.fillStream(audioFileDescr4);
                    audioFileDescr4.file = new File(this.pr.text[3]);
                    audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr4);
                }
                if (!this.threadRunning) break block88;
                float f4 = this.pr.intg[2] == 0 ? 1.0f : -1.0f;
                long l6 = 0L;
                long l7 = l * (long)(3 + n2 * n7) + l3;
                if (this.pr.bool[0]) {
                    l7 += l3;
                }
                if (this.pr.bool[1]) {
                    l7 += l;
                }
                if (this.pr.intg[3] == 0) {
                    l7 += l * (long)n7;
                }
                floatFileArray = new FloatFile[n7][4];
                fileArray = new File[n7][4];
                for (n6 = 0; n6 < n7; ++n6) {
                    for (n = 0; n < 4; ++n) {
                        fileArray[n6][n] = null;
                        floatFileArray[n6][n] = null;
                    }
                }
                for (n6 = 0; n6 < n7; ++n6) {
                    for (n = 0; n < 4; ++n) {
                        fileArray[n6][n] = IOUtil.createTempFile();
                        floatFileArray[n6][n] = new FloatFile(fileArray[n6][n], 1);
                    }
                }
                int n8 = (int)Math.min(0x40000000L, Math.min(l, ((long)this.pr.para[1].value << 20) / 12L));
                for (n5 = 4; n5 <= n8; n5 <<= 1) {
                }
                n5 >>= 1;
                boolean bl = this.pr.intg[2] == 1 && this.pr.intg[4] == 1;
                fArray3 = new float[n7][8192];
                fArray2 = this.pr.bool[0] || this.pr.bool[1] ? new float[n7][8192] : fArray3;
                fArray = new float[16384];
                long l8 = 0L;
                while (this.threadRunning && l8 < l3) {
                    n4 = (int)Math.min(8192L, l3 - l8);
                    if (l8 < l5 && l8 + (long)n4 > l5) {
                        n4 = (int)(l5 - l8);
                    }
                    audioFile4.readFrames(fArray3, 0, n4);
                    this.setProgression((float)(l6 += (long)n4) / (float)l7);
                    if (audioFile3 != null) {
                        audioFile3.readFrames(fArray2, 0, n4);
                        this.setProgression((float)(l6 += (long)n4) / (float)l7);
                    }
                    l8 += (long)n4;
                    for (n6 = 0; this.threadRunning && n6 < n7; ++n6) {
                        fArray6 = fArray3[n6];
                        fArray5 = fArray2[n6];
                        if (this.pr.bool[0]) {
                            n3 = 0;
                            for (n = 0; n < n4; ++n) {
                                fArray[n3++] = fArray6[n];
                                fArray[n3++] = fArray5[n];
                            }
                            if (bl) {
                                Fourier.polar2Rect(fArray, 0, fArray, 0, n4 << 1);
                            }
                        } else {
                            n3 = 0;
                            for (n = 0; n < n4; ++n) {
                                fArray[n3++] = fArray6[n];
                                fArray[n3++] = 0.0f;
                            }
                        }
                        if (l8 <= l5) {
                            floatFileArray[n6][0].writeFloats(fArray, 0, n4 << 1);
                            continue;
                        }
                        floatFileArray[n6][1].writeFloats(fArray, 0, n4 << 1);
                    }
                    this.setProgression((float)(l6 += (long)n4) / (float)l7);
                }
                if (!this.threadRunning) break block88;
                for (n6 = 0; n6 < fArray.length; ++n6) {
                    fArray[n6] = 0.0f;
                }
                while (this.threadRunning && l8 < l) {
                    n4 = (int)Math.min(8192L, l - l8);
                    if (l8 < l5 && l8 + (long)n4 > l5) {
                        n4 = (int)(l5 - l8);
                    }
                    l8 += (long)n4;
                    for (n6 = 0; this.threadRunning && n6 < n7; ++n6) {
                        if (l8 <= l5) {
                            floatFileArray[n6][0].writeFloats(fArray, 0, n4 << 1);
                            continue;
                        }
                        floatFileArray[n6][1].writeFloats(fArray, 0, n4 << 1);
                    }
                    this.setProgression((float)(l6 += (long)n4) / (float)l7);
                }
                if (!this.threadRunning) break block88;
                audioFile4.close();
                audioFile4 = null;
                if (audioFile3 != null) {
                    audioFile3.close();
                    audioFile3 = null;
                }
                fArray4 = new float[3][n5];
                for (n6 = 0; this.threadRunning && n6 < n7; ++n6) {
                    this.storageFFT(floatFileArray[n6], fileArray[n6], l, f4, fArray4, (float)(l6 += l * (long)n2) / (float)l7);
                }
                if (!this.threadRunning) break block88;
                boolean bl2 = bl = this.pr.intg[2] == 0 && this.pr.intg[4] == 1;
                if (this.pr.intg[3] == 0) {
                    for (n6 = 0; n6 < n7; ++n6) {
                        for (n = 2; n < 4; ++n) {
                            floatFileArray[n6][n].seekFloat(0);
                            l8 = 0L;
                            while (this.threadRunning && l8 < l) {
                                n4 = (int)Math.min(8192L, l - l8);
                                floatFileArray[n6][n].readFloats(fArray, 0, n4);
                                l8 += (long)n4;
                                if (bl) {
                                    n3 = 0;
                                    while (n3 < n4) {
                                        d2 = fArray[n3++];
                                        int n9 = n3++;
                                        d = fArray[n9];
                                        f3 = (float)Math.sqrt(d2 * d2 + d * d);
                                        if (!(f3 > f)) continue;
                                        f = f3;
                                    }
                                } else if (this.pr.bool[1]) {
                                    for (n3 = 0; n3 < n4; ++n3) {
                                        if (!(Math.abs(fArray[n3]) > f)) continue;
                                        f = Math.abs(fArray[n3]);
                                    }
                                } else {
                                    for (n3 = 0; n3 < n4; n3 += 2) {
                                        if (!(Math.abs(fArray[n3]) > f)) continue;
                                        f = Math.abs(fArray[n3]);
                                    }
                                }
                                this.setProgression((float)(l6 += (long)(n4 >> 1)) / (float)l7);
                            }
                        }
                    }
                    f2 = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f), (int)1), null).value;
                } else {
                    f2 = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                    f2 = (float)((double)f2 / Math.sqrt(l));
                }
                for (n6 = 0; n6 < n7; ++n6) {
                    for (n = 0; n < 2; ++n) {
                        floatFileArray[n6][n].cleanUp();
                        floatFileArray[n6][n] = null;
                        fileArray[n6][n].delete();
                        fileArray[n6][n] = null;
                    }
                    while (n < 4) {
                        floatFileArray[n6][n].seekFloat(0);
                        ++n;
                    }
                }
                this.indicateOutputWrite();
                for (long i = 0L; this.threadRunning && i < l; i += (long)n4) {
                    n4 = (int)Math.min(8192L, l - i);
                    if (i < l5 && i + (long)n4 > l5) {
                        n4 = (int)(l5 - i);
                    }
                    for (n6 = 0; this.threadRunning && n6 < n7; ++n6) {
                        if (i < l5) {
                            floatFileArray[n6][2].readFloats(fArray, 0, n4 << 1);
                        } else {
                            floatFileArray[n6][3].readFloats(fArray, 0, n4 << 1);
                        }
                        fArray6 = fArray3[n6];
                        fArray5 = fArray2[n6];
                        if (bl) {
                            if (this.pr.bool[1]) {
                                Fourier.rect2Polar(fArray, 0, fArray, 0, n4 << 1);
                                if (this.pr.intg[3] == 1) {
                                    n3 = 0;
                                    for (n = 0; n < n4; ++n) {
                                        if (Math.abs(fArray[n3]) > f) {
                                            f = Math.abs(fArray[n3]);
                                        }
                                        fArray6[n] = f2 * fArray[n3++];
                                        fArray5[n] = (float)((double)fArray[n3++] / Math.PI);
                                    }
                                    continue;
                                }
                                n3 = 0;
                                for (n = 0; n < n4; ++n) {
                                    fArray6[n] = f2 * fArray[n3++];
                                    fArray5[n] = (float)((double)fArray[n3++] / Math.PI);
                                }
                                continue;
                            }
                            if (this.pr.intg[3] == 1) {
                                n3 = 0;
                                for (n = 0; n < n4; ++n) {
                                    d2 = fArray[n3++];
                                    int n10 = n3++;
                                    d = fArray[n10];
                                    f3 = (float)Math.sqrt(d2 * d2 + d * d);
                                    if (f3 > f) {
                                        f = f3;
                                    }
                                    fArray6[n] = f2 * f3;
                                }
                                continue;
                            }
                            n3 = 0;
                            for (n = 0; n < n4; ++n) {
                                d2 = fArray[n3++];
                                d = fArray[n3++];
                                f3 = (float)Math.sqrt(d2 * d2 + d * d);
                                fArray6[n] = f2 * f3;
                            }
                            continue;
                        }
                        if (this.pr.bool[1]) {
                            if (this.pr.intg[3] == 1) {
                                n3 = 0;
                                for (n = 0; n < n4; ++n) {
                                    if (Math.abs(fArray[n3]) > f) {
                                        f = Math.abs(fArray[n3]);
                                    }
                                    fArray6[n] = f2 * fArray[n3++];
                                    if (Math.abs(fArray[n3]) > f) {
                                        f = Math.abs(fArray[n3]);
                                    }
                                    fArray5[n] = f2 * fArray[n3++];
                                }
                                continue;
                            }
                            n3 = 0;
                            for (n = 0; n < n4; ++n) {
                                fArray6[n] = f2 * fArray[n3++];
                                fArray5[n] = f2 * fArray[n3++];
                            }
                            continue;
                        }
                        if (this.pr.intg[3] == 1) {
                            n = 0;
                            n3 = 0;
                            while (n < n4) {
                                if (Math.abs(fArray[n3]) > f) {
                                    f = Math.abs(fArray[n3]);
                                }
                                fArray6[n] = f2 * fArray[n3];
                                ++n;
                                n3 += 2;
                            }
                            continue;
                        }
                        n = 0;
                        n3 = 0;
                        while (n < n4) {
                            fArray6[n] = f2 * fArray[n3];
                            ++n;
                            n3 += 2;
                        }
                    }
                    this.setProgression((float)(l6 += (long)n4) / (float)l7);
                    audioFile2.writeFrames(fArray3, 0, n4);
                    this.setProgression((float)(l6 += (long)n4) / (float)l7);
                    if (audioFile == null) continue;
                    audioFile.writeFrames(fArray2, 0, n4);
                    this.setProgression((float)(l6 += (long)n4) / (float)l7);
                }
                if (this.threadRunning) {
                    audioFile2.close();
                    audioFile2 = null;
                    if (audioFile != null) {
                        audioFile.close();
                        audioFile = null;
                    }
                    this.handleClipping(f *= f2);
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                fArray3 = null;
                fArray2 = null;
                fArray = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        fArray3 = null;
        fArray2 = null;
        fArray = null;
        if (audioFile4 != null) {
            audioFile4.cleanUp();
            audioFile4 = null;
        }
        if (audioFile3 != null) {
            audioFile3.cleanUp();
            audioFile3 = null;
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
            audioFile2 = null;
        }
        if (audioFile != null) {
            audioFile.cleanUp();
            audioFile = null;
        }
        if (floatFileArray != null) {
            for (int i = 0; i < floatFileArray.length; ++i) {
                for (n = 0; n < 4; ++n) {
                    if (floatFileArray[i][n] != null) {
                        floatFileArray[i][n].cleanUp();
                        floatFileArray[i][n] = null;
                    }
                    if (fileArray[i][n] == null) continue;
                    fileArray[i][n].delete();
                    fileArray[i][n] = null;
                }
            }
        }
    }

    protected void storageFFT(FloatFile[] floatFileArray, File[] fileArray, long l, float f, float[][] fArray, float f2) throws IOException {
        int n;
        float f3;
        float f4;
        int n2;
        int n3;
        float f5;
        float f6;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        int n4;
        int n5;
        int n6;
        long l2;
        int n7;
        int n8;
        long l3;
        int[] nArray = new int[]{1, 0, 3, 2};
        int[] nArray2 = new int[4];
        float f7 = this.getProgression();
        float f8 = f2 - f7;
        int n9 = 0;
        int n10 = fArray[0].length;
        float[] fArray2 = fArray[0];
        float[] fArray3 = fArray[1];
        float[] fArray4 = fArray[2];
        long l4 = 0L;
        long l5 = l;
        long l6 = l / (long)n10;
        long l7 = l6 >> 1;
        double d7 = (double)f * Math.PI;
        n9 = 0;
        int n11 = 0;
        long l8 = l;
        int n12 = n10 >> 1;
        long l9 = l;
        do {
            n11 = (int)((long)n11 + Math.max(1L, l7) * (long)(n10 << 2) * (long)(l7 == 0L ? 1 : 2));
            l9 >>= 1;
            if ((l8 >>= 1) <= (long)n10) continue;
            l3 = 2L * ((l6 + l8 / (long)n10 - 1L) / (l8 / (long)n10)) * ((l8 + (long)n10 - 1L) / (long)n10);
            n11 = (int)((long)n11 + l3 * (long)(n10 << 1));
        } while (l8 >= (long)n10);
        int n13 = 0;
        do {
            n11 = (int)((long)n11 + 2L * l6 * (long)n10);
            n8 = n12;
            n12 >>= 1;
            for (n7 = 0; n7 < 2; ++n7) {
                for (l2 = 0L; l2 < l6; ++l2) {
                    n6 = 0;
                    n5 = n8;
                    do {
                        n4 = n5 - n6 + 1 & 0xFFFFFFFE;
                        n13 += n4;
                        n6 += n4;
                        n5 = (n6 += n8) + n8;
                    } while (n6 < n10);
                    if (n13 < n10) continue;
                    n11 += n10 << 1;
                    n13 = 0;
                }
            }
        } while ((l9 >>= 1) > 1L);
        f8 /= (float)n11;
        l8 = l;
        n12 = n10 >> 1;
        l9 = l;
        this.rewind(floatFileArray, fileArray, nArray2);
        do {
            d6 = d7 / (double)(l / l5);
            d5 = Math.sin(d6 / 2.0);
            d4 = -2.0 * d5 * d5;
            d3 = Math.sin(d6);
            d2 = 1.0;
            d = 0.0;
            f6 = 1.0f;
            f5 = 0.0f;
            l5 >>= 1;
            for (n7 = 0; this.threadRunning && n7 < 2; ++n7) {
                l2 = 0L;
                do {
                    for (n2 = 0; this.threadRunning && n2 < n10; n2 += n3) {
                        n3 = Math.min(32768, n10 - n2);
                        floatFileArray[nArray2[0]].readFloats(fArray2, n2, n3);
                        this.setProgression((float)(n9 += n3) * f8 + f7);
                    }
                    for (n2 = 0; this.threadRunning && n2 < n10; n2 += n3) {
                        n3 = Math.min(32768, n10 - n2);
                        floatFileArray[nArray2[1]].readFloats(fArray3, n2, n3);
                        this.setProgression((float)(n9 += n3) * f8 + f7);
                    }
                    if (!this.threadRunning) {
                        return;
                    }
                    for (n13 = 0; n13 < n10; n13 += 2) {
                        n4 = n13 + 1;
                        f4 = f6 * fArray3[n13] - f5 * fArray3[n4];
                        f3 = f5 * fArray3[n13] + f6 * fArray3[n4];
                        fArray3[n13] = fArray2[n13] - f4;
                        int n14 = n13;
                        fArray2[n14] = fArray2[n14] + f4;
                        fArray3[n4] = fArray2[n4] - f3;
                        int n15 = n4;
                        fArray2[n15] = fArray2[n15] + f3;
                    }
                    if ((l4 += (long)n12) == l5) {
                        l4 = 0L;
                        d5 = d2;
                        d += d5 * d3 + d * d4;
                        f6 = (float)(d2 += d5 * d4 - d * d3);
                        f5 = (float)d;
                    }
                    for (n = 0; this.threadRunning && n < n10; n += n3) {
                        n3 = Math.min(32768, n10 - n);
                        floatFileArray[nArray2[2]].writeFloats(fArray2, n, n3);
                        this.setProgression((float)(n9 += n3) * f8 + f7);
                    }
                    for (n = 0; this.threadRunning && n < n10; n += n3) {
                        n3 = Math.min(32768, n10 - n);
                        floatFileArray[nArray2[3]].writeFloats(fArray3, n, n3);
                        this.setProgression((float)(n9 += n3) * f8 + f7);
                    }
                } while (this.threadRunning && ++l2 < l7);
                if (!this.threadRunning) {
                    return;
                }
                if (n7 == 0 && l8 != l && l8 == (long)n10) {
                    nArray2[0] = nArray[nArray2[0]];
                    nArray2[1] = nArray2[0];
                }
                if (l7 == 0L) break;
            }
            if (!this.threadRunning) {
                return;
            }
            this.rewind(floatFileArray, fileArray, nArray2);
            if ((l9 >>= 1) == 1L) {
                l5 = l;
                l9 = l;
                System.out.println("We never get here?!!");
            }
            if ((l8 >>= 1) > (long)n10) {
                for (n7 = 0; n7 < 2; ++n7) {
                    for (l2 = 0L; l2 < l6; l2 += l8 / (long)n10) {
                        for (l3 = 0L; l3 < l8; l3 += (long)n10) {
                            for (n2 = 0; this.threadRunning && n2 < n10; n2 += n3) {
                                n3 = Math.min(32768, n10 - n2);
                                floatFileArray[nArray2[0]].readFloats(fArray2, n2, n3);
                                this.setProgression((float)(n9 += n3) * f8 + f7);
                            }
                            for (n = 0; this.threadRunning && n < n10; n += n3) {
                                n3 = Math.min(32768, n10 - n);
                                floatFileArray[nArray2[2]].writeFloats(fArray2, n, n3);
                                this.setProgression((float)(n9 += n3) * f8 + f7);
                            }
                            if (this.threadRunning) continue;
                            return;
                        }
                        nArray2[2] = nArray[nArray2[2]];
                    }
                    nArray2[0] = nArray[nArray2[0]];
                }
                this.rewind(floatFileArray, fileArray, nArray2);
                continue;
            }
            if (l8 != (long)n10) continue;
            nArray2[1] = nArray2[0];
        } while (this.threadRunning && l8 >= (long)n10);
        if (!this.threadRunning) {
            return;
        }
        n13 = 0;
        do {
            d6 = d7 / (double)(l / l5);
            d5 = Math.sin(d6 / 2.0);
            d4 = -2.0 * d5 * d5;
            d3 = Math.sin(d6);
            d2 = 1.0;
            d = 0.0;
            f6 = 1.0f;
            f5 = 0.0f;
            l5 >>= 1;
            n8 = n12;
            n12 >>= 1;
            for (n7 = 0; this.threadRunning && n7 < 2; ++n7) {
                for (l2 = 0L; this.threadRunning && l2 < l6; ++l2) {
                    for (n2 = 0; this.threadRunning && n2 < n10; n2 += n3) {
                        n3 = Math.min(32768, n10 - n2);
                        floatFileArray[nArray2[0]].readFloats(fArray4, n2, n3);
                        this.setProgression((float)(n9 += n3) * f8 + f7);
                    }
                    if (!this.threadRunning) {
                        return;
                    }
                    n6 = 0;
                    n5 = n8;
                    while (true) {
                        n4 = n6 + n8 + 1;
                        f4 = f6 * fArray4[n6 + n8] - f5 * fArray4[n4];
                        f3 = f5 * fArray4[n6 + n8] + f6 * fArray4[n4];
                        fArray2[n13] = fArray4[n6] + f4;
                        fArray3[n13] = fArray4[n6] - f4;
                        fArray2[++n13] = fArray4[++n6] + f3;
                        fArray3[n13++] = fArray4[n6++] - f3;
                        if (n6 < n5) continue;
                        if ((l4 += (long)n12) == l5) {
                            l4 = 0L;
                            d5 = d2;
                            d += d5 * d3 + d * d4;
                            f6 = (float)(d2 += d5 * d4 - d * d3);
                            f5 = (float)d;
                        }
                        if ((n6 += n8) >= n10) break;
                        n5 = n6 + n8;
                    }
                    if (n13 < n10) continue;
                    for (n = 0; this.threadRunning && n < n10; n += n3) {
                        n3 = Math.min(32768, n10 - n);
                        floatFileArray[nArray2[2]].writeFloats(fArray2, n, n3);
                        this.setProgression((float)(n9 += n3) * f8 + f7);
                    }
                    for (n = 0; this.threadRunning && n < n10; n += n3) {
                        n3 = Math.min(32768, n10 - n);
                        floatFileArray[nArray2[3]].writeFloats(fArray3, n, n3);
                        this.setProgression((float)(n9 += n3) * f8 + f7);
                    }
                    if (!this.threadRunning) {
                        return;
                    }
                    n13 = 0;
                }
                nArray2[0] = nArray[nArray2[0]];
            }
            this.rewind(floatFileArray, fileArray, nArray2);
        } while (this.threadRunning && (l9 >>= 1) > 1L);
        fArray2 = null;
        fArray3 = null;
        fArray4 = null;
    }

    protected void rewind(FloatFile[] floatFileArray, File[] fileArray, int[] nArray) throws IOException {
        for (int i = 0; i < 4; ++i) {
            floatFileArray[i].seekFloat(0);
        }
        FloatFile floatFile = floatFileArray[1];
        floatFileArray[1] = floatFileArray[3];
        floatFileArray[3] = floatFile;
        floatFile = floatFileArray[0];
        floatFileArray[0] = floatFileArray[2];
        floatFileArray[2] = floatFile;
        File file = fileArray[1];
        fileArray[1] = fileArray[3];
        fileArray[3] = file;
        file = fileArray[0];
        fileArray[0] = fileArray[2];
        fileArray[2] = file;
        nArray[0] = 2;
        nArray[1] = 3;
        nArray[2] = 0;
        nArray[3] = 1;
    }

    @Override
    protected void reflectPropertyChanges() {
        super.reflectPropertyChanges();
        Component component = this.gui.getItemObj(1025);
        if (component != null) {
            component.setEnabled(this.pr.bool[0]);
        }
        if ((component = this.gui.getItemObj(1027)) != null) {
            component.setEnabled(this.pr.bool[1]);
        }
    }
}

